/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.fieldmanager;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.mapping.CollectionMapping;
import org.datanucleus.store.mapped.mapping.InterfaceMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MapMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class DynamicSchemaFieldManager
extends AbstractFieldManager {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)(class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = DynamicSchemaFieldManager.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    RDBMSManager rdbmsMgr;
    StateManager sm;
    boolean schemaUpdatesPerformed = false;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public DynamicSchemaFieldManager(RDBMSManager rdbmsMgr, StateManager sm) {
        this.rdbmsMgr = rdbmsMgr;
        this.sm = sm;
    }

    public boolean hasPerformedSchemaUpdates() {
        return this.schemaUpdatesPerformed;
    }

    public void storeObjectField(int fieldNumber, Object value) {
        if (value == null) {
            return;
        }
        ObjectManager om = this.sm.getObjectManager();
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        DatastoreClass table = this.rdbmsMgr.getDatastoreClass(this.sm.getObject().getClass().getName(), clr);
        JavaTypeMapping fieldMapping = table.getFieldMapping(mmd);
        if (fieldMapping != null) {
            if (fieldMapping instanceof InterfaceMapping) {
                InterfaceMapping intfMapping = (InterfaceMapping)fieldMapping;
                int intfImplMappingNumber = intfMapping.getMappingNumberForValue(om, value);
                if (intfImplMappingNumber == -1) {
                    if (mmd != null && (mmd.getFieldTypes() != null || mmd.hasExtension("implementation-classes"))) {
                        return;
                    }
                    NucleusLogger.JDO.debug((Object)(">> DynamicSchemaFM field=" + mmd.getFullFieldName() + " mapping=" + fieldMapping + " but value=" + StringUtils.toJVMIDString((Object)value) + " is not a known implementation - trying to update the schema ..."));
                    MetaDataManager mmgr = om.getStoreManager().getOMFContext().getMetaDataManager();
                    mmgr.getMetaDataForClass(value.getClass(), clr);
                    String[] impls = om.getMetaDataManager().getClassesImplementingInterface(mmd.getTypeName(), clr);
                    if (ClassUtils.stringArrayContainsValue((String[])impls, (String)value.getClass().getName())) {
                        try {
                            NucleusLogger.JDO.debug((Object)(">> DynamicSchemaFM field=" + mmd.getFullFieldName() + " REINITIALISING mapping " + intfMapping));
                            intfMapping.initialize(this.rdbmsMgr.getDatastoreAdapter(), mmd, intfMapping.getDatastoreContainer(), clr);
                            ((RDBMSManager)om.getStoreManager()).validateTable((TableImpl)intfMapping.getDatastoreContainer(), clr);
                            intfImplMappingNumber = intfMapping.getMappingNumberForValue(om, value);
                        }
                        catch (Exception e) {
                            NucleusLogger.JDO.debug((Object)"Exception thrown trying to create missing columns for implementation", (Throwable)e);
                            throw new NucleusException("Exception thrown performing dynamic update of schema", (Throwable)e);
                        }
                        this.schemaUpdatesPerformed = true;
                    }
                }
            } else if (fieldMapping instanceof CollectionMapping || fieldMapping instanceof MapMapping) {
                // empty if block
            }
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    public void storeByteField(int fieldNumber, byte value) {
    }

    public void storeCharField(int fieldNumber, char value) {
    }

    public void storeDoubleField(int fieldNumber, double value) {
    }

    public void storeFloatField(int fieldNumber, float value) {
    }

    public void storeIntField(int fieldNumber, int value) {
    }

    public void storeLongField(int fieldNumber, long value) {
    }

    public void storeShortField(int fieldNumber, short value) {
    }

    public void storeStringField(int fieldNumber, String value) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

