/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.datanucleus.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringExpression;
import org.datanucleus.store.mapped.expression.TableExprAsJoins;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.schema.MySQLTypeInfo;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.store.schema.StoreSchemaHandler;

public class MySQLAdapter
extends DatabaseAdapter {
    public static final String NONSQL92_RESERVED_WORDS = "ANALYZE,AUTO_INCREMENT,BDB,BERKELEYDB,BIGINT,BINARY,BLOB,BTREE,CHANGE,COLUMNS,DATABASE,DATABASES,DAY_HOUR,DAY_MINUTE,DAY_SECOND,DELAYED,DISTINCTROW,DIV,ENCLOSED,ERRORS,ESCAPED,EXPLAIN,FIELDS,FORCE,FULLTEXT,FUNCTION,GEOMETRY,HASH,HELP,HIGH_PRIORITY,HOUR_MINUTE,HOUR_SECOND,IF,IGNORE,INDEX,INFILE,INNODB,KEYS,KILL,LIMIT,LINES,LOAD,LOCALTIME,LOCALTIMESTAMP,LOCK,LONG,LONGBLOB,LONGTEXT,LOW_PRIORITY,MASTER_SERVER_ID,MEDIUMBLOB,MEDIUMINT,MEDIUMTEXT,MIDDLEINT,MINUTE_SECOND,MOD,MRG_MYISAM,OPTIMIZE,OPTIONALLY,OUTFILE,PURGE,REGEXP,RENAME,REPLACE,REQUIRE,RETURNS,RLIKE,RTREE,SHOW,SONAME,SPATIAL,SQL_BIG_RESULT,SQL_CALC_FOUND_ROWS,SQL_SMALL_RESULT,SSL,STARTING,STRAIGHT_JOIN,STRIPED,TABLES,TERMINATED,TINYBLOB,TINYINT,TINYTEXT,TYPES,UNLOCK,UNSIGNED,USE,USER_RESOURCES,VARBINARY,VARCHARACTER,WARNINGS,XOR,YEAR_MONTH,ZEROFILL";
    static /* synthetic */ Class class$java$math$BigInteger;

    public MySQLAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.reservedKeywords.addAll(this.parseKeywordList(NONSQL92_RESERVED_WORDS));
        this.supportedOptions.remove("AlterTableDropConstraint_Syntax");
        if (this.datastoreMajorVersion < 4 || this.datastoreMajorVersion == 4 && this.datastoreMinorVersion == 0 && this.datastoreRevisionVersion < 13) {
            this.supportedOptions.remove("AlterTableDropForeignKey_Syntax");
        } else {
            this.supportedOptions.add("AlterTableDropForeignKey_Syntax");
        }
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("ColumnOptions_DefaultBeforeNull");
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        if (this.datastoreMajorVersion < 5 && (this.datastoreMajorVersion < 4 || this.datastoreMinorVersion < 1)) {
            this.supportedOptions.remove("Exists_Syntax");
        } else {
            this.supportedOptions.add("Exists_Syntax");
        }
        if (this.datastoreMajorVersion < 4) {
            this.supportedOptions.remove("Union_Syntax");
        } else {
            this.supportedOptions.add("Union_Syntax");
        }
        this.supportedOptions.add("BlobSetUsingSetString");
        this.supportedOptions.add("ClobSetUsingSetString");
        this.supportedOptions.add("CreateIndexesBeforeForeignKeys");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.remove("AnalysisMethods");
        this.supportedOptions.remove("DateTimeStoresMillisecs");
    }

    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        MySQLTypeInfo sqlType = new MySQLTypeInfo("MEDIUMBLOB", 2004, Integer.MAX_VALUE, null, null, null, 1, false, 1, false, false, false, "MEDIUMBLOB", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2004, sqlType, true);
        sqlType = new MySQLTypeInfo("MEDIUMTEXT", 2005, Integer.MAX_VALUE, null, null, null, 1, true, 1, false, false, false, "MEDIUMTEXT", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2005, sqlType, true);
    }

    public String getVendorID() {
        return "mysql";
    }

    public RDBMSColumnInfo newRDBMSColumnInfo(ResultSet rs) {
        RDBMSColumnInfo info = super.newRDBMSColumnInfo(rs);
        short dataType = info.getDataType();
        String typeName = info.getTypeName();
        if (dataType == -4 && typeName.equalsIgnoreCase("mediumblob")) {
            info.setDataType((short)2004);
        }
        if (dataType == -1 && typeName.equalsIgnoreCase("mediumtext")) {
            info.setDataType((short)2005);
        }
        return info;
    }

    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        MySQLTypeInfo info = new MySQLTypeInfo(rs);
        String typeName = info.getTypeName();
        if (typeName.equalsIgnoreCase("binary") || typeName.equalsIgnoreCase("varbinary")) {
            return null;
        }
        return info;
    }

    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    public String getCreateTableStatement(TableImpl table, Column[] columns, Properties props) {
        StringBuffer createStmt = new StringBuffer(super.getCreateTableStatement(table, columns, props));
        String engineType = "INNODB";
        if (props != null && ((Hashtable)props).containsKey("mysql-engine-type")) {
            engineType = props.getProperty("mysql-engine-type");
        }
        boolean engineKeywordPresent = false;
        if (this.datastoreMajorVersion >= 5 || this.datastoreMajorVersion == 4 && this.datastoreMinorVersion >= 1 && this.datastoreRevisionVersion >= 2 || this.datastoreMajorVersion == 4 && this.datastoreMinorVersion == 0 && this.datastoreRevisionVersion >= 18) {
            engineKeywordPresent = true;
        }
        if (engineKeywordPresent) {
            createStmt.append(" ENGINE=" + engineType);
        } else {
            createStmt.append(" TYPE=" + engineType);
        }
        return createStmt.toString();
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public String getAddColumnStatement(DatastoreContainerObject table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD COLUMN " + col.getSQLDefinition();
    }

    public String getAutoIncrementStmt(Table table, String columnName) {
        return "SELECT LAST_INSERT_ID()";
    }

    public String getAutoIncrementKeyword() {
        return "AUTO_INCREMENT";
    }

    public String getSelectNewUUIDStmt() {
        return "SELECT uuid()";
    }

    public String getRangeByLimitWhereClause(long offset, long count) {
        if (offset >= 0L && count > 0L) {
            return " LIMIT " + offset + "," + count;
        }
        if (offset <= 0L && count > 0L) {
            return " LIMIT " + count;
        }
        if (offset >= 0L && count < 0L) {
            return " LIMIT " + offset + "," + Long.MAX_VALUE;
        }
        return "";
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        return new TableExprAsJoins(qs, table, rangeVar);
    }

    public ScalarExpression concatOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(operand1);
        args.add(operand2);
        return new StringExpression("CONCAT", args);
    }

    public BooleanExpression startsWithMethod(ScalarExpression source, ScalarExpression str) {
        ScalarExpression integerLiteral = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = MySQLAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, source).newLiteral(source.getQueryExpression(), BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(source);
        return new BooleanExpression(new StringExpression("LOCATE", args), ScalarExpression.OP_EQ, integerLiteral);
    }

    public String getEscapePatternExpression() {
        return "ESCAPE '\\\\'";
    }

    public StringExpression toStringExpression(NumericExpression expr) {
        if (expr instanceof Literal) {
            return super.toStringExpression(expr);
        }
        ArrayList<NumericExpression> args = new ArrayList<NumericExpression>();
        args.add(expr);
        ArrayList<String> types = new ArrayList<String>();
        types.add("CHAR(4000)");
        return new StringExpression("CAST", args, types);
    }

    public String cartersianProduct(LogicSetExpression Y) {
        StringBuffer sb = new StringBuffer();
        sb.append(" CROSS JOIN ");
        sb.append(Y.toString());
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

