/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.fieldmanager.DynamicSchemaFieldManager;
import org.datanucleus.store.rdbms.request.DeleteRequest;
import org.datanucleus.store.rdbms.request.FetchRequest;
import org.datanucleus.store.rdbms.request.InsertRequest;
import org.datanucleus.store.rdbms.request.LocateRequest;
import org.datanucleus.store.rdbms.request.RequestIdentifier;
import org.datanucleus.store.rdbms.request.UpdateRequest;
import org.datanucleus.store.rdbms.table.SecondaryTable;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.SoftValueMap;

public class RDBMSPersistenceHandler
implements StorePersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)(class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = RDBMSPersistenceHandler.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    protected final MappedStoreManager storeMgr;
    private Map requestsByID = Collections.synchronizedMap(new SoftValueMap());
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public RDBMSPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (MappedStoreManager)storeMgr;
    }

    public void close() {
        this.requestsByID.clear();
        this.requestsByID = null;
    }

    public void insertObject(StateManager sm) {
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getBooleanObjectProperty("datanucleus.rdbms.dynamicSchemaUpdates").booleanValue()) {
            NucleusLogger.JDO.debug((Object)">> RDBMSPersistenceHandler - checking dynamic schema");
            DynamicSchemaFieldManager dynamicSchemaFM = new DynamicSchemaFieldManager((RDBMSManager)this.storeMgr, sm);
            sm.provideFields(sm.getLoadedFieldNumbers(), (FieldManager)dynamicSchemaFM);
            if (dynamicSchemaFM.hasPerformedSchemaUpdates()) {
                NucleusLogger.JDO.debug((Object)">> RDBMSPersistenceHandler - schema updates performed so invalidating all requests");
                this.requestsByID.clear();
            }
            NucleusLogger.JDO.debug((Object)">> RDBMSPersistenceHandler - check of dynamic schema DONE");
        }
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        String className = sm.getObject().getClass().getName();
        DatastoreClass dc = this.storeMgr.getDatastoreClass(className, clr);
        if (dc == null) {
            AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(sm.getObject().getClass(), clr);
            if (cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                throw new NucleusUserException(LOCALISER.msg("032013", (Object)className));
            }
            throw new NucleusException(LOCALISER.msg("032014", (Object)className, (Object)cmd.getInheritanceMetaData().getStrategyValue())).setFatal();
        }
        if (this.storeMgr.getRuntimeManager() != null) {
            this.storeMgr.getRuntimeManager().incrementInsertCount();
        }
        this.insertTable(dc, sm, clr);
    }

    private void insertTable(DatastoreClass table, StateManager sm, ClassLoaderResolver clr) {
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.insertTable(supertable, sm, clr);
        }
        InsertRequest req = this.getInsertRequest(table, sm.getObject().getClass(), clr);
        req.execute(sm);
        Collection secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            Iterator tablesIter = secondaryTables.iterator();
            while (tablesIter.hasNext()) {
                SecondaryTable secTable = (SecondaryTable)tablesIter.next();
                this.insertTable(secTable, sm, clr);
            }
        }
    }

    private InsertRequest getInsertRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestIdentifier.Type.INSERT, cls.getName());
        InsertRequest req = (InsertRequest)this.requestsByID.get(reqID);
        if (req == null) {
            req = new InsertRequest(table, cls, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void fetchObject(StateManager sm, int[] fieldNumbers) {
        AbstractMemberMetaData[] fmds = null;
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            fmds = new AbstractMemberMetaData[fieldNumbers.length];
            for (int i = 0; i < fmds.length; ++i) {
                fmds[i] = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            }
            if (sm.getPcObjectType() != 0) {
                StringBuffer str = new StringBuffer();
                for (int i = 0; i < fmds.length; ++i) {
                    if (i > 0) {
                        str.append(',');
                    }
                    str.append(fmds[i].getName());
                }
                NucleusLogger.PERSISTENCE.info((Object)("Request to load fields \"" + str.toString() + "\" of class " + sm.getClassMetaData().getFullClassName() + " but object is embedded, so ignored"));
            } else {
                if (this.storeMgr.getRuntimeManager() != null) {
                    this.storeMgr.getRuntimeManager().incrementFetchCount();
                }
                ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
                DatastoreClass table = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
                FetchRequest req = this.getFetchRequest(table, fmds, sm.getObject().getClass(), clr);
                req.execute(sm);
            }
        }
    }

    private FetchRequest getFetchRequest(DatastoreClass table, AbstractMemberMetaData[] fieldMetaData, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, fieldMetaData, RequestIdentifier.Type.FETCH, cls.getName());
        FetchRequest req = (FetchRequest)this.requestsByID.get(reqID);
        if (req == null) {
            req = new FetchRequest(table, fieldMetaData, cls, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void updateObject(StateManager sm, int[] fieldNumbers) {
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getBooleanObjectProperty("datanucleus.rdbms.dynamicSchemaUpdates").booleanValue()) {
            NucleusLogger.JDO.debug((Object)">> RDBMSPersistenceHandler - checking dynamic schema");
            DynamicSchemaFieldManager dynamicSchemaFM = new DynamicSchemaFieldManager((RDBMSManager)this.storeMgr, sm);
            sm.provideFields(fieldNumbers, (FieldManager)dynamicSchemaFM);
            if (dynamicSchemaFM.hasPerformedSchemaUpdates()) {
                NucleusLogger.JDO.debug((Object)">> RDBMSPersistenceHandler - schema updates performed so invalidating all requests");
                this.requestsByID.clear();
            }
            NucleusLogger.JDO.debug((Object)">> RDBMSPersistenceHandler - check of dynamic schema DONE");
        }
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        AbstractMemberMetaData[] fmds = null;
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            fmds = new AbstractMemberMetaData[fieldNumbers.length];
            for (int i = 0; i < fmds.length; ++i) {
                fmds[i] = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementUpdateCount();
            }
            ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
            DatastoreClass dc = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
            this.updateTable(dc, sm, clr, fmds);
        }
    }

    private void updateTable(DatastoreClass table, StateManager sm, ClassLoaderResolver clr, AbstractMemberMetaData[] fieldMetaData) {
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.updateTable(supertable, sm, clr, fieldMetaData);
        }
        UpdateRequest req = this.getUpdateRequest(table, fieldMetaData, sm.getObject().getClass(), clr);
        req.execute(sm);
        Collection secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            Iterator tablesIter = secondaryTables.iterator();
            while (tablesIter.hasNext()) {
                SecondaryTable secTable = (SecondaryTable)tablesIter.next();
                this.updateTable(secTable, sm, clr, fieldMetaData);
            }
        }
    }

    private UpdateRequest getUpdateRequest(DatastoreClass table, AbstractMemberMetaData[] fieldMetaData, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, fieldMetaData, RequestIdentifier.Type.UPDATE, cls.getName());
        UpdateRequest req = (UpdateRequest)this.requestsByID.get(reqID);
        if (req == null) {
            req = new UpdateRequest(table, fieldMetaData, cls, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void deleteObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        if (this.storeMgr.getRuntimeManager() != null) {
            this.storeMgr.getRuntimeManager().incrementDeleteCount();
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        DatastoreClass dc = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
        this.deleteTable(dc, sm, clr);
    }

    private void deleteTable(DatastoreClass table, StateManager sm, ClassLoaderResolver clr) {
        Collection secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            Iterator tablesIter = secondaryTables.iterator();
            while (tablesIter.hasNext()) {
                SecondaryTable secTable = (SecondaryTable)tablesIter.next();
                this.deleteTable(secTable, sm, clr);
            }
        }
        DeleteRequest req = this.getDeleteRequest(table, sm.getObject().getClass(), clr);
        req.execute(sm);
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.deleteTable(supertable, sm, clr);
        }
    }

    private DeleteRequest getDeleteRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestIdentifier.Type.DELETE, cls.getName());
        DeleteRequest req = (DeleteRequest)this.requestsByID.get(reqID);
        if (req == null) {
            req = new DeleteRequest(table, cls, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void locateObject(StateManager sm) {
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        DatastoreClass table = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
        LocateRequest req = this.getLocateRequest(table, sm.getObject().getClass().getName());
        req.execute(sm);
    }

    private LocateRequest getLocateRequest(DatastoreClass table, String className) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestIdentifier.Type.LOCATE, className);
        LocateRequest req = (LocateRequest)this.requestsByID.get(reqID);
        if (req == null) {
            req = new LocateRequest(table);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public Object findObject(ObjectManager om, Object id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRequests() {
        Map map = this.requestsByID;
        synchronized (map) {
            this.requestsByID.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequestsForTable(DatastoreClass table) {
        Map map = this.requestsByID;
        synchronized (map) {
            HashSet keySet = new HashSet(this.requestsByID.keySet());
            Iterator keyIter = keySet.iterator();
            while (keyIter.hasNext()) {
                RequestIdentifier reqId = (RequestIdentifier)keyIter.next();
                if (reqId.getTable() != table) continue;
                this.requestsByID.remove(reqId);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

