/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import org.datanucleus.store.mapped.expression.BooleanBitColumnLiteral;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.query.StatementText;

public class BooleanBitColumnExpression
extends BooleanExpression {
    private boolean truthTest;
    private StatementText booleanCondition = new StatementText();

    public BooleanBitColumnExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te) {
        this(qs, mapping, te, true);
    }

    public BooleanBitColumnExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te, boolean truthTest) {
        super(qs, mapping, te);
        this.truthTest = truthTest;
        this.booleanCondition.append(" = ").append(new BooleanBitColumnLiteral(qs, mapping, truthTest));
        this.lowestOperator = ScalarExpression.OP_EQ;
    }

    public BooleanExpression not() {
        return new BooleanBitColumnExpression(this.qs, this.mapping, this.te, !this.truthTest);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.eq(new NumericExpression(this.qs, this.mapping, this.te));
        }
        if (expr instanceof BooleanBitColumnExpression) {
            return new BooleanExpression(new NumericExpression(this.qs, this.mapping, this.te), ScalarExpression.OP_EQ, new NumericExpression(this.qs, expr.mapping, expr.te));
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.noteq(new NumericExpression(this.qs, this.mapping, this.te));
        }
        if (expr instanceof BooleanBitColumnExpression) {
            return new BooleanExpression(new NumericExpression(this.qs, this.mapping, this.te), ScalarExpression.OP_NOTEQ, new NumericExpression(this.qs, expr.mapping, expr.te));
        }
        return super.noteq(expr);
    }

    public StatementText toStatementText(int mode) {
        StatementText st = super.toStatementText(mode);
        if (mode == ScalarExpression.FILTER) {
            st.append(this.booleanCondition, mode);
        }
        return st;
    }
}

