/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j.query.expression;

import org.datanucleus.store.neo4j.query.expression.Neo4jExpression;
import org.datanucleus.store.neo4j.query.expression.Neo4jFieldExpression;
import org.datanucleus.store.neo4j.query.expression.Neo4jLiteral;
import org.datanucleus.store.query.expression.Expression;

public class Neo4jBooleanExpression
extends Neo4jExpression {
    public Neo4jBooleanExpression(String cypher) {
        this.cypherText = cypher;
    }

    public Neo4jBooleanExpression(Neo4jFieldExpression fieldExpr, Neo4jLiteral lit, Expression.Operator op) {
        String propName = fieldExpr.getFieldName();
        if (op == Expression.OP_EQ) {
            this.cypherText = propName + (String)(lit.getValue() == null ? " IS NULL" : " = " + lit.getCypherText());
        } else if (op == Expression.OP_NOTEQ) {
            this.cypherText = propName + (String)(lit.getValue() == null ? " IS NOT NULL" : " <> " + lit.getCypherText());
        } else if (op == Expression.OP_GT) {
            this.cypherText = propName + " > " + lit.getCypherText();
        } else if (op == Expression.OP_GTEQ) {
            this.cypherText = propName + " >= " + lit.getCypherText();
        } else if (op == Expression.OP_LT) {
            this.cypherText = propName + " < " + lit.getCypherText();
        } else if (op == Expression.OP_LTEQ) {
            this.cypherText = propName + " <= " + lit.getCypherText();
        }
    }

    public Neo4jBooleanExpression(Neo4jBooleanExpression expr1, Neo4jBooleanExpression expr2, Expression.DyadicOperator op) {
        if (op == Expression.OP_AND) {
            this.cypherText = "(" + expr1.getCypherText() + ") and (" + expr2.getCypherText() + ")";
        } else if (op == Expression.OP_OR) {
            this.cypherText = "(" + expr1.getCypherText() + ") or (" + expr2.getCypherText() + ")";
        }
    }

    public Neo4jBooleanExpression(Neo4jBooleanExpression expr, Expression.MonadicOperator op) {
        if (op == Expression.OP_NOT) {
            this.cypherText = "not(" + expr.getCypherText() + ")";
        }
    }

    public Neo4jBooleanExpression(Neo4jExpression expr1, Neo4jExpression expr2, Expression.Operator op) {
        if (op == Expression.OP_EQ) {
            this.cypherText = expr1.getCypherText() + " = " + expr2.getCypherText();
        } else if (op == Expression.OP_NOTEQ) {
            this.cypherText = expr1.getCypherText() + " <> " + expr2.getCypherText();
        } else if (op == Expression.OP_GT) {
            this.cypherText = expr1.getCypherText() + " > " + expr2.getCypherText();
        } else if (op == Expression.OP_GTEQ) {
            this.cypherText = expr1.getCypherText() + " >= " + expr2.getCypherText();
        } else if (op == Expression.OP_LT) {
            this.cypherText = expr1.getCypherText() + " < " + expr2.getCypherText();
        } else if (op == Expression.OP_LTEQ) {
            this.cypherText = expr1.getCypherText() + " <= " + expr2.getCypherText();
        }
    }
}

