/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j.fieldmanager;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.neo4j.fieldmanager.StoreFieldManager;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.ClassUtils;
import org.neo4j.graphdb.PropertyContainer;

public class StoreEmbeddedFieldManager
extends StoreFieldManager {
    protected List<AbstractMemberMetaData> mmds;

    public StoreEmbeddedFieldManager(DNStateManager sm, PropertyContainer propObj, boolean insert, List<AbstractMemberMetaData> mmds, Table table) {
        super(sm, propObj, insert, table);
        this.mmds = mmds;
    }

    public StoreEmbeddedFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, PropertyContainer propObj, boolean insert, List<AbstractMemberMetaData> mmds, Table table) {
        super(ec, cmd, propObj, insert, table);
        this.mmds = mmds;
    }

    @Override
    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
        embMmds.add(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        return this.table.getMemberColumnMappingForEmbeddedMember(embMmds);
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        AbstractMemberMetaData lastMmd = this.mmds.get(this.mmds.size() - 1);
        EmbeddedMetaData embmd = this.mmds.get(0).getEmbeddedMetaData();
        if (this.mmds.size() == 1 && embmd != null && embmd.getOwnerMember() != null && embmd.getOwnerMember().equals(mmd.getName())) {
            DNStateManager ownerSM = this.ec.getOwnerForEmbeddedStateManager(this.sm);
            if (ownerSM != null && value != ownerSM.getObject()) {
                this.sm.replaceField(fieldNumber, ownerSM.getObject());
            }
            return;
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, lastMmd) && RelationType.isRelationSingleValued((RelationType)relationType)) {
            AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
            if (embCmd == null) {
                throw new NucleusUserException("Field " + mmd.getFullFieldName() + " specified as embedded but metadata not found for the class of type " + mmd.getTypeName());
            }
            if (RelationType.isBidirectional((RelationType)relationType)) {
                // empty if block
            }
            ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
            embMmds.add(mmd);
            if (value == null) {
                int[] embMmdPosns = embCmd.getAllMemberPositions();
                StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(this.ec, embCmd, this.propObj, this.insert, embMmds, this.table);
                for (int i = 0; i < embMmdPosns.length; ++i) {
                    AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(embMmdPosns[i]);
                    if (String.class.isAssignableFrom(embMmd.getType()) || embMmd.getType().isPrimitive() || ClassUtils.isPrimitiveWrapperType((String)mmd.getTypeName())) {
                        ArrayList<AbstractMemberMetaData> colEmbMmds = new ArrayList<AbstractMemberMetaData>(embMmds);
                        colEmbMmds.add(embMmd);
                        MemberColumnMapping mapping = this.table.getMemberColumnMappingForEmbeddedMember(colEmbMmds);
                        this.propObj.removeProperty(mapping.getColumn(0).getName());
                        continue;
                    }
                    if (!Object.class.isAssignableFrom(embMmd.getType())) continue;
                    storeEmbFM.storeObjectField(embMmdPosns[i], null);
                }
                return;
            }
            DNStateManager embSM = this.ec.findStateManagerForEmbedded(value, this.sm, mmd, null);
            StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embSM, this.propObj, this.insert, embMmds, this.table);
            embSM.provideFields(embCmd.getAllMemberPositions(), (FieldManager)ffm);
            return;
        }
        this.storeNonEmbeddedObjectField(mmd, relationType, clr, value);
    }
}

