/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.neo4j.Neo4jStoreManager;
import org.datanucleus.store.neo4j.fieldmanager.FetchFieldManager;
import org.datanucleus.store.neo4j.query.LazyLoadQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.EnumConversionHelper;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.RelationshipIndex;

public class Neo4jUtils {
    public static PropertyContainer getPropertyContainerForStateManager(GraphDatabaseService graphDB, DNStateManager sm) {
        Object val = sm.getAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER);
        if (val != null) {
            return (PropertyContainer)val;
        }
        AbstractClassMetaData cmd = sm.getClassMetaData();
        ExecutionContext ec = sm.getExecutionContext();
        PropertyContainer propObj = Neo4jUtils.getPropertyContainerForObjectId(graphDB, ec, cmd, sm.getInternalObjectId());
        if (propObj != null) {
            sm.setAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER, (Object)propObj);
        }
        return propObj;
    }

    public static PropertyContainer getPropertyContainerForObjectId(GraphDatabaseService graphDB, ExecutionContext ec, AbstractClassMetaData cmd, Object id) {
        StoreManager storeMgr = ec.getStoreManager();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        StoreData sd = storeMgr.getStoreDataForClass(cmd.getFullClassName());
        if (sd == null) {
            storeMgr.manageClasses(clr, new String[]{cmd.getFullClassName()});
            sd = storeMgr.getStoreDataForClass(cmd.getFullClassName());
        }
        Table table = sd.getTable();
        boolean attributedRelation = Neo4jUtils.classIsAttributedRelation(cmd);
        if (cmd.pkIsDatastoreAttributed(storeMgr)) {
            int[] pkFieldNumbers;
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                Long key = (Long)IdentityUtils.getTargetKeyForDatastoreIdentity((Object)id);
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving PropertyContainer for id=" + key));
                }
                return attributedRelation ? graphDB.getRelationshipById(key.longValue()) : graphDB.getNodeById(key.longValue());
            }
            if (cmd.getIdentityType() == IdentityType.APPLICATION && (pkFieldNumbers = cmd.getPKMemberPositions()).length == 1) {
                Long key = (Long)IdentityUtils.getTargetKeyForSingleFieldIdentity((Object)id);
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving PropertyContainer for id=" + key));
                }
                return attributedRelation ? graphDB.getRelationshipById(key.longValue()) : graphDB.getNodeById(key.longValue());
            }
        }
        if (attributedRelation ? !graphDB.index().existsForRelationships(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX) : !graphDB.index().existsForNodes(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX)) {
            return null;
        }
        StringBuilder cypherString = new StringBuilder();
        cypherString.append("START pc=" + (attributedRelation ? "relationship:" : "node:") + Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX + "(" + Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX_KEY + "=\"" + cmd.getFullClassName() + "\")");
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            cypherString.append(" WHERE (");
            int[] pkPositions = cmd.getPKMemberPositions();
            for (int i = 0; i < pkPositions.length; ++i) {
                AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkPositions[i]);
                RelationType relType = pkMmd.getRelationType(clr);
                if (relType != RelationType.NONE) {
                    throw new NucleusException("We do not currently support retrieving objects with PK field that is a relation : " + pkMmd.getFullFieldName());
                }
                Object value = null;
                value = cmd.usesSingleFieldIdentityClass() ? IdentityUtils.getTargetKeyForSingleFieldIdentity((Object)id) : IdentityUtils.getValueForMemberInId((Object)id, (AbstractMemberMetaData)pkMmd);
                cypherString.append("pc." + table.getMemberColumnMappingForMember(pkMmd).getColumn(0).getName());
                cypherString.append(" = ");
                Object storedValue = Neo4jUtils.getStoredValueForField(ec, pkMmd, value, FieldRole.ROLE_FIELD);
                if (storedValue instanceof String) {
                    cypherString.append("\"" + storedValue + "\"");
                } else {
                    cypherString.append(storedValue);
                }
                if (i == pkPositions.length - 1) continue;
                cypherString.append(" and ");
            }
            cypherString.append(")");
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            if (id == null || storeMgr.isValueGenerationStrategyDatastoreAttributed(cmd, -1)) {
                return null;
            }
            Object value = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)id);
            String propName = table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID).getName();
            cypherString.append(" WHERE (pc.");
            cypherString.append(propName);
            cypherString.append(" = ");
            cypherString.append(Neo4jUtils.getStoredValueForField(ec, null, value, FieldRole.ROLE_FIELD));
            cypherString.append(")");
        } else {
            throw new NucleusException("Impossible to retrieve Node/Relationship for nondurable identity");
        }
        if (cmd.hasDiscriminatorStrategy()) {
            String propName = table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR).getName();
            Object discVal = cmd.getDiscriminatorValue();
            cypherString.append(" and (pc.").append(propName).append(" = \"").append(discVal).append("\")");
        }
        cypherString.append(" RETURN pc");
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving object using Cypher query : " + cypherString));
        }
        Result result = graphDB.execute(cypherString.toString());
        if (ec.getStatistics() != null) {
            ec.getStatistics().incrementNumReads();
        }
        if (!result.hasNext()) {
            result.close();
            return null;
        }
        Map map = result.next();
        PropertyContainer propObj = (PropertyContainer)map.get("pc");
        if (result.hasNext()) {
            throw new NucleusException("Query of Node/Relationship for object with id=" + id + " returned more than 1 result! : " + cypherString);
        }
        result.close();
        return propObj;
    }

    public static List executeCypherQuery(Query query, GraphDatabaseService db, String cypherText, AbstractClassMetaData candidateCmd) {
        int limitStart;
        int skipStart;
        int resultStart;
        String resultStr;
        int orderByStart;
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            if (candidateCmd != null) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving objects of type " + candidateCmd.getFullClassName() + " using Cypher query : " + cypherText));
            } else {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving objects using Cypher query : " + cypherText));
            }
        }
        if ((orderByStart = (resultStr = cypherText.substring(resultStart = cypherText.indexOf("RETURN ") + 7)).indexOf(" ORDER BY")) > 0) {
            resultStr = resultStr.substring(0, orderByStart);
        }
        if ((skipStart = resultStr.indexOf(" SKIP")) > 0) {
            resultStr = resultStr.substring(0, skipStart);
        }
        if ((limitStart = resultStr.indexOf(" LIMIT")) > 0) {
            resultStr = resultStr.substring(0, limitStart);
        }
        if (resultStr.equals(query.getCompilation().getCandidateAlias())) {
            resultStr = null;
        }
        Result queryResult = db.execute(cypherText);
        return new LazyLoadQueryResult(query, queryResult, resultStr);
    }

    public static String getCypherTextForQuery(ExecutionContext ec, AbstractClassMetaData cmd, String candidateAlias, boolean subclasses, String filterText, String resultText, String orderText, Long rangeFromIncl, Long rangeToExcl) {
        String value;
        StoreData sd = ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName());
        if (sd == null) {
            ec.getStoreManager().manageClasses(ec.getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
            sd = ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName());
        }
        Table table = sd.getTable();
        boolean attributedRelation = Neo4jUtils.classIsAttributedRelation(cmd);
        if (candidateAlias == null) {
            candidateAlias = attributedRelation ? "r" : "n";
        }
        StringBuilder cypherString = new StringBuilder();
        Object indexClassName = cmd.getFullClassName();
        if (!subclasses) {
            indexClassName = (String)indexClassName + "-EXCLUSIVE";
        }
        cypherString.append("START " + candidateAlias + (attributedRelation ? "=relationship:" : "=node:") + Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX + "(" + Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX_KEY + "=\"" + (String)indexClassName + "\")");
        boolean multiple = false;
        String multitenancyText = null;
        Column multitenancyCol = table.getSurrogateColumn(SurrogateColumnType.MULTITENANCY);
        if (multitenancyCol != null && (value = ec.getTenantId()) != null) {
            String propName = multitenancyCol.getName();
            multitenancyText = propName + " = \"" + value + "\"";
            if (filterText != null) {
                multiple = true;
            }
        }
        String softDeleteText = null;
        Column softDeleteCol = table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE);
        if (softDeleteCol != null) {
            String propName = softDeleteCol.getName();
            softDeleteText = propName + " = \"" + Boolean.FALSE + "\"";
            if (filterText != null) {
                multiple = true;
            }
        }
        if (filterText != null || multitenancyText != null || softDeleteText != null) {
            cypherString.append(" WHERE ");
            boolean started = false;
            if (filterText != null) {
                if (multiple) {
                    cypherString.append("(");
                }
                cypherString.append(filterText);
                if (multiple) {
                    cypherString.append(")");
                }
                started = true;
            }
            if (multitenancyText != null) {
                if (started) {
                    cypherString.append(" and");
                }
                if (multiple) {
                    cypherString.append("(");
                }
                cypherString.append(multitenancyText);
                if (multiple) {
                    cypherString.append(")");
                }
            }
            if (softDeleteText != null) {
                if (started) {
                    cypherString.append(" and");
                }
                if (multiple) {
                    cypherString.append("(");
                }
                cypherString.append(softDeleteText);
                if (multiple) {
                    cypherString.append(")");
                }
            }
        }
        if (resultText != null) {
            cypherString.append(" RETURN " + resultText);
        } else {
            cypherString.append(" RETURN " + candidateAlias);
        }
        if (orderText != null) {
            cypherString.append(" ORDER BY " + orderText);
        }
        if (rangeFromIncl != null || rangeToExcl != null) {
            long lower = 0L;
            if (rangeFromIncl != null) {
                lower = rangeFromIncl;
                cypherString.append(" SKIP " + rangeFromIncl);
            }
            if (rangeToExcl != null) {
                cypherString.append(" LIMIT " + (rangeToExcl - lower));
            }
        }
        return cypherString.toString();
    }

    public static AbstractClassMetaData getClassMetaDataForPropertyContainer(PropertyContainer propObj, ExecutionContext ec, AbstractClassMetaData cmd) {
        block6: {
            block5: {
                boolean attributedRelation = Neo4jUtils.classIsAttributedRelation(cmd);
                if (!attributedRelation) break block5;
                RelationshipIndex typesIdx = propObj.getGraphDatabase().index().forRelationships(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX);
                String[] subclassNames = ec.getMetaDataManager().getSubclassesForClass(cmd.getFullClassName(), false);
                if (subclassNames == null) break block6;
                for (int i = 0; i < subclassNames.length; ++i) {
                    AbstractClassMetaData subcmd = ec.getMetaDataManager().getMetaDataForClass(subclassNames[i], ec.getClassLoaderResolver());
                    IndexHits relsForSubclass = typesIdx.get(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX_KEY, (Object)subcmd.getFullClassName());
                    if (relsForSubclass == null) continue;
                    for (Relationship subclassRel : relsForSubclass) {
                        if (!subclassRel.equals(propObj)) continue;
                        return Neo4jUtils.getClassMetaDataForPropertyContainer((PropertyContainer)subclassRel, ec, subcmd);
                    }
                }
                break block6;
            }
            Index typesIdx = propObj.getGraphDatabase().index().forNodes(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX);
            String[] subclassNames = ec.getMetaDataManager().getSubclassesForClass(cmd.getFullClassName(), false);
            if (subclassNames != null) {
                for (int i = 0; i < subclassNames.length; ++i) {
                    AbstractClassMetaData subcmd = ec.getMetaDataManager().getMetaDataForClass(subclassNames[i], ec.getClassLoaderResolver());
                    IndexHits nodesForSubclass = typesIdx.get(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX_KEY, (Object)subcmd.getFullClassName());
                    if (nodesForSubclass == null) continue;
                    for (Node subclassNode : nodesForSubclass) {
                        if (!subclassNode.equals(propObj)) continue;
                        return Neo4jUtils.getClassMetaDataForPropertyContainer((PropertyContainer)subclassNode, ec, subcmd);
                    }
                }
            }
        }
        return cmd;
    }

    public static Object getObjectForPropertyContainer(PropertyContainer propObj, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache) {
        int[] fpMembers = ec.getFetchPlan().getFetchPlanForClass(cmd).getMemberNumbers();
        Object obj = null;
        obj = cmd.getIdentityType() == IdentityType.APPLICATION ? Neo4jUtils.getObjectUsingApplicationIdForDBObject(propObj, cmd, ec, ignoreCache, fpMembers) : (cmd.getIdentityType() == IdentityType.DATASTORE ? Neo4jUtils.getObjectUsingDatastoreIdForDBObject(propObj, cmd, ec, ignoreCache, fpMembers) : Neo4jUtils.getObjectUsingNondurableIdForDBObject(propObj, cmd, ec, ignoreCache, fpMembers));
        return obj;
    }

    protected static Object getObjectUsingApplicationIdForDBObject(PropertyContainer propObj, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        Class type;
        Table table;
        FetchFieldManager fm;
        Object id;
        Persistable pc;
        DNStateManager sm;
        StoreData sd = ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName());
        if (sd == null) {
            ec.getStoreManager().manageClasses(ec.getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
            sd = ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName());
        }
        if ((sm = ec.findStateManager((Object)(pc = ec.findObject(id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)false, (FieldManager)(fm = new FetchFieldManager(ec, propObj, cmd, table = sd.getTable()))), false, false, (type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName())).getName())))).getAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER) == null) {
            sm.setAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER, (Object)propObj);
            sm.loadFieldValues(new FieldValues((FieldManager)fm){
                final /* synthetic */ FieldManager val$fm;
                {
                    this.val$fm = fieldManager;
                }

                public void fetchFields(DNStateManager sm) {
                    sm.replaceFields(fpMembers, this.val$fm);
                }

                public void fetchNonLoadedFields(DNStateManager sm) {
                    sm.replaceNonLoadedFields(fpMembers, this.val$fm);
                }

                public FetchPlan getFetchPlanForLoading() {
                    return null;
                }
            });
            if (cmd.isVersioned()) {
                Object version = null;
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                if (vermd.getMemberName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getMemberName());
                    version = sm.provideField(verMmd.getAbsoluteFieldNumber());
                } else {
                    version = propObj.getProperty(table.getSurrogateColumn(SurrogateColumnType.VERSION).getName());
                }
                sm.setVersion(version);
            }
            sm.replaceAllLoadedSCOFieldsWithWrappers();
        }
        return pc;
    }

    protected static Object getObjectUsingDatastoreIdForDBObject(PropertyContainer propObj, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        Class type;
        StoreData sd = ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName());
        if (sd == null) {
            ec.getStoreManager().manageClasses(ec.getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
            sd = ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName());
        }
        Table table = sd.getTable();
        Object idKey = propObj.getProperty(table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID).getName());
        DatastoreId id = ec.getNucleusContext().getIdentityManager().getDatastoreId(cmd.getFullClassName(), idKey);
        Persistable pc = ec.findObject((Object)id, false, false, (type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName())).getName());
        DNStateManager sm = ec.findStateManager((Object)pc);
        if (sm.getAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER) == null) {
            sm.setAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER, (Object)propObj);
            FetchFieldManager fm = new FetchFieldManager(sm, propObj, table);
            sm.loadFieldValues(new FieldValues((FieldManager)fm){
                final /* synthetic */ FieldManager val$fm;
                {
                    this.val$fm = fieldManager;
                }

                public void fetchFields(DNStateManager sm) {
                    sm.replaceFields(fpMembers, this.val$fm);
                }

                public void fetchNonLoadedFields(DNStateManager sm) {
                    sm.replaceNonLoadedFields(fpMembers, this.val$fm);
                }

                public FetchPlan getFetchPlanForLoading() {
                    return null;
                }
            });
            if (cmd.isVersioned()) {
                Object version = null;
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                version = vermd.getMemberName() != null ? sm.provideField(cmd.getMetaDataForMember(vermd.getMemberName()).getAbsoluteFieldNumber()) : propObj.getProperty(table.getSurrogateColumn(SurrogateColumnType.VERSION).getName());
                sm.setVersion(version);
            }
        }
        return pc;
    }

    protected static Object getObjectUsingNondurableIdForDBObject(PropertyContainer propObj, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        SCOID id = new SCOID(cmd.getFullClassName());
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Persistable pc = ec.findObject((Object)id, false, false, type.getName());
        DNStateManager sm = ec.findStateManager((Object)pc);
        StoreData sd = ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName());
        if (sd == null) {
            ec.getStoreManager().manageClasses(ec.getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
            sd = ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName());
        }
        Table table = sd.getTable();
        if (sm.getAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER) == null) {
            sm.setAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER, (Object)propObj);
            FetchFieldManager fm = new FetchFieldManager(sm, propObj, table);
            sm.loadFieldValues(new FieldValues((FieldManager)fm){
                final /* synthetic */ FieldManager val$fm;
                {
                    this.val$fm = fieldManager;
                }

                public void fetchFields(DNStateManager sm) {
                    sm.replaceFields(fpMembers, this.val$fm);
                }

                public void fetchNonLoadedFields(DNStateManager sm) {
                    sm.replaceNonLoadedFields(fpMembers, this.val$fm);
                }

                public FetchPlan getFetchPlanForLoading() {
                    return null;
                }
            });
            if (cmd.isVersioned()) {
                Object version = null;
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                if (vermd.getMemberName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getMemberName());
                    version = sm.provideField(verMmd.getAbsoluteFieldNumber());
                } else {
                    version = propObj.getProperty(table.getSurrogateColumn(SurrogateColumnType.VERSION).getName());
                }
                sm.setVersion(version);
            }
        }
        return pc;
    }

    public static Object getStoredValueForField(ExecutionContext ec, AbstractMemberMetaData mmd, Object value, FieldRole fieldRole) {
        if (value == null) {
            return null;
        }
        boolean optional = mmd != null ? Optional.class.isAssignableFrom(mmd.getType()) : false;
        Class type = value.getClass();
        if (mmd != null) {
            type = optional ? ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType()) : (fieldRole == FieldRole.ROLE_COLLECTION_ELEMENT ? ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType()) : (fieldRole == FieldRole.ROLE_ARRAY_ELEMENT ? ec.getClassLoaderResolver().classForName(mmd.getArray().getElementType()) : (fieldRole == FieldRole.ROLE_MAP_KEY ? ec.getClassLoaderResolver().classForName(mmd.getMap().getKeyType()) : (fieldRole == FieldRole.ROLE_MAP_VALUE ? ec.getClassLoaderResolver().classForName(mmd.getMap().getValueType()) : mmd.getType()))));
        }
        if (mmd != null && mmd.hasCollection() && !optional && fieldRole == FieldRole.ROLE_FIELD) {
            Collection rawColl = (Collection)value;
            if (rawColl.isEmpty()) {
                return null;
            }
            Object[] objArray = new Object[rawColl.size()];
            int i = 0;
            for (Object elem : rawColl) {
                Object storeElem = Neo4jUtils.getStoredValueForField(ec, mmd, elem, FieldRole.ROLE_COLLECTION_ELEMENT);
                objArray[i++] = storeElem;
            }
            return Neo4jUtils.convertArrayToStorableArray(objArray, mmd);
        }
        if (mmd != null && mmd.hasArray() && fieldRole == FieldRole.ROLE_FIELD) {
            if (Array.getLength(value) == 0) {
                return null;
            }
            if (type.getComponentType().isPrimitive()) {
                return value;
            }
            if (type.getComponentType() == String.class) {
                return value;
            }
            Object[] objArray = new Object[Array.getLength(value)];
            for (int i = 0; i < objArray.length; ++i) {
                Object storeElem;
                Object elem = Array.get(value, i);
                objArray[i] = storeElem = Neo4jUtils.getStoredValueForField(ec, mmd, elem, FieldRole.ROLE_ARRAY_ELEMENT);
            }
            return Neo4jUtils.convertArrayToStorableArray(objArray, mmd);
        }
        if (Byte.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || String.class.isAssignableFrom(type)) {
            return value;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return EnumConversionHelper.getStoredValueFromEnum((AbstractMemberMetaData)mmd, (FieldRole)fieldRole, (Enum)((Enum)value));
        }
        TypeConverter strConv = ec.getTypeManager().getTypeConverterForType(type, String.class);
        TypeConverter longConv = ec.getTypeManager().getTypeConverterForType(type, Long.class);
        if (strConv != null) {
            return strConv.toDatastoreType(value);
        }
        if (longConv != null) {
            return longConv.toDatastoreType(value);
        }
        return value;
    }

    private static Object convertArrayToStorableArray(Object[] objArray, AbstractMemberMetaData mmd) {
        if (objArray == null || objArray.length == 0) {
            return null;
        }
        Object array = objArray;
        Class<?> cmptCls = objArray[0].getClass();
        if (ClassUtils.isPrimitiveWrapperType((String)cmptCls.getName())) {
            Class primType = ClassUtils.getPrimitiveTypeForType(cmptCls);
            array = Array.newInstance(primType, objArray.length);
            for (int i = 0; i < objArray.length; ++i) {
                Array.set(array, i, objArray[i]);
            }
        } else if (cmptCls.isPrimitive() || cmptCls == String.class) {
            array = Array.newInstance(cmptCls, objArray.length);
            for (int i = 0; i < objArray.length; ++i) {
                Array.set(array, i, objArray[i]);
            }
        } else {
            throw new NucleusException("Field " + mmd.getFullFieldName() + " cannot be persisted to Neo4j since Neo4j doesn't natively support such a type (" + mmd.getType() + ")");
        }
        return array;
    }

    public static Object getFieldValueFromStored(ExecutionContext ec, AbstractMemberMetaData mmd, Object value, FieldRole fieldRole) {
        if (value == null) {
            return null;
        }
        boolean optional = mmd != null ? Optional.class.isAssignableFrom(mmd.getType()) : false;
        Class type = value.getClass();
        if (mmd != null) {
            type = optional ? ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType()) : (fieldRole == FieldRole.ROLE_COLLECTION_ELEMENT ? ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType()) : (fieldRole == FieldRole.ROLE_ARRAY_ELEMENT ? ec.getClassLoaderResolver().classForName(mmd.getArray().getElementType()) : (fieldRole == FieldRole.ROLE_MAP_KEY ? ec.getClassLoaderResolver().classForName(mmd.getMap().getKeyType()) : (fieldRole == FieldRole.ROLE_MAP_VALUE ? ec.getClassLoaderResolver().classForName(mmd.getMap().getValueType()) : mmd.getType()))));
        }
        if (mmd != null && mmd.hasCollection() && !optional && fieldRole == FieldRole.ROLE_FIELD) {
            Collection coll;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                coll = (Collection)instanceType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object elem = Array.get(value, i);
                Object storeElem = Neo4jUtils.getFieldValueFromStored(ec, mmd, elem, FieldRole.ROLE_COLLECTION_ELEMENT);
                coll.add(storeElem);
            }
            return coll;
        }
        if (mmd != null && mmd.hasArray() && fieldRole == FieldRole.ROLE_FIELD) {
            Object array = Array.newInstance(mmd.getType().getComponentType(), Array.getLength(value));
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object elem = Array.get(value, i);
                Object storeElem = Neo4jUtils.getFieldValueFromStored(ec, mmd, elem, FieldRole.ROLE_ARRAY_ELEMENT);
                Array.set(array, i++, storeElem);
            }
            return array;
        }
        if (Byte.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || String.class.isAssignableFrom(type)) {
            return value;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return EnumConversionHelper.getEnumForStoredValue((AbstractMemberMetaData)mmd, (FieldRole)fieldRole, (Object)value, (ClassLoaderResolver)ec.getClassLoaderResolver());
        }
        TypeConverter strConv = ec.getTypeManager().getTypeConverterForType(type, String.class);
        TypeConverter longConv = ec.getTypeManager().getTypeConverterForType(type, Long.class);
        if (strConv != null) {
            String strValue = (String)value;
            return strConv.toMemberType((Object)strValue);
        }
        if (longConv != null) {
            Long longValue = (Long)value;
            return longConv.toMemberType((Object)longValue);
        }
        return value;
    }

    public static String getPropertyNameForEmbeddedField(AbstractMemberMetaData ownerMmd, int fieldNumber) {
        String columnName = null;
        EmbeddedMetaData embmd = ownerMmd.getEmbeddedMetaData();
        AbstractMemberMetaData embMmd = null;
        if (embmd != null) {
            embMmd = (AbstractMemberMetaData)embmd.getMemberMetaData().get(fieldNumber);
        }
        if (embMmd != null) {
            ColumnMetaData[] colmds = embMmd.getColumnMetaData();
            if (colmds != null && colmds.length > 0) {
                columnName = colmds[0].getName();
            }
            if (columnName == null) {
                columnName = embMmd.getName();
            }
            if (columnName == null) {
                columnName = embMmd.getName();
            }
        }
        return columnName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassNameForIdentity(Object id, AbstractClassMetaData rootCmd, ExecutionContext ec, ClassLoaderResolver clr) {
        StoreManager storeMgr = ec.getStoreManager();
        ManagedConnection mconn = storeMgr.getConnectionManager().getConnection(ec);
        try {
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            PropertyContainer propObj = Neo4jUtils.getPropertyContainerForObjectId(db, ec, rootCmd, id);
            if (propObj instanceof Node) {
                String string = Neo4jUtils.getClassMetaDataForPropertyContainer(propObj, ec, rootCmd).getFullClassName();
                return string;
            }
            String string = rootCmd.getFullClassName();
            return string;
        }
        finally {
            mconn.release();
        }
    }

    public static boolean classIsAttributedRelation(AbstractClassMetaData cmd) {
        return cmd.hasExtension(Neo4jStoreManager.METADATA_ATTRIBUTED_RELATION) && cmd.getValueForExtension(Neo4jStoreManager.METADATA_ATTRIBUTED_RELATION).equalsIgnoreCase("TRUE");
    }
}

