/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j;

import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.neo4j.Neo4jStoreManager;
import org.datanucleus.store.neo4j.Neo4jUtils;
import org.datanucleus.store.neo4j.fieldmanager.FetchFieldManager;
import org.datanucleus.store.neo4j.fieldmanager.StoreFieldManager;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

public class Neo4jPersistenceHandler
extends AbstractPersistenceHandler {
    public Neo4jPersistenceHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void close() {
    }

    public void insertObjects(DNStateManager ... sms) {
        ExecutionContext ec = sms[0].getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.InsertObjects.Start", (Object[])new Object[]{StringUtils.objectArrayToString((Object[])sms)}));
            }
            for (DNStateManager sm : sms) {
                this.insertObjectToPropertyContainer(sm, db);
            }
            for (DNStateManager sm : sms) {
                AbstractClassMetaData cmd = sm.getClassMetaData();
                StoreData sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                if (sd == null) {
                    this.storeMgr.manageClasses(sm.getExecutionContext().getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
                    sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                }
                Table table = sd.getTable();
                PropertyContainer propObj = (PropertyContainer)sm.getAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER);
                int[] relPositions = cmd.getRelationMemberPositions(ec.getClassLoaderResolver());
                if (relPositions.length <= 0) continue;
                StoreFieldManager fm = new StoreFieldManager(sm, propObj, true, table);
                sm.provideFields(relPositions, (FieldManager)fm);
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementInsertCount();
            }
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error((Object)"Exception inserting objects ", (Throwable)e);
            throw new NucleusDataStoreException("Exception inserting objects", (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public PropertyContainer insertObjectToPropertyContainer(DNStateManager sm, GraphDatabaseService db) {
        Column softDeleteCol;
        String tenantId;
        Column multitenancyCol;
        VersionMetaData vermd;
        this.assertReadOnlyForUpdateOfObject(sm);
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (!(cmd.getIdentityType() != IdentityType.APPLICATION && cmd.getIdentityType() != IdentityType.DATASTORE || cmd.pkIsDatastoreAttributed(this.storeMgr))) {
            try {
                this.locateObject(sm);
                throw new NucleusUserException(Localiser.msg((String)"Neo4j.Insert.ObjectWithIdAlreadyExists", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
            }
            catch (NucleusObjectNotFoundException nucleusObjectNotFoundException) {
                // empty catch block
            }
        }
        ExecutionContext ec = sm.getExecutionContext();
        StoreData sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
        if (sd == null) {
            this.storeMgr.manageClasses(sm.getExecutionContext().getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
            sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
        }
        Table table = sd.getTable();
        Node propObj = db.createNode();
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Persisting " + sm + " as " + (PropertyContainer)propObj));
        }
        this.addPropertyContainerToTypeIndex(db, (PropertyContainer)propObj, cmd, false);
        sm.setAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER, (Object)propObj);
        if (cmd.pkIsDatastoreAttributed(this.storeMgr)) {
            long id;
            long l = id = propObj instanceof Node ? propObj.getId() : ((Relationship)propObj).getId();
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                sm.setPostStoreNewObjectId((Object)id);
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.Insert.ObjectPersistedWithIdentity", (Object[])new Object[]{sm.getObjectAsPrintable(), id}));
                }
            } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                int[] pkFieldNumbers = cmd.getPKMemberPositions();
                for (int i = 0; i < pkFieldNumbers.length; ++i) {
                    AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
                    if (!this.storeMgr.isValueGenerationStrategyDatastoreAttributed(cmd, pkFieldNumbers[i])) continue;
                    if (!Number.class.isAssignableFrom(mmd.getType()) && mmd.getType() != Long.TYPE && mmd.getType() != Integer.TYPE) {
                        throw new NucleusUserException("Any field using IDENTITY value generation with Neo4j should be of type numeric");
                    }
                    sm.setPostStoreNewObjectId((Object)id);
                    if (!NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) continue;
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.Insert.ObjectPersistedWithIdentity", (Object[])new Object[]{sm.getObjectAsPrintable(), id}));
                }
            }
        }
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            String propName = table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID).getName();
            Object key = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)sm.getInternalObjectId());
            propObj.setProperty(propName, key);
        }
        if (cmd.isVersioned() && (vermd = cmd.getVersionMetaDataForClass()).getStrategy() == VersionStrategy.VERSION_NUMBER) {
            long versionNumber = 1L;
            sm.setTransactionalVersion((Object)versionNumber);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"Neo4j.Insert.ObjectPersistedWithVersion", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId(), "" + versionNumber}));
            }
            if (vermd.getMemberName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getMemberName());
                Number verFieldValue = versionNumber;
                if (verMmd.getType() == Integer.TYPE || verMmd.getType() == Integer.class) {
                    verFieldValue = (int)versionNumber;
                }
                sm.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)verFieldValue);
            } else {
                propObj.setProperty(table.getSurrogateColumn(SurrogateColumnType.VERSION).getName(), (Object)versionNumber);
            }
        }
        if (cmd.hasDiscriminatorStrategy()) {
            String propName = table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR).getName();
            propObj.setProperty(propName, cmd.getDiscriminatorValue());
        }
        if ((multitenancyCol = table.getSurrogateColumn(SurrogateColumnType.MULTITENANCY)) != null && (tenantId = ec.getTenantId()) != null) {
            propObj.setProperty(multitenancyCol.getName(), (Object)tenantId);
        }
        if ((softDeleteCol = table.getSurrogateColumn(SurrogateColumnType.SOFTDELETE)) != null) {
            propObj.setProperty(softDeleteCol.getName(), (Object)Boolean.FALSE);
        }
        int[] nonRelPositions = cmd.getNonRelationMemberPositions(ec.getClassLoaderResolver());
        StoreFieldManager fm = new StoreFieldManager(sm, (PropertyContainer)propObj, true, table);
        sm.provideFields(nonRelPositions, (FieldManager)fm);
        return propObj;
    }

    public void insertObject(DNStateManager sm) {
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.Insert.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
            }
            PropertyContainer propObj = this.insertObjectToPropertyContainer(sm, db);
            AbstractClassMetaData cmd = sm.getClassMetaData();
            StoreData sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            if (sd == null) {
                this.storeMgr.manageClasses(sm.getExecutionContext().getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
                sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            }
            Table table = sd.getTable();
            int[] relPositions = cmd.getRelationMemberPositions(ec.getClassLoaderResolver());
            if (relPositions.length > 0) {
                StoreFieldManager fm = new StoreFieldManager(sm, propObj, true, table);
                sm.provideFields(relPositions, (FieldManager)fm);
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementInsertCount();
            }
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception inserting object " + sm), (Throwable)e);
            throw new NucleusDataStoreException("Exception inserting object for " + sm, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    private void addPropertyContainerToTypeIndex(GraphDatabaseService db, PropertyContainer propObj, AbstractClassMetaData cmd, boolean superclass) {
        if (propObj instanceof Node) {
            if (!superclass) {
                db.index().forNodes(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX).add((PropertyContainer)((Node)propObj), Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX_KEY, (Object)(cmd.getFullClassName() + "-EXCLUSIVE"));
            }
            db.index().forNodes(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX).add((PropertyContainer)((Node)propObj), Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX_KEY, (Object)cmd.getFullClassName());
        } else {
            if (!superclass) {
                db.index().forRelationships(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX).add((PropertyContainer)((Relationship)propObj), Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX_KEY, (Object)(cmd.getFullClassName() + "-EXCLUSIVE"));
            }
            db.index().forRelationships(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX).add((PropertyContainer)((Relationship)propObj), Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX_KEY, (Object)cmd.getFullClassName());
        }
        AbstractClassMetaData superCmd = cmd.getSuperAbstractClassMetaData();
        if (superCmd != null) {
            this.addPropertyContainerToTypeIndex(db, propObj, superCmd, true);
        }
    }

    public void updateObject(DNStateManager sm, int[] fieldNumbers) {
        this.assertReadOnlyForUpdateOfObject(sm);
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            StoreData sd;
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            AbstractClassMetaData cmd = sm.getClassMetaData();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                StringBuilder fieldStr = new StringBuilder();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.Update.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId(), fieldStr.toString()}));
            }
            if ((sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName())) == null) {
                this.storeMgr.manageClasses(sm.getExecutionContext().getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
                sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            }
            Table table = sd.getTable();
            PropertyContainer propObj = Neo4jUtils.getPropertyContainerForStateManager(db, sm);
            if (propObj == null) {
                if (cmd.isVersioned()) {
                    throw new NucleusOptimisticException("Object with id " + sm.getInternalObjectId() + " and version " + sm.getTransactionalVersion() + " no longer present");
                }
                throw new NucleusDataStoreException("Could not find object with id " + sm.getInternalObjectId());
            }
            int[] updatedFieldNums = fieldNumbers;
            if (cmd.isVersioned()) {
                Object currentVersion = sm.getTransactionalVersion();
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                Object nextVersion = ec.getLockManager().getNextVersion(vermd, currentVersion);
                sm.setTransactionalVersion(nextVersion);
                if (vermd.getMemberName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getMemberName());
                    sm.replaceField(verMmd.getAbsoluteFieldNumber(), nextVersion);
                    boolean updatingVerField = false;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (fieldNumbers[i] != verMmd.getAbsoluteFieldNumber()) continue;
                        updatingVerField = true;
                    }
                    if (!updatingVerField) {
                        updatedFieldNums = new int[fieldNumbers.length + 1];
                        System.arraycopy(fieldNumbers, 0, updatedFieldNums, 0, fieldNumbers.length);
                        updatedFieldNums[fieldNumbers.length] = verMmd.getAbsoluteFieldNumber();
                    }
                } else {
                    propObj.setProperty(table.getSurrogateColumn(SurrogateColumnType.VERSION).getName(), nextVersion);
                }
            }
            StoreFieldManager fm = new StoreFieldManager(sm, propObj, false, table);
            sm.provideFields(updatedFieldNums, (FieldManager)fm);
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("Updating " + sm + " in " + propObj));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementUpdateCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception updating object " + sm), (Throwable)e);
            throw new NucleusDataStoreException("Exception updating object for " + sm, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObject(DNStateManager sm) {
        this.assertReadOnlyForUpdateOfObject(sm);
        AbstractClassMetaData cmd = sm.getClassMetaData();
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            PropertyContainer propObj = Neo4jUtils.getPropertyContainerForStateManager(db, sm);
            if (propObj == null) {
                throw new NucleusException("Attempt to delete " + sm + " yet no Node/Relationship found! See the log for details");
            }
            sm.loadUnloadedFields();
            int[] relMemberPosns = cmd.getRelationMemberPositions(ec.getClassLoaderResolver());
            sm.provideFields(relMemberPosns, (FieldManager)new DeleteFieldManager(sm, true));
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.Delete.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
            }
            if (propObj instanceof Node) {
                Node node = (Node)propObj;
                Iterable rels = node.getRelationships();
                for (Relationship rel : rels) {
                    if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_NATIVE.debug((Object)("Deleting relationship " + rel + " for " + node));
                    }
                    rel.delete();
                }
                db.index().forNodes(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX).remove((PropertyContainer)node);
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Deleting " + sm + " as " + node));
                }
                node.delete();
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementDeleteCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception deleting object " + sm), (Throwable)e);
            throw new NucleusDataStoreException("Exception deleting object for " + sm, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void fetchObject(DNStateManager sm, int[] fieldNumbers) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            StoreData sd;
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                StringBuilder str = new StringBuilder("Fetching object \"");
                str.append(sm.getObjectAsPrintable()).append("\" (id=");
                str.append(sm.getInternalObjectId()).append(")").append(" fields [");
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                str.append("]");
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)str.toString());
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"Neo4j.Fetch.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
            }
            if ((sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName())) == null) {
                this.storeMgr.manageClasses(sm.getExecutionContext().getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
                sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
            }
            Table table = sd.getTable();
            PropertyContainer propObj = Neo4jUtils.getPropertyContainerForStateManager(db, sm);
            if (propObj == null) {
                throw new NucleusObjectNotFoundException("Datastore object not found for id " + IdentityUtils.getPersistableIdentityForId((Object)sm.getInternalObjectId()));
            }
            FetchFieldManager fm = new FetchFieldManager(sm, propObj, table);
            sm.replaceFields(fieldNumbers, (FieldManager)fm);
            if (cmd.isVersioned() && sm.getTransactionalVersion() == null) {
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                if (vermd.getMemberName() != null) {
                    Object datastoreVersion = sm.provideField(cmd.getAbsolutePositionOfMember(vermd.getMemberName()));
                    sm.setVersion(datastoreVersion);
                } else {
                    Object datastoreVersion = propObj.getProperty(table.getSurrogateColumn(SurrogateColumnType.VERSION).getName());
                    sm.setVersion(datastoreVersion);
                }
            }
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"Neo4j.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementFetchCount();
            }
        }
        catch (Exception e) {
            NucleusLogger.DATASTORE_RETRIEVE.error((Object)"Exception on fetch of fields", (Throwable)e);
            throw new NucleusDataStoreException("Exception on fetch of fields", (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locateObject(DNStateManager sm) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            ExecutionContext ec = sm.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
            try {
                GraphDatabaseService db;
                PropertyContainer propObj;
                StoreData sd = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                if (sd == null) {
                    this.storeMgr.manageClasses(sm.getExecutionContext().getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
                }
                if ((propObj = Neo4jUtils.getPropertyContainerForStateManager(db = (GraphDatabaseService)mconn.getConnection(), sm)) == null) {
                    throw new NucleusObjectNotFoundException("Object not found for id " + IdentityUtils.getPersistableIdentityForId((Object)sm.getInternalObjectId()));
                }
            }
            finally {
                mconn.release();
            }
        }
    }

    public Object findObject(ExecutionContext ec, Object id) {
        return null;
    }
}

