/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j.fieldmanager;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractStoreFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.neo4j.Neo4jStoreManager;
import org.datanucleus.store.neo4j.Neo4jUtils;
import org.datanucleus.store.neo4j.fieldmanager.DNRelationshipType;
import org.datanucleus.store.neo4j.fieldmanager.StoreEmbeddedFieldManager;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class StoreFieldManager
extends AbstractStoreFieldManager {
    protected Table table;
    protected PropertyContainer propObj;

    public StoreFieldManager(ObjectProvider op, PropertyContainer propObj, boolean insert, Table table) {
        super(op, insert);
        this.table = table;
        this.propObj = propObj;
    }

    public StoreFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, PropertyContainer propObj, boolean insert, Table table) {
        super(ec, cmd, insert);
        this.table = table;
        this.propObj = propObj;
    }

    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        return this.table.getMemberColumnMappingForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.propObj.setProperty(this.getColumnMapping(fieldNumber).getColumn(0).getName(), (Object)value);
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.propObj.setProperty(this.getColumnMapping(fieldNumber).getColumn(0).getName(), (Object)value);
    }

    public void storeCharField(int fieldNumber, char value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.propObj.setProperty(this.getColumnMapping(fieldNumber).getColumn(0).getName(), (Object)Character.valueOf(value));
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.propObj.setProperty(this.getColumnMapping(fieldNumber).getColumn(0).getName(), (Object)value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.propObj.setProperty(this.getColumnMapping(fieldNumber).getColumn(0).getName(), (Object)Float.valueOf(value));
    }

    public void storeIntField(int fieldNumber, int value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.propObj.setProperty(this.getColumnMapping(fieldNumber).getColumn(0).getName(), (Object)value);
    }

    public void storeLongField(int fieldNumber, long value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.propObj.setProperty(this.getColumnMapping(fieldNumber).getColumn(0).getName(), (Object)value);
    }

    public void storeShortField(int fieldNumber, short value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.propObj.setProperty(this.getColumnMapping(fieldNumber).getColumn(0).getName(), (Object)value);
    }

    public void storeStringField(int fieldNumber, String value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String propName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (value == null) {
            if (!this.insert) {
                this.propObj.removeProperty(propName);
            }
            return;
        }
        this.propObj.setProperty(propName, (Object)value);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                if ((this.insert && !mmd.isCascadePersist() || !this.insert && !mmd.isCascadeUpdate()) && !this.ec.getApiAdapter().isDetached(value) && !this.ec.getApiAdapter().isPersistent(value)) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
                    }
                    throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), value);
                }
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                if (value == null) {
                    AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                    int[] embMmdPosns = embCmd.getAllMemberPositions();
                    StoreEmbeddedFieldManager storeEmbFM = new StoreEmbeddedFieldManager(this.ec, embCmd, this.propObj, this.insert, embMmds, this.table);
                    for (int i = 0; i < embMmdPosns.length; ++i) {
                        AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(embMmdPosns[i]);
                        if (String.class.isAssignableFrom(embMmd.getType()) || embMmd.getType().isPrimitive() || ClassUtils.isPrimitiveWrapperType((String)mmd.getTypeName())) {
                            ArrayList<AbstractMemberMetaData> colEmbMmds = new ArrayList<AbstractMemberMetaData>(embMmds);
                            colEmbMmds.add(embMmd);
                            MemberColumnMapping mapping = this.table.getMemberColumnMappingForEmbeddedMember(colEmbMmds);
                            this.propObj.removeProperty(mapping.getColumn(0).getName());
                            continue;
                        }
                        if (!Object.class.isAssignableFrom(embMmd.getType())) continue;
                        storeEmbFM.storeObjectField(embMmdPosns[i], null);
                    }
                    return;
                }
                AbstractClassMetaData embcmd = this.ec.getMetaDataManager().getMetaDataForClass(value.getClass(), clr);
                if (embcmd == null) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " specified as embedded but metadata not found for the class of type " + mmd.getTypeName());
                }
                ObjectProvider embOP = this.ec.findObjectProviderForEmbedded(value, this.op, mmd);
                StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embOP, this.propObj, this.insert, embMmds, this.table);
                embOP.provideFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                return;
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                throw new NucleusUserException("Don't currently support embedded field : " + mmd.getFullFieldName());
            }
        }
        this.storeNonEmbeddedObjectField(mmd, relationType, clr, value);
    }

    protected void storeNonEmbeddedObjectField(AbstractMemberMetaData mmd, RelationType relationType, ClassLoaderResolver clr, Object value) {
        Node node;
        int fieldNumber = mmd.getAbsoluteFieldNumber();
        ExecutionContext ec = this.op.getExecutionContext();
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        boolean optional = false;
        if (value instanceof Optional) {
            if (relationType != RelationType.NONE) {
                relationType = RelationType.ONE_TO_ONE_UNI;
            }
            optional = true;
            Optional opt = value;
            value = opt.isPresent() ? opt.get() : null;
        }
        if (value == null) {
            if (!this.insert) {
                for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                    String colName = mapping.getColumn(i).getName();
                    if (!this.propObj.hasProperty(colName)) continue;
                    this.propObj.removeProperty(colName);
                }
            }
            return;
        }
        if (mmd.isSerialized()) {
            if (value instanceof Serializable) {
                TypeConverter conv = ec.getTypeManager().getTypeConverterForType(Serializable.class, String.class);
                String strValue = (String)conv.toDatastoreType((Object)((Serializable)((Object)value)));
                this.propObj.setProperty(mapping.getColumn(0).getName(), (Object)strValue);
                return;
            }
            throw new NucleusUserException("Field " + mmd.getFullFieldName() + " is marked as serialised, but value is not Serializable");
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            if (!(this.propObj instanceof Node)) {
                throw new NucleusUserException("Object " + this.op + " is mapped to a Relationship. Not yet supported");
            }
            node = (Node)this.propObj;
            this.processSingleValuedRelationForNode(mmd, relationType, value, ec, clr, node);
            return;
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            if (!(this.propObj instanceof Node)) {
                throw new NucleusUserException("Object " + this.op + " is mapped to a Relationship but has field " + mmd.getFullFieldName() + " which is multi-valued. This is illegal");
            }
            node = (Node)this.propObj;
            this.processMultiValuedRelationForNode(mmd, relationType, value, ec, clr, node);
        } else if (mapping.getTypeConverter() != null) {
            Object datastoreValue = mapping.getTypeConverter().toDatastoreType((Object)value);
            if (mapping.getNumberOfColumns() > 1) {
                for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                    Object colValue = Array.get(datastoreValue, i);
                    this.propObj.setProperty(mapping.getColumn(i).getName(), colValue);
                }
            } else {
                this.propObj.setProperty(mapping.getColumn(0).getName(), datastoreValue);
            }
        } else {
            Object storedValue = Neo4jUtils.getStoredValueForField(ec, mmd, value, FieldRole.ROLE_FIELD);
            if (storedValue != null) {
                this.propObj.setProperty(mapping.getColumn(0).getName(), storedValue);
            }
        }
        if (optional) {
            value = Optional.of(value);
        }
        SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, value, (boolean)true);
    }

    protected void processSingleValuedRelationForNode(AbstractMemberMetaData mmd, RelationType relationType, Object value, ExecutionContext ec, ClassLoaderResolver clr, Node node) {
        ObjectProvider relatedOP;
        if ((this.insert && !mmd.isCascadePersist() || !this.insert && !mmd.isCascadeUpdate()) && !ec.getApiAdapter().isDetached(value) && !ec.getApiAdapter().isPersistent(value)) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
            }
            throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), value);
        }
        Object valuePC = value != null ? ec.persistObjectInternal(value, null, -1, -1) : null;
        ObjectProvider objectProvider = relatedOP = value != null ? ec.findObjectProvider(valuePC) : null;
        if (relationType != RelationType.MANY_TO_ONE_BI && mmd.getMappedBy() == null) {
            Node relatedNode = (Node)(value != null ? Neo4jUtils.getPropertyContainerForObjectProvider(this.propObj.getGraphDatabase(), relatedOP) : null);
            boolean hasRelation = false;
            if (!this.insert) {
                Iterable rels = node.getRelationships(new RelationshipType[]{DNRelationshipType.SINGLE_VALUED});
                for (Relationship rel : rels) {
                    if (!rel.getProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME).equals(mmd.getName())) continue;
                    Node currentNode = rel.getOtherNode(node);
                    if (currentNode.equals(relatedNode)) {
                        hasRelation = true;
                        break;
                    }
                    rel.delete();
                }
            }
            if (!hasRelation && relatedNode != null) {
                Relationship rel = node.createRelationshipTo(relatedNode, (RelationshipType)DNRelationshipType.SINGLE_VALUED);
                rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                if (RelationType.isBidirectional((RelationType)relationType)) {
                    AbstractMemberMetaData[] relMmds = mmd.getRelatedMemberMetaData(clr);
                    rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                }
            }
        }
    }

    protected void processMultiValuedRelationForNode(AbstractMemberMetaData mmd, RelationType relationType, Object value, ExecutionContext ec, ClassLoaderResolver clr, Node node) {
        if (mmd.hasCollection()) {
            AbstractMemberMetaData[] relMmds;
            Relationship rel;
            if (mmd.getCollection().isSerializedElement()) {
                throw new NucleusUserException("Don't currently support serialised collection elements at " + mmd.getFullFieldName());
            }
            Collection coll = (Collection)value;
            if (this.insert && !mmd.isCascadePersist() || !this.insert && !mmd.isCascadeUpdate()) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{mmd.getFullFieldName()}));
                }
                for (Object element : coll) {
                    if (ec.getApiAdapter().isDetached(element) || ec.getApiAdapter().isPersistent(element)) continue;
                    throw new ReachableObjectNotCascadedException(mmd.getFullFieldName(), element);
                }
            }
            ArrayList<Node> relNodes = new ArrayList<Node>();
            if (value != null) {
                for (Object element : coll) {
                    if (element != null) {
                        Object object = ec.persistObjectInternal(element, null, -1, -1);
                        ObjectProvider relatedOP = ec.findObjectProvider(object);
                        Node relatedNode = (Node)Neo4jUtils.getPropertyContainerForObjectProvider(this.propObj.getGraphDatabase(), relatedOP);
                        relNodes.add(relatedNode);
                        continue;
                    }
                    throw new NucleusUserException("Dont currently support having null elements in collections : " + mmd.getFullFieldName());
                }
            }
            if (relationType != RelationType.ONE_TO_MANY_BI && relationType != RelationType.ONE_TO_MANY_UNI && (relationType != RelationType.MANY_TO_MANY_BI || mmd.getMappedBy() != null)) {
                return;
            }
            if (this.insert) {
                int index = 0;
                for (Node node2 : relNodes) {
                    rel = node.createRelationshipTo(node2, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                    rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                    if (coll instanceof List) {
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME, (Object)index);
                        ++index;
                    }
                    if (!RelationType.isBidirectional((RelationType)relationType)) continue;
                    relMmds = mmd.getRelatedMemberMetaData(clr);
                    rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                }
            } else {
                this.deleteRelationshipsForMultivaluedMember(node, mmd);
                int index = 0;
                for (Node node3 : relNodes) {
                    rel = node.createRelationshipTo(node3, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                    rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                    if (coll instanceof List) {
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME, (Object)index);
                        ++index;
                    }
                    if (!RelationType.isBidirectional((RelationType)relationType)) continue;
                    relMmds = mmd.getRelatedMemberMetaData(clr);
                    rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                }
            }
        } else if (mmd.hasArray()) {
            AbstractMemberMetaData[] relMmds;
            int index;
            if (mmd.getArray().isSerializedElement()) {
                throw new NucleusUserException("Don't currently support serialised array elements at " + mmd.getFullFieldName());
            }
            ArrayList<Node> relNodes = new ArrayList<Node>();
            if (value != null) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Iterator element = Array.get(value, i);
                    if (element == null) {
                        throw new NucleusUserException("Dont currently support having null elements in arrays : " + mmd.getFullFieldName());
                    }
                    Object elementPC = ec.persistObjectInternal(element, null, -1, -1);
                    ObjectProvider objectProvider = ec.findObjectProvider(elementPC);
                    Node relatedNode = (Node)Neo4jUtils.getPropertyContainerForObjectProvider(this.propObj.getGraphDatabase(), objectProvider);
                    relNodes.add(relatedNode);
                }
            }
            if (relationType != RelationType.ONE_TO_MANY_BI && relationType != RelationType.ONE_TO_MANY_UNI && (relationType != RelationType.MANY_TO_MANY_BI || mmd.getMappedBy() != null)) {
                return;
            }
            if (this.insert) {
                index = 0;
                for (Node newNode : relNodes) {
                    Relationship relationship = node.createRelationshipTo(newNode, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                    relationship.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                    relationship.setProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME, (Object)index);
                    if (RelationType.isBidirectional((RelationType)relationType)) {
                        relMmds = mmd.getRelatedMemberMetaData(clr);
                        relationship.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                    }
                    ++index;
                }
            } else {
                this.deleteRelationshipsForMultivaluedMember(node, mmd);
                index = 0;
                for (Node newNode : relNodes) {
                    Relationship relationship = node.createRelationshipTo(newNode, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                    relationship.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                    relationship.setProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME, (Object)index);
                    if (RelationType.isBidirectional((RelationType)relationType)) {
                        relMmds = mmd.getRelatedMemberMetaData(clr);
                        relationship.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                    }
                    ++index;
                }
            }
        } else if (mmd.hasMap()) {
            if (mmd.getMap().isSerializedValue()) {
                throw new NucleusUserException("Don't currently support serialised map values at " + mmd.getFullFieldName());
            }
            Map map = (Map)value;
            if (!mmd.getMap().keyIsPersistent() && mmd.getMap().valueIsPersistent()) {
                AbstractMemberMetaData[] relMmds;
                Object relKeyVal;
                Relationship rel;
                Iterator relKeyIter;
                ArrayList<Node> relNodes = new ArrayList<Node>();
                ArrayList<Object> relKeyValues = new ArrayList<Object>();
                if (map != null) {
                    for (Map.Entry entry : map.entrySet()) {
                        Object key = entry.getKey();
                        Object val = entry.getValue();
                        if (val != null) {
                            Object valPC = ec.persistObjectInternal(val, null, -1, -1);
                            ObjectProvider relatedOP = ec.findObjectProvider(valPC);
                            Node relatedNode = (Node)Neo4jUtils.getPropertyContainerForObjectProvider(this.propObj.getGraphDatabase(), relatedOP);
                            relNodes.add(relatedNode);
                            relKeyValues.add(Neo4jUtils.getStoredValueForField(ec, mmd, key, FieldRole.ROLE_MAP_KEY));
                            continue;
                        }
                        throw new NucleusUserException("Dont currently support having null values in maps : " + mmd.getFullFieldName());
                    }
                }
                if (relationType != RelationType.ONE_TO_MANY_BI && relationType != RelationType.ONE_TO_MANY_UNI && (relationType != RelationType.MANY_TO_MANY_BI || mmd.getMappedBy() != null)) {
                    return;
                }
                if (this.insert) {
                    relKeyIter = relKeyValues.iterator();
                    for (Node newNode : relNodes) {
                        rel = node.createRelationshipTo(newNode, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                        if (mmd.getKeyMetaData() == null || mmd.getKeyMetaData().getMappedBy() == null) {
                            relKeyVal = relKeyIter.next();
                            rel.setProperty(Neo4jStoreManager.RELATIONSHIP_MAP_KEY_VALUE, relKeyVal);
                        }
                        if (!RelationType.isBidirectional((RelationType)relationType)) continue;
                        relMmds = mmd.getRelatedMemberMetaData(clr);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                    }
                } else {
                    this.deleteRelationshipsForMultivaluedMember(node, mmd);
                    relKeyIter = relKeyValues.iterator();
                    for (Node newNode : relNodes) {
                        rel = node.createRelationshipTo(newNode, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                        if (mmd.getKeyMetaData() == null || mmd.getKeyMetaData().getMappedBy() == null) {
                            relKeyVal = relKeyIter.next();
                            rel.setProperty(Neo4jStoreManager.RELATIONSHIP_MAP_KEY_VALUE, relKeyVal);
                        }
                        if (!RelationType.isBidirectional((RelationType)relationType)) continue;
                        relMmds = mmd.getRelatedMemberMetaData(clr);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                    }
                }
            } else if (mmd.getMap().keyIsPersistent() && !mmd.getMap().valueIsPersistent()) {
                AbstractMemberMetaData[] relMmds;
                Object relValValue;
                Relationship rel;
                Iterator relValIter;
                ArrayList<Node> relNodes = new ArrayList<Node>();
                ArrayList<Object> relValValues = new ArrayList<Object>();
                if (map != null) {
                    Iterator mapEntryIter = map.entrySet().iterator();
                    while (mapEntryIter.hasNext()) {
                        if (mmd.getMap().isSerializedKey()) {
                            throw new NucleusUserException("Don't currently support serialised map keys at " + mmd.getFullFieldName());
                        }
                        Map.Entry entry = mapEntryIter.next();
                        Object key = entry.getKey();
                        Object val = entry.getValue();
                        if (val != null) {
                            Object keyPC = ec.persistObjectInternal(key, null, -1, -1);
                            ObjectProvider relatedOP = ec.findObjectProvider(keyPC);
                            Node relatedNode = (Node)Neo4jUtils.getPropertyContainerForObjectProvider(this.propObj.getGraphDatabase(), relatedOP);
                            relNodes.add(relatedNode);
                            relValValues.add(Neo4jUtils.getStoredValueForField(ec, mmd, val, FieldRole.ROLE_MAP_VALUE));
                            continue;
                        }
                        throw new NucleusUserException("Dont currently support having null keys in maps : " + mmd.getFullFieldName());
                    }
                }
                if (relationType != RelationType.ONE_TO_MANY_BI && relationType != RelationType.ONE_TO_MANY_UNI && (relationType != RelationType.MANY_TO_MANY_BI || mmd.getMappedBy() != null)) {
                    return;
                }
                if (this.insert) {
                    relValIter = relValValues.iterator();
                    for (Node newNode : relNodes) {
                        rel = node.createRelationshipTo(newNode, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                        if (mmd.getValueMetaData() == null || mmd.getValueMetaData().getMappedBy() == null) {
                            relValValue = relValIter.next();
                            rel.setProperty(Neo4jStoreManager.RELATIONSHIP_MAP_VAL_VALUE, relValValue);
                        }
                        if (!RelationType.isBidirectional((RelationType)relationType)) continue;
                        relMmds = mmd.getRelatedMemberMetaData(clr);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                    }
                } else {
                    this.deleteRelationshipsForMultivaluedMember(node, mmd);
                    relValIter = relValValues.iterator();
                    for (Node newNode : relNodes) {
                        rel = node.createRelationshipTo(newNode, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                        if (mmd.getValueMetaData() == null || mmd.getValueMetaData().getMappedBy() == null) {
                            relValValue = relValIter.next();
                            rel.setProperty(Neo4jStoreManager.RELATIONSHIP_MAP_VAL_VALUE, relValValue);
                        }
                        if (!RelationType.isBidirectional((RelationType)relationType)) continue;
                        relMmds = mmd.getRelatedMemberMetaData(clr);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                    }
                }
            } else {
                throw new NucleusUserException("Don't currently support maps of persistable objects : " + mmd.getFullFieldName());
            }
        }
    }

    private void deleteRelationshipsForMultivaluedMember(Node ownerNode, AbstractMemberMetaData mmd) {
        Iterable rels = ownerNode.getRelationships(new RelationshipType[]{DNRelationshipType.MULTI_VALUED});
        for (Relationship rel : rels) {
            if (!rel.getProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME).equals(mmd.getName())) continue;
            rel.delete();
        }
    }
}

