/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j.query.expression;

import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.neo4j.query.expression.Neo4jExpression;

public class Neo4jBooleanExpression
extends Neo4jExpression {
    public Neo4jBooleanExpression(String propName, Object value, Expression.Operator op) {
        String valueStr = "" + value;
        if (value != null && value instanceof String) {
            valueStr = "\"" + valueStr + "\"";
        }
        if (op == Expression.OP_EQ) {
            this.cypherText = propName + (value == null ? " IS NULL" : " = " + valueStr);
        } else if (op == Expression.OP_NOTEQ) {
            this.cypherText = propName + (value == null ? " IS NOT NULL" : " <> " + valueStr);
        } else if (op == Expression.OP_GT) {
            this.cypherText = propName + " > " + valueStr;
        } else if (op == Expression.OP_GTEQ) {
            this.cypherText = propName + " >= " + valueStr;
        } else if (op == Expression.OP_LT) {
            this.cypherText = propName + " < " + valueStr;
        } else if (op == Expression.OP_LTEQ) {
            this.cypherText = propName + " <= " + valueStr;
        }
    }

    public Neo4jBooleanExpression(Neo4jBooleanExpression expr1, Neo4jBooleanExpression expr2, Expression.DyadicOperator op) {
        if (op == Expression.OP_AND) {
            this.cypherText = "(" + expr1.cypherText + ") and (" + expr2.cypherText + ")";
        } else if (op == Expression.OP_OR) {
            this.cypherText = "(" + expr1.cypherText + ") or (" + expr2.cypherText + ")";
        }
    }

    public Neo4jBooleanExpression(Neo4jBooleanExpression expr, Expression.MonadicOperator op) {
        if (op == Expression.OP_NOT) {
            this.cypherText = "not(" + expr.cypherText + ")";
        }
    }
}

