/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j.query;

import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.AbstractExpressionEvaluator;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.store.neo4j.Neo4jUtils;
import org.datanucleus.store.neo4j.query.Neo4jQueryCompilation;
import org.datanucleus.store.neo4j.query.expression.Neo4jAggregateExpression;
import org.datanucleus.store.neo4j.query.expression.Neo4jBooleanExpression;
import org.datanucleus.store.neo4j.query.expression.Neo4jExpression;
import org.datanucleus.store.neo4j.query.expression.Neo4jFieldExpression;
import org.datanucleus.store.neo4j.query.expression.Neo4jLiteral;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class QueryToCypherMapper
extends AbstractExpressionEvaluator {
    final ExecutionContext ec;
    final AbstractClassMetaData candidateCmd;
    final Query query;
    final QueryCompilation compilation;
    final Map parameters;
    int positionalParamNumber = -1;
    CompilationComponent compileComponent;
    String filterText = null;
    boolean filterComplete = true;
    String resultText = null;
    boolean resultComplete = true;
    String orderText = null;
    boolean orderComplete = true;
    boolean precompilable = true;
    Deque<Neo4jExpression> stack = new ArrayDeque<Neo4jExpression>();

    public QueryToCypherMapper(QueryCompilation compilation, Map parameters, AbstractClassMetaData cmd, ExecutionContext ec, Query q) {
        this.ec = ec;
        this.query = q;
        this.compilation = compilation;
        this.parameters = parameters;
        this.candidateCmd = cmd;
    }

    public void compile(Neo4jQueryCompilation neo4jCompilation) {
        this.compileFilter();
        this.compileResult();
        this.compileOrder();
        neo4jCompilation.setPrecompilable(this.precompilable);
        neo4jCompilation.setFilterComplete(this.filterComplete);
        neo4jCompilation.setResultComplete(this.resultComplete);
        neo4jCompilation.setOrderComplete(this.orderComplete);
        Long rangeFrom = null;
        Long rangeTo = null;
        if (this.filterComplete && this.orderComplete) {
            rangeFrom = this.query.getRangeFromIncl() > 0L ? Long.valueOf(this.query.getRangeFromIncl()) : null;
            Long l = rangeTo = this.query.getRangeToExcl() != Long.MAX_VALUE ? Long.valueOf(this.query.getRangeToExcl()) : null;
            if (rangeFrom != null || rangeTo != null) {
                neo4jCompilation.setRangeComplete(true);
            }
        }
        String cypherText = Neo4jUtils.getCypherTextForQuery(this.ec, this.candidateCmd, this.compilation.getCandidateAlias(), this.query.isSubclasses(), this.filterText, this.resultComplete ? this.resultText : null, this.orderText, rangeFrom, rangeTo);
        neo4jCompilation.setCypherText(cypherText);
    }

    protected void compileFilter() {
        if (this.compilation.getExprFilter() != null) {
            this.compileComponent = CompilationComponent.FILTER;
            try {
                this.compilation.getExprFilter().evaluate((ExpressionEvaluator)this);
                Neo4jExpression neoExpr = this.stack.pop();
                if (!(neoExpr instanceof Neo4jBooleanExpression)) {
                    NucleusLogger.QUERY.error((Object)("Invalid compilation : filter compiled to " + neoExpr));
                    this.filterComplete = false;
                } else {
                    this.filterText = ((Neo4jBooleanExpression)neoExpr).getCypherText();
                }
            }
            catch (Exception e) {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)("Compilation of filter to be evaluated completely in-datastore was impossible : " + e.getMessage()));
                }
                this.filterComplete = false;
            }
            this.compileComponent = null;
        }
    }

    protected void compileOrder() {
        if (this.compilation.getExprOrdering() != null) {
            this.compileComponent = CompilationComponent.ORDERING;
            try {
                StringBuilder orderStr = new StringBuilder();
                Expression[] orderingExpr = this.compilation.getExprOrdering();
                for (int i = 0; i < orderingExpr.length; ++i) {
                    OrderExpression orderExpr = (OrderExpression)orderingExpr[i];
                    orderExpr.evaluate((ExpressionEvaluator)this);
                    Neo4jExpression neoExpr = this.stack.pop();
                    orderStr.append(neoExpr.getCypherText());
                    String orderDir = orderExpr.getSortOrder();
                    if (orderDir.equalsIgnoreCase("descending")) {
                        orderStr.append(" DESC");
                    }
                    if (i >= orderingExpr.length - 1) continue;
                    orderStr.append(",");
                }
                this.orderText = orderStr.toString();
            }
            catch (Exception e) {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)("Compilation of ordering to be evaluated completely in-datastore was impossible : " + e.getMessage()));
                }
                this.orderComplete = false;
            }
            this.compileComponent = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void compileResult() {
        if (this.compilation.getExprResult() != null) {
            this.compileComponent = CompilationComponent.RESULT;
            this.resultComplete = true;
            StringBuilder str = new StringBuilder();
            try {
                Expression[] resultExprs = this.compilation.getExprResult();
                int i = 0;
                Expression[] expressionArray = resultExprs;
                int n = expressionArray.length;
                for (int j = 0; j < n; ++i, ++j) {
                    block16: {
                        Expression expr = expressionArray[j];
                        Neo4jExpression neo4jExpr = null;
                        if (expr instanceof PrimaryExpression) {
                            PrimaryExpression primExpr = (PrimaryExpression)expr;
                            this.processPrimaryExpression(primExpr);
                            neo4jExpr = this.stack.pop();
                            str.append(neo4jExpr.getCypherText());
                        } else if (expr instanceof Literal) {
                            this.processLiteral((Literal)expr);
                            neo4jExpr = this.stack.pop();
                            str.append(neo4jExpr.getCypherText());
                        } else if (expr instanceof ParameterExpression) {
                            this.processParameterExpression((ParameterExpression)expr);
                            neo4jExpr = this.stack.pop();
                            str.append(neo4jExpr.getCypherText());
                        } else {
                            if (expr instanceof InvokeExpression) {
                                InvokeExpression invokeExpr = (InvokeExpression)expr;
                                if (invokeExpr.getOperation().equalsIgnoreCase("MAX") || invokeExpr.getOperation().equalsIgnoreCase("MIN") || invokeExpr.getOperation().equalsIgnoreCase("SUM") || invokeExpr.getOperation().equalsIgnoreCase("AVG") || invokeExpr.getOperation().equalsIgnoreCase("COUNT")) {
                                    if (invokeExpr.getLeft() == null) {
                                        List argExprs = invokeExpr.getArguments();
                                        if (argExprs == null || argExprs.size() != 1) {
                                            throw new NucleusUserException("Invalid number of arguments to MAX");
                                        }
                                        Expression argExpr = (Expression)argExprs.get(0);
                                        if (!(argExpr instanceof PrimaryExpression)) {
                                            throw new NucleusUserException("Invocation of static method " + invokeExpr.getOperation() + " with arg of type " + argExpr.getClass().getName() + " not supported in-datastore");
                                        }
                                        this.processPrimaryExpression((PrimaryExpression)argExpr);
                                        Neo4jExpression aggrArgExpr = this.stack.pop();
                                        Neo4jAggregateExpression aggExpr = new Neo4jAggregateExpression(invokeExpr.getOperation(), aggrArgExpr);
                                        str.append(aggExpr.getCypherText());
                                    }
                                    break block16;
                                } else {
                                    NucleusLogger.QUERY.warn((Object)("Invocation of static method " + invokeExpr.getOperation() + " not supported in-datastore"));
                                    this.resultComplete = false;
                                    break;
                                }
                            }
                            NucleusLogger.GENERAL.info((Object)("Query result expression " + expr + " not supported via Cypher so will be processed in-memory"));
                            this.resultComplete = false;
                            break;
                        }
                    }
                    if (i >= resultExprs.length - 1) continue;
                    str.append(",");
                }
                this.resultText = str.toString();
            }
            catch (Exception e) {
                NucleusLogger.GENERAL.info((Object)("Query result clause " + StringUtils.objectArrayToString((Object[])this.compilation.getExprResult()) + " not totally supported via Cypher so will be processed in-memory"));
                this.resultComplete = false;
            }
            this.compileComponent = null;
        }
    }

    protected Object processAndExpression(Expression expr) {
        Neo4jBooleanExpression right = (Neo4jBooleanExpression)this.stack.pop();
        Neo4jBooleanExpression left = (Neo4jBooleanExpression)this.stack.pop();
        Neo4jBooleanExpression andExpr = new Neo4jBooleanExpression(left, right, Expression.OP_AND);
        this.stack.push(andExpr);
        return andExpr;
    }

    protected Object processOrExpression(Expression expr) {
        Neo4jBooleanExpression right = (Neo4jBooleanExpression)this.stack.pop();
        Neo4jBooleanExpression left = (Neo4jBooleanExpression)this.stack.pop();
        Neo4jBooleanExpression andExpr = new Neo4jBooleanExpression(left, right, Expression.OP_OR);
        this.stack.push(andExpr);
        return andExpr;
    }

    protected Object processEqExpression(Expression expr) {
        Neo4jExpression right = this.stack.pop();
        Neo4jExpression left = this.stack.pop();
        if (left instanceof Neo4jLiteral && right instanceof Neo4jFieldExpression) {
            String field = ((Neo4jFieldExpression)right).getFieldName();
            Object value = ((Neo4jLiteral)left).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_EQ);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        if (left instanceof Neo4jFieldExpression && right instanceof Neo4jLiteral) {
            String field = ((Neo4jFieldExpression)left).getFieldName();
            Object value = ((Neo4jLiteral)right).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_EQ);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        return super.processEqExpression(expr);
    }

    protected Object processNoteqExpression(Expression expr) {
        Neo4jExpression right = this.stack.pop();
        Neo4jExpression left = this.stack.pop();
        if (left instanceof Neo4jLiteral && right instanceof Neo4jFieldExpression) {
            String field = ((Neo4jFieldExpression)right).getFieldName();
            Object value = ((Neo4jLiteral)left).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_NOTEQ);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        if (left instanceof Neo4jFieldExpression && right instanceof Neo4jLiteral) {
            String field = ((Neo4jFieldExpression)left).getFieldName();
            Object value = ((Neo4jLiteral)right).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_NOTEQ);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        return super.processEqExpression(expr);
    }

    protected Object processGtExpression(Expression expr) {
        Neo4jExpression right = this.stack.pop();
        Neo4jExpression left = this.stack.pop();
        if (left instanceof Neo4jLiteral && right instanceof Neo4jFieldExpression) {
            String field = ((Neo4jFieldExpression)right).getFieldName();
            Object value = ((Neo4jLiteral)left).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_LTEQ);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        if (left instanceof Neo4jFieldExpression && right instanceof Neo4jLiteral) {
            String field = ((Neo4jFieldExpression)left).getFieldName();
            Object value = ((Neo4jLiteral)right).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_GT);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        return super.processEqExpression(expr);
    }

    protected Object processLtExpression(Expression expr) {
        Neo4jExpression right = this.stack.pop();
        Neo4jExpression left = this.stack.pop();
        if (left instanceof Neo4jLiteral && right instanceof Neo4jFieldExpression) {
            String field = ((Neo4jFieldExpression)right).getFieldName();
            Object value = ((Neo4jLiteral)left).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_GTEQ);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        if (left instanceof Neo4jFieldExpression && right instanceof Neo4jLiteral) {
            String field = ((Neo4jFieldExpression)left).getFieldName();
            Object value = ((Neo4jLiteral)right).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_LT);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        return super.processEqExpression(expr);
    }

    protected Object processGteqExpression(Expression expr) {
        Neo4jExpression right = this.stack.pop();
        Neo4jExpression left = this.stack.pop();
        if (left instanceof Neo4jLiteral && right instanceof Neo4jFieldExpression) {
            String field = ((Neo4jFieldExpression)right).getFieldName();
            Object value = ((Neo4jLiteral)left).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_LT);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        if (left instanceof Neo4jFieldExpression && right instanceof Neo4jLiteral) {
            String field = ((Neo4jFieldExpression)left).getFieldName();
            Object value = ((Neo4jLiteral)right).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_GTEQ);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        return super.processEqExpression(expr);
    }

    protected Object processLteqExpression(Expression expr) {
        Neo4jExpression right = this.stack.pop();
        Neo4jExpression left = this.stack.pop();
        if (left instanceof Neo4jLiteral && right instanceof Neo4jFieldExpression) {
            String field = ((Neo4jFieldExpression)right).getFieldName();
            Object value = ((Neo4jLiteral)left).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_GT);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        if (left instanceof Neo4jFieldExpression && right instanceof Neo4jLiteral) {
            String field = ((Neo4jFieldExpression)left).getFieldName();
            Object value = ((Neo4jLiteral)right).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_LTEQ);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        return super.processEqExpression(expr);
    }

    protected Object processNotExpression(Expression expr) {
        Neo4jExpression theExpr = this.stack.pop();
        if (theExpr instanceof Neo4jBooleanExpression) {
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression((Neo4jBooleanExpression)theExpr, Expression.OP_NOT);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        return super.processNotExpression(expr);
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        Object paramValue = null;
        boolean paramValueSet = false;
        if (this.parameters != null && !this.parameters.isEmpty()) {
            if (this.parameters.containsKey(expr.getId())) {
                paramValue = this.parameters.get(expr.getId());
                paramValueSet = true;
            } else if (this.parameters.containsKey(expr.getId())) {
                paramValue = this.parameters.get(expr.getId());
                paramValueSet = true;
            } else {
                int position = this.positionalParamNumber;
                if (this.positionalParamNumber < 0) {
                    position = 0;
                }
                if (this.parameters.containsKey(position)) {
                    paramValue = this.parameters.get(position);
                    paramValueSet = true;
                    this.positionalParamNumber = position + 1;
                }
            }
        }
        if (paramValueSet) {
            if (paramValue instanceof Number) {
                Neo4jLiteral lit = new Neo4jLiteral(paramValue);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue instanceof String) {
                Neo4jLiteral lit = new Neo4jLiteral(paramValue);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue instanceof Character) {
                Neo4jLiteral lit = new Neo4jLiteral("" + paramValue);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue instanceof Boolean) {
                Neo4jLiteral lit = new Neo4jLiteral(paramValue);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue instanceof Date) {
                Object storedVal = paramValue;
                Class<?> paramType = paramValue.getClass();
                if (paramValue instanceof SCO) {
                    paramType = ((SCO)paramValue).getValue().getClass();
                }
                TypeConverter strConv = this.ec.getTypeManager().getTypeConverterForType(paramType, String.class);
                TypeConverter longConv = this.ec.getTypeManager().getTypeConverterForType(paramType, Long.class);
                if (strConv != null) {
                    storedVal = strConv.toDatastoreType(paramValue);
                } else if (longConv != null) {
                    storedVal = longConv.toDatastoreType(paramValue);
                }
                Neo4jLiteral lit = new Neo4jLiteral(storedVal);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue == null) {
                Neo4jLiteral lit = new Neo4jLiteral(null);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
        } else {
            this.precompilable = false;
            throw new NucleusException("Parameter " + expr + " is not currently set, so cannot complete the compilation");
        }
        NucleusLogger.QUERY.info((Object)("Dont currently support parameter values of type " + paramValue.getClass().getName()));
        return super.processParameterExpression(expr);
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        Expression left = expr.getLeft();
        if (left == null) {
            if (expr.getId().equals(this.compilation.getCandidateAlias())) {
                Neo4jFieldExpression fieldExpr = new Neo4jFieldExpression(this.compilation.getCandidateAlias());
                this.stack.push(fieldExpr);
                return fieldExpr;
            }
            String fieldName = this.getFieldNameForPrimary(expr);
            if (fieldName == null) {
                if (this.compileComponent == CompilationComponent.FILTER) {
                    this.filterComplete = false;
                }
                NucleusLogger.QUERY.debug((Object)(">> Primary " + expr + " is not stored in this Neo4j type, so unexecutable in datastore"));
            } else {
                Neo4jFieldExpression fieldExpr = new Neo4jFieldExpression(this.compilation.getCandidateAlias() + "." + fieldName);
                this.stack.push(fieldExpr);
                return fieldExpr;
            }
        }
        return super.processPrimaryExpression(expr);
    }

    protected Object processLiteral(Literal expr) {
        Object litValue = expr.getLiteral();
        if (litValue instanceof BigDecimal) {
            Neo4jLiteral lit = new Neo4jLiteral(((BigDecimal)litValue).doubleValue());
            this.stack.push(lit);
            return lit;
        }
        if (litValue instanceof Number) {
            Neo4jLiteral lit = new Neo4jLiteral(litValue);
            this.stack.push(lit);
            return lit;
        }
        if (litValue instanceof String) {
            Neo4jLiteral lit = new Neo4jLiteral(litValue);
            this.stack.push(lit);
            return lit;
        }
        if (litValue instanceof Boolean) {
            Neo4jLiteral lit = new Neo4jLiteral(litValue);
            this.stack.push(lit);
            return lit;
        }
        if (litValue == null) {
            Neo4jLiteral lit = new Neo4jLiteral(null);
            this.stack.push(lit);
            return lit;
        }
        return super.processLiteral(expr);
    }

    protected Object processInvokeExpression(InvokeExpression expr) {
        Expression invokedExpr = expr.getLeft();
        String operation = expr.getOperation();
        List args = expr.getArguments();
        if (invokedExpr == null) {
            // empty if block
        }
        NucleusLogger.QUERY.debug((Object)(">> Dont currently support any method invocation in Neo4j datastore queries : method=" + operation + " args=" + StringUtils.collectionToString((Collection)args)));
        return super.processInvokeExpression(expr);
    }

    protected String getFieldNameForPrimary(PrimaryExpression expr) {
        List tuples = expr.getTuples();
        if (tuples == null || tuples.isEmpty()) {
            return null;
        }
        AbstractClassMetaData cmd = this.candidateCmd;
        Table table = this.ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName()).getTable();
        AbstractMemberMetaData embMmd = null;
        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
        boolean firstTuple = true;
        Iterator iter = tuples.iterator();
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (firstTuple && name.equals(this.compilation.getCandidateAlias())) {
                cmd = this.candidateCmd;
                continue;
            }
            AbstractMemberMetaData mmd = cmd.getMetaDataForMember(name);
            RelationType relationType = mmd.getRelationType(this.ec.getClassLoaderResolver());
            if (relationType == RelationType.NONE) {
                if (iter.hasNext()) {
                    throw new NucleusUserException("Query has reference to " + StringUtils.collectionToString((Collection)tuples) + " yet " + name + " is a non-relation field!");
                }
                if (embMmd != null) {
                    embMmds.add(mmd);
                    return table.getMemberColumnMappingForEmbeddedMember(embMmds).getColumn(0).getName();
                }
                return table.getMemberColumnMappingForMember(mmd).getColumn(0).getName();
            }
            boolean embedded = MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, embMmds.isEmpty() ? null : (AbstractMemberMetaData)embMmds.get(embMmds.size() - 1));
            if (embedded) {
                if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                    cmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), this.ec.getClassLoaderResolver());
                    embMmd = embMmd != null ? embMmd.getEmbeddedMetaData().getMemberMetaData()[mmd.getAbsoluteFieldNumber()] : mmd;
                    embMmds.add(embMmd);
                } else if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                    throw new NucleusUserException("Do not support the querying of embedded collection/map/array fields : " + mmd.getFullFieldName());
                }
            } else {
                embMmds.clear();
                if (relationType == RelationType.ONE_TO_MANY_UNI || relationType == RelationType.ONE_TO_MANY_BI || relationType == RelationType.MANY_TO_ONE_UNI || relationType == RelationType.MANY_TO_ONE_BI) {
                    if (!iter.hasNext()) {
                        return name;
                    }
                    throw new NucleusUserException("Do not support query joining to related object at " + mmd.getFullFieldName() + " in " + StringUtils.collectionToString((Collection)tuples));
                }
                if (this.compileComponent == CompilationComponent.FILTER) {
                    this.filterComplete = false;
                }
                NucleusLogger.QUERY.debug((Object)("Query has reference to " + StringUtils.collectionToString((Collection)tuples) + " and " + mmd.getFullFieldName() + " is not persisted into this object, so unexecutable in the datastore"));
                return null;
            }
            firstTuple = false;
        }
        return null;
    }
}

