/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j;

import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.VersionHelper;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.neo4j.Neo4jStoreManager;
import org.datanucleus.store.neo4j.Neo4jUtils;
import org.datanucleus.store.neo4j.fieldmanager.FetchFieldManager;
import org.datanucleus.store.neo4j.fieldmanager.StoreFieldManager;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

public class Neo4jPersistenceHandler
extends AbstractPersistenceHandler {
    public Neo4jPersistenceHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void close() {
    }

    public void insertObjects(ObjectProvider ... ops) {
        ExecutionContext ec = ops[0].getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.InsertObjects.Start", (Object[])new Object[]{StringUtils.objectArrayToString((Object[])ops)}));
            }
            for (ObjectProvider op : ops) {
                this.insertObjectToPropertyContainer(op, db);
            }
            for (ObjectProvider op : ops) {
                AbstractClassMetaData cmd = op.getClassMetaData();
                Table table = this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
                PropertyContainer propObj = (PropertyContainer)op.getAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER);
                int[] relPositions = cmd.getRelationMemberPositions(ec.getClassLoaderResolver(), ec.getMetaDataManager());
                if (relPositions.length <= 0) continue;
                StoreFieldManager fm = new StoreFieldManager(op, propObj, true, table);
                op.provideFields(relPositions, (FieldManager)fm);
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementInsertCount();
            }
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error((Object)"Exception inserting objects ", (Throwable)e);
            throw new NucleusDataStoreException("Exception inserting objects", (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public PropertyContainer insertObjectToPropertyContainer(ObjectProvider op, GraphDatabaseService db) {
        String propName;
        this.assertReadOnlyForUpdateOfObject(op);
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (!(cmd.getIdentityType() != IdentityType.APPLICATION && cmd.getIdentityType() != IdentityType.DATASTORE || cmd.pkIsDatastoreAttributed(this.storeMgr))) {
            try {
                this.locateObject(op);
                throw new NucleusUserException(Localiser.msg((String)"Neo4j.Insert.ObjectWithIdAlreadyExists", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
            catch (NucleusObjectNotFoundException nucleusObjectNotFoundException) {
                // empty catch block
            }
        }
        if (!this.storeMgr.managesClass(cmd.getFullClassName())) {
            this.storeMgr.manageClasses(op.getExecutionContext().getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
        }
        Table table = this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
        Node propObj = db.createNode();
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Persisting " + op + " as " + propObj));
        }
        this.addPropertyContainerToTypeIndex(db, (PropertyContainer)propObj, cmd, false);
        op.setAssociatedValue((Object)Neo4jStoreManager.OBJECT_PROVIDER_PROPCONTAINER, (Object)propObj);
        if (cmd.pkIsDatastoreAttributed(this.storeMgr)) {
            long id;
            long l = id = propObj instanceof Node ? propObj.getId() : ((Relationship)propObj).getId();
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                op.setPostStoreNewObjectId((Object)id);
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.Insert.ObjectPersistedWithIdentity", (Object[])new Object[]{op.getObjectAsPrintable(), id}));
                }
            } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                int[] pkFieldNumbers = cmd.getPKMemberPositions();
                for (int i = 0; i < pkFieldNumbers.length; ++i) {
                    AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
                    if (!this.storeMgr.isStrategyDatastoreAttributed(cmd, pkFieldNumbers[i])) continue;
                    if (!Number.class.isAssignableFrom(mmd.getType()) && mmd.getType() != Long.TYPE && mmd.getType() != Integer.TYPE) {
                        throw new NucleusUserException("Any field using IDENTITY value generation with Neo4j should be of type numeric");
                    }
                    op.setPostStoreNewObjectId((Object)id);
                    if (!NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) continue;
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.Insert.ObjectPersistedWithIdentity", (Object[])new Object[]{op.getObjectAsPrintable(), id}));
                }
            }
        }
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            String propName2 = table.getDatastoreIdColumn().getName();
            Object key = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)op.getInternalObjectId());
            propObj.setProperty(propName2, key);
        }
        if (cmd.isVersioned()) {
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            propName = table.getVersionColumn().getName();
            if (vermd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                long versionNumber = 1L;
                op.setTransactionalVersion((Object)versionNumber);
                if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"Neo4j.Insert.ObjectPersistedWithVersion", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId(), "" + versionNumber}));
                }
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    Number verFieldValue = versionNumber;
                    if (verMmd.getType() == Integer.TYPE || verMmd.getType() == Integer.class) {
                        verFieldValue = (int)versionNumber;
                    }
                    op.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)verFieldValue);
                } else {
                    propObj.setProperty(propName, (Object)versionNumber);
                }
            }
        }
        if (cmd.hasDiscriminatorStrategy()) {
            DiscriminatorMetaData discmd = cmd.getDiscriminatorMetaData();
            propName = table.getDiscriminatorColumn().getName();
            String discVal = null;
            discVal = cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? cmd.getFullClassName() : discmd.getValue();
            propObj.setProperty(propName, (Object)discVal);
        }
        if (this.storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
            String propName3 = table.getMultitenancyColumn().getName();
            propObj.setProperty(propName3, (Object)this.storeMgr.getStringProperty("datanucleus.TenantID"));
        }
        ExecutionContext ec = op.getExecutionContext();
        int[] nonRelPositions = cmd.getNonRelationMemberPositions(ec.getClassLoaderResolver(), ec.getMetaDataManager());
        StoreFieldManager fm = new StoreFieldManager(op, (PropertyContainer)propObj, true, table);
        op.provideFields(nonRelPositions, (FieldManager)fm);
        return propObj;
    }

    public void insertObject(ObjectProvider op) {
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.Insert.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
            PropertyContainer propObj = this.insertObjectToPropertyContainer(op, db);
            AbstractClassMetaData cmd = op.getClassMetaData();
            Table table = this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
            int[] relPositions = cmd.getRelationMemberPositions(ec.getClassLoaderResolver(), ec.getMetaDataManager());
            if (relPositions.length > 0) {
                StoreFieldManager fm = new StoreFieldManager(op, propObj, true, table);
                op.provideFields(relPositions, (FieldManager)fm);
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementInsertCount();
            }
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception inserting object " + op), (Throwable)e);
            throw new NucleusDataStoreException("Exception inserting object for " + op, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    private void addPropertyContainerToTypeIndex(GraphDatabaseService db, PropertyContainer propObj, AbstractClassMetaData cmd, boolean superclass) {
        if (propObj instanceof Node) {
            if (!superclass) {
                db.index().forNodes(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX).add((PropertyContainer)((Node)propObj), Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX_KEY, (Object)(cmd.getFullClassName() + "-EXCLUSIVE"));
            }
            db.index().forNodes(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX).add((PropertyContainer)((Node)propObj), Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX_KEY, (Object)cmd.getFullClassName());
        } else {
            if (!superclass) {
                db.index().forRelationships(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX).add((PropertyContainer)((Relationship)propObj), Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX_KEY, (Object)(cmd.getFullClassName() + "-EXCLUSIVE"));
            }
            db.index().forRelationships(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX).add((PropertyContainer)((Relationship)propObj), Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX_KEY, (Object)cmd.getFullClassName());
        }
        AbstractClassMetaData superCmd = cmd.getSuperAbstractClassMetaData();
        if (superCmd != null) {
            this.addPropertyContainerToTypeIndex(db, propObj, superCmd, true);
        }
    }

    public void updateObject(ObjectProvider op, int[] fieldNumbers) {
        this.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            AbstractClassMetaData cmd = op.getClassMetaData();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                StringBuilder fieldStr = new StringBuilder();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.Update.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId(), fieldStr.toString()}));
            }
            if (!this.storeMgr.managesClass(cmd.getFullClassName())) {
                this.storeMgr.manageClasses(op.getExecutionContext().getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
            }
            Table table = this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
            PropertyContainer propObj = Neo4jUtils.getPropertyContainerForObjectProvider(db, op);
            if (propObj == null) {
                if (cmd.isVersioned()) {
                    throw new NucleusOptimisticException("Object with id " + op.getInternalObjectId() + " and version " + op.getTransactionalVersion() + " no longer present");
                }
                throw new NucleusDataStoreException("Could not find object with id " + op.getInternalObjectId());
            }
            int[] updatedFieldNums = fieldNumbers;
            if (cmd.isVersioned()) {
                Object currentVersion = op.getTransactionalVersion();
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                Object nextVersion = VersionHelper.getNextVersion((VersionStrategy)vermd.getVersionStrategy(), (Object)currentVersion);
                op.setTransactionalVersion(nextVersion);
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    op.replaceField(verMmd.getAbsoluteFieldNumber(), nextVersion);
                    boolean updatingVerField = false;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (fieldNumbers[i] != verMmd.getAbsoluteFieldNumber()) continue;
                        updatingVerField = true;
                    }
                    if (!updatingVerField) {
                        updatedFieldNums = new int[fieldNumbers.length + 1];
                        System.arraycopy(fieldNumbers, 0, updatedFieldNums, 0, fieldNumbers.length);
                        updatedFieldNums[fieldNumbers.length] = verMmd.getAbsoluteFieldNumber();
                    }
                } else {
                    String propName = table.getVersionColumn().getName();
                    propObj.setProperty(propName, nextVersion);
                }
            }
            StoreFieldManager fm = new StoreFieldManager(op, propObj, false, table);
            op.provideFields(updatedFieldNums, (FieldManager)fm);
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("Updating " + op + " in " + propObj));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementUpdateCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception updating object " + op), (Throwable)e);
            throw new NucleusDataStoreException("Exception updating object for " + op, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            PropertyContainer propObj = Neo4jUtils.getPropertyContainerForObjectProvider(db, op);
            if (propObj == null) {
                throw new NucleusException("Attempt to delete " + op + " yet no Node/Relationship found! See the log for details");
            }
            op.loadUnloadedFields();
            int[] relMemberPosns = cmd.getRelationMemberPositions(ec.getClassLoaderResolver(), ec.getMetaDataManager());
            op.provideFields(relMemberPosns, (FieldManager)new DeleteFieldManager(op, true));
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.Delete.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
            if (propObj instanceof Node) {
                Node node = (Node)propObj;
                Iterable rels = node.getRelationships();
                for (Relationship rel : rels) {
                    if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_NATIVE.debug((Object)("Deleting relationship " + rel + " for " + node));
                    }
                    rel.delete();
                }
                db.index().forNodes(Neo4jStoreManager.PROPCONTAINER_TYPE_INDEX).remove((PropertyContainer)node);
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Deleting " + op + " as " + node));
                }
                node.delete();
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementDeleteCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"Neo4j.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception deleting object " + op), (Throwable)e);
            throw new NucleusDataStoreException("Exception deleting object for " + op, (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void fetchObject(ObjectProvider op, int[] fieldNumbers) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                StringBuilder str = new StringBuilder("Fetching object \"");
                str.append(op.getObjectAsPrintable()).append("\" (id=");
                str.append(op.getInternalObjectId()).append(")").append(" fields [");
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                str.append("]");
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)str.toString());
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"Neo4j.Fetch.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
            if (!this.storeMgr.managesClass(cmd.getFullClassName())) {
                this.storeMgr.manageClasses(op.getExecutionContext().getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
            }
            Table table = this.storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
            PropertyContainer propObj = Neo4jUtils.getPropertyContainerForObjectProvider(db, op);
            if (propObj == null) {
                throw new NucleusObjectNotFoundException("Datastore object for " + op + " is not found");
            }
            FetchFieldManager fm = new FetchFieldManager(op, propObj, table);
            op.replaceFields(fieldNumbers, (FieldManager)fm);
            if (cmd.isVersioned() && op.getTransactionalVersion() == null) {
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                if (vermd.getFieldName() != null) {
                    Object datastoreVersion = op.provideField(cmd.getAbsolutePositionOfMember(vermd.getFieldName()));
                    op.setVersion(datastoreVersion);
                } else {
                    String propName = table.getVersionColumn().getName();
                    Object datastoreVersion = propObj.getProperty(propName);
                    op.setVersion(datastoreVersion);
                }
            }
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"Neo4j.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementFetchCount();
            }
        }
        catch (Exception e) {
            NucleusLogger.DATASTORE_RETRIEVE.error((Object)"Exception on fetch of fields", (Throwable)e);
            throw new NucleusDataStoreException("Exception on fetch of fields", (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locateObject(ObjectProvider op) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            ExecutionContext ec = op.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                GraphDatabaseService db;
                PropertyContainer propObj;
                if (!this.storeMgr.managesClass(cmd.getFullClassName())) {
                    this.storeMgr.manageClasses(ec.getClassLoaderResolver(), new String[]{cmd.getFullClassName()});
                }
                if ((propObj = Neo4jUtils.getPropertyContainerForObjectProvider(db = (GraphDatabaseService)mconn.getConnection(), op)) == null) {
                    throw new NucleusObjectNotFoundException("Object not found for id=" + op.getInternalObjectId());
                }
            }
            finally {
                mconn.release();
            }
        }
    }

    public Object findObject(ExecutionContext ec, Object id) {
        return null;
    }
}

