/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j.fieldmanager;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractStoreFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.neo4j.Neo4jStoreManager;
import org.datanucleus.store.neo4j.Neo4jUtils;
import org.datanucleus.store.neo4j.fieldmanager.DNRelationshipType;
import org.datanucleus.store.neo4j.fieldmanager.StoreEmbeddedFieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.TypeConverter;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class StoreFieldManager
extends AbstractStoreFieldManager {
    protected PropertyContainer propObj;
    protected AbstractMemberMetaData ownerMmd = null;

    public StoreFieldManager(ObjectProvider op, PropertyContainer propObj, boolean insert) {
        super(op, insert);
        this.propObj = propObj;
    }

    protected String getPropName(int fieldNumber) {
        return this.op.getExecutionContext().getStoreManager().getNamingFactory().getColumnName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), ColumnType.COLUMN);
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.propObj.setProperty(this.getPropName(fieldNumber), (Object)value);
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.propObj.setProperty(this.getPropName(fieldNumber), (Object)value);
    }

    public void storeCharField(int fieldNumber, char value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.propObj.setProperty(this.getPropName(fieldNumber), (Object)Character.valueOf(value));
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.propObj.setProperty(this.getPropName(fieldNumber), (Object)value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.propObj.setProperty(this.getPropName(fieldNumber), (Object)Float.valueOf(value));
    }

    public void storeIntField(int fieldNumber, int value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.propObj.setProperty(this.getPropName(fieldNumber), (Object)value);
    }

    public void storeLongField(int fieldNumber, long value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.propObj.setProperty(this.getPropName(fieldNumber), (Object)value);
    }

    public void storeShortField(int fieldNumber, short value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.propObj.setProperty(this.getPropName(fieldNumber), (Object)value);
    }

    public void storeStringField(int fieldNumber, String value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        if (value == null) {
            if (!this.insert) {
                this.propObj.removeProperty(this.getPropName(fieldNumber));
            }
            return;
        }
        this.propObj.setProperty(this.getPropName(fieldNumber), (Object)value);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        Node node;
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        ExecutionContext ec = this.op.getExecutionContext();
        String propName = ec.getStoreManager().getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
        if (!this.insert && this.propObj.hasProperty(propName) && value == null) {
            this.propObj.removeProperty(propName);
            return;
        }
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        boolean embedded = false;
        if (relationType != RelationType.NONE) {
            AbstractMemberMetaData[] embMmds;
            if (RelationType.isRelationSingleValued((RelationType)relationType) && this.ownerMmd != null && this.ownerMmd.getEmbeddedMetaData() != null && (embMmds = this.ownerMmd.getEmbeddedMetaData().getMemberMetaData()) != null) {
                for (int i = 0; i < embMmds.length; ++i) {
                    if (!embMmds[i].getName().equals(mmd.getName())) continue;
                    embedded = true;
                }
            }
            if (mmd.isEmbedded()) {
                embedded = true;
            } else if (mmd.getEmbeddedMetaData() != null) {
                embedded = true;
            } else if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                if (mmd.hasCollection() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                    embedded = true;
                } else if (mmd.hasArray() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                    embedded = true;
                } else if (mmd.hasMap() && (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getEmbeddedMetaData() != null || mmd.getValueMetaData() != null && mmd.getValueMetaData().getEmbeddedMetaData() != null)) {
                    embedded = true;
                }
            }
        }
        if (embedded) {
            if (RelationType.isRelationSingleValued((RelationType)relationType) && value != null) {
                if (this.ownerMmd != null && (RelationType.isBidirectional((RelationType)relationType) ? this.ownerMmd.getMappedBy() != null && mmd.getName().equals(this.ownerMmd.getMappedBy()) || mmd.getMappedBy() != null && this.ownerMmd.getName().equals(mmd.getMappedBy()) : this.ownerMmd.getEmbeddedMetaData() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember().equals(mmd.getName()))) {
                    return;
                }
                AbstractClassMetaData embcmd = ec.getMetaDataManager().getMetaDataForClass(value.getClass(), clr);
                if (embcmd == null) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " specified as embedded but metadata not found for the class of type " + mmd.getTypeName());
                }
                AbstractMemberMetaData embMmd = mmd;
                if (this.ownerMmd != null) {
                    embMmd = this.ownerMmd.getEmbeddedMetaData().getMemberMetaData()[fieldNumber];
                }
                ObjectProvider embOP = ec.findObjectProviderForEmbedded(value, this.op, mmd);
                StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embOP, this.propObj, this.insert, embMmd);
                embOP.provideFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                return;
            }
            throw new NucleusUserException("Don't currently support embedded field : " + mmd.getFullFieldName());
        }
        if (mmd.isSerialized()) {
            if (value == null) {
                return;
            }
            if (value instanceof Serializable) {
                TypeConverter conv = ec.getTypeManager().getTypeConverterForType(Serializable.class, String.class);
                String strValue = (String)conv.toDatastoreType((Object)((Serializable)value));
                this.propObj.setProperty(propName, (Object)strValue);
                return;
            }
            throw new NucleusUserException("Field " + mmd.getFullFieldName() + " is marked as serialised, but value is not Serializable");
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            if (!(this.propObj instanceof Node)) {
                throw new NucleusUserException("Object " + this.op + " is mapped to a Relationship. Not yet supported");
            }
            node = (Node)this.propObj;
            this.processSingleValuedRelationForNode(mmd, relationType, value, ec, clr, node);
            return;
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            if (!(this.propObj instanceof Node)) {
                throw new NucleusUserException("Object " + this.op + " is mapped to a Relationship but has field " + mmd.getFullFieldName() + " which is multi-valued. This is illegal");
            }
            node = (Node)this.propObj;
            this.processMultiValuedRelationForNode(mmd, relationType, value, ec, clr, node);
            return;
        }
        if (value == null) {
            return;
        }
        if (mmd.getTypeConverterName() != null) {
            TypeManager typeMgr = this.op.getExecutionContext().getNucleusContext().getTypeManager();
            TypeConverter conv = typeMgr.getTypeConverterForName(mmd.getTypeConverterName());
            this.propObj.setProperty(propName, conv.toDatastoreType(value));
        } else {
            Object storedValue = Neo4jUtils.getStoredValueForField(ec, mmd, value, 2);
            if (storedValue != null) {
                this.propObj.setProperty(propName, storedValue);
            }
        }
        this.op.wrapSCOField(fieldNumber, value, false, false, true);
    }

    protected void processSingleValuedRelationForNode(AbstractMemberMetaData mmd, RelationType relationType, Object value, ExecutionContext ec, ClassLoaderResolver clr, Node node) {
        ObjectProvider relatedOP;
        Object valuePC = value != null ? ec.persistObjectInternal(value, null, -1, -1) : null;
        ObjectProvider objectProvider = relatedOP = value != null ? ec.findObjectProvider(valuePC) : null;
        if (relationType != RelationType.MANY_TO_ONE_BI && mmd.getMappedBy() == null) {
            Node relatedNode = (Node)(value != null ? Neo4jUtils.getPropertyContainerForObjectProvider(this.propObj.getGraphDatabase(), relatedOP) : null);
            boolean hasRelation = false;
            if (!this.insert) {
                Iterable rels = node.getRelationships(new RelationshipType[]{DNRelationshipType.SINGLE_VALUED});
                for (Relationship rel : rels) {
                    if (!rel.getProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME).equals(mmd.getName())) continue;
                    Node currentNode = rel.getOtherNode(node);
                    if (currentNode.equals(relatedNode)) {
                        hasRelation = true;
                        break;
                    }
                    rel.delete();
                }
            }
            if (!hasRelation && relatedNode != null) {
                Relationship rel = node.createRelationshipTo(relatedNode, (RelationshipType)DNRelationshipType.SINGLE_VALUED);
                rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                if (RelationType.isBidirectional((RelationType)relationType)) {
                    AbstractMemberMetaData[] relMmds = mmd.getRelatedMemberMetaData(clr);
                    rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                }
            }
        }
    }

    protected void processMultiValuedRelationForNode(AbstractMemberMetaData mmd, RelationType relationType, Object value, ExecutionContext ec, ClassLoaderResolver clr, Node node) {
        if (mmd.hasCollection()) {
            AbstractMemberMetaData[] relMmds;
            Relationship rel;
            Collection coll = (Collection)value;
            ArrayList<Node> relNodes = new ArrayList<Node>();
            if (value != null) {
                Iterator collIter = coll.iterator();
                while (collIter.hasNext()) {
                    if (mmd.getCollection().isSerializedElement()) {
                        throw new NucleusUserException("Don't currently support serialised collection elements at " + mmd.getFullFieldName());
                    }
                    Object element = collIter.next();
                    if (element != null) {
                        Object elementPC = ec.persistObjectInternal(element, null, -1, -1);
                        ObjectProvider relatedOP = ec.findObjectProvider(elementPC);
                        Node relatedNode = (Node)Neo4jUtils.getPropertyContainerForObjectProvider(this.propObj.getGraphDatabase(), relatedOP);
                        relNodes.add(relatedNode);
                        continue;
                    }
                    throw new NucleusUserException("Dont currently support having null elements in collections : " + mmd.getFullFieldName());
                }
            }
            if (relationType != RelationType.ONE_TO_MANY_BI && relationType != RelationType.ONE_TO_MANY_UNI && (relationType != RelationType.MANY_TO_MANY_BI || mmd.getMappedBy() != null)) {
                return;
            }
            if (this.insert) {
                int index = 0;
                for (Node newNode : relNodes) {
                    rel = node.createRelationshipTo(newNode, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                    rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                    if (coll instanceof List) {
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME, (Object)index);
                        ++index;
                    }
                    if (!RelationType.isBidirectional((RelationType)relationType)) continue;
                    relMmds = mmd.getRelatedMemberMetaData(clr);
                    rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                }
            } else {
                this.deleteRelationshipsForMultivaluedMember(node, mmd);
                int index = 0;
                for (Node newNode : relNodes) {
                    rel = node.createRelationshipTo(newNode, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                    rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                    if (coll instanceof List) {
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME, (Object)index);
                        ++index;
                    }
                    if (!RelationType.isBidirectional((RelationType)relationType)) continue;
                    relMmds = mmd.getRelatedMemberMetaData(clr);
                    rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                }
            }
        } else if (mmd.hasArray()) {
            AbstractMemberMetaData[] relMmds;
            Relationship rel;
            int index;
            ArrayList<Node> relNodes = new ArrayList<Node>();
            if (value != null) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    if (mmd.getArray().isSerializedElement()) {
                        throw new NucleusUserException("Don't currently support serialised array elements at " + mmd.getFullFieldName());
                    }
                    Object element = Array.get(value, i);
                    if (element == null) {
                        throw new NucleusUserException("Dont currently support having null elements in arrays : " + mmd.getFullFieldName());
                    }
                    Object elementPC = ec.persistObjectInternal(element, null, -1, -1);
                    ObjectProvider relatedOP = ec.findObjectProvider(elementPC);
                    Node relatedNode = (Node)Neo4jUtils.getPropertyContainerForObjectProvider(this.propObj.getGraphDatabase(), relatedOP);
                    relNodes.add(relatedNode);
                }
            }
            if (relationType != RelationType.ONE_TO_MANY_BI && relationType != RelationType.ONE_TO_MANY_UNI && (relationType != RelationType.MANY_TO_MANY_BI || mmd.getMappedBy() != null)) {
                return;
            }
            if (this.insert) {
                index = 0;
                for (Node newNode : relNodes) {
                    rel = node.createRelationshipTo(newNode, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                    rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                    rel.setProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME, (Object)index);
                    if (RelationType.isBidirectional((RelationType)relationType)) {
                        relMmds = mmd.getRelatedMemberMetaData(clr);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                    }
                    ++index;
                }
            } else {
                this.deleteRelationshipsForMultivaluedMember(node, mmd);
                index = 0;
                for (Node newNode : relNodes) {
                    rel = node.createRelationshipTo(newNode, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                    rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                    rel.setProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME, (Object)index);
                    if (RelationType.isBidirectional((RelationType)relationType)) {
                        relMmds = mmd.getRelatedMemberMetaData(clr);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                    }
                    ++index;
                }
            }
        } else if (mmd.hasMap()) {
            Map map = (Map)value;
            if (!mmd.getMap().keyIsPersistent() && mmd.getMap().valueIsPersistent()) {
                AbstractMemberMetaData[] relMmds;
                Object relKeyVal;
                Relationship rel;
                Iterator relKeyIter;
                ArrayList<Node> relNodes = new ArrayList<Node>();
                ArrayList<Object> relKeyValues = new ArrayList<Object>();
                if (map != null) {
                    Iterator mapEntryIter = map.entrySet().iterator();
                    while (mapEntryIter.hasNext()) {
                        if (mmd.getMap().isSerializedValue()) {
                            throw new NucleusUserException("Don't currently support serialised map values at " + mmd.getFullFieldName());
                        }
                        Map.Entry entry = mapEntryIter.next();
                        Object key = entry.getKey();
                        Object val = entry.getValue();
                        if (val != null) {
                            Object valPC = ec.persistObjectInternal(val, null, -1, -1);
                            ObjectProvider relatedOP = ec.findObjectProvider(valPC);
                            Node relatedNode = (Node)Neo4jUtils.getPropertyContainerForObjectProvider(this.propObj.getGraphDatabase(), relatedOP);
                            relNodes.add(relatedNode);
                            relKeyValues.add(Neo4jUtils.getStoredValueForField(ec, mmd, key, 5));
                            continue;
                        }
                        throw new NucleusUserException("Dont currently support having null values in maps : " + mmd.getFullFieldName());
                    }
                }
                if (relationType != RelationType.ONE_TO_MANY_BI && relationType != RelationType.ONE_TO_MANY_UNI && (relationType != RelationType.MANY_TO_MANY_BI || mmd.getMappedBy() != null)) {
                    return;
                }
                if (this.insert) {
                    relKeyIter = relKeyValues.iterator();
                    for (Node newNode : relNodes) {
                        rel = node.createRelationshipTo(newNode, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                        if (mmd.getKeyMetaData() == null || mmd.getKeyMetaData().getMappedBy() == null) {
                            relKeyVal = relKeyIter.next();
                            rel.setProperty(Neo4jStoreManager.RELATIONSHIP_MAP_KEY_VALUE, relKeyVal);
                        }
                        if (!RelationType.isBidirectional((RelationType)relationType)) continue;
                        relMmds = mmd.getRelatedMemberMetaData(clr);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                    }
                } else {
                    this.deleteRelationshipsForMultivaluedMember(node, mmd);
                    relKeyIter = relKeyValues.iterator();
                    for (Node newNode : relNodes) {
                        rel = node.createRelationshipTo(newNode, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                        if (mmd.getKeyMetaData() == null || mmd.getKeyMetaData().getMappedBy() == null) {
                            relKeyVal = relKeyIter.next();
                            rel.setProperty(Neo4jStoreManager.RELATIONSHIP_MAP_KEY_VALUE, relKeyVal);
                        }
                        if (!RelationType.isBidirectional((RelationType)relationType)) continue;
                        relMmds = mmd.getRelatedMemberMetaData(clr);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                    }
                }
            } else if (mmd.getMap().keyIsPersistent() && !mmd.getMap().valueIsPersistent()) {
                AbstractMemberMetaData[] relMmds;
                Object relValValue;
                Relationship rel;
                Iterator relValIter;
                ArrayList<Node> relNodes = new ArrayList<Node>();
                ArrayList<Object> relValValues = new ArrayList<Object>();
                if (map != null) {
                    Iterator mapEntryIter = map.entrySet().iterator();
                    while (mapEntryIter.hasNext()) {
                        if (mmd.getMap().isSerializedKey()) {
                            throw new NucleusUserException("Don't currently support serialised map keys at " + mmd.getFullFieldName());
                        }
                        Map.Entry entry = mapEntryIter.next();
                        Object key = entry.getKey();
                        Object val = entry.getValue();
                        if (val != null) {
                            Object keyPC = ec.persistObjectInternal(key, null, -1, -1);
                            ObjectProvider relatedOP = ec.findObjectProvider(keyPC);
                            Node relatedNode = (Node)Neo4jUtils.getPropertyContainerForObjectProvider(this.propObj.getGraphDatabase(), relatedOP);
                            relNodes.add(relatedNode);
                            relValValues.add(Neo4jUtils.getStoredValueForField(ec, mmd, val, 6));
                            continue;
                        }
                        throw new NucleusUserException("Dont currently support having null keys in maps : " + mmd.getFullFieldName());
                    }
                }
                if (relationType != RelationType.ONE_TO_MANY_BI && relationType != RelationType.ONE_TO_MANY_UNI && (relationType != RelationType.MANY_TO_MANY_BI || mmd.getMappedBy() != null)) {
                    return;
                }
                if (this.insert) {
                    relValIter = relValValues.iterator();
                    for (Node newNode : relNodes) {
                        rel = node.createRelationshipTo(newNode, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                        if (mmd.getValueMetaData() == null || mmd.getValueMetaData().getMappedBy() == null) {
                            relValValue = relValIter.next();
                            rel.setProperty(Neo4jStoreManager.RELATIONSHIP_MAP_VAL_VALUE, relValValue);
                        }
                        if (!RelationType.isBidirectional((RelationType)relationType)) continue;
                        relMmds = mmd.getRelatedMemberMetaData(clr);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                    }
                } else {
                    this.deleteRelationshipsForMultivaluedMember(node, mmd);
                    relValIter = relValValues.iterator();
                    for (Node newNode : relNodes) {
                        rel = node.createRelationshipTo(newNode, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                        if (mmd.getValueMetaData() == null || mmd.getValueMetaData().getMappedBy() == null) {
                            relValValue = relValIter.next();
                            rel.setProperty(Neo4jStoreManager.RELATIONSHIP_MAP_VAL_VALUE, relValValue);
                        }
                        if (!RelationType.isBidirectional((RelationType)relationType)) continue;
                        relMmds = mmd.getRelatedMemberMetaData(clr);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                    }
                }
            } else {
                throw new NucleusUserException("Don't currently support maps of persistable objects : " + mmd.getFullFieldName());
            }
        }
    }

    private void deleteRelationshipsForMultivaluedMember(Node ownerNode, AbstractMemberMetaData mmd) {
        Iterable rels = ownerNode.getRelationships(new RelationshipType[]{DNRelationshipType.MULTI_VALUED});
        for (Relationship rel : rels) {
            if (!rel.getProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME).equals(mmd.getName())) continue;
            rel.delete();
        }
    }
}

