/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j.valuegenerator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.valuegenerator.AbstractDatastoreGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;

public class IncrementGenerator
extends AbstractDatastoreGenerator
implements ValueGenerator {
    protected static final String INCREMENT_INDEX = "DN_INCREMENT_INDEX";
    protected static final String INCREMENT_NAME = "INCREMENT_NAME";
    protected static final String INCREMENT_VALUE_PROPERTY = "INCREMENT_VAL";

    public IncrementGenerator(String name, Properties props) {
        super(name, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueGenerationBlock reserveBlock(long size) {
        ArrayList<Long> oids = new ArrayList<Long>();
        try {
            String cypherStr;
            ExecutionEngine engine;
            ExecutionResult queryResult;
            Iterator iter;
            ManagedConnection mconn = this.connectionProvider.retrieveConnection();
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            Node generatorNode = null;
            if (db.index().existsForNodes(INCREMENT_INDEX) && (iter = (queryResult = (engine = new ExecutionEngine(db)).execute(cypherStr = "START n=node:DN_INCREMENT_INDEX(INCREMENT_NAME=\"" + this.name + "\") RETURN n")).iterator()).hasNext()) {
                Map map = (Map)iter.next();
                generatorNode = (Node)map.get("n");
            }
            if (generatorNode == null) {
                if (!this.storeMgr.isAutoCreateTables()) {
                    throw new NucleusUserException(LOCALISER.msg("040011", (Object)this.name));
                }
                generatorNode = db.createNode();
                generatorNode.setProperty(INCREMENT_VALUE_PROPERTY, (Object)new Long(0L));
                db.index().forNodes(INCREMENT_INDEX).add((PropertyContainer)generatorNode, INCREMENT_NAME, (Object)this.name);
            }
            long number = (Long)generatorNode.getProperty(INCREMENT_VALUE_PROPERTY);
            int i = 0;
            while ((long)i < size) {
                oids.add(++number);
                ++i;
            }
            generatorNode.setProperty(INCREMENT_VALUE_PROPERTY, (Object)number);
        }
        finally {
            this.connectionProvider.releaseConnection();
        }
        return new ValueGenerationBlock(oids);
    }
}

