/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j;

import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.neo4j.Neo4jStoreManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.neo4j.Localisation", (ClassLoader)Neo4jStoreManager.class.getClassLoader());
    GraphDatabaseService graphDB;

    public ConnectionFactoryImpl(StoreManager storeMgr, String resourceType) {
        super(storeMgr, resourceType);
        String url = storeMgr.getConnectionURL();
        if (url == null) {
            throw new NucleusException("You haven't specified persistence property 'datanucleus.ConnectionURL' (or alias)");
        }
        String remains = url.substring(6).trim();
        if (remains.indexOf(58) == 0) {
            remains = remains.substring(1);
        }
        String dbName = "DataNucleus";
        if (remains.length() > 0) {
            dbName = remains;
        }
        GraphDatabaseFactory factory = new GraphDatabaseFactory();
        this.graphDB = factory.newEmbeddedDatabase(dbName);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                ConnectionFactoryImpl.this.graphDB.shutdown();
            }
        });
    }

    public void close() {
        super.close();
    }

    public ManagedConnection createManagedConnection(ExecutionContext ec, Map txnOptionsIgnored) {
        return new ManagedConnectionImpl();
    }

    static class EmulatedXAResource
    implements XAResource {
        ManagedConnectionImpl mconn;
        Transaction graphTx;

        EmulatedXAResource(ManagedConnectionImpl mconn) {
            this.mconn = mconn;
            this.graphTx = mconn.graphTx;
        }

        public void start(Xid xid, int flags) throws XAException {
        }

        public void commit(Xid xid, boolean onePhase) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is committing for transaction " + xid.toString() + " with onePhase=" + onePhase));
            this.graphTx.success();
            this.graphTx.finish();
            this.mconn.graphTx = null;
            this.mconn.xaRes = null;
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " committed connection for transaction " + xid.toString() + " with onePhase=" + onePhase));
        }

        public void rollback(Xid xid) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is rolling back for transaction " + xid.toString()));
            this.graphTx.failure();
            this.graphTx.finish();
            this.mconn.graphTx = null;
            this.mconn.xaRes = null;
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " rolled back connection for transaction " + xid.toString()));
        }

        public void end(Xid xid, int flags) throws XAException {
            this.mconn.xaRes = null;
        }

        public void forget(Xid xid) throws XAException {
        }

        public int prepare(Xid xid) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is preparing for transaction " + xid.toString()));
            return 0;
        }

        public Xid[] recover(int flags) throws XAException {
            throw new XAException("Unsupported operation");
        }

        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        public boolean setTransactionTimeout(int timeout) throws XAException {
            return false;
        }

        public boolean isSameRM(XAResource xares) throws XAException {
            return this == xares;
        }
    }

    public class ManagedConnectionImpl
    extends AbstractManagedConnection {
        Transaction graphTx;
        XAResource xaRes = null;

        public boolean closeAfterTransactionEnd() {
            return false;
        }

        protected void obtainNewConnection() {
            if (this.conn == null) {
                this.conn = ConnectionFactoryImpl.this.graphDB;
                this.graphTx = ConnectionFactoryImpl.this.graphDB.beginTx();
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is starting"));
            }
            if (this.graphTx == null) {
                this.graphTx = ((GraphDatabaseService)this.conn).beginTx();
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is starting"));
            }
        }

        public Object getConnection() {
            if (this.conn == null || this.graphTx == null) {
                this.obtainNewConnection();
            }
            return this.conn;
        }

        public void release() {
            if (this.commitOnRelease && this.conn != null) {
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is committing"));
                this.graphTx.success();
                this.graphTx.finish();
                this.graphTx = null;
                this.xaRes = null;
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " committed connection"));
            }
            super.release();
        }

        public void close() {
            int i;
            if (this.conn == null) {
                return;
            }
            for (i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            if (this.graphTx != null) {
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is committing"));
                this.graphTx.success();
                this.graphTx.finish();
                this.graphTx = null;
                this.xaRes = null;
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " committed connection"));
            }
            for (i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
            }
            this.conn = null;
        }

        public XAResource getXAResource() {
            if (this.xaRes == null) {
                if (this.conn == null || this.graphTx == null) {
                    this.obtainNewConnection();
                }
                this.xaRes = new EmulatedXAResource(this);
            }
            return this.xaRes;
        }
    }
}

