/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j.query;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.neo4j.Neo4jUtils;
import org.datanucleus.store.query.AbstractQueryResult;
import org.datanucleus.store.query.AbstractQueryResultIterator;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.SoftValueMap;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.WeakValueMap;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.PropertyContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyLoadQueryResult
extends AbstractQueryResult
implements Serializable {
    protected ExecutionContext ec;
    protected ExecutionResult result;
    protected Iterator<Map<String, Object>> resultIterator;
    protected String candidateAliasName = this.query.getCompilation().getCandidateAlias();
    protected AbstractClassMetaData cmd;
    protected String[] cypherResults;
    protected Map<Integer, Object> itemsByIndex = null;

    public LazyLoadQueryResult(Query q, ExecutionResult result, String cypherResult) {
        super(q);
        this.ec = q.getExecutionContext();
        this.cmd = this.ec.getMetaDataManager().getMetaDataForClass(this.query.getCandidateClass(), this.ec.getClassLoaderResolver());
        this.result = result;
        this.resultIterator = result.iterator();
        this.cypherResults = cypherResult != null ? cypherResult.split(",") : null;
        this.resultSizeMethod = this.cypherResults == null || this.cypherResults[0].equals(this.candidateAliasName) ? "count" : "last";
        String cacheType = this.query.getStringExtensionProperty("cacheType", "strong");
        this.itemsByIndex = cacheType != null ? (cacheType.equalsIgnoreCase("soft") ? new SoftValueMap() : (cacheType.equalsIgnoreCase("weak") ? new WeakValueMap() : (cacheType.equalsIgnoreCase("strong") ? new HashMap<Integer, Object>() : (cacheType.equalsIgnoreCase("none") ? null : new WeakValueMap())))) : new WeakValueMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closingConnection() {
        this.resultSizeMethod = "last";
        if (this.loadResultsAtCommit && this.isOpen() && this.resultIterator != null) {
            NucleusLogger.QUERY.info((Object)LOCALISER.msg("052606", (Object)this.query.toString()));
            LazyLoadQueryResult lazyLoadQueryResult = this;
            synchronized (lazyLoadQueryResult) {
                while (this.resultIterator.hasNext()) {
                    Map<String, Object> map = this.resultIterator.next();
                    Object result = this.getResultFromMapRow(map);
                    this.itemsByIndex.put(this.itemsByIndex.size(), result);
                }
                this.resultIterator = null;
            }
        }
    }

    private Object getResultFromMapRow(Map<String, Object> map) {
        Object result = null;
        if (this.cypherResults == null || this.cypherResults[0].equals(this.candidateAliasName)) {
            PropertyContainer node = (PropertyContainer)map.get(this.candidateAliasName);
            AbstractClassMetaData propObjCmd = Neo4jUtils.getClassMetaDataForPropertyContainer(node, this.query.getExecutionContext(), this.cmd);
            result = Neo4jUtils.getObjectForPropertyContainer(node, propObjCmd, this.query.getExecutionContext(), this.query.getIgnoreCache());
        } else if (this.cypherResults.length == 1) {
            result = map.get(this.cypherResults[0]);
        } else {
            result = new Object[this.cypherResults.length];
            for (int i = 0; i < this.cypherResults.length; ++i) {
                Array.set(result, i, map.get(this.cypherResults[i]));
            }
        }
        return result;
    }

    public synchronized void close() {
        this.itemsByIndex.clear();
        this.itemsByIndex = null;
        this.result = null;
        super.close();
    }

    protected void closeResults() {
    }

    protected int getSizeUsingMethod() {
        if (this.resultSizeMethod.equalsIgnoreCase("LAST")) {
            do {
                this.getNextObject();
            } while (this.resultIterator != null);
            this.size = this.itemsByIndex.size();
            return this.size;
        }
        return super.getSizeUsingMethod();
    }

    public Object get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index must be 0 or higher");
        }
        if (this.itemsByIndex != null && this.itemsByIndex.containsKey(index)) {
            return this.itemsByIndex.get(index);
        }
        do {
            Object nextPojo = this.getNextObject();
            if (this.itemsByIndex.size() != index + 1) continue;
            return nextPojo;
        } while (this.resultIterator != null);
        throw new IndexOutOfBoundsException("Beyond size of the results (" + this.itemsByIndex.size() + ")");
    }

    protected Object getNextObject() {
        if (this.resultIterator == null) {
            return null;
        }
        Map<String, Object> map = this.resultIterator.next();
        Object result = this.getResultFromMapRow(map);
        this.itemsByIndex.put(this.itemsByIndex.size(), result);
        if (!this.resultIterator.hasNext()) {
            this.resultIterator = null;
        }
        return result;
    }

    public Iterator iterator() {
        return new QueryResultIterator();
    }

    public ListIterator listIterator() {
        return new QueryResultIterator();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof LazyLoadQueryResult)) {
            return false;
        }
        LazyLoadQueryResult other = (LazyLoadQueryResult)o;
        if (this.query != null) {
            return other.query == this.query;
        }
        return StringUtils.toJVMIDString((Object)other).equals(StringUtils.toJVMIDString((Object)this));
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.disconnect();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < this.itemsByIndex.size(); ++i) {
            list.add(this.itemsByIndex.get(i));
        }
        return list;
    }

    private class QueryResultIterator
    extends AbstractQueryResultIterator {
        private int nextRowNum = 0;

        private QueryResultIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            LazyLoadQueryResult lazyLoadQueryResult = LazyLoadQueryResult.this;
            synchronized (lazyLoadQueryResult) {
                if (!LazyLoadQueryResult.this.isOpen()) {
                    return false;
                }
                if (this.nextRowNum < LazyLoadQueryResult.this.itemsByIndex.size()) {
                    return true;
                }
                return LazyLoadQueryResult.this.resultIterator != null;
            }
        }

        public Object next() {
            LazyLoadQueryResult lazyLoadQueryResult = LazyLoadQueryResult.this;
            synchronized (lazyLoadQueryResult) {
                if (!LazyLoadQueryResult.this.isOpen()) {
                    throw new NoSuchElementException(LOCALISER.msg("052600"));
                }
                if (this.nextRowNum < LazyLoadQueryResult.this.itemsByIndex.size()) {
                    Object pojo = LazyLoadQueryResult.this.itemsByIndex.get(this.nextRowNum);
                    ++this.nextRowNum;
                    return pojo;
                }
                if (LazyLoadQueryResult.this.resultIterator != null) {
                    Object pojo = LazyLoadQueryResult.this.getNextObject();
                    ++this.nextRowNum;
                    return pojo;
                }
                throw new NoSuchElementException(LOCALISER.msg("052602"));
            }
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public int nextIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public Object previous() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public int previousIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }
}

