/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.neo4j.Neo4jStoreManager;
import org.datanucleus.store.neo4j.fieldmanager.FetchFieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.NucleusLogger;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Neo4jUtils {
    public static Node getNodeForObjectProvider(GraphDatabaseService graphDB, ObjectProvider op) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        return Neo4jUtils.getNodeForObjectId(graphDB, ec, cmd, op.getInternalObjectId());
    }

    public static Node getNodeForObjectId(GraphDatabaseService graphDB, ExecutionContext ec, AbstractClassMetaData cmd, Object id) {
        Iterator iter;
        StoreManager storeMgr = ec.getStoreManager();
        if (cmd.pkIsDatastoreAttributed(storeMgr)) {
            int[] pkFieldNumbers;
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                OID oid = (OID)id;
                Long key = (Long)oid.getKeyValue();
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving Node for id=" + key));
                }
                return graphDB.getNodeById(key.longValue());
            }
            if (cmd.getIdentityType() == IdentityType.APPLICATION && (pkFieldNumbers = cmd.getPKMemberPositions()).length == 1) {
                Long key = (Long)ec.getApiAdapter().getTargetKeyForSingleFieldIdentity(id);
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving Node for id=" + key));
                }
                return graphDB.getNodeById(key.longValue());
            }
        }
        if (!graphDB.index().existsForNodes(Neo4jStoreManager.NODE_TYPE_INDEX_NAME)) {
            return null;
        }
        StringBuffer cypherString = new StringBuffer();
        cypherString.append("START n=node:" + Neo4jStoreManager.NODE_TYPE_INDEX_NAME + "(" + Neo4jStoreManager.NODE_TYPE_INDEX_KEY + "=\"" + cmd.getFullClassName() + "\")");
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            cypherString.append(" WHERE (");
            int[] pkPositions = cmd.getPKMemberPositions();
            for (int i = 0; i < pkPositions.length; ++i) {
                AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkPositions[i]);
                Object value = null;
                value = cmd.usesSingleFieldIdentityClass() ? ec.getApiAdapter().getTargetKeyForSingleFieldIdentity(id) : IdentityUtils.getValueForMemberInId((Object)id, (AbstractMemberMetaData)pkMmd);
                cypherString.append("n." + ec.getStoreManager().getNamingFactory().getColumnName(pkMmd, ColumnType.COLUMN));
                cypherString.append(" = ");
                Object storedValue = Neo4jUtils.getStoredValueForField(ec, pkMmd, value, 2);
                if (storedValue instanceof String) {
                    cypherString.append("\"" + storedValue + "\"");
                } else {
                    cypherString.append(storedValue);
                }
                if (i == pkPositions.length - 1) continue;
                cypherString.append(" and ");
            }
            cypherString.append(")");
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            OID oid = (OID)id;
            if (oid == null && storeMgr.isStrategyDatastoreAttributed(cmd, -1)) {
                return null;
            }
            Object value = oid.getKeyValue();
            String propName = ec.getStoreManager().getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN);
            cypherString.append(" WHERE (n.");
            cypherString.append(propName);
            cypherString.append(" = ");
            cypherString.append(Neo4jUtils.getStoredValueForField(ec, null, value, 2));
            cypherString.append(")");
        } else {
            throw new NucleusException("Impossible to retrieve Node for nondurable identity");
        }
        if (cmd.hasDiscriminatorStrategy()) {
            DiscriminatorMetaData discmd = cmd.getDiscriminatorMetaData();
            String propName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN);
            String discVal = null;
            discVal = cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? cmd.getFullClassName() : discmd.getValue();
            cypherString.append(" and (n.").append(propName).append(" = \"").append((Object)discVal).append("\")");
        }
        cypherString.append(" RETURN n");
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving objects using Cypher query : " + cypherString));
        }
        ExecutionEngine engine = new ExecutionEngine(graphDB);
        ExecutionResult result = engine.execute(cypherString.toString());
        if (ec.getStatistics() != null) {
            ec.getStatistics().incrementNumReads();
        }
        if (!(iter = result.iterator()).hasNext()) {
            return null;
        }
        Map map = (Map)iter.next();
        Node node = (Node)map.get("n");
        if (iter.hasNext()) {
            throw new NucleusException("Query of Node for object with id=" + id + " returned more than 1 result! : " + cypherString);
        }
        return node;
    }

    public static List getObjectsOfCandidateType(ExecutionContext ec, GraphDatabaseService db, Class candidateClass, boolean subclasses, boolean ignoreCache, FetchPlan fp, Map<String, Object> options, String candidateAliasName, String filterText, String orderText) {
        String propName;
        if (candidateAliasName == null) {
            candidateAliasName = "n";
        }
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(candidateClass, ec.getClassLoaderResolver());
        StoreManager storeMgr = ec.getStoreManager();
        StringBuffer cypherString = new StringBuffer();
        cypherString.append("START " + candidateAliasName + "=node:" + Neo4jStoreManager.NODE_TYPE_INDEX_NAME + "(" + Neo4jStoreManager.NODE_TYPE_INDEX_KEY + "=\"" + cmd.getFullClassName() + "\")");
        boolean multiple = false;
        String discriminatorText = null;
        if (cmd.hasDiscriminatorStrategy()) {
            DiscriminatorMetaData discmd = cmd.getDiscriminatorMetaData();
            propName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN);
            String discVal = null;
            discVal = cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? cmd.getFullClassName() : discmd.getValue();
            discriminatorText = propName + " = \"" + discVal + "\"";
            if (filterText != null) {
                multiple = true;
            }
        }
        String multitenancyText = null;
        if (storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
            propName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.MULTITENANCY_COLUMN);
            String value = storeMgr.getStringProperty("datanucleus.TenantID");
            multitenancyText = propName + " = \"" + value + "\"";
            if (filterText != null || discriminatorText != null) {
                multiple = true;
            }
        }
        if (filterText != null || discriminatorText != null || multitenancyText != null) {
            cypherString.append(" WHERE ");
            boolean started = false;
            if (filterText != null) {
                if (multiple) {
                    cypherString.append("(");
                }
                cypherString.append(filterText);
                if (multiple) {
                    cypherString.append(")");
                }
                started = true;
            }
            if (discriminatorText != null) {
                if (started) {
                    cypherString.append(" and");
                }
                if (multiple) {
                    cypherString.append("(");
                }
                cypherString.append(discriminatorText);
                if (multiple) {
                    cypherString.append(")");
                }
                started = true;
            }
            if (multitenancyText != null) {
                if (started) {
                    cypherString.append(" and");
                }
                if (multiple) {
                    cypherString.append("(");
                }
                cypherString.append(multitenancyText);
                if (multiple) {
                    cypherString.append(")");
                }
            }
        }
        cypherString.append(" RETURN " + candidateAliasName);
        if (orderText != null) {
            cypherString.append(" ORDER BY " + orderText);
        }
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving objects using Cypher query : " + cypherString));
        }
        ArrayList<Object> results = new ArrayList<Object>();
        ExecutionEngine engine = new ExecutionEngine(db);
        ExecutionResult queryResult = engine.execute(cypherString.toString());
        Iterator iter = queryResult.iterator();
        fp.manageFetchPlanForClass(cmd);
        int[] fpMembers = fp.getFetchPlanForClass(cmd).getMemberNumbers();
        while (iter.hasNext()) {
            Map map = (Map)iter.next();
            if (map.size() <= 0) continue;
            Node node = (Node)map.get(candidateAliasName);
            AbstractClassMetaData nodeCmd = Neo4jUtils.getClassMetaDataForNode(node, ec, cmd);
            if (!subclasses && !cmd.getFullClassName().equals(nodeCmd.getFullClassName())) continue;
            Object obj = Neo4jUtils.getObjectForNode(node, nodeCmd, ec, ignoreCache, fpMembers);
            results.add(obj);
        }
        return results;
    }

    public static AbstractClassMetaData getClassMetaDataForNode(Node node, ExecutionContext ec, AbstractClassMetaData cmd) {
        Index typesIdx = node.getGraphDatabase().index().forNodes(Neo4jStoreManager.NODE_TYPE_INDEX_NAME);
        String[] subclassNames = ec.getMetaDataManager().getSubclassesForClass(cmd.getFullClassName(), false);
        if (subclassNames != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                AbstractClassMetaData subcmd = ec.getMetaDataManager().getMetaDataForClass(subclassNames[i], ec.getClassLoaderResolver());
                IndexHits nodesForSubclass = typesIdx.get(Neo4jStoreManager.NODE_TYPE_INDEX_KEY, (Object)subcmd.getFullClassName());
                if (nodesForSubclass == null) continue;
                for (Node subclassNode : nodesForSubclass) {
                    if (!subclassNode.equals(node)) continue;
                    return Neo4jUtils.getClassMetaDataForNode(subclassNode, ec, subcmd);
                }
            }
        }
        return cmd;
    }

    public static Object getObjectForNode(Node node, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, int[] fpMembers) {
        if (fpMembers == null) {
            ec.getFetchPlan().manageFetchPlanForClass(cmd);
            fpMembers = ec.getFetchPlan().getFetchPlanForClass(cmd).getMemberNumbers();
        }
        Object obj = null;
        obj = cmd.getIdentityType() == IdentityType.APPLICATION ? Neo4jUtils.getObjectUsingApplicationIdForDBObject(node, cmd, ec, ignoreCache, fpMembers) : (cmd.getIdentityType() == IdentityType.DATASTORE ? Neo4jUtils.getObjectUsingDatastoreIdForDBObject(node, cmd, ec, ignoreCache, fpMembers) : Neo4jUtils.getObjectUsingNondurableIdForDBObject(node, cmd, ec, ignoreCache, fpMembers));
        return obj;
    }

    public static Object getObjectUsingApplicationIdForDBObject(final Node node, final AbstractClassMetaData cmd, final ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        Object id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)false, (FieldManager)new FetchFieldManager(ec, node, cmd));
        StoreManager storeMgr = ec.getStoreManager();
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject(id, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, (FieldManager)new FetchFieldManager(ec, node, cmd));
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, (FieldManager)new FetchFieldManager(ec, node, cmd));
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        if (cmd.isVersioned()) {
            ObjectProvider sm = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = sm.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = node.getProperty(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN));
            }
            sm.setVersion(version);
        }
        return pc;
    }

    public static Object getObjectUsingDatastoreIdForDBObject(final Node node, final AbstractClassMetaData cmd, final ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        StoreManager storeMgr = ec.getStoreManager();
        Object idKey = node.getProperty(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN));
        OID oid = OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)cmd.getFullClassName(), (Object)idKey);
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject((Object)oid, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, (FieldManager)new FetchFieldManager(ec, node, cmd));
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, (FieldManager)new FetchFieldManager(ec, node, cmd));
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        if (cmd.isVersioned()) {
            ObjectProvider sm = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = sm.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = node.getProperty(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN));
            }
            sm.setVersion(version);
        }
        return pc;
    }

    public static Object getObjectUsingNondurableIdForDBObject(final Node node, final AbstractClassMetaData cmd, final ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        SCOID oid = new SCOID(cmd.getFullClassName());
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject((Object)oid, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, (FieldManager)new FetchFieldManager(ec, node, cmd));
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, (FieldManager)new FetchFieldManager(ec, node, cmd));
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        if (cmd.isVersioned()) {
            ObjectProvider sm = ec.findObjectProvider(pc);
            StoreManager storeMgr = ec.getStoreManager();
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = sm.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = node.getProperty(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN));
            }
            sm.setVersion(version);
        }
        return pc;
    }

    public static Object getStoredValueForField(ExecutionContext ec, AbstractMemberMetaData mmd, Object value, int fieldRole) {
        if (value == null) {
            return null;
        }
        Class type = value.getClass();
        if (mmd != null) {
            type = fieldRole == 3 ? ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType()) : (fieldRole == 4 ? ec.getClassLoaderResolver().classForName(mmd.getArray().getElementType()) : (fieldRole == 5 ? ec.getClassLoaderResolver().classForName(mmd.getMap().getKeyType()) : (fieldRole == 6 ? ec.getClassLoaderResolver().classForName(mmd.getMap().getValueType()) : mmd.getType())));
        }
        if (Byte.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || String.class.isAssignableFrom(type)) {
            return value;
        }
        if (Enum.class.isAssignableFrom(type)) {
            boolean useNumeric;
            ColumnMetaData colmd = null;
            if (mmd != null && mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                colmd = mmd.getColumnMetaData()[0];
            }
            return (useNumeric = MetaDataUtils.persistColumnAsNumeric(colmd)) ? Integer.valueOf(((Enum)value).ordinal()) : ((Enum)value).name();
        }
        TypeConverter strConv = ec.getTypeManager().getTypeConverterForType(type, String.class);
        TypeConverter longConv = ec.getTypeManager().getTypeConverterForType(type, Long.class);
        if (strConv != null) {
            return strConv.toDatastoreType(value);
        }
        if (longConv != null) {
            return longConv.toDatastoreType(value);
        }
        return value;
    }

    public static Object getFieldValueFromStored(ExecutionContext ec, AbstractMemberMetaData mmd, Object value, int fieldRole) {
        if (value == null) {
            return null;
        }
        Class type = value.getClass();
        if (mmd != null) {
            type = fieldRole == 3 ? ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType()) : (fieldRole == 4 ? ec.getClassLoaderResolver().classForName(mmd.getArray().getElementType()) : (fieldRole == 5 ? ec.getClassLoaderResolver().classForName(mmd.getMap().getKeyType()) : (fieldRole == 6 ? ec.getClassLoaderResolver().classForName(mmd.getMap().getValueType()) : mmd.getType())));
        }
        if (Byte.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || String.class.isAssignableFrom(type)) {
            return value;
        }
        if (Enum.class.isAssignableFrom(type)) {
            ColumnMetaData colmd = null;
            if (mmd != null && mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                colmd = mmd.getColumnMetaData()[0];
            }
            if (MetaDataUtils.persistColumnAsNumeric(colmd)) {
                return type.getEnumConstants()[((Number)value).intValue()];
            }
            return Enum.valueOf(type, (String)value);
        }
        TypeConverter strConv = ec.getTypeManager().getTypeConverterForType(type, String.class);
        TypeConverter longConv = ec.getTypeManager().getTypeConverterForType(type, Long.class);
        if (strConv != null) {
            String strValue = (String)value;
            return strConv.toMemberType((Object)strValue);
        }
        if (longConv != null) {
            Long longValue = (Long)value;
            return longConv.toMemberType((Object)longValue);
        }
        return value;
    }

    public static String getPropertyNameForEmbeddedField(AbstractMemberMetaData ownerMmd, int fieldNumber) {
        ColumnMetaData[] colmds;
        String columnName = null;
        EmbeddedMetaData embmd = ownerMmd.getEmbeddedMetaData();
        AbstractMemberMetaData embMmd = null;
        if (embmd != null) {
            AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
            embMmd = embmmds[fieldNumber];
        }
        if ((colmds = embMmd.getColumnMetaData()) != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = embMmd.getName();
        }
        if (columnName == null) {
            columnName = embMmd.getName();
        }
        return columnName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassNameForIdentity(Object id, AbstractClassMetaData rootCmd, ExecutionContext ec, ClassLoaderResolver clr) {
        StoreManager storeMgr = ec.getStoreManager();
        ManagedConnection mconn = storeMgr.getConnection(ec);
        try {
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            Node node = Neo4jUtils.getNodeForObjectId(db, ec, rootCmd, id);
            AbstractClassMetaData cmd = Neo4jUtils.getClassMetaDataForNode(node, ec, rootCmd);
            String string = cmd.getFullClassName();
            return string;
        }
        finally {
            mconn.release();
        }
    }
}

