/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.StoreFieldManager;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;

public class StoreEmbeddedFieldManager
extends StoreFieldManager {
    protected List<AbstractMemberMetaData> mmds;

    public StoreEmbeddedFieldManager(ObjectProvider op, DBObject dbObject, boolean insert, List<AbstractMemberMetaData> mmds, Table table) {
        super(op, dbObject, insert, table);
        this.mmds = mmds;
    }

    @Override
    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
        embMmds.add(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        return this.table.getMemberColumnMappingForEmbeddedMember(embMmds);
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        AbstractMemberMetaData lastMmd = this.mmds.get(this.mmds.size() - 1);
        EmbeddedMetaData embmd = this.mmds.get(0).getEmbeddedMetaData();
        if (this.mmds.size() == 1 && embmd != null && embmd.getOwnerMember() != null && embmd.getOwnerMember().equals(mmd.getName())) {
            ObjectProvider[] ownerOPs = this.ec.getOwnersForEmbeddedObjectProvider(this.op);
            if (ownerOPs != null && ownerOPs.length == 1 && value != ownerOPs[0].getObject()) {
                this.op.replaceField(fieldNumber, ownerOPs[0].getObject());
            }
            return;
        }
        ExecutionContext ec = this.op.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
        embMmds.add(mmd);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(ec.getMetaDataManager(), clr, mmd, relationType, lastMmd)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                AbstractClassMetaData embCmd = ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                if (embCmd == null) {
                    throw new NucleusUserException("Member " + mmd.getFullFieldName() + " specified as embedded but metadata not found for the class of type " + mmd.getTypeName());
                }
                if (RelationType.isBidirectional((RelationType)relationType)) {
                    // empty if block
                }
                if (value == null) {
                    for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                        this.dbObject.removeField(mapping.getColumn(i).getName());
                    }
                    return;
                }
                boolean nested = MongoDBUtils.isMemberNested(mmd);
                Object obj = nested ? new BasicDBObject() : this.dbObject;
                ObjectProvider embOP = ec.findObjectProviderForEmbedded(value, this.op, mmd);
                StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embOP, (DBObject)obj, this.insert, (List<AbstractMemberMetaData>)embMmds, this.table);
                embOP.provideFields(embCmd.getAllMemberPositions(), (FieldManager)ffm);
                if (nested) {
                    this.dbObject.put(mapping.getColumn(0).getName(), obj);
                }
                return;
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                ColumnMetaData[] embeddedColumns = mapping.getMemberMetaData().getElementMetaData().getColumnMetaData();
                if (embeddedColumns.length == 0) {
                    return;
                }
                String fieldName = embeddedColumns[0].getName();
                if (value == null) {
                    this.dbObject.removeField(fieldName);
                    return;
                }
                if (mmd.hasCollection()) {
                    AbstractClassMetaData embcmd = mmd.getCollection().getElementClassMetaData(clr);
                    ArrayList<BasicDBObject> coll = new ArrayList<BasicDBObject>();
                    Collection valueColl = (Collection)value;
                    for (Object element : valueColl) {
                        if (!element.getClass().getName().equals(embcmd.getFullClassName())) {
                            embcmd = ec.getMetaDataManager().getMetaDataForClass(element.getClass(), clr);
                        }
                        BasicDBObject embeddedObject = new BasicDBObject();
                        ObjectProvider embOP = ec.findObjectProviderForEmbedded(element, this.op, mmd);
                        embOP.setPcObjectType((short)2);
                        StoreEmbeddedFieldManager sfm = new StoreEmbeddedFieldManager(embOP, (DBObject)embeddedObject, this.insert, embMmds, this.table);
                        sfm.ownerMmd = mmd;
                        embOP.provideFields(embcmd.getAllMemberPositions(), (FieldManager)sfm);
                        coll.add(embeddedObject);
                    }
                    this.dbObject.put(fieldName, coll);
                    return;
                }
                if (mmd.hasArray()) {
                    throw new NucleusException("Member " + mmd.getFullFieldName() + " is embedded but we do not support embedded array fields in this location (owner=" + this.op + ")");
                }
                if (mmd.hasMap()) {
                    throw new NucleusException("Member " + mmd.getFullFieldName() + " is embedded but we do not support embedded map fields in this location (owner=" + this.op + ")");
                }
            }
        }
        this.storeNonEmbeddedObjectField(mmd, relationType, clr, value);
    }
}

