/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bson.types.ObjectId;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBStoreManager;
import org.datanucleus.store.mongodb.fieldmanager.FetchFieldManager;
import org.datanucleus.store.mongodb.query.LazyLoadQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.TypeConversionHelper;

public class MongoDBUtils {
    private MongoDBUtils() {
    }

    public static List<Long> performMongoCount(DB db, BasicDBObject filterObject, Class candidateClass, boolean subclasses, ExecutionContext ec) throws MongoException {
        StoreManager storeMgr = ec.getStoreManager();
        long count = 0L;
        for (AbstractClassMetaData cmd : MetaDataUtils.getMetaDataForCandidates((Class)candidateClass, (boolean)subclasses, (ExecutionContext)ec)) {
            Table table = storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
            String collectionName = table.getName();
            count += db.getCollection(collectionName).count((DBObject)filterObject);
        }
        LinkedList<Long> results = new LinkedList<Long>();
        results.add(count);
        if (ec.getStatistics() != null) {
            ec.getStatistics().incrementNumReads();
        }
        return results;
    }

    public static boolean isMemberNested(AbstractMemberMetaData mmd) {
        boolean nested = true;
        String nestedStr = mmd.getValueForExtension("nested");
        if (nestedStr != null && nestedStr.equalsIgnoreCase("false")) {
            nested = false;
        }
        return nested;
    }

    public static String getDefaultValueForMember(AbstractMemberMetaData mmd) {
        ColumnMetaData[] colmds = mmd.getColumnMetaData();
        if (colmds == null || colmds.length < 1) {
            return null;
        }
        return colmds[0].getDefaultValue();
    }

    public static String getFieldName(AbstractMemberMetaData mmd, int fieldNumber) {
        String columnName = null;
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData embMmd = null;
        if (embmd != null) {
            AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
            embMmd = embmmds[fieldNumber];
        }
        if (embMmd != null) {
            ColumnMetaData[] colmds = embMmd.getColumnMetaData();
            if (colmds != null && colmds.length > 0) {
                columnName = colmds[0].getName();
            }
            if (columnName == null) {
                columnName = embMmd.getName();
            }
            if (columnName == null) {
                columnName = embMmd.getName();
            }
        }
        return columnName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassNameForIdentity(Object id, AbstractClassMetaData rootCmd, ExecutionContext ec, ClassLoaderResolver clr) {
        HashMap classNamesByTableName = new HashMap();
        HashMap<String, Table> tableByTableName = new HashMap<String, Table>();
        StoreManager storeMgr = ec.getStoreManager();
        ManagedConnection mconn = storeMgr.getConnectionManager().getConnection(ec);
        try {
            DB db = (DB)mconn.getConnection();
            StoreData sd = storeMgr.getStoreDataForClass(rootCmd.getFullClassName());
            if (sd == null) {
                ((MongoDBStoreManager)storeMgr).manageClasses(new String[]{rootCmd.getFullClassName()}, ec.getClassLoaderResolver(), db);
                sd = storeMgr.getStoreDataForClass(rootCmd.getFullClassName());
            }
            HashSet<String> rootClassNames = new HashSet<String>();
            rootClassNames.add(rootCmd.getFullClassName());
            Table tbl = sd.getTable();
            classNamesByTableName.put(tbl.getName(), rootClassNames);
            tableByTableName.put(tbl.getName(), tbl);
            Collection subclassNames = storeMgr.getSubClassesForClass(rootCmd.getFullClassName(), true, clr);
            if (subclassNames != null && !subclassNames.isEmpty()) {
                for (String subclassName : subclassNames) {
                    Table subTable;
                    String subTableName;
                    HashSet<String> classNames;
                    AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(subclassName, clr);
                    sd = storeMgr.getStoreDataForClass(cmd.getFullClassName());
                    if (sd == null) {
                        ((MongoDBStoreManager)storeMgr).manageClasses(new String[]{rootCmd.getFullClassName()}, ec.getClassLoaderResolver(), db);
                        sd = storeMgr.getStoreDataForClass(rootCmd.getFullClassName());
                    }
                    if ((classNames = (HashSet<String>)classNamesByTableName.get(subTableName = (subTable = sd.getTable()).getName())) == null) {
                        classNames = new HashSet<String>();
                        classNamesByTableName.put(subTableName, classNames);
                    }
                    classNames.add(cmd.getFullClassName());
                    if (tableByTableName.containsKey(subTableName)) continue;
                    tableByTableName.put(subTableName, subTable);
                }
            }
            for (Map.Entry dbCollEntry : classNamesByTableName.entrySet()) {
                Object key;
                String tableName = (String)dbCollEntry.getKey();
                Set classNames = (Set)dbCollEntry.getValue();
                Table table = (Table)tableByTableName.get(tableName);
                DBCollection dbColl = db.getCollection(tableName);
                BasicDBObject query = new BasicDBObject();
                if (rootCmd.getIdentityType() == IdentityType.DATASTORE) {
                    key = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)id);
                    if (storeMgr.isValueGenerationStrategyDatastoreAttributed(rootCmd, -1)) {
                        query.put((Object)"_id", (Object)new ObjectId((String)key));
                    } else {
                        query.put((Object)table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID).getName(), key);
                    }
                } else if (rootCmd.getIdentityType() == IdentityType.APPLICATION) {
                    String pkPropName;
                    AbstractMemberMetaData pkMmd;
                    if (IdentityUtils.isSingleFieldIdentity((Object)id)) {
                        key = IdentityUtils.getTargetKeyForSingleFieldIdentity((Object)id);
                        int[] pkNums = rootCmd.getPKMemberPositions();
                        pkMmd = rootCmd.getMetaDataForManagedMemberAtAbsolutePosition(pkNums[0]);
                        pkPropName = table.getMemberColumnMappingForMember(pkMmd).getColumn(0).getName();
                        query.put((Object)pkPropName, key);
                    } else {
                        int[] pkNums = rootCmd.getPKMemberPositions();
                        for (int i = 0; i < pkNums.length; ++i) {
                            pkMmd = rootCmd.getMetaDataForManagedMemberAtAbsolutePosition(pkNums[i]);
                            pkPropName = table.getMemberColumnMappingForMember(pkMmd).getColumn(0).getName();
                            Object pkVal = IdentityUtils.getValueForMemberInId((Object)id, (AbstractMemberMetaData)pkMmd);
                            query.put((Object)pkPropName, pkVal);
                        }
                    }
                }
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving object for " + query + " from DBCollection with name " + tableName));
                }
                DBObject foundObj = dbColl.findOne((DBObject)query);
                if (ec.getStatistics() != null) {
                    ec.getStatistics().incrementNumReads();
                }
                if (foundObj == null) continue;
                if (classNames.size() == 1) {
                    String i = (String)classNames.iterator().next();
                    return i;
                }
                if (rootCmd.hasDiscriminatorStrategy()) {
                    String discValue = (String)foundObj.get(table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR).getName());
                    String string = ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discValue, rootCmd.getDiscriminatorMetaData());
                    return string;
                }
                String string = rootCmd.getFullClassName();
                return string;
            }
        }
        finally {
            mconn.release();
        }
        return null;
    }

    public static DBObject getObjectForObjectProvider(DBCollection dbCollection, ObjectProvider op, boolean checkVersion, boolean originalValue) {
        BasicDBObject query = new BasicDBObject();
        AbstractClassMetaData cmd = op.getClassMetaData();
        Table table = op.getStoreManager().getStoreDataForClass(cmd.getFullClassName()).getTable();
        ExecutionContext ec = op.getExecutionContext();
        StoreManager storeMgr = ec.getStoreManager();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkPositions = cmd.getPKMemberPositions();
            for (int i = 0; i < pkPositions.length; ++i) {
                AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkPositions[i]);
                RelationType relType = pkMmd.getRelationType(clr);
                Object fieldVal = op.provideField(pkPositions[i]);
                if (relType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(op.getStoreManager().getMetaDataManager(), clr, pkMmd, relType, null)) {
                    ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                    embMmds.add(pkMmd);
                    ObjectProvider embOP = ec.findObjectProvider(fieldVal);
                    AbstractClassMetaData embCmd = embOP.getClassMetaData();
                    int[] memberPositions = embCmd.getAllMemberPositions();
                    String embOwnerCol = null;
                    if (MongoDBUtils.isMemberNested(pkMmd)) {
                        MemberColumnMapping mapping = table.getMemberColumnMappingForMember(pkMmd);
                        embOwnerCol = mapping.getColumn(0).getName();
                    }
                    for (int j = 0; j < memberPositions.length; ++j) {
                        AbstractMemberMetaData embMmd = embCmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPositions[j]);
                        if (embMmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) continue;
                        embMmds.add(embMmd);
                        MemberColumnMapping mapping = table.getMemberColumnMappingForEmbeddedMember(embMmds);
                        embMmds.remove(embMmds.size() - 1);
                        Column[] cols = mapping.getColumns();
                        Object embFieldVal = embOP.provideField(memberPositions[j]);
                        if (embOwnerCol != null) {
                            query.put((Object)(embOwnerCol + "." + cols[0].getName()), embFieldVal);
                            continue;
                        }
                        query.put((Object)cols[0].getName(), embFieldVal);
                    }
                    continue;
                }
                if (storeMgr.isValueGenerationStrategyDatastoreAttributed(cmd, pkPositions[i])) {
                    if (fieldVal == null) {
                        return null;
                    }
                    query.put((Object)"_id", (Object)new ObjectId((String)fieldVal));
                    continue;
                }
                MemberColumnMapping mapping = table.getMemberColumnMappingForMember(pkMmd);
                Object storeValue = fieldVal;
                storeValue = RelationType.isRelationSingleValued((RelationType)relType) ? IdentityUtils.getPersistableIdentityForId((Object)ec.getApiAdapter().getIdForObject(fieldVal)) : (mapping.getTypeConverter() != null ? mapping.getTypeConverter().toDatastoreType(storeValue) : MongoDBUtils.getStoredValueForField(ec, pkMmd, mapping, fieldVal, FieldRole.ROLE_FIELD));
                query.put((Object)mapping.getColumn(0).getName(), storeValue);
            }
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            Object id = op.getInternalObjectId();
            if (id == null && storeMgr.isValueGenerationStrategyDatastoreAttributed(cmd, -1)) {
                return null;
            }
            Object value = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)id);
            if (storeMgr.isValueGenerationStrategyDatastoreAttributed(cmd, -1)) {
                query.put((Object)"_id", (Object)new ObjectId((String)value));
            } else {
                query.put((Object)table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID).getName(), value);
            }
        } else {
            int[] fieldNumbers = cmd.getAllMemberPositions();
            for (int i = 0; i < fieldNumbers.length; ++i) {
                Object oldValue;
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                RelationType relationType = mmd.getRelationType(clr);
                if (relationType != RelationType.NONE) continue;
                Object fieldValue = null;
                fieldValue = originalValue ? ((oldValue = op.getAssociatedValue((Object)("FIELD_VALUE.ORIGINAL." + fieldNumbers[i]))) != null ? oldValue : op.provideField(fieldNumbers[i])) : op.provideField(fieldNumbers[i]);
                MemberColumnMapping mapping = table.getMemberColumnMappingForMember(mmd);
                Object storeValue = MongoDBUtils.getStoredValueForField(ec, mmd, mapping, fieldValue, FieldRole.ROLE_FIELD);
                query.put((Object)mapping.getColumn(0).getName(), storeValue);
            }
        }
        if (cmd.hasDiscriminatorStrategy()) {
            query.put((Object)table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR).getName(), cmd.getDiscriminatorValue());
        }
        if (checkVersion && cmd.isVersioned()) {
            Object currentVersion = op.getTransactionalVersion();
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                query.put((Object)table.getMemberColumnMappingForMember(cmd.getMetaDataForMember(vermd.getFieldName())).getColumn(0).getName(), currentVersion);
            } else {
                query.put((Object)table.getSurrogateColumn(SurrogateColumnType.VERSION).getName(), currentVersion);
            }
        }
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving object for " + query));
        }
        DBObject dbObj = dbCollection.findOne((DBObject)query);
        if (ec.getStatistics() != null) {
            ec.getStatistics().incrementNumReads();
        }
        return dbObj;
    }

    public static List getObjectsOfCandidateType(Query q, DB db, BasicDBObject filterObject, Map<String, Object> options) {
        return MongoDBUtils.getObjectsOfCandidateType(q, db, filterObject, null, options, null, null);
    }

    public static List getObjectsOfCandidateType(Query q, DB db, BasicDBObject filterObject, BasicDBObject orderingObject, Map<String, Object> options, Integer skip, Integer limit) {
        LazyLoadQueryResult qr = new LazyLoadQueryResult(q);
        ExecutionContext ec = q.getExecutionContext();
        StoreManager storeMgr = ec.getStoreManager();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        List cmds = MetaDataUtils.getMetaDataForCandidates((Class)q.getCandidateClass(), (boolean)q.isSubclasses(), (ExecutionContext)ec);
        HashMap<String, ArrayList<AbstractClassMetaData>> classesByCollectionName = new HashMap<String, ArrayList<AbstractClassMetaData>>();
        for (AbstractClassMetaData cmd : cmds) {
            Table table;
            String collectionName;
            ArrayList<AbstractClassMetaData> cmdsForCollection;
            if (cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract()) continue;
            StoreData sd = storeMgr.getStoreDataForClass(cmd.getFullClassName());
            if (sd == null) {
                ((MongoDBStoreManager)storeMgr).manageClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), db);
                sd = storeMgr.getStoreDataForClass(cmd.getFullClassName());
            }
            if ((cmdsForCollection = (ArrayList<AbstractClassMetaData>)classesByCollectionName.get(collectionName = (table = sd.getTable()).getName())) == null) {
                cmdsForCollection = new ArrayList<AbstractClassMetaData>();
                classesByCollectionName.put(collectionName, cmdsForCollection);
            }
            cmdsForCollection.add(cmd);
        }
        for (Map.Entry entry : classesByCollectionName.entrySet()) {
            Boolean val;
            String collectionName = (String)entry.getKey();
            List cmdsForCollection = (List)entry.getValue();
            AbstractClassMetaData rootCmd = (AbstractClassMetaData)cmdsForCollection.get(0);
            Table rootTable = storeMgr.getStoreDataForClass(rootCmd.getFullClassName()).getTable();
            int[] fpMembers = q.getFetchPlan().getFetchPlanForClass(rootCmd).getMemberNumbers();
            BasicDBObject fieldsSelection = new BasicDBObject();
            if (fpMembers != null && fpMembers.length > 0) {
                fieldsSelection = new BasicDBObject();
                for (int i = 0; i < fpMembers.length; ++i) {
                    AbstractMemberMetaData mmd = rootCmd.getMetaDataForManagedMemberAtAbsolutePosition(fpMembers[i]);
                    RelationType relationType = mmd.getRelationType(clr);
                    if (mmd.isEmbedded() && RelationType.isRelationSingleValued((RelationType)relationType)) {
                        boolean nested = MongoDBUtils.isMemberNested(mmd);
                        if (nested) {
                            fieldsSelection.append(storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN), (Object)1);
                            continue;
                        }
                        MongoDBUtils.selectAllFieldsOfEmbeddedObject(mmd, fieldsSelection, ec, clr);
                        continue;
                    }
                    MemberColumnMapping mapping = rootTable.getMemberColumnMappingForMember(mmd);
                    for (int j = 0; j < mapping.getNumberOfColumns(); ++j) {
                        fieldsSelection.append(rootTable.getMemberColumnMappingForMember(mmd).getColumn(j).getName(), (Object)1);
                    }
                }
            }
            if (rootCmd.getIdentityType() == IdentityType.DATASTORE) {
                fieldsSelection.append(rootTable.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID).getName(), (Object)1);
            }
            if (rootCmd.isVersioned()) {
                VersionMetaData vermd = rootCmd.getVersionMetaDataForClass();
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = rootCmd.getMetaDataForMember(vermd.getFieldName());
                    String fieldName = rootTable.getMemberColumnMappingForMember(verMmd).getColumn(0).getName();
                    fieldsSelection.append(fieldName, (Object)1);
                } else {
                    fieldsSelection.append(rootTable.getSurrogateColumn(SurrogateColumnType.VERSION).getName(), (Object)1);
                }
            }
            if (rootCmd.hasDiscriminatorStrategy()) {
                fieldsSelection.append(rootTable.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR).getName(), (Object)1);
            }
            BasicDBObject query = new BasicDBObject();
            if (filterObject != null) {
                for (Map.Entry filterEntry : filterObject.entrySet()) {
                    query.put(filterEntry.getKey(), filterEntry.getValue());
                }
            }
            if (rootCmd.hasDiscriminatorStrategy() && cmdsForCollection.size() == 1) {
                query.put((Object)rootTable.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR).getName(), rootCmd.getDiscriminatorValue());
            }
            if (ec.getNucleusContext().isClassMultiTenant(rootCmd)) {
                String fieldName = rootTable.getSurrogateColumn(SurrogateColumnType.MULTITENANCY).getName();
                String value = ec.getNucleusContext().getMultiTenancyId(ec, rootCmd);
                query.put((Object)fieldName, (Object)value);
            }
            if (rootTable.getSurrogateColumn(SurrogateColumnType.SOFTDELETE) != null) {
                query.put((Object)rootTable.getSurrogateColumn(SurrogateColumnType.SOFTDELETE).getName(), (Object)Boolean.FALSE);
            }
            DBCollection dbColl = db.getCollection(collectionName);
            Boolean bl = val = options != null ? options.get("slave-ok") : Boolean.FALSE;
            if (val == Boolean.TRUE) {
                dbColl.setReadPreference(ReadPreference.secondaryPreferred());
            }
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("Performing find() using query on collection " + collectionName + " for fields=" + fieldsSelection + " with filter=" + query + " and ordering=" + orderingObject));
            }
            DBCursor curs = dbColl.find((DBObject)query, (DBObject)fieldsSelection);
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumReads();
            }
            if (classesByCollectionName.size() == 1) {
                if (orderingObject != null) {
                    curs = curs.sort((DBObject)orderingObject);
                    qr.setOrderProcessed(true);
                }
                if (skip != null && skip > 0) {
                    curs = curs.skip(skip.intValue());
                    qr.setRangeProcessed(true);
                }
                if (limit != null && limit > 0) {
                    curs = curs.limit(limit.intValue());
                    qr.setRangeProcessed(true);
                }
            }
            if (!curs.hasNext()) continue;
            qr.addCandidateResult(rootCmd, curs, fpMembers);
        }
        return qr;
    }

    public static Object getPojoForDBObjectForCandidate(DBObject dbObject, ExecutionContext ec, AbstractClassMetaData cmd, int[] fpMembers, boolean ignoreCache) {
        Table table = ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName()).getTable();
        if (cmd.hasDiscriminatorStrategy()) {
            String disPropName = table.getSurrogateColumn(SurrogateColumnType.DISCRIMINATOR).getName();
            String discValue = (String)dbObject.get(disPropName);
            String clsName = ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discValue, cmd.getDiscriminatorMetaData());
            if (!cmd.getFullClassName().equals(clsName) && clsName != null) {
                cmd = ec.getMetaDataManager().getMetaDataForClass(clsName, ec.getClassLoaderResolver());
            }
        }
        Object pojo = null;
        pojo = cmd.getIdentityType() == IdentityType.APPLICATION ? MongoDBUtils.getObjectUsingApplicationIdForDBObject(dbObject, cmd, ec, ignoreCache, fpMembers) : (cmd.getIdentityType() == IdentityType.DATASTORE ? MongoDBUtils.getObjectUsingDatastoreIdForDBObject(dbObject, cmd, ec, ignoreCache, fpMembers) : MongoDBUtils.getObjectUsingNondurableIdForDBObject(dbObject, cmd, ec, ignoreCache, fpMembers));
        return pojo;
    }

    protected static void selectAllFieldsOfEmbeddedObject(AbstractMemberMetaData mmd, BasicDBObject fieldsSelection, ExecutionContext ec, ClassLoaderResolver clr) {
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
        for (int i = 0; i < embmmds.length; ++i) {
            RelationType relationType = embmmds[i].getRelationType(clr);
            if (embmmds[i].isEmbedded() && RelationType.isRelationSingleValued((RelationType)relationType)) {
                MongoDBUtils.selectAllFieldsOfEmbeddedObject(embmmds[i], fieldsSelection, ec, clr);
                continue;
            }
            fieldsSelection.append(MongoDBUtils.getFieldName(mmd, i), (Object)1);
        }
    }

    public static Object getObjectUsingApplicationIdForDBObject(DBObject dbObject, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        Table table = ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName()).getTable();
        final FetchFieldManager fm = new FetchFieldManager(ec, dbObject, cmd, table);
        Object id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)false, (FieldManager)fm);
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject(id, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, (FieldManager)fm);
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, (FieldManager)fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        ObjectProvider op = ec.findObjectProvider(pc);
        if (cmd.isVersioned()) {
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            version = vermd.getFieldName() != null ? op.provideField(cmd.getMetaDataForMember(vermd.getFieldName()).getAbsoluteFieldNumber()) : dbObject.get(table.getSurrogateColumn(SurrogateColumnType.VERSION).getName());
            op.setVersion(version);
        }
        op.replaceAllLoadedSCOFieldsWithWrappers();
        return pc;
    }

    public static Object getObjectUsingDatastoreIdForDBObject(DBObject dbObject, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        Object idKey = null;
        StoreManager storeMgr = ec.getStoreManager();
        Table table = storeMgr.getStoreDataForClass(cmd.getFullClassName()).getTable();
        if (storeMgr.isValueGenerationStrategyDatastoreAttributed(cmd, -1)) {
            idKey = dbObject.get("_id");
            if (idKey instanceof ObjectId) {
                idKey = ((ObjectId)idKey).toString();
            }
        } else {
            idKey = dbObject.get(table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID).getName());
        }
        final FetchFieldManager fm = new FetchFieldManager(ec, dbObject, cmd, table);
        DatastoreId oid = ec.getNucleusContext().getIdentityManager().getDatastoreId(cmd.getFullClassName(), idKey);
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject((Object)oid, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, (FieldManager)fm);
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, (FieldManager)fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        ObjectProvider op = ec.findObjectProvider(pc);
        if (cmd.isVersioned()) {
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            version = vermd.getFieldName() != null ? op.provideField(cmd.getMetaDataForMember(vermd.getFieldName()).getAbsoluteFieldNumber()) : dbObject.get(table.getSurrogateColumn(SurrogateColumnType.VERSION).getName());
            op.setVersion(version);
        }
        op.replaceAllLoadedSCOFieldsWithWrappers();
        return pc;
    }

    public static Object getObjectUsingNondurableIdForDBObject(DBObject dbObject, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        Table table = ec.getStoreManager().getStoreDataForClass(cmd.getFullClassName()).getTable();
        SCOID oid = new SCOID(cmd.getFullClassName());
        final FetchFieldManager fm = new FetchFieldManager(ec, dbObject, cmd, table);
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject((Object)oid, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, (FieldManager)fm);
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, (FieldManager)fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        ObjectProvider op = ec.findObjectProvider(pc);
        if (cmd.isVersioned()) {
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            version = vermd.getFieldName() != null ? op.provideField(cmd.getMetaDataForMember(vermd.getFieldName()).getAbsoluteFieldNumber()) : dbObject.get(table.getSurrogateColumn(SurrogateColumnType.VERSION).getName());
            op.setVersion(version);
        }
        op.replaceAllLoadedSCOFieldsWithWrappers();
        return pc;
    }

    public static Object getStoredValueForField(ExecutionContext ec, AbstractMemberMetaData mmd, MemberColumnMapping mapping, Object value, FieldRole fieldRole) {
        boolean optional;
        if (value == null) {
            return null;
        }
        boolean bl = optional = mmd != null ? Optional.class.isAssignableFrom(mmd.getType()) : false;
        if (mmd != null) {
            if (mmd.hasCollection() && !optional) {
                TypeConverter elemConv;
                if (fieldRole == FieldRole.ROLE_FIELD) {
                    ArrayList<Object> coll = new ArrayList<Object>();
                    Collection rawColl = (Collection)value;
                    for (Object elem : rawColl) {
                        Object storeElem = MongoDBUtils.getStoredValueForField(ec, mmd, mapping, elem, FieldRole.ROLE_COLLECTION_ELEMENT);
                        coll.add(storeElem);
                    }
                    return coll;
                }
                if (fieldRole == FieldRole.ROLE_COLLECTION_ELEMENT && (elemConv = mapping.getTypeConverterForComponent(fieldRole)) != null) {
                    return elemConv.toDatastoreType(value);
                }
            } else if (mmd.hasArray()) {
                if (fieldRole == FieldRole.ROLE_FIELD) {
                    Object[] array = new Object[Array.getLength(value)];
                    for (int i = 0; i < array.length; ++i) {
                        Object storeElem;
                        Object elem = Array.get(value, i);
                        array[i] = storeElem = MongoDBUtils.getStoredValueForField(ec, mmd, mapping, elem, FieldRole.ROLE_ARRAY_ELEMENT);
                    }
                    return array;
                }
            } else if (mmd.hasMap()) {
                TypeConverter valConv;
                if (fieldRole == FieldRole.ROLE_FIELD) {
                    ArrayList<BasicDBObject> coll = new ArrayList<BasicDBObject>();
                    Map rawMap = (Map)value;
                    for (Map.Entry entry : rawMap.entrySet()) {
                        BasicDBObject entryObj = new BasicDBObject();
                        Object storeKey = MongoDBUtils.getStoredValueForField(ec, mmd, mapping, entry.getKey(), FieldRole.ROLE_MAP_KEY);
                        entryObj.put((Object)"key", storeKey);
                        Object storeValue = MongoDBUtils.getStoredValueForField(ec, mmd, mapping, entry.getValue(), FieldRole.ROLE_MAP_VALUE);
                        entryObj.put((Object)"value", storeValue);
                        coll.add(entryObj);
                    }
                    return coll;
                }
                if (fieldRole == FieldRole.ROLE_MAP_KEY) {
                    TypeConverter keyConv = mapping.getTypeConverterForComponent(fieldRole);
                    if (keyConv != null) {
                        return keyConv.toDatastoreType(value);
                    }
                } else if (fieldRole == FieldRole.ROLE_MAP_VALUE && (valConv = mapping.getTypeConverterForComponent(fieldRole)) != null) {
                    return valConv.toDatastoreType(value);
                }
            }
        }
        Class type = value.getClass();
        if (mmd != null) {
            if (optional) {
                type = ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType());
            } else if (mmd.hasCollection() && fieldRole == FieldRole.ROLE_COLLECTION_ELEMENT) {
                type = ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType());
            } else if (mmd.hasArray() && fieldRole == FieldRole.ROLE_ARRAY_ELEMENT) {
                type = ec.getClassLoaderResolver().classForName(mmd.getArray().getElementType());
            } else if (mmd.hasMap() && fieldRole == FieldRole.ROLE_MAP_KEY) {
                type = ec.getClassLoaderResolver().classForName(mmd.getMap().getKeyType());
            } else if (mmd.hasMap() && fieldRole == FieldRole.ROLE_MAP_VALUE) {
                type = ec.getClassLoaderResolver().classForName(mmd.getMap().getValueType());
            }
        }
        if (Long.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || String.class.isAssignableFrom(type) || Byte.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type)) {
            return value;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return TypeConversionHelper.getStoredValueFromEnum((AbstractMemberMetaData)mmd, (FieldRole)fieldRole, (Enum)((Enum)value));
        }
        if (type == java.util.Date.class) {
            return value;
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return new java.util.Date(((java.util.Date)value).getTime());
        }
        if (Calendar.class.isAssignableFrom(type)) {
            ColumnMetaData colmd = null;
            if (mmd != null && mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                colmd = mmd.getColumnMetaData()[0];
            }
            if (!MetaDataUtils.persistColumnAsString(colmd)) {
                return ((Calendar)value).getTime();
            }
        } else if (Character.class.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type)) {
            return "" + value;
        }
        TypeConverter strConv = ec.getTypeManager().getTypeConverterForType(type, String.class);
        TypeConverter longConv = ec.getTypeManager().getTypeConverterForType(type, Long.class);
        if (strConv != null) {
            return strConv.toDatastoreType(value);
        }
        if (longConv != null) {
            return longConv.toDatastoreType(value);
        }
        return value;
    }

    public static Object getFieldValueFromStored(ExecutionContext ec, AbstractMemberMetaData mmd, MemberColumnMapping mapping, Object value, FieldRole fieldRole) {
        boolean optional;
        if (value == null) {
            return null;
        }
        boolean bl = optional = mmd != null ? Optional.class.isAssignableFrom(mmd.getType()) : false;
        if (mmd != null) {
            if (mmd.hasCollection() && !optional) {
                TypeConverter elemConv;
                if (fieldRole == FieldRole.ROLE_FIELD) {
                    Collection coll;
                    try {
                        Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                        coll = (Collection)instanceType.newInstance();
                    }
                    catch (Exception e) {
                        throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                    }
                    Collection rawColl = (Collection)value;
                    for (Object elem : rawColl) {
                        Object storeElem = MongoDBUtils.getFieldValueFromStored(ec, mmd, mapping, elem, FieldRole.ROLE_COLLECTION_ELEMENT);
                        coll.add(storeElem);
                    }
                    return coll;
                }
                if (fieldRole == FieldRole.ROLE_COLLECTION_ELEMENT && (elemConv = mapping.getTypeConverterForComponent(fieldRole)) != null) {
                    return elemConv.toMemberType(value);
                }
            } else if (mmd.hasArray()) {
                if (fieldRole == FieldRole.ROLE_FIELD) {
                    Collection rawColl = (Collection)value;
                    Object array = Array.newInstance(mmd.getType().getComponentType(), rawColl.size());
                    int i = 0;
                    for (Object elem : rawColl) {
                        Object storeElem = MongoDBUtils.getFieldValueFromStored(ec, mmd, mapping, elem, FieldRole.ROLE_ARRAY_ELEMENT);
                        storeElem = TypeConversionHelper.convertTo((Object)storeElem, mmd.getType().getComponentType());
                        Array.set(array, i++, storeElem);
                    }
                    return array;
                }
            } else if (mmd.hasMap()) {
                TypeConverter valConv;
                if (fieldRole == FieldRole.ROLE_FIELD) {
                    Map map;
                    try {
                        Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                        map = (Map)instanceType.newInstance();
                    }
                    catch (Exception e) {
                        throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                    }
                    Collection rawColl = (Collection)value;
                    for (DBObject mapEntryObj : rawColl) {
                        Object dbKey = mapEntryObj.get("key");
                        Object dbVal = mapEntryObj.get("value");
                        Object key = MongoDBUtils.getFieldValueFromStored(ec, mmd, mapping, dbKey, FieldRole.ROLE_MAP_KEY);
                        Object val = MongoDBUtils.getFieldValueFromStored(ec, mmd, mapping, dbVal, FieldRole.ROLE_MAP_VALUE);
                        map.put(key, val);
                    }
                    return map;
                }
                if (fieldRole == FieldRole.ROLE_MAP_KEY) {
                    TypeConverter keyConv = mapping.getTypeConverterForComponent(fieldRole);
                    if (keyConv != null) {
                        return keyConv.toMemberType(value);
                    }
                } else if (fieldRole == FieldRole.ROLE_MAP_VALUE && (valConv = mapping.getTypeConverterForComponent(fieldRole)) != null) {
                    return valConv.toMemberType(value);
                }
            }
        }
        Class type = value.getClass();
        if (mmd != null) {
            type = optional ? ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType()) : (fieldRole == FieldRole.ROLE_COLLECTION_ELEMENT ? ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType()) : (fieldRole == FieldRole.ROLE_ARRAY_ELEMENT ? ec.getClassLoaderResolver().classForName(mmd.getArray().getElementType()) : (fieldRole == FieldRole.ROLE_MAP_KEY ? ec.getClassLoaderResolver().classForName(mmd.getMap().getKeyType()) : (fieldRole == FieldRole.ROLE_MAP_VALUE ? ec.getClassLoaderResolver().classForName(mmd.getMap().getValueType()) : mmd.getType()))));
        }
        if (Character.class.isAssignableFrom(type)) {
            if (value instanceof Character) {
                return value;
            }
            return Character.valueOf(((String)value).charAt(0));
        }
        if (Short.class.isAssignableFrom(type)) {
            if (value instanceof Short) {
                return value;
            }
            return ((Number)value).shortValue();
        }
        if (Integer.class.isAssignableFrom(type)) {
            if (value instanceof Integer) {
                return value;
            }
            return ((Number)value).intValue();
        }
        if (Long.class.isAssignableFrom(type)) {
            if (value instanceof Long) {
                return value;
            }
            return ((Number)value).longValue();
        }
        if (Float.class.isAssignableFrom(type)) {
            if (value instanceof Float) {
                return value;
            }
            return Float.valueOf(((Number)value).floatValue());
        }
        if (Double.class.isAssignableFrom(type)) {
            if (value instanceof Double) {
                return value;
            }
            return ((Number)value).doubleValue();
        }
        if (Byte.class.isAssignableFrom(type)) {
            if (value instanceof Byte) {
                return value;
            }
            return ((Number)value).byteValue();
        }
        if (Enum.class.isAssignableFrom(type)) {
            return TypeConversionHelper.getEnumForStoredValue((AbstractMemberMetaData)mmd, (FieldRole)fieldRole, (Object)value, (ClassLoaderResolver)ec.getClassLoaderResolver());
        }
        if (Date.class.isAssignableFrom(type) && value instanceof java.util.Date) {
            Date sqlDate = null;
            sqlDate = value instanceof Date ? (Date)value : new Date(((java.util.Date)value).getTime());
            return sqlDate;
        }
        if (Time.class.isAssignableFrom(type) && value instanceof java.util.Date) {
            Time sqlTime = null;
            sqlTime = value instanceof Time ? (Time)value : new Time(((java.util.Date)value).getTime());
            return sqlTime;
        }
        if (Timestamp.class.isAssignableFrom(type) && value instanceof java.util.Date) {
            Timestamp sqlTs = null;
            sqlTs = value instanceof Timestamp ? (Timestamp)value : new Timestamp(((java.util.Date)value).getTime());
            return sqlTs;
        }
        if (java.util.Date.class.isAssignableFrom(type) && value instanceof java.util.Date) {
            return value;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            ColumnMetaData colmd = null;
            if (mmd != null && mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                colmd = mmd.getColumnMetaData()[0];
            }
            if (!MetaDataUtils.persistColumnAsString(colmd)) {
                Calendar cal = Calendar.getInstance();
                cal.setTime((java.util.Date)value);
                return cal;
            }
        }
        TypeConverter strConv = ec.getTypeManager().getTypeConverterForType(type, String.class);
        TypeConverter longConv = ec.getTypeManager().getTypeConverterForType(type, Long.class);
        if (strConv != null) {
            String strValue = (String)value;
            return strConv.toMemberType((Object)strValue);
        }
        if (longConv != null) {
            Long longValue = (Long)value;
            return longConv.toMemberType((Object)longValue);
        }
        return value;
    }

    public static Object getAcceptableDatastoreValue(Object value) {
        if (value == null) {
            return null;
        }
        Object returnValue = value;
        if (returnValue instanceof SCO) {
            returnValue = ((SCO)returnValue).getValue();
        }
        if (returnValue instanceof Timestamp) {
            return new java.util.Date(((Timestamp)returnValue).getTime());
        }
        if (returnValue instanceof Time) {
            return new java.util.Date(((Time)returnValue).getTime());
        }
        if (returnValue instanceof Date) {
            return new java.util.Date(((Date)returnValue).getTime());
        }
        return returnValue;
    }

    public static byte[] getStoredValueForJavaSerialisedField(AbstractMemberMetaData mmd, Object value) {
        byte[] storeValue = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            storeValue = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException("Exception thrown serialising value for field " + mmd.getFullFieldName(), (Throwable)e);
        }
        return storeValue;
    }

    public static Object getFieldValueForJavaSerialisedField(AbstractMemberMetaData mmd, Object value) {
        Object returnValue = null;
        try {
            if (value != null) {
                byte[] bytes = (byte[])value;
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                returnValue = ois.readObject();
                ois.close();
                bis.close();
            }
        }
        catch (Exception e) {
            throw new NucleusUserException("Exception thrown deserialising field at " + mmd.getFullFieldName(), (Throwable)e);
        }
        return returnValue;
    }
}

