/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractEmulatedXAResource;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    public static final String MONGODB_CONNECTIONS_PER_HOST = "datanucleus.mongodb.connectionsPerHost";
    public static final String MONGODB_THREAD_BLOCK_FOR_MULTIPLIER = "datanucleus.mongodb.threadsAllowedToBlockForConnectionMultiplier";
    String dbName = "DataNucleus";
    MongoClient mongo;

    public ConnectionFactoryImpl(StoreManager storeMgr, String resourceType) {
        super(storeMgr, resourceType);
        String url = storeMgr.getConnectionURL();
        if (url == null) {
            throw new NucleusException("You haven't specified persistence property 'datanucleus.ConnectionURL' (or alias)");
        }
        String remains = url.substring(7).trim();
        if (remains.indexOf(58) == 0) {
            remains = remains.substring(1);
        }
        try {
            ArrayList<ServerAddress> serverAddrs = new ArrayList<ServerAddress>();
            if (remains.length() == 0) {
                serverAddrs.add(new ServerAddress());
            } else {
                StringTokenizer tokeniser = new StringTokenizer(remains, ",");
                while (tokeniser.hasMoreTokens()) {
                    String token = tokeniser.nextToken();
                    String serverName = "localhost";
                    if (serverAddrs.isEmpty()) {
                        int dbNameSepPos = token.indexOf("/");
                        if (dbNameSepPos >= 0) {
                            String dbNameStr;
                            if (dbNameSepPos < token.length() && (dbNameStr = token.substring(dbNameSepPos + 1)).length() > 0) {
                                this.dbName = dbNameStr;
                            }
                            if (dbNameSepPos > 0) {
                                serverName = token.substring(0, dbNameSepPos);
                            }
                        } else if (token.length() > 0) {
                            serverName = token;
                        }
                    } else {
                        serverName = token;
                    }
                    ServerAddress addr = null;
                    int portSeparatorPos = serverName.indexOf(58);
                    addr = portSeparatorPos > 0 ? new ServerAddress(serverName.substring(0, portSeparatorPos), Integer.valueOf(serverName.substring(portSeparatorPos + 1)).intValue()) : new ServerAddress(serverName);
                    serverAddrs.add(addr);
                }
            }
            ArrayList<MongoCredential> credentials = null;
            String userName = storeMgr.getConnectionUserName();
            String password = storeMgr.getConnectionPassword();
            if (!StringUtils.isWhitespace((String)userName)) {
                MongoCredential credential = MongoCredential.createCredential((String)userName, (String)this.dbName, (char[])password.toCharArray());
                credentials = new ArrayList<MongoCredential>();
                credentials.add(credential);
            }
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"MongoDB.ServerConnect", (Object[])new Object[]{this.dbName, serverAddrs.size(), StringUtils.collectionToString(serverAddrs)}));
            }
            this.mongo = serverAddrs.size() == 1 ? (credentials == null ? new MongoClient((ServerAddress)serverAddrs.get(0), this.getMongodbOptions(storeMgr)) : new MongoClient((ServerAddress)serverAddrs.get(0), credentials, this.getMongodbOptions(storeMgr))) : (credentials == null ? new MongoClient(serverAddrs, this.getMongodbOptions(storeMgr)) : new MongoClient(serverAddrs, credentials, this.getMongodbOptions(storeMgr)));
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug((Object)("Created MongoClient object on resource " + this.getResourceName()));
            }
        }
        catch (MongoException me) {
            throw new NucleusDataStoreException("Unable to connect to MongoClient", (Throwable)me);
        }
        catch (Exception e) {
            throw new NucleusDataStoreException("Unable to connect to MongoClient", (Throwable)e);
        }
    }

    private MongoClientOptions getMongodbOptions(StoreManager storeManager) {
        MongoClientOptions.Builder mongoOptionsBuilder = MongoClientOptions.builder();
        if (storeManager.hasProperty(MONGODB_CONNECTIONS_PER_HOST)) {
            mongoOptionsBuilder.connectionsPerHost(storeManager.getIntProperty(MONGODB_CONNECTIONS_PER_HOST));
        }
        if (storeManager.hasProperty(MONGODB_THREAD_BLOCK_FOR_MULTIPLIER)) {
            mongoOptionsBuilder.threadsAllowedToBlockForConnectionMultiplier(storeManager.getIntProperty(MONGODB_THREAD_BLOCK_FOR_MULTIPLIER));
        }
        return mongoOptionsBuilder.build();
    }

    public void close() {
        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
            NucleusLogger.CONNECTION.debug((Object)("Closing MongoClient object on resource " + this.getResourceName()));
        }
        this.mongo.close();
        super.close();
    }

    public ManagedConnection createManagedConnection(ExecutionContext ec, Map options) {
        return new ManagedConnectionImpl(ec);
    }

    static class EmulatedXAResource
    extends AbstractEmulatedXAResource {
        DB db;

        EmulatedXAResource(ManagedConnectionImpl mconn, DB db) {
            super((ManagedConnection)mconn);
            this.db = db;
        }

        public void commit(Xid xid, boolean onePhase) throws XAException {
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"009015", (Object[])new Object[]{((Object)((Object)this)).toString()}));
            }
            super.commit(xid, onePhase);
        }

        public void rollback(Xid xid) throws XAException {
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"009016", (Object[])new Object[]{((Object)((Object)this)).toString()}));
            }
            super.rollback(xid);
        }
    }

    public class ManagedConnectionImpl
    extends AbstractManagedConnection {
        ExecutionContext ec;
        XAResource xaRes = null;

        public ManagedConnectionImpl(ExecutionContext ec) {
            this.ec = ec;
        }

        public boolean closeAfterTransactionEnd() {
            return false;
        }

        public Object getConnection() {
            if (this.conn == null) {
                this.obtainNewConnection();
            }
            return this.conn;
        }

        protected void obtainNewConnection() {
            if (this.conn == null) {
                this.conn = ConnectionFactoryImpl.this.mongo.getDB(ConnectionFactoryImpl.this.dbName);
                if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                    NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"009011", (Object[])new Object[]{this.toString(), ConnectionFactoryImpl.this.getResourceName()}));
                }
            }
        }

        public void release() {
            if (this.commitOnRelease && NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"009015", (Object[])new Object[]{this.toString()}));
            }
            super.release();
        }

        public void close() {
            for (ManagedConnectionResourceListener listener : this.listeners) {
                listener.managedConnectionPreClose();
            }
            if (this.conn != null && NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug((Object)Localiser.msg((String)"009013", (Object[])new Object[]{this.toString()}));
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
            }
            this.ec = null;
            this.xaRes = null;
            super.close();
        }

        public XAResource getXAResource() {
            if (this.xaRes == null) {
                if (this.conn == null) {
                    this.obtainNewConnection();
                }
                this.xaRes = new EmulatedXAResource(this, (DB)this.conn);
            }
            return this.xaRes;
        }
    }
}

