/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractStoreFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.StoreEmbeddedFieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.TypeConverter;

public class StoreFieldManager
extends AbstractStoreFieldManager {
    protected DBObject dbObject;
    protected AbstractMemberMetaData ownerMmd = null;

    public StoreFieldManager(ObjectProvider op, DBObject dbObject, boolean insert) {
        super(op, insert);
        this.dbObject = dbObject;
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        this.dbObject.put(fieldName, (Object)value);
    }

    public void storeCharField(int fieldNumber, char value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        this.dbObject.put(fieldName, (Object)("" + value));
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        this.dbObject.put(fieldName, (Object)value);
    }

    public void storeShortField(int fieldNumber, short value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        this.dbObject.put(fieldName, (Object)value);
    }

    public void storeIntField(int fieldNumber, int value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        this.dbObject.put(fieldName, (Object)value);
    }

    public void storeLongField(int fieldNumber, long value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        this.dbObject.put(fieldName, (Object)value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        this.dbObject.put(fieldName, (Object)Float.valueOf(value));
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        this.dbObject.put(fieldName, (Object)value);
    }

    public void storeStringField(int fieldNumber, String value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        if (mmd.getValueStrategy() == IdentityStrategy.IDENTITY) {
            return;
        }
        String fieldName = this.getFieldName(fieldNumber);
        if (value == null) {
            this.dbObject.removeField(fieldName);
            return;
        }
        this.dbObject.put(fieldName, (Object)value);
    }

    protected String getFieldName(int fieldNumber) {
        return this.op.getExecutionContext().getStoreManager().getNamingFactory().getColumnName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), ColumnType.COLUMN);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        ExecutionContext ec = this.op.getExecutionContext();
        String fieldName = ec.getStoreManager().getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(ec.getMetaDataManager(), clr, mmd, relationType, this.ownerMmd)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                boolean nested = true;
                String nestedStr = mmd.getValueForExtension("nested");
                if (nestedStr != null && nestedStr.equalsIgnoreCase("false")) {
                    nested = false;
                }
                if (nested && this.ownerMmd != null && (RelationType.isBidirectional((RelationType)relationType) ? this.ownerMmd.getMappedBy() != null && mmd.getName().equals(this.ownerMmd.getMappedBy()) || mmd.getMappedBy() != null && this.ownerMmd.getName().equals(mmd.getMappedBy()) : (this.ownerMmd.hasCollection() ? this.ownerMmd.getElementMetaData().getEmbeddedMetaData() != null && this.ownerMmd.getElementMetaData().getEmbeddedMetaData().getOwnerMember() != null && this.ownerMmd.getElementMetaData().getEmbeddedMetaData().getOwnerMember().equals(mmd.getName()) : this.ownerMmd.getEmbeddedMetaData() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember().equals(mmd.getName())))) {
                    return;
                }
                if (value == null) {
                    if (nested) {
                        this.dbObject.removeField(fieldName);
                        return;
                    }
                    return;
                }
                AbstractClassMetaData embcmd = ec.getMetaDataManager().getMetaDataForClass(value.getClass(), clr);
                if (embcmd == null) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " specified as embedded but metadata not found for the class of type " + mmd.getTypeName());
                }
                ObjectProvider embOP = ec.findObjectProviderForEmbedded(value, this.op, mmd);
                if (nested) {
                    BasicDBObject embeddedObject = new BasicDBObject();
                    if (embcmd.hasDiscriminatorStrategy()) {
                        String discPropName = null;
                        discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : ec.getStoreManager().getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                        DiscriminatorMetaData discmd = embcmd.getDiscriminatorMetaData();
                        String discVal = null;
                        discVal = embcmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? embcmd.getFullClassName() : discmd.getValue();
                        embeddedObject.put(discPropName, (Object)discVal);
                    }
                    StoreFieldManager sfm = new StoreFieldManager(embOP, (DBObject)embeddedObject, this.insert);
                    sfm.ownerMmd = mmd;
                    embOP.provideFields(embcmd.getAllMemberPositions(), (FieldManager)sfm);
                    this.dbObject.put(fieldName, (Object)embeddedObject);
                    return;
                }
                if (embcmd.hasDiscriminatorStrategy()) {
                    String discPropName = null;
                    discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : ec.getStoreManager().getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                    DiscriminatorMetaData discmd = embcmd.getDiscriminatorMetaData();
                    String discVal = null;
                    discVal = embcmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? embcmd.getFullClassName() : discmd.getValue();
                    this.dbObject.put(discPropName, (Object)discVal);
                }
                StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embOP, this.dbObject, mmd, this.insert);
                embOP.provideFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                return;
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                if (value == null) {
                    this.dbObject.removeField(fieldName);
                    return;
                }
                if (mmd.hasCollection()) {
                    AbstractClassMetaData embcmd = mmd.getCollection().getElementClassMetaData(clr, ec.getMetaDataManager());
                    ArrayList<BasicDBObject> coll = new ArrayList<BasicDBObject>();
                    Collection valueColl = (Collection)value;
                    for (Object element : valueColl) {
                        if (!element.getClass().getName().equals(embcmd.getFullClassName())) {
                            embcmd = ec.getMetaDataManager().getMetaDataForClass(element.getClass(), clr);
                        }
                        BasicDBObject embeddedObject = new BasicDBObject();
                        if (embcmd.hasDiscriminatorStrategy()) {
                            String discPropName = null;
                            discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : ec.getStoreManager().getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                            DiscriminatorMetaData discmd = embcmd.getDiscriminatorMetaData();
                            String discVal = null;
                            discVal = embcmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? embcmd.getFullClassName() : discmd.getValue();
                            embeddedObject.put(discPropName, (Object)discVal);
                        }
                        ObjectProvider embOP = ec.findObjectProviderForEmbedded(element, this.op, mmd);
                        embOP.setPcObjectType((short)2);
                        StoreFieldManager sfm = new StoreFieldManager(embOP, (DBObject)embeddedObject, this.insert);
                        sfm.ownerMmd = mmd;
                        embOP.provideFields(embcmd.getAllMemberPositions(), (FieldManager)sfm);
                        coll.add(embeddedObject);
                    }
                    this.dbObject.put(fieldName, coll);
                    return;
                }
                if (mmd.hasArray()) {
                    AbstractClassMetaData embcmd = mmd.getArray().getElementClassMetaData(clr, ec.getMetaDataManager());
                    Object[] array = new Object[Array.getLength(value)];
                    for (int i = 0; i < array.length; ++i) {
                        Object element = Array.get(value, i);
                        if (!element.getClass().getName().equals(embcmd.getFullClassName())) {
                            embcmd = ec.getMetaDataManager().getMetaDataForClass(element.getClass(), clr);
                        }
                        BasicDBObject embeddedObject = new BasicDBObject();
                        if (embcmd.hasDiscriminatorStrategy()) {
                            String discPropName = null;
                            discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : ec.getStoreManager().getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                            DiscriminatorMetaData discmd = embcmd.getDiscriminatorMetaData();
                            String discVal = null;
                            discVal = embcmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? embcmd.getFullClassName() : discmd.getValue();
                            embeddedObject.put(discPropName, (Object)discVal);
                        }
                        ObjectProvider embOP = ec.findObjectProviderForEmbedded(element, this.op, mmd);
                        embOP.setPcObjectType((short)2);
                        StoreFieldManager sfm = new StoreFieldManager(embOP, (DBObject)embeddedObject, this.insert);
                        sfm.ownerMmd = mmd;
                        embOP.provideFields(embcmd.getAllMemberPositions(), (FieldManager)sfm);
                        array[i] = embeddedObject;
                    }
                    this.dbObject.put(fieldName, (Object)array);
                    return;
                }
                AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, ec.getMetaDataManager());
                AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr, ec.getMetaDataManager());
                ArrayList<BasicDBObject> entryList = new ArrayList<BasicDBObject>();
                Map valueMap = (Map)value;
                for (Map.Entry entry : valueMap.entrySet()) {
                    StoreFieldManager sfm;
                    ObjectProvider embOP;
                    BasicDBObject entryObj = new BasicDBObject();
                    if (keyCmd == null) {
                        this.processContainerNonRelationField("key", ec, entry.getKey(), (DBObject)entryObj, mmd, 5);
                    } else {
                        embOP = ec.findObjectProviderForEmbedded(entry.getKey(), this.op, mmd);
                        embOP.setPcObjectType((short)3);
                        BasicDBObject embeddedKey = new BasicDBObject();
                        sfm = new StoreFieldManager(embOP, (DBObject)embeddedKey, this.insert);
                        sfm.ownerMmd = mmd;
                        embOP.provideFields(keyCmd.getAllMemberPositions(), (FieldManager)sfm);
                        entryObj.append("key", (Object)embeddedKey);
                    }
                    if (valCmd == null) {
                        this.processContainerNonRelationField("value", ec, entry.getValue(), (DBObject)entryObj, mmd, 6);
                    } else {
                        embOP = ec.findObjectProviderForEmbedded(entry.getValue(), this.op, mmd);
                        embOP.setPcObjectType((short)4);
                        BasicDBObject embeddedVal = new BasicDBObject();
                        sfm = new StoreFieldManager(embOP, (DBObject)embeddedVal, this.insert);
                        sfm.ownerMmd = mmd;
                        embOP.provideFields(valCmd.getAllMemberPositions(), (FieldManager)sfm);
                        entryObj.append("value", (Object)embeddedVal);
                    }
                    entryList.add(entryObj);
                }
                this.dbObject.put(fieldName, entryList);
                return;
            }
        }
        if (value == null) {
            if (this.dbObject.containsField(fieldName)) {
                this.dbObject.removeField(fieldName);
            }
            return;
        }
        if (mmd.isSerialized()) {
            byte[] bytes = MongoDBUtils.getStoredValueForJavaSerialisedField(mmd, value);
            this.dbObject.put(fieldName, (Object)bytes);
            this.op.wrapSCOField(fieldNumber, value, false, false, true);
        } else if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            this.processSingleRelationField(value, ec, fieldName);
        } else if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            this.processContainerRelationField(mmd, value, ec, fieldName);
            this.op.wrapSCOField(fieldNumber, value, false, false, true);
        } else {
            if (mmd.getTypeConverterName() != null) {
                TypeManager typeMgr = this.op.getExecutionContext().getNucleusContext().getTypeManager();
                TypeConverter conv = typeMgr.getTypeConverterForName(mmd.getTypeConverterName());
                this.dbObject.put(fieldName, conv.toDatastoreType(value));
            } else {
                this.processContainerNonRelationField(fieldName, ec, value, this.dbObject, mmd, 2);
            }
            this.op.wrapSCOField(fieldNumber, value, false, false, true);
        }
    }

    protected void processSingleRelationField(Object value, ExecutionContext ec, String fieldName) {
        Object valuePC = this.op.getExecutionContext().persistObjectInternal(value, null, -1, -1);
        Object valueId = ec.getApiAdapter().getIdForObject(valuePC);
        this.dbObject.put(fieldName, (Object)IdentityUtils.getPersistableIdentityForId((Object)valueId));
    }

    protected void processContainerRelationField(AbstractMemberMetaData mmd, Object value, ExecutionContext ec, String fieldName) {
        if (mmd.hasCollection()) {
            ArrayList<String> collIds = new ArrayList<String>();
            Collection coll = (Collection)value;
            Iterator collIter = coll.iterator();
            while (collIter.hasNext()) {
                if (mmd.getCollection().isSerializedElement()) {
                    throw new NucleusUserException("Don't currently support serialised collection elements at " + mmd.getFullFieldName() + " . Serialise the whole field");
                }
                Object element = collIter.next();
                if (element != null) {
                    Object elementPC = ec.persistObjectInternal(element, null, -1, -1);
                    Object elementID = ec.getApiAdapter().getIdForObject(elementPC);
                    collIds.add(IdentityUtils.getPersistableIdentityForId((Object)elementID));
                    continue;
                }
                collIds.add("NULL");
            }
            this.dbObject.put(fieldName, collIds);
        } else if (mmd.hasMap()) {
            HashSet<BasicDBObject> collEntries = new HashSet<BasicDBObject>();
            Map map = (Map)value;
            Iterator mapIter = map.entrySet().iterator();
            while (mapIter.hasNext()) {
                Object pc;
                if (mmd.getMap().isSerializedKey() || mmd.getMap().isSerializedValue()) {
                    throw new NucleusUserException("Don't currently support serialised map keys/values at " + mmd.getFullFieldName() + " . Serialise the whole field");
                }
                Map.Entry entry = mapIter.next();
                Object mapKey = entry.getKey();
                Object mapValue = entry.getValue();
                BasicDBObject entryObj = new BasicDBObject();
                if (ec.getApiAdapter().isPersistable(mapKey)) {
                    pc = ec.persistObjectInternal(mapKey, null, -1, -1);
                    Object keyID = ec.getApiAdapter().getIdForObject(pc);
                    entryObj.append("key", (Object)IdentityUtils.getPersistableIdentityForId((Object)keyID));
                } else {
                    this.processContainerNonRelationField("key", ec, mapKey, (DBObject)entryObj, mmd, 5);
                }
                if (ec.getApiAdapter().isPersistable(mapValue)) {
                    pc = ec.persistObjectInternal(mapValue, null, -1, -1);
                    Object valueID = ec.getApiAdapter().getIdForObject(pc);
                    entryObj.append("value", (Object)IdentityUtils.getPersistableIdentityForId((Object)valueID));
                } else {
                    this.processContainerNonRelationField("value", ec, mapValue, (DBObject)entryObj, mmd, 6);
                }
                collEntries.add(entryObj);
            }
            this.dbObject.put(fieldName, collEntries);
        } else if (mmd.hasArray()) {
            ArrayList<String> collIds = new ArrayList<String>();
            for (int i = 0; i < Array.getLength(value); ++i) {
                if (mmd.getArray().isSerializedElement()) {
                    throw new NucleusUserException("Don't currently support serialised array elements at " + mmd.getFullFieldName() + " . Serialise the whole field");
                }
                Object element = Array.get(value, i);
                if (element != null) {
                    Object elementPC = ec.persistObjectInternal(element, null, -1, -1);
                    Object elementID = ec.getApiAdapter().getIdForObject(elementPC);
                    collIds.add(IdentityUtils.getPersistableIdentityForId((Object)elementID));
                    continue;
                }
                collIds.add("NULL");
            }
            this.dbObject.put(fieldName, collIds);
        }
    }

    protected void processContainerNonRelationField(String fieldName, ExecutionContext ec, Object value, DBObject dbObject, AbstractMemberMetaData mmd, int fieldRole) {
        Object storeValue = MongoDBUtils.getStoredValueForField(ec, mmd, value, fieldRole);
        dbObject.put(fieldName, storeValue);
    }
}

