/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.bson.types.ObjectId;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.fieldmanager.FetchFieldManager;
import org.datanucleus.store.mongodb.query.LazyLoadQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.NucleusLogger;

public class MongoDBUtils {
    public static List<Long> performMongoCount(DB db, BasicDBObject filterObject, Class candidateClass, boolean subclasses, ExecutionContext ec) throws MongoException {
        StoreManager storeMgr = ec.getStoreManager();
        long count = 0L;
        for (AbstractClassMetaData cmd : MetaDataUtils.getMetaDataForCandidates((Class)candidateClass, (boolean)subclasses, (ExecutionContext)ec)) {
            String collectionName = storeMgr.getNamingFactory().getTableName(cmd);
            count += db.getCollection(collectionName).count((DBObject)filterObject);
        }
        LinkedList<Long> results = new LinkedList<Long>();
        results.add(count);
        if (ec.getStatistics() != null) {
            ec.getStatistics().incrementNumReads();
        }
        return results;
    }

    public static String getDefaultValueForMember(AbstractMemberMetaData mmd) {
        ColumnMetaData[] colmds = mmd.getColumnMetaData();
        if (colmds == null || colmds.length < 1) {
            return null;
        }
        return colmds[0].getDefaultValue();
    }

    public static String getFieldName(AbstractMemberMetaData mmd, int fieldNumber) {
        String columnName = null;
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData embMmd = null;
        if (embmd != null) {
            AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
            embMmd = embmmds[fieldNumber];
        }
        if (embMmd != null) {
            ColumnMetaData[] colmds = embMmd.getColumnMetaData();
            if (colmds != null && colmds.length > 0) {
                columnName = colmds[0].getName();
            }
            if (columnName == null) {
                columnName = embMmd.getName();
            }
            if (columnName == null) {
                columnName = embMmd.getName();
            }
        }
        return columnName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassNameForIdentity(Object id, AbstractClassMetaData rootCmd, ExecutionContext ec, ClassLoaderResolver clr) {
        HashMap classNamesByDbCollectionName = new HashMap();
        StoreManager storeMgr = ec.getStoreManager();
        HashSet<String> rootClassNames = new HashSet<String>();
        rootClassNames.add(rootCmd.getFullClassName());
        classNamesByDbCollectionName.put(storeMgr.getNamingFactory().getTableName(rootCmd), rootClassNames);
        String[] subclassNames = ec.getMetaDataManager().getSubclassesForClass(rootCmd.getFullClassName(), true);
        if (subclassNames != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(subclassNames[i], clr);
                String collName = storeMgr.getNamingFactory().getTableName(cmd);
                HashSet<String> classNames = (HashSet<String>)classNamesByDbCollectionName.get(collName);
                if (classNames == null) {
                    classNames = new HashSet<String>();
                    classNamesByDbCollectionName.put(collName, classNames);
                }
                classNames.add(cmd.getFullClassName());
            }
        }
        ManagedConnection mconn = storeMgr.getConnection(ec);
        try {
            DB db = (DB)mconn.getConnection();
            for (Map.Entry dbCollEntry : classNamesByDbCollectionName.entrySet()) {
                String pkPropName;
                AbstractMemberMetaData pkMmd;
                Object key;
                String dbCollName = (String)dbCollEntry.getKey();
                Set classNames = (Set)dbCollEntry.getValue();
                DBCollection dbColl = db.getCollection(dbCollName);
                BasicDBObject query = new BasicDBObject();
                if (id instanceof OID) {
                    key = ((OID)id).getKeyValue();
                    if (storeMgr.isStrategyDatastoreAttributed(rootCmd, -1)) {
                        query.put("_id", (Object)new ObjectId((String)key));
                    } else {
                        query.put(storeMgr.getNamingFactory().getColumnName(rootCmd, ColumnType.DATASTOREID_COLUMN), key);
                    }
                } else if (ec.getApiAdapter().isSingleFieldIdentity(id)) {
                    key = ec.getApiAdapter().getTargetKeyForSingleFieldIdentity(id);
                    int[] pkNums = rootCmd.getPKMemberPositions();
                    pkMmd = rootCmd.getMetaDataForManagedMemberAtAbsolutePosition(pkNums[0]);
                    pkPropName = storeMgr.getNamingFactory().getColumnName(pkMmd, ColumnType.COLUMN);
                    query.put(pkPropName, key);
                } else {
                    int[] pkNums = rootCmd.getPKMemberPositions();
                    for (int i = 0; i < pkNums.length; ++i) {
                        pkMmd = rootCmd.getMetaDataForManagedMemberAtAbsolutePosition(pkNums[i]);
                        pkPropName = storeMgr.getNamingFactory().getColumnName(pkMmd, ColumnType.COLUMN);
                        Object pkVal = IdentityUtils.getValueForMemberInId((Object)id, (AbstractMemberMetaData)pkMmd);
                        query.put(pkPropName, pkVal);
                    }
                }
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving object for " + query + " from DBCollection with name " + dbCollName));
                }
                DBObject foundObj = dbColl.findOne((DBObject)query);
                if (ec.getStatistics() != null) {
                    ec.getStatistics().incrementNumReads();
                }
                if (foundObj == null) continue;
                if (classNames.size() == 1) {
                    String i = (String)classNames.iterator().next();
                    return i;
                }
                if (rootCmd.hasDiscriminatorStrategy()) {
                    String disPropName = storeMgr.getNamingFactory().getColumnName(rootCmd, ColumnType.DISCRIMINATOR_COLUMN);
                    String discValue = (String)foundObj.get(disPropName);
                    String string = ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discValue, rootCmd.getDiscriminatorMetaData());
                    return string;
                }
                String string = rootCmd.getFullClassName();
                return string;
            }
        }
        finally {
            mconn.release();
        }
        return null;
    }

    public static DBObject getObjectForObjectProvider(DBCollection dbCollection, ObjectProvider op, boolean checkVersion, boolean originalValue) {
        BasicDBObject query = new BasicDBObject();
        AbstractClassMetaData cmd = op.getClassMetaData();
        StoreManager storeMgr = op.getExecutionContext().getStoreManager();
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkPositions = cmd.getPKMemberPositions();
            for (int i = 0; i < pkPositions.length; ++i) {
                AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkPositions[i]);
                Object value = op.provideField(pkPositions[i]);
                if (value == null && storeMgr.isStrategyDatastoreAttributed(cmd, pkPositions[i])) {
                    return null;
                }
                if (storeMgr.isStrategyDatastoreAttributed(cmd, pkPositions[i])) {
                    query.put("_id", (Object)new ObjectId((String)value));
                    continue;
                }
                Object storeValue = MongoDBUtils.getStoredValueForField(op.getExecutionContext(), pkMmd, value, 2);
                query.put(storeMgr.getNamingFactory().getColumnName(pkMmd, ColumnType.COLUMN), storeValue);
            }
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            OID oid = (OID)op.getInternalObjectId();
            if (oid == null && storeMgr.isStrategyDatastoreAttributed(cmd, -1)) {
                return null;
            }
            Object value = oid.getKeyValue();
            if (storeMgr.isStrategyDatastoreAttributed(cmd, -1)) {
                query.put("_id", (Object)new ObjectId((String)value));
            } else {
                query.put(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN), value);
            }
        } else {
            int[] fieldNumbers = cmd.getAllMemberPositions();
            for (int i = 0; i < fieldNumbers.length; ++i) {
                Object oldValue;
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                RelationType relationType = mmd.getRelationType(op.getExecutionContext().getClassLoaderResolver());
                if (relationType != RelationType.NONE) continue;
                Object fieldValue = null;
                fieldValue = originalValue ? ((oldValue = op.getAssociatedValue((Object)("FIELD_VALUE.ORIGINAL." + fieldNumbers[i]))) != null ? oldValue : op.provideField(fieldNumbers[i])) : op.provideField(fieldNumbers[i]);
                Object storeValue = MongoDBUtils.getStoredValueForField(op.getExecutionContext(), mmd, fieldValue, 2);
                query.put(storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN), storeValue);
            }
        }
        if (cmd.hasDiscriminatorStrategy()) {
            query.put(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN), cmd.getDiscriminatorValue());
        }
        if (checkVersion && cmd.isVersioned()) {
            Object currentVersion = op.getTransactionalVersion();
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                String fieldName = storeMgr.getNamingFactory().getColumnName(verMmd, ColumnType.COLUMN);
                query.put(fieldName, currentVersion);
            } else {
                String fieldName = storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN);
                query.put(fieldName, currentVersion);
            }
        }
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Retrieving object for " + query));
        }
        DBObject dbObj = dbCollection.findOne((DBObject)query);
        if (op.getExecutionContext().getStatistics() != null) {
            op.getExecutionContext().getStatistics().incrementNumReads();
        }
        return dbObj;
    }

    public static List getObjectsOfCandidateType(Query q, DB db, BasicDBObject filterObject, Map<String, Object> options) {
        return MongoDBUtils.getObjectsOfCandidateType(q, db, filterObject, null, options, null, null);
    }

    public static List getObjectsOfCandidateType(Query q, DB db, BasicDBObject filterObject, BasicDBObject orderingObject, Map<String, Object> options, Integer skip, Integer limit) {
        ArrayList<AbstractClassMetaData> cmdsForCollection;
        String collectionName;
        LazyLoadQueryResult qr = new LazyLoadQueryResult(q);
        ExecutionContext ec = q.getExecutionContext();
        StoreManager storeMgr = ec.getStoreManager();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        List cmds = MetaDataUtils.getMetaDataForCandidates((Class)q.getCandidateClass(), (boolean)q.isSubclasses(), (ExecutionContext)ec);
        HashMap<String, ArrayList<AbstractClassMetaData>> classesByCollectionName = new HashMap<String, ArrayList<AbstractClassMetaData>>();
        for (AbstractClassMetaData cmd : cmds) {
            if (cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract()) continue;
            collectionName = storeMgr.getNamingFactory().getTableName(cmd);
            cmdsForCollection = (ArrayList<AbstractClassMetaData>)classesByCollectionName.get(collectionName);
            if (cmdsForCollection == null) {
                cmdsForCollection = new ArrayList<AbstractClassMetaData>();
                classesByCollectionName.put(collectionName, cmdsForCollection);
            }
            cmdsForCollection.add(cmd);
        }
        for (Map.Entry entry : classesByCollectionName.entrySet()) {
            Boolean val;
            collectionName = (String)entry.getKey();
            cmdsForCollection = (List)entry.getValue();
            AbstractClassMetaData rootCmd = (AbstractClassMetaData)cmdsForCollection.get(0);
            int[] fpMembers = q.getFetchPlan().getFetchPlanForClass(rootCmd).getMemberNumbers();
            BasicDBObject fieldsSelection = new BasicDBObject();
            if (fpMembers != null && fpMembers.length > 0) {
                fieldsSelection = new BasicDBObject();
                for (int i = 0; i < fpMembers.length; ++i) {
                    AbstractMemberMetaData mmd = rootCmd.getMetaDataForManagedMemberAtAbsolutePosition(fpMembers[i]);
                    RelationType relationType = mmd.getRelationType(clr);
                    if (mmd.isEmbedded() && RelationType.isRelationSingleValued((RelationType)relationType)) {
                        boolean nested = true;
                        String nestedStr = mmd.getValueForExtension("nested");
                        if (nestedStr != null && nestedStr.equalsIgnoreCase("false")) {
                            nested = false;
                        }
                        if (nested) {
                            String fieldName = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
                            fieldsSelection.append(fieldName, (Object)1);
                            continue;
                        }
                        MongoDBUtils.selectAllFieldsOfEmbeddedObject(mmd, fieldsSelection, ec, clr);
                        continue;
                    }
                    String fieldName = storeMgr.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
                    fieldsSelection.append(fieldName, (Object)1);
                }
            }
            if (rootCmd.getIdentityType() == IdentityType.DATASTORE) {
                fieldsSelection.append(storeMgr.getNamingFactory().getColumnName(rootCmd, ColumnType.DATASTOREID_COLUMN), (Object)1);
            }
            if (rootCmd.isVersioned()) {
                VersionMetaData vermd = rootCmd.getVersionMetaDataForClass();
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = rootCmd.getMetaDataForMember(vermd.getFieldName());
                    String fieldName = storeMgr.getNamingFactory().getColumnName(verMmd, ColumnType.COLUMN);
                    fieldsSelection.append(fieldName, (Object)1);
                } else {
                    fieldsSelection.append(storeMgr.getNamingFactory().getColumnName(rootCmd, ColumnType.VERSION_COLUMN), (Object)1);
                }
            }
            if (rootCmd.hasDiscriminatorStrategy()) {
                fieldsSelection.append(storeMgr.getNamingFactory().getColumnName(rootCmd, ColumnType.DISCRIMINATOR_COLUMN), (Object)1);
            }
            BasicDBObject query = new BasicDBObject();
            if (filterObject != null) {
                for (Map.Entry filterEntry : filterObject.entrySet()) {
                    query.put((String)filterEntry.getKey(), filterEntry.getValue());
                }
            }
            if (rootCmd.hasDiscriminatorStrategy() && cmdsForCollection.size() == 1) {
                query.put(storeMgr.getNamingFactory().getColumnName(rootCmd, ColumnType.DISCRIMINATOR_COLUMN), rootCmd.getDiscriminatorValue());
            }
            if (storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(rootCmd.getValueForExtension("multitenancy-disable"))) {
                String fieldName = storeMgr.getNamingFactory().getColumnName(rootCmd, ColumnType.MULTITENANCY_COLUMN);
                String value = storeMgr.getStringProperty("datanucleus.TenantID");
                query.put(fieldName, (Object)value);
            }
            DBCollection dbColl = db.getCollection(collectionName);
            Boolean bl = val = options != null ? options.get("slave-ok") : Boolean.FALSE;
            if (val == Boolean.TRUE) {
                dbColl.setReadPreference(ReadPreference.secondaryPreferred());
            }
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("Performing find() using query on collection " + collectionName + " for fields=" + fieldsSelection + " with filter=" + query + " and ordering=" + orderingObject));
            }
            DBCursor curs = dbColl.find((DBObject)query, (DBObject)fieldsSelection);
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumReads();
            }
            if (classesByCollectionName.size() == 1) {
                if (orderingObject != null) {
                    curs = curs.sort((DBObject)orderingObject);
                    qr.setOrderProcessed(true);
                }
                if (skip != null && skip > 0) {
                    curs = curs.skip(skip.intValue());
                    qr.setRangeProcessed(true);
                }
                if (limit != null && limit > 0) {
                    curs = curs.limit(limit.intValue());
                    qr.setRangeProcessed(true);
                }
            }
            if (!curs.hasNext()) continue;
            qr.addCandidateResult(rootCmd, curs, fpMembers);
        }
        return qr;
    }

    public static Object getPojoForDBObjectForCandidate(DBObject dbObject, ExecutionContext ec, AbstractClassMetaData cmd, int[] fpMembers, boolean ignoreCache) {
        if (cmd.hasDiscriminatorStrategy()) {
            String disPropName = ec.getStoreManager().getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN);
            String discValue = (String)dbObject.get(disPropName);
            String clsName = ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discValue, cmd.getDiscriminatorMetaData());
            if (!cmd.getFullClassName().equals(clsName) && clsName != null) {
                cmd = ec.getMetaDataManager().getMetaDataForClass(clsName, ec.getClassLoaderResolver());
            }
        }
        Object pojo = null;
        pojo = cmd.getIdentityType() == IdentityType.APPLICATION ? MongoDBUtils.getObjectUsingApplicationIdForDBObject(dbObject, cmd, ec, ignoreCache, fpMembers) : (cmd.getIdentityType() == IdentityType.DATASTORE ? MongoDBUtils.getObjectUsingDatastoreIdForDBObject(dbObject, cmd, ec, ignoreCache, fpMembers) : MongoDBUtils.getObjectUsingNondurableIdForDBObject(dbObject, cmd, ec, ignoreCache, fpMembers));
        return pojo;
    }

    protected static void selectAllFieldsOfEmbeddedObject(AbstractMemberMetaData mmd, BasicDBObject fieldsSelection, ExecutionContext ec, ClassLoaderResolver clr) {
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
        for (int i = 0; i < embmmds.length; ++i) {
            RelationType relationType = embmmds[i].getRelationType(clr);
            if (embmmds[i].isEmbedded() && RelationType.isRelationSingleValued((RelationType)relationType)) {
                MongoDBUtils.selectAllFieldsOfEmbeddedObject(embmmds[i], fieldsSelection, ec, clr);
                continue;
            }
            String embFieldName = MongoDBUtils.getFieldName(mmd, i);
            fieldsSelection.append(embFieldName, (Object)1);
        }
    }

    public static Object getObjectUsingApplicationIdForDBObject(DBObject dbObject, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        final FetchFieldManager fm = new FetchFieldManager(ec, dbObject, cmd);
        Object id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)false, (FieldManager)fm);
        StoreManager storeMgr = ec.getStoreManager();
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject(id, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, (FieldManager)fm);
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, (FieldManager)fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        if (cmd.isVersioned()) {
            ObjectProvider sm = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = sm.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = dbObject.get(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN));
            }
            sm.setVersion(version);
        }
        return pc;
    }

    public static Object getObjectUsingDatastoreIdForDBObject(DBObject dbObject, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        Object idKey = null;
        StoreManager storeMgr = ec.getStoreManager();
        if (storeMgr.isStrategyDatastoreAttributed(cmd, -1)) {
            idKey = dbObject.get("_id");
            if (idKey instanceof ObjectId) {
                idKey = ((ObjectId)idKey).toString();
            }
        } else {
            idKey = dbObject.get(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN));
        }
        final FetchFieldManager fm = new FetchFieldManager(ec, dbObject, cmd);
        OID oid = OIDFactory.getInstance((PersistenceNucleusContext)ec.getNucleusContext(), (String)cmd.getFullClassName(), (Object)idKey);
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject((Object)oid, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, (FieldManager)fm);
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, (FieldManager)fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        if (cmd.isVersioned()) {
            ObjectProvider sm = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = sm.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = dbObject.get(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN));
            }
            sm.setVersion(version);
        }
        return pc;
    }

    public static Object getObjectUsingNondurableIdForDBObject(DBObject dbObject, AbstractClassMetaData cmd, ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        SCOID oid = new SCOID(cmd.getFullClassName());
        final FetchFieldManager fm = new FetchFieldManager(ec, dbObject, cmd);
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject((Object)oid, new FieldValues(){

            public void fetchFields(ObjectProvider op) {
                op.replaceFields(fpMembers, (FieldManager)fm);
            }

            public void fetchNonLoadedFields(ObjectProvider op) {
                op.replaceNonLoadedFields(fpMembers, (FieldManager)fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache, false);
        if (cmd.isVersioned()) {
            ObjectProvider sm = ec.findObjectProvider(pc);
            StoreManager storeMgr = ec.getStoreManager();
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = sm.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = dbObject.get(storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN));
            }
            sm.setVersion(version);
        }
        return pc;
    }

    public static Object getStoredValueForField(ExecutionContext ec, AbstractMemberMetaData mmd, Object value, int fieldRole) {
        if (value == null) {
            return null;
        }
        Class type = value.getClass();
        if (mmd != null) {
            type = fieldRole == 3 ? ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType()) : (fieldRole == 4 ? ec.getClassLoaderResolver().classForName(mmd.getArray().getElementType()) : (fieldRole == 5 ? ec.getClassLoaderResolver().classForName(mmd.getMap().getKeyType()) : (fieldRole == 6 ? ec.getClassLoaderResolver().classForName(mmd.getMap().getValueType()) : mmd.getType())));
        }
        if (mmd != null && mmd.hasCollection() && fieldRole == 2) {
            ArrayList<Object> coll = new ArrayList<Object>();
            Collection rawColl = (Collection)value;
            for (Object elem : rawColl) {
                Object storeElem = MongoDBUtils.getStoredValueForField(ec, mmd, elem, 3);
                coll.add(storeElem);
            }
            return coll;
        }
        if (mmd != null && mmd.hasArray() && fieldRole == 2) {
            Object[] array = new Object[Array.getLength(value)];
            for (int i = 0; i < array.length; ++i) {
                Object storeElem;
                Object elem = Array.get(value, i);
                array[i] = storeElem = MongoDBUtils.getStoredValueForField(ec, mmd, elem, 4);
            }
            return array;
        }
        if (Long.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || String.class.isAssignableFrom(type) || Byte.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type)) {
            return value;
        }
        if (Enum.class.isAssignableFrom(type)) {
            boolean useNumeric;
            ColumnMetaData colmd = null;
            if (mmd != null && mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                colmd = mmd.getColumnMetaData()[0];
            }
            return (useNumeric = MetaDataUtils.persistColumnAsNumeric(colmd)) ? Integer.valueOf(((Enum)value).ordinal()) : ((Enum)value).name();
        }
        if (!Time.class.isAssignableFrom(type) && !Date.class.isAssignableFrom(type)) {
            if (java.util.Date.class.isAssignableFrom(type)) {
                return value;
            }
            if (Calendar.class.isAssignableFrom(type)) {
                ColumnMetaData colmd = null;
                if (mmd != null && mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                    colmd = mmd.getColumnMetaData()[0];
                }
                if (!MetaDataUtils.persistColumnAsString(colmd)) {
                    return ((Calendar)value).getTime();
                }
            } else {
                if (Character.class.isAssignableFrom(type)) {
                    return "" + value;
                }
                if (Character.TYPE.isAssignableFrom(type)) {
                    return "" + value;
                }
                if (BufferedImage.class.isAssignableFrom(type)) {
                    byte[] bytes = null;
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
                        ImageIO.write((RenderedImage)((BufferedImage)value), "jpg", baos);
                        bytes = baos.toByteArray();
                        baos.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return bytes;
                }
            }
        }
        TypeConverter strConv = ec.getTypeManager().getTypeConverterForType(type, String.class);
        TypeConverter longConv = ec.getTypeManager().getTypeConverterForType(type, Long.class);
        if (strConv != null) {
            return strConv.toDatastoreType(value);
        }
        if (longConv != null) {
            return longConv.toDatastoreType(value);
        }
        return value;
    }

    public static Object getFieldValueFromStored(ExecutionContext ec, AbstractMemberMetaData mmd, Object value, int fieldRole) {
        if (value == null) {
            return null;
        }
        Class type = value.getClass();
        if (mmd != null) {
            type = fieldRole == 3 ? ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType()) : (fieldRole == 4 ? ec.getClassLoaderResolver().classForName(mmd.getArray().getElementType()) : (fieldRole == 5 ? ec.getClassLoaderResolver().classForName(mmd.getMap().getKeyType()) : (fieldRole == 6 ? ec.getClassLoaderResolver().classForName(mmd.getMap().getValueType()) : mmd.getType())));
        }
        if (mmd != null && mmd.hasCollection() && fieldRole == 2) {
            Collection coll;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                coll = (Collection)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            Collection rawColl = (Collection)value;
            for (Object elem : rawColl) {
                Object storeElem = MongoDBUtils.getFieldValueFromStored(ec, mmd, elem, 3);
                coll.add(storeElem);
            }
            return coll;
        }
        if (mmd != null && mmd.hasArray() && fieldRole == 2) {
            Collection rawColl = (Collection)value;
            Object array = Array.newInstance(mmd.getType().getComponentType(), rawColl.size());
            int i = 0;
            for (Object elem : rawColl) {
                Object storeElem = MongoDBUtils.getFieldValueFromStored(ec, mmd, elem, 4);
                Array.set(array, i++, storeElem);
            }
            return array;
        }
        if (Character.class.isAssignableFrom(type)) {
            if (value instanceof Character) {
                return value;
            }
            return Character.valueOf(((String)value).charAt(0));
        }
        if (Short.class.isAssignableFrom(type)) {
            if (value instanceof Short) {
                return value;
            }
            return ((Number)value).shortValue();
        }
        if (Integer.class.isAssignableFrom(type)) {
            if (value instanceof Integer) {
                return value;
            }
            return ((Number)value).intValue();
        }
        if (Long.class.isAssignableFrom(type)) {
            if (value instanceof Long) {
                return value;
            }
            return ((Number)value).longValue();
        }
        if (Float.class.isAssignableFrom(type)) {
            if (value instanceof Float) {
                return value;
            }
            return Float.valueOf(((Number)value).floatValue());
        }
        if (Double.class.isAssignableFrom(type)) {
            if (value instanceof Double) {
                return value;
            }
            return ((Number)value).doubleValue();
        }
        if (Byte.class.isAssignableFrom(type)) {
            if (value instanceof Byte) {
                return value;
            }
            return ((Number)value).byteValue();
        }
        if (Enum.class.isAssignableFrom(type)) {
            ColumnMetaData colmd = null;
            if (mmd != null && mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                colmd = mmd.getColumnMetaData()[0];
            }
            if (MetaDataUtils.persistColumnAsNumeric(colmd)) {
                return type.getEnumConstants()[((Number)value).intValue()];
            }
            return Enum.valueOf(type, (String)value);
        }
        if (Date.class.isAssignableFrom(type) && value instanceof java.util.Date) {
            Date sqlDate = null;
            sqlDate = value instanceof Date ? (Date)value : new Date(((java.util.Date)value).getTime());
            return sqlDate;
        }
        if (Time.class.isAssignableFrom(type) && value instanceof java.util.Date) {
            Time sqlTime = null;
            sqlTime = value instanceof Time ? (Time)value : new Time(((java.util.Date)value).getTime());
            return sqlTime;
        }
        if (Timestamp.class.isAssignableFrom(type) && value instanceof java.util.Date) {
            Timestamp sqlTs = null;
            sqlTs = value instanceof Timestamp ? (Timestamp)value : new Timestamp(((java.util.Date)value).getTime());
            return sqlTs;
        }
        if (java.util.Date.class.isAssignableFrom(type) && value instanceof java.util.Date) {
            return value;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            ColumnMetaData colmd = null;
            if (mmd != null && mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                colmd = mmd.getColumnMetaData()[0];
            }
            if (!MetaDataUtils.persistColumnAsString(colmd)) {
                Calendar cal = Calendar.getInstance();
                cal.setTime((java.util.Date)value);
                return cal;
            }
        } else if (BufferedImage.class.isAssignableFrom(type)) {
            BufferedImage returnValue = null;
            try {
                returnValue = ImageIO.read(new ByteArrayInputStream((byte[])value));
            }
            catch (IOException e) {
                // empty catch block
            }
            return returnValue;
        }
        TypeConverter strConv = ec.getTypeManager().getTypeConverterForType(type, String.class);
        TypeConverter longConv = ec.getTypeManager().getTypeConverterForType(type, Long.class);
        if (strConv != null) {
            String strValue = (String)value;
            return strConv.toMemberType((Object)strValue);
        }
        if (longConv != null) {
            Long longValue = (Long)value;
            return longConv.toMemberType((Object)longValue);
        }
        return value;
    }

    public static byte[] getStoredValueForJavaSerialisedField(AbstractMemberMetaData mmd, Object value) {
        byte[] storeValue = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            storeValue = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (IOException e) {
            throw new NucleusException("Exception thrown serialising value for field " + mmd.getFullFieldName(), (Throwable)e);
        }
        return storeValue;
    }

    public static Object getFieldValueForJavaSerialisedField(AbstractMemberMetaData mmd, Object value) {
        Object returnValue = null;
        try {
            if (value != null) {
                byte[] bytes = (byte[])value;
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                returnValue = ois.readObject();
                ois.close();
                bis.close();
            }
        }
        catch (Exception e) {
            throw new NucleusUserException("Exception thrown deserialising field at " + mmd.getFullFieldName(), (Throwable)e);
        }
        return returnValue;
    }
}

