/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.query.evaluator.JPQLEvaluator;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.query.LazyLoadQueryResult;
import org.datanucleus.store.mongodb.query.MongoDBQueryCompilation;
import org.datanucleus.store.mongodb.query.MongoDBResult;
import org.datanucleus.store.mongodb.query.QueryToMongoDBMapper;
import org.datanucleus.store.mongodb.query.expression.MongoBooleanExpression;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.AbstractQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.util.NucleusLogger;

public class JPQLQuery
extends AbstractJPQLQuery {
    protected transient MongoDBQueryCompilation datastoreCompilation = null;

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (JPQLQuery)null);
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, JPQLQuery q) {
        super(storeMgr, ec, (AbstractJPQLQuery)q);
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec, query);
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.datastoreCompilation = null;
    }

    protected boolean isCompiled() {
        if (this.evaluateInMemory()) {
            return this.compilation != null;
        }
        if (this.compilation == null || this.datastoreCompilation == null) {
            return false;
        }
        if (!this.datastoreCompilation.isPrecompilable()) {
            NucleusLogger.GENERAL.info((Object)"Query compiled but not precompilable so ditching datastore compilation");
            this.datastoreCompilation = null;
            return false;
        }
        return true;
    }

    protected boolean evaluateInMemory() {
        if (this.candidateCollection != null) {
            if (this.compilation != null && this.compilation.getSubqueryAliases() != null) {
                NucleusLogger.QUERY.warn((Object)"In-memory evaluator doesn't currently handle subqueries completely so evaluating in datastore");
                return false;
            }
            Object val = this.getExtension("datanucleus.query.evaluateInMemory");
            if (val == null) {
                return true;
            }
            return Boolean.valueOf((String)val);
        }
        return super.evaluateInMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void compileInternal(Map parameterValues) {
        if (this.isCompiled()) {
            return;
        }
        super.compileInternal(parameterValues);
        boolean inMemory = this.evaluateInMemory();
        if (this.candidateCollection != null && inMemory) {
            return;
        }
        if (this.candidateClass == null || this.candidateClassName == null) {
            this.candidateClass = this.compilation.getCandidateClass();
            this.candidateClassName = this.candidateClass.getName();
        }
        this.ec.hasPersistenceInformationForClass(this.candidateClass);
        QueryManager qm = this.getQueryManager();
        String datastoreKey = this.getStoreManager().getQueryCacheKey();
        String cacheKey = this.getQueryCacheKey();
        if (this.useCaching()) {
            this.datastoreCompilation = (MongoDBQueryCompilation)qm.getDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey);
            if (this.datastoreCompilation != null) {
                this.setResultDistinct(this.compilation.getResultDistinct());
                return;
            }
        }
        this.datastoreCompilation = new MongoDBQueryCompilation();
        AbstractClassMetaData cmd = this.getCandidateClassMetaData();
        MongoDBQueryCompilation mongoDBQueryCompilation = this.datastoreCompilation;
        synchronized (mongoDBQueryCompilation) {
            if (!inMemory) {
                this.compileQueryFull(parameterValues, cmd);
            }
        }
        if (cacheKey != null && this.datastoreCompilation.isPrecompilable()) {
            qm.addDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey, (Object)this.datastoreCompilation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        ManagedConnection mconn = this.getStoreManager().getConnection(this.ec);
        try {
            Object resultMapper;
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JPQL", (Object)this.getSingleStringQuery(), null));
            }
            boolean filterInMemory = true;
            boolean orderInMemory = this.ordering != null;
            boolean rangeInMemory = this.range != null;
            List candidates = null;
            if (this.candidateCollection != null) {
                candidates = new ArrayList(this.candidateCollection);
            } else if (this.evaluateInMemory()) {
                candidates = MongoDBUtils.getObjectsOfCandidateType((Query)this, db, null, null);
            } else {
                MongoDBResult resultObject;
                BasicDBObject filterObject = null;
                MongoBooleanExpression filterExpr = this.datastoreCompilation.getFilterExpression();
                if (filterExpr != null) {
                    filterObject = filterExpr.getDBObject();
                }
                if ((resultObject = this.datastoreCompilation.getResult()) != null && resultObject.isCountOnly() && this.datastoreCompilation.isFilterComplete() && this.grouping == null) {
                    List<Long> list = MongoDBUtils.performMongoCount(db, filterObject, this.candidateClass, this.subclasses, this.ec);
                    return list;
                }
                HashMap<String, Object> options = new HashMap<String, Object>();
                if (this.getBooleanExtensionProperty("slave-ok", false)) {
                    options.put("slave-ok", true);
                }
                if (this.filter == null || this.datastoreCompilation.isFilterComplete()) {
                    filterInMemory = false;
                }
                if (filterInMemory || this.result != null || this.resultClass != null) {
                    candidates = MongoDBUtils.getObjectsOfCandidateType((Query)this, db, filterObject, options);
                } else {
                    BasicDBObject orderingObject = this.datastoreCompilation.getOrdering();
                    candidates = MongoDBUtils.getObjectsOfCandidateType((Query)this, db, filterObject, orderingObject, options, (int)this.fromInclNo, (int)(this.toExclNo - this.fromInclNo));
                    if (orderInMemory && ((LazyLoadQueryResult)((Object)candidates)).getOrderProcessed()) {
                        orderInMemory = false;
                    }
                    if (rangeInMemory && ((LazyLoadQueryResult)((Object)candidates)).getRangeProcessed()) {
                        rangeInMemory = false;
                    }
                }
            }
            Collection results = candidates;
            if (filterInMemory || this.result != null || this.resultClass != null || rangeInMemory || orderInMemory) {
                if (results instanceof QueryResult) {
                    ((QueryResult)results).disconnect();
                }
                resultMapper = new JPQLEvaluator((Query)this, candidates, this.compilation, parameters, this.ec.getClassLoaderResolver());
                results = resultMapper.execute(filterInMemory, orderInMemory, this.result != null, this.resultClass != null, rangeInMemory);
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)"JPQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            if (this.type == 2) {
                if (results instanceof QueryResult) {
                    ((QueryResult)results).disconnect();
                }
                this.ec.deleteObjects(results.toArray());
                resultMapper = Long.valueOf(results.size());
                return resultMapper;
            }
            if (this.type == 1) {
                throw new NucleusException("Bulk Update is not yet supported");
            }
            if (results instanceof QueryResult) {
                final QueryResult qr1 = (QueryResult)results;
                final ManagedConnection mconn1 = mconn;
                ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener(){

                    public void transactionFlushed() {
                    }

                    public void transactionPreClose() {
                        qr1.disconnect();
                    }

                    public void managedConnectionPreClose() {
                        if (!JPQLQuery.this.ec.getTransaction().isActive()) {
                            qr1.disconnect();
                        }
                    }

                    public void managedConnectionPostClose() {
                    }

                    public void resourcePostClose() {
                        mconn1.removeListener((ManagedConnectionResourceListener)this);
                    }
                };
                mconn.addListener(listener);
                if (qr1 instanceof AbstractQueryResult) {
                    ((AbstractQueryResult)qr1).addConnectionListener(listener);
                }
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        finally {
            mconn.release();
        }
    }

    private void compileQueryFull(Map parameters, AbstractClassMetaData candidateCmd) {
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021083", (Object)this.getLanguage(), (Object)this.toString()));
        }
        QueryToMongoDBMapper mapper = new QueryToMongoDBMapper(this.compilation, parameters, candidateCmd, this.ec, (Query)this);
        mapper.compile();
        this.datastoreCompilation.setFilterComplete(mapper.isFilterComplete());
        this.datastoreCompilation.setFilterExpression(mapper.getFilterExpression());
        this.datastoreCompilation.setResultComplete(mapper.isResultComplete());
        this.datastoreCompilation.setResult(mapper.getResultObject());
        this.datastoreCompilation.setPrecompilable(mapper.isPrecompilable());
        if (this.candidateCollection != null) {
            // empty if block
        }
        if (this.range != null) {
            // empty if block
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021084", (Object)this.getLanguage(), (Object)(System.currentTimeMillis() - startTime)));
        }
    }
}

