/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.VersionHelper;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBStoreManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.FetchFieldManager;
import org.datanucleus.store.mongodb.fieldmanager.StoreFieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class MongoDBPersistenceHandler
extends AbstractPersistenceHandler {
    protected static final Localiser LOCALISER_MONGODB = Localiser.getInstance((String)"org.datanucleus.store.mongodb.Localisation", (ClassLoader)MongoDBStoreManager.class.getClassLoader());
    public static final String OP_DB_OBJECT = "DB_OBJECT";

    public MongoDBPersistenceHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void close() {
    }

    public void insertObjects(ObjectProvider ... ops) {
        Set<Object> opsForTable;
        String tableName;
        int i;
        ArrayList<ObjectProvider> insertOps = new ArrayList<ObjectProvider>();
        for (i = 0; i < ops.length; ++i) {
            insertOps.add(ops[i]);
        }
        if (ops.length == 1) {
            this.insertObject(ops[0]);
            return;
        }
        for (i = 0; i < ops.length; ++i) {
            AbstractClassMetaData cmd = ops[i].getClassMetaData();
            if (!cmd.pkIsDatastoreAttributed(this.storeMgr)) continue;
            this.insertObject(ops[i]);
        }
        HashMap<String, HashSet<ObjectProvider>> opsByTable = new HashMap<String, HashSet<ObjectProvider>>();
        for (int i2 = 0; i2 < ops.length; ++i2) {
            AbstractClassMetaData cmd = ops[i2].getClassMetaData();
            if (cmd.pkIsDatastoreAttributed(this.storeMgr)) continue;
            tableName = this.storeMgr.getNamingFactory().getTableName(cmd);
            opsForTable = (Set)opsByTable.get(tableName);
            if (opsForTable == null) {
                opsForTable = new HashSet<ObjectProvider>();
                opsByTable.put(tableName, (HashSet<ObjectProvider>)opsForTable);
            }
            opsForTable.add(ops[i2]);
        }
        for (Map.Entry opsEntry : opsByTable.entrySet()) {
            tableName = (String)opsEntry.getKey();
            opsForTable = (HashSet<ObjectProvider>)opsEntry.getValue();
            ExecutionContext ec = ops[0].getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                DB db = (DB)mconn.getConnection();
                long startTime = System.currentTimeMillis();
                DBCollection collection = db.getCollection(tableName);
                Object[] dbObjects = new DBObject[opsForTable.size()];
                int i3 = 0;
                for (ObjectProvider op : opsForTable) {
                    this.assertReadOnlyForUpdateOfObject(op);
                    AbstractClassMetaData cmd = op.getClassMetaData();
                    if (!this.storeMgr.managesClass(cmd.getFullClassName())) {
                        ((MongoDBStoreManager)this.storeMgr).addClasses(new String[]{cmd.getFullClassName()}, op.getExecutionContext().getClassLoaderResolver(), db);
                    }
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_MONGODB.msg("MongoDB.Insert.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
                    }
                    dbObjects[i3] = this.getDBObjectForObjectProviderToInsert(op, true);
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_MONGODB.msg("MongoDB.Insert.ObjectPersisted", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
                    }
                    ++i3;
                }
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Persisting objects as " + StringUtils.objectArrayToString((Object[])dbObjects)));
                }
                collection.insert((DBObject[])dbObjects, new WriteConcern(1));
                if (ec.getStatistics() != null) {
                    ec.getStatistics().incrementNumWrites();
                    for (int j = 0; j < dbObjects.length; ++j) {
                        ec.getStatistics().incrementInsertCount();
                    }
                }
                if (!NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) continue;
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_MONGODB.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            catch (MongoException me) {
                NucleusLogger.PERSISTENCE.error((Object)"Exception inserting objects", (Throwable)me);
                throw new NucleusDataStoreException("Exception inserting objects", (Throwable)me);
            }
            finally {
                mconn.release();
            }
        }
    }

    public void insertObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            DB db = (DB)mconn.getConnection();
            AbstractClassMetaData cmd = op.getClassMetaData();
            if (!this.storeMgr.managesClass(cmd.getFullClassName())) {
                ((MongoDBStoreManager)this.storeMgr).addClasses(new String[]{cmd.getFullClassName()}, ec.getClassLoaderResolver(), db);
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_MONGODB.msg("MongoDB.Insert.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
            DBCollection collection = db.getCollection(this.storeMgr.getNamingFactory().getTableName(cmd));
            DBObject dbObject = this.getDBObjectForObjectProviderToInsert(op, !cmd.pkIsDatastoreAttributed(this.storeMgr));
            NucleusLogger.DATASTORE_NATIVE.debug((Object)("Persisting object " + op + " as " + dbObject));
            collection.insert(dbObject, new WriteConcern(1));
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
            }
            if (cmd.pkIsDatastoreAttributed(this.storeMgr)) {
                if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                    ObjectId idKey = (ObjectId)dbObject.get("_id");
                    op.setPostStoreNewObjectId((Object)idKey.toString());
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_MONGODB.msg("MongoDB.Insert.ObjectPersistedWithIdentity", (Object)op.getObjectAsPrintable(), (Object)idKey));
                    }
                } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    int[] pkFieldNumbers = cmd.getPKMemberPositions();
                    for (int i = 0; i < pkFieldNumbers.length; ++i) {
                        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
                        if (!this.storeMgr.isStrategyDatastoreAttributed(cmd, pkFieldNumbers[i])) continue;
                        if (mmd.getType() != String.class) {
                            throw new NucleusUserException("Any field using IDENTITY value generation with MongoDB should be of type String");
                        }
                        ObjectId idKey = (ObjectId)dbObject.get("_id");
                        op.replaceField(mmd.getAbsoluteFieldNumber(), (Object)idKey.toString());
                        op.setPostStoreNewObjectId((Object)idKey);
                        if (!NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) continue;
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_MONGODB.msg("MongoDB.Insert.ObjectPersistedWithIdentity", (Object)op.getObjectAsPrintable(), (Object)idKey));
                    }
                }
                StoreFieldManager fieldManager = new StoreFieldManager(op, dbObject, true);
                int[] fieldNumbers = cmd.getRelationMemberPositions(ec.getClassLoaderResolver(), ec.getMetaDataManager());
                if (fieldNumbers != null && fieldNumbers.length > 0) {
                    op.provideFields(fieldNumbers, (FieldManager)fieldManager);
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Saving object " + op + " as " + dbObject));
                    collection.save(dbObject);
                    if (ec.getStatistics() != null) {
                        ec.getStatistics().incrementNumWrites();
                    }
                }
            } else if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_MONGODB.msg("MongoDB.Insert.ObjectPersisted", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_MONGODB.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementInsertCount();
            }
        }
        catch (MongoException me) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception inserting object " + op), (Throwable)me);
            throw new NucleusDataStoreException("Exception inserting object for " + op, (Throwable)me);
        }
        finally {
            mconn.release();
        }
    }

    private DBObject getDBObjectForObjectProviderToInsert(ObjectProvider op, boolean includeRelationFields) {
        String fieldName;
        BasicDBObject dbObject = new BasicDBObject();
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.DATASTORE && !this.storeMgr.isStrategyDatastoreAttributed(cmd, -1)) {
            fieldName = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN);
            OID oid = (OID)op.getInternalObjectId();
            Object key = oid.getKeyValue();
            dbObject.put(fieldName, key);
        }
        if (cmd.hasDiscriminatorStrategy()) {
            DiscriminatorMetaData discmd = cmd.getDiscriminatorMetaData();
            String fieldName2 = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.DISCRIMINATOR_COLUMN);
            String discVal = null;
            discVal = cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? cmd.getFullClassName() : discmd.getValue();
            dbObject.put(fieldName2, (Object)discVal);
        }
        if (this.storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
            fieldName = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.MULTITENANCY_COLUMN);
            dbObject.put(fieldName, (Object)this.storeMgr.getStringProperty("datanucleus.TenantID"));
        }
        if (cmd.isVersioned()) {
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                long versionNumber = 1L;
                op.setTransactionalVersion((Object)versionNumber);
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_MONGODB.msg("MongoDB.Insert.ObjectPersistedWithVersion", (Object)op.getObjectAsPrintable(), op.getInternalObjectId(), (Object)("" + versionNumber)));
                }
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    Number verFieldValue = versionNumber;
                    if (verMmd.getType() == Integer.TYPE || verMmd.getType() == Integer.class) {
                        verFieldValue = (int)versionNumber;
                    }
                    op.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)verFieldValue);
                } else {
                    String fieldName3 = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN);
                    dbObject.put(fieldName3, (Object)versionNumber);
                }
            } else if (vermd.getVersionStrategy() == VersionStrategy.DATE_TIME) {
                Date date = new Date();
                Timestamp ts = new Timestamp(date.getTime());
                op.setTransactionalVersion((Object)ts);
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    op.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)ts);
                } else {
                    String fieldName4 = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN);
                    dbObject.put(fieldName4, (Object)ts);
                }
            }
        }
        StoreFieldManager fieldManager = new StoreFieldManager(op, (DBObject)dbObject, true);
        int[] fieldNumbers = cmd.getAllMemberPositions();
        if (!includeRelationFields) {
            ExecutionContext ec = op.getExecutionContext();
            fieldNumbers = cmd.getNonRelationMemberPositions(ec.getClassLoaderResolver(), ec.getMetaDataManager());
        }
        op.provideFields(fieldNumbers, (FieldManager)fieldManager);
        return dbObject;
    }

    public void updateObject(ObjectProvider op, int[] fieldNumbers) {
        this.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            DBCollection collection;
            DBObject dbObject;
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            AbstractClassMetaData cmd = op.getClassMetaData();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                StringBuilder fieldStr = new StringBuilder();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_MONGODB.msg("MongoDB.Update.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId(), (Object)fieldStr.toString()));
            }
            if ((dbObject = MongoDBUtils.getObjectForObjectProvider(collection = db.getCollection(this.storeMgr.getNamingFactory().getTableName(cmd)), op, true, true)) == null) {
                if (cmd.isVersioned()) {
                    throw new NucleusOptimisticException("Object with id " + op.getInternalObjectId() + " and version " + op.getTransactionalVersion() + " no longer present");
                }
                throw new NucleusDataStoreException("Could not find object with id " + op.getInternalObjectId());
            }
            int[] updatedFieldNums = fieldNumbers;
            if (cmd.isVersioned()) {
                Object currentVersion = op.getTransactionalVersion();
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                Object nextVersion = VersionHelper.getNextVersion((VersionStrategy)vermd.getVersionStrategy(), (Object)currentVersion);
                op.setTransactionalVersion(nextVersion);
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    op.replaceField(verMmd.getAbsoluteFieldNumber(), nextVersion);
                    boolean updatingVerField = false;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (fieldNumbers[i] != verMmd.getAbsoluteFieldNumber()) continue;
                        updatingVerField = true;
                    }
                    if (!updatingVerField) {
                        updatedFieldNums = new int[fieldNumbers.length + 1];
                        System.arraycopy(fieldNumbers, 0, updatedFieldNums, 0, fieldNumbers.length);
                        updatedFieldNums[fieldNumbers.length] = verMmd.getAbsoluteFieldNumber();
                    }
                } else {
                    String fieldName = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN);
                    dbObject.put(fieldName, nextVersion);
                }
            }
            StoreFieldManager fieldManager = new StoreFieldManager(op, dbObject, false);
            op.provideFields(updatedFieldNums, (FieldManager)fieldManager);
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("Updating object " + op + " as " + dbObject));
            }
            collection.save(dbObject);
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementUpdateCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_MONGODB.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
            }
        }
        catch (MongoException me) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception updating object " + op), (Throwable)me);
            throw new NucleusDataStoreException("Exception updating object for " + op, (Throwable)me);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObjects(ObjectProvider ... ops) {
        super.deleteObjects(ops);
    }

    public void deleteObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            DBCollection collection;
            DBObject dbObject;
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_MONGODB.msg("MongoDB.Delete.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
            if ((dbObject = MongoDBUtils.getObjectForObjectProvider(collection = db.getCollection(this.storeMgr.getNamingFactory().getTableName(cmd)), op, true, false)) == null) {
                if (cmd.isVersioned()) {
                    throw new NucleusOptimisticException("Object with id " + op.getInternalObjectId() + " and version " + op.getTransactionalVersion() + " no longer present");
                }
                throw new NucleusDataStoreException("Could not find object with id " + op.getInternalObjectId());
            }
            op.setAssociatedValue((Object)OP_DB_OBJECT, (Object)dbObject);
            op.loadUnloadedFields();
            op.provideFields(cmd.getAllMemberPositions(), (FieldManager)new DeleteFieldManager(op, true));
            op.removeAssociatedValue((Object)OP_DB_OBJECT);
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)("Removing object " + op + " as " + dbObject));
            }
            collection.remove(dbObject);
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementDeleteCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER_MONGODB.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
            }
        }
        catch (MongoException me) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception deleting object " + op), (Throwable)me);
            throw new NucleusDataStoreException("Exception deleting object for " + op, (Throwable)me);
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchObject(ObjectProvider op, int[] fieldNumbers) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            DBCollection collection;
            DBObject dbObject;
            DB db = (DB)mconn.getConnection();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                StringBuilder str = new StringBuilder("Fetching object \"");
                str.append(op.getObjectAsPrintable()).append("\" (id=");
                str.append(op.getInternalObjectId()).append(")").append(" fields [");
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                str.append("]");
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)str.toString());
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER_MONGODB.msg("MongoDB.Fetch.Start", (Object)op.getObjectAsPrintable(), op.getInternalObjectId()));
            }
            if ((dbObject = (DBObject)op.getAssociatedValue((Object)OP_DB_OBJECT)) == null && (dbObject = MongoDBUtils.getObjectForObjectProvider(collection = db.getCollection(this.storeMgr.getNamingFactory().getTableName(cmd)), op, false, false)) == null) {
                throw new NucleusObjectNotFoundException("Could not find object with id " + op.getInternalObjectId() + " op=" + op);
            }
            FetchFieldManager fieldManager = new FetchFieldManager(op, dbObject);
            op.replaceFields(fieldNumbers, (FieldManager)fieldManager);
            if (cmd.isVersioned() && op.getTransactionalVersion() == null) {
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                if (vermd.getFieldName() != null) {
                    Object datastoreVersion = op.provideField(cmd.getAbsolutePositionOfMember(vermd.getFieldName()));
                    op.setVersion(datastoreVersion);
                } else {
                    String fieldName = this.storeMgr.getNamingFactory().getColumnName(cmd, ColumnType.VERSION_COLUMN);
                    Object datastoreVersion = dbObject.get(fieldName);
                    op.setVersion(datastoreVersion);
                }
            }
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER_MONGODB.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementFetchCount();
            }
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ExecutionContext om, Object id) {
        return null;
    }

    public void locateObjects(ObjectProvider[] ops) {
        super.locateObjects(ops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locateObject(ObjectProvider op) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            ExecutionContext ec = op.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                DB db = (DB)mconn.getConnection();
                DBCollection collection = db.getCollection(this.storeMgr.getNamingFactory().getTableName(cmd));
                DBObject dbObject = MongoDBUtils.getObjectForObjectProvider(collection, op, false, false);
                if (dbObject == null) {
                    throw new NucleusObjectNotFoundException();
                }
            }
            finally {
                mconn.release();
            }
        }
    }
}

