/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.DBObject;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.StoreFieldManager;

public class StoreEmbeddedFieldManager
extends StoreFieldManager {
    public StoreEmbeddedFieldManager(ObjectProvider op, DBObject dbObject, AbstractMemberMetaData ownerMmd, boolean insert) {
        super(op, dbObject, insert);
        this.ownerMmd = ownerMmd;
    }

    protected String getFieldName(int fieldNumber) {
        return MongoDBUtils.getFieldName(this.ownerMmd, fieldNumber);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData embMmd = this.ownerMmd.getEmbeddedMetaData().getMemberMetaData()[fieldNumber];
        if (!this.isStorable(embMmd)) {
            return;
        }
        ExecutionContext ec = this.op.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        RelationType relationType = embMmd.getRelationType(clr);
        if (embMmd.isEmbedded() && RelationType.isRelationSingleValued((RelationType)relationType)) {
            AbstractClassMetaData embcmd = ec.getMetaDataManager().getMetaDataForClass(embMmd.getType(), clr);
            if (embcmd == null) {
                throw new NucleusUserException("Field " + embMmd.getFullFieldName() + " specified as embedded but metadata not found for the class of type " + embMmd.getTypeName());
            }
            if (value == null) {
                return;
            }
            if ((relationType == RelationType.ONE_TO_ONE_BI || relationType == RelationType.MANY_TO_ONE_BI) && (this.ownerMmd.getMappedBy() != null && embMmd.getName().equals(this.ownerMmd.getMappedBy()) || embMmd.getMappedBy() != null && this.ownerMmd.getName().equals(embMmd.getMappedBy()))) {
                return;
            }
            ObjectProvider embOP = ec.findObjectProviderForEmbedded(value, this.op, embMmd);
            StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embOP, this.dbObject, embMmd, this.insert);
            embOP.provideFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
            return;
        }
        String fieldName = MongoDBUtils.getFieldName(this.ownerMmd, fieldNumber);
        if (value == null) {
            if (this.dbObject.containsField(fieldName)) {
                this.dbObject.removeField(fieldName);
            }
            return;
        }
        if (embMmd.isSerialized()) {
            byte[] bytes = MongoDBUtils.getStoredValueForJavaSerialisedField(embMmd, value);
            this.dbObject.put(fieldName, (Object)bytes);
            this.op.wrapSCOField(fieldNumber, value, false, false, true);
        } else if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            this.processSingleRelationField(value, ec, fieldName);
        } else if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            this.processContainerRelationField(embMmd, value, ec, fieldName);
        } else {
            this.processContainerNonRelationField(fieldName, ec, value, this.dbObject, embMmd, 2);
        }
    }
}

