/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mongodb.MongoDBPersistenceHandler;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.schema.SchemaAwareStoreManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoDBStoreManager
extends AbstractStoreManager
implements SchemaAwareStoreManager {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.mongodb.Localisation", (ClassLoader)MongoDBStoreManager.class.getClassLoader());
    public static final String CAPPED_SIZE_EXTENSION_NAME = "mongodb.capped.size";

    public MongoDBStoreManager(ClassLoaderResolver clr, NucleusContext nucleusCtx, Map<String, Object> props) {
        super("mongodb", clr, nucleusCtx, props);
        this.persistenceHandler = new MongoDBPersistenceHandler((StoreManager)this);
        this.initialiseAutoStart(clr);
        this.logConfiguration();
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationIdentity");
        set.add("DatastoreIdentity");
        set.add("NonDurableIdentity");
        set.add("ORM");
        set.add("TransactionIsolationLevel.read-committed");
        return set;
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        if (id == null) {
            return null;
        }
        if (id instanceof SCOID) {
            return ((SCOID)id).getSCOClass();
        }
        String rootClassName = super.getClassNameForObjectID(id, clr, ec);
        String[] subclasses = this.getMetaDataManager().getSubclassesForClass(rootClassName, true);
        if (subclasses == null || subclasses.length == 0) {
            return rootClassName;
        }
        AbstractClassMetaData rootCmd = this.getMetaDataManager().getMetaDataForClass(rootClassName, clr);
        return MongoDBUtils.getClassNameForIdentity(id, rootCmd, ec, clr);
    }

    public boolean supportsValueStrategy(String strategy) {
        if (super.supportsValueStrategy(strategy)) {
            return true;
        }
        return strategy.equalsIgnoreCase("IDENTITY");
    }

    protected String getStrategyForNative(AbstractClassMetaData cmd, int absFieldNumber) {
        String jdbcType;
        if (absFieldNumber >= 0) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absFieldNumber);
            Class type = mmd.getType();
            if (String.class.isAssignableFrom(type)) {
                if (this.supportsValueStrategy("identity")) {
                    return "identity";
                }
                return "uuid-hex";
            }
            if (type == Long.class || type == Integer.class || type == Short.class || type == Long.TYPE || type == Integer.TYPE || type == Short.TYPE) {
                if (this.supportsValueStrategy("sequence") && mmd.getSequence() != null) {
                    return "sequence";
                }
                if (this.supportsValueStrategy("increment")) {
                    return "increment";
                }
                throw new NucleusUserException("This datastore provider doesn't support numeric native strategy for member " + mmd.getFullFieldName());
            }
            throw new NucleusUserException("This datastore provider doesn't support native strategy for field of type " + type.getName());
        }
        IdentityMetaData idmd = cmd.getBaseIdentityMetaData();
        if (idmd != null && idmd.getColumnMetaData() != null && MetaDataUtils.isJdbcTypeString((String)(jdbcType = idmd.getColumnMetaData().getJdbcType()))) {
            return "uuid-hex";
        }
        if (this.supportsValueStrategy("identity")) {
            return "identity";
        }
        if (this.supportsValueStrategy("sequence") && idmd.getSequence() != null) {
            return "sequence";
        }
        if (this.supportsValueStrategy("increment")) {
            return "increment";
        }
        throw new NucleusUserException("This datastore provider doesn't support numeric native strategy for class " + cmd.getFullClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClasses(String[] classNames, ClassLoaderResolver clr) {
        if (classNames == null) {
            return;
        }
        ManagedConnection mconn = this.getConnection(-1);
        try {
            DB db = (DB)mconn.getConnection();
            this.addClasses(classNames, clr, db);
        }
        finally {
            mconn.release();
        }
    }

    public void addClasses(String[] classNames, ClassLoaderResolver clr, DB db) {
        if (classNames == null) {
            return;
        }
        String[] filteredClassNames = this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        for (ClassMetaData cmd : this.getMetaDataManager().getReferencedClasses(filteredClassNames, clr)) {
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || this.storeDataMgr.managesClass(cmd.getFullClassName())) continue;
            StoreData sd = this.storeDataMgr.get(cmd.getFullClassName());
            if (sd == null) {
                this.registerStoreData(this.newStoreData(cmd, clr));
            }
            this.createSchemaForClass((AbstractClassMetaData)cmd, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(Set<String> classNames, Properties props) {
        ManagedConnection mconn = this.getConnection(-1);
        try {
            DB db = (DB)mconn.getConnection();
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                String className = classIter.next();
                AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                this.createSchemaForClass(cmd, db);
            }
        }
        finally {
            mconn.close();
        }
    }

    protected void createSchemaForClass(AbstractClassMetaData cmd, DB db) {
        String collectionName = this.getNamingFactory().getTableName(cmd);
        DBCollection collection = null;
        if (this.autoCreateTables) {
            if (cmd.hasExtension(CAPPED_SIZE_EXTENSION_NAME)) {
                Set collNames = db.getCollectionNames();
                if (!collNames.contains(collectionName)) {
                    BasicDBObject options = new BasicDBObject();
                    options.put("capped", (Object)"true");
                    Long size = Long.valueOf(cmd.getValueForExtension(CAPPED_SIZE_EXTENSION_NAME));
                    options.put("size", (Object)size);
                    db.createCollection(collectionName, (DBObject)options);
                } else {
                    collection = db.getCollection(collectionName);
                }
            } else {
                collection = db.getCollection(collectionName);
            }
        }
        if (this.autoCreateConstraints) {
            BasicDBObject query;
            UniqueMetaData[] unimds;
            IndexMetaData[] idxmds;
            if (collection == null && !db.getCollectionNames().contains(collectionName)) {
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)("Cannot create constraints for " + cmd.getFullClassName() + " since collection of name " + collectionName + " doesn't exist (enable autoCreateTables?)"));
                return;
            }
            if (collection == null) {
                collection = db.getCollection(collectionName);
            }
            if ((idxmds = cmd.getIndexMetaData()) != null && idxmds.length > 0) {
                for (int i = 0; i < idxmds.length; ++i) {
                    DBObject idxObj = this.getDBObjectForIndex(cmd, idxmds[i]);
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("MongoDB.SchemaCreate.Class.Index", (Object)idxmds[i].getName(), (Object)collectionName, (Object)idxObj));
                    }
                    collection.ensureIndex(idxObj, idxmds[i].getName(), idxmds[i].isUnique());
                }
            }
            if ((unimds = cmd.getUniqueMetaData()) != null && unimds.length > 0) {
                for (int i = 0; i < unimds.length; ++i) {
                    DBObject uniObj = this.getDBObjectForUnique(cmd, unimds[i]);
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("MongoDB.SchemaCreate.Class.Index", (Object)unimds[i].getName(), (Object)collectionName, (Object)uniObj));
                    }
                    collection.ensureIndex(uniObj, unimds[i].getName(), true);
                }
            }
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                query = new BasicDBObject();
                int[] pkFieldNumbers = cmd.getPKMemberPositions();
                boolean applyIndex = true;
                for (int i = 0; i < pkFieldNumbers.length; ++i) {
                    AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
                    if (this.isStrategyDatastoreAttributed(cmd, pkFieldNumbers[i])) {
                        applyIndex = false;
                        break;
                    }
                    query.append(this.getNamingFactory().getColumnName(pkMmd, ColumnType.COLUMN), (Object)1);
                }
                if (applyIndex) {
                    String pkName;
                    String string = pkName = cmd.getPrimaryKeyMetaData() != null ? cmd.getPrimaryKeyMetaData().getName() : cmd.getName() + "_PK";
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("MongoDB.SchemaCreate.Class.Index", (Object)pkName, (Object)collectionName, (Object)query));
                    }
                    collection.ensureIndex((DBObject)query, pkName, true);
                }
            } else if (cmd.getIdentityType() == IdentityType.DATASTORE && !this.isStrategyDatastoreAttributed(cmd, -1)) {
                String pkName;
                query = new BasicDBObject();
                query.append(this.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN), (Object)1);
                String string = pkName = cmd.getPrimaryKeyMetaData() != null ? cmd.getPrimaryKeyMetaData().getName() : cmd.getName() + "_PK";
                if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("MongoDB.SchemaCreate.Class.Index", (Object)pkName, (Object)collectionName, (Object)query));
                }
                collection.ensureIndex((DBObject)query, pkName, true);
            }
            AbstractMemberMetaData[] mmds = cmd.getManagedMembers();
            if (mmds != null && mmds.length > 0) {
                for (int i = 0; i < mmds.length; ++i) {
                    UniqueMetaData unimd;
                    String colName = this.getNamingFactory().getColumnName(mmds[i], ColumnType.COLUMN);
                    IndexMetaData idxmd = mmds[i].getIndexMetaData();
                    if (idxmd != null) {
                        BasicDBObject query2 = new BasicDBObject();
                        query2.append(colName, (Object)1);
                        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("MongoDB.SchemaCreate.Class.Index", (Object)idxmd.getName(), (Object)collectionName, (Object)query2));
                        }
                        collection.ensureIndex((DBObject)query2, idxmd.getName(), idxmd.isUnique());
                    }
                    if ((unimd = mmds[i].getUniqueMetaData()) == null) continue;
                    BasicDBObject query3 = new BasicDBObject();
                    query3.append(colName, (Object)1);
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("MongoDB.SchemaCreate.Class.Index", (Object)unimd.getName(), (Object)collectionName, (Object)query3));
                    }
                    collection.ensureIndex((DBObject)query3, unimd.getName(), true);
                }
            }
        }
    }

    private DBObject getDBObjectForIndex(AbstractClassMetaData cmd, IndexMetaData idxmd) {
        BasicDBObject idxObj;
        block3: {
            block2: {
                idxObj = new BasicDBObject();
                if (idxmd.getColumnMetaData() == null) break block2;
                ColumnMetaData[] idxcolmds = idxmd.getColumnMetaData();
                for (int j = 0; j < idxcolmds.length; ++j) {
                    idxObj.append(idxcolmds[j].getName(), (Object)1);
                }
                break block3;
            }
            if (idxmd.getMemberMetaData() == null) break block3;
            AbstractMemberMetaData[] idxmmds = idxmd.getMemberMetaData();
            for (int j = 0; j < idxmmds.length; ++j) {
                String memberName = idxmmds[j].getName();
                AbstractMemberMetaData mmd = cmd.getMetaDataForMember(memberName);
                idxObj.append(this.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN), (Object)1);
            }
        }
        return idxObj;
    }

    private DBObject getDBObjectForUnique(AbstractClassMetaData cmd, UniqueMetaData unimd) {
        BasicDBObject uniObj;
        block3: {
            block2: {
                uniObj = new BasicDBObject();
                if (unimd.getColumnMetaData() == null) break block2;
                ColumnMetaData[] unicolmds = unimd.getColumnMetaData();
                for (int j = 0; j < unicolmds.length; ++j) {
                    uniObj.append(unicolmds[j].getName(), (Object)1);
                }
                break block3;
            }
            if (unimd.getMemberMetaData() == null) break block3;
            AbstractMemberMetaData[] unimmds = unimd.getMemberMetaData();
            for (int j = 0; j < unimmds.length; ++j) {
                String memberName = unimmds[j].getName();
                AbstractMemberMetaData mmd = cmd.getMetaDataForMember(memberName);
                uniObj.append(this.getNamingFactory().getColumnName(mmd, ColumnType.COLUMN), (Object)1);
            }
        }
        return uniObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchema(Set<String> classNames, Properties props) {
        ManagedConnection mconn = this.getConnection(-1);
        try {
            DB db = (DB)mconn.getConnection();
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                String className = classIter.next();
                AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                DBCollection collection = db.getCollection(this.getNamingFactory().getTableName(cmd));
                collection.dropIndexes();
                collection.drop();
            }
        }
        finally {
            mconn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateSchema(Set<String> classNames, Properties props) {
        boolean success = true;
        ManagedConnection mconn = this.getConnection(-1);
        try {
            DB db = (DB)mconn.getConnection();
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                AbstractMemberMetaData[] mmds;
                String msg;
                DBObject indexObj;
                UniqueMetaData[] unimds;
                String msg2;
                String className = classIter.next();
                AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                String tableName = this.getNamingFactory().getTableName(cmd);
                if (!db.collectionExists(tableName)) {
                    success = false;
                    msg2 = "Table doesn't exist for " + cmd.getFullClassName() + " - should have name=" + tableName;
                    System.out.println(msg2);
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)msg2);
                    continue;
                }
                msg2 = "Table for class=" + cmd.getFullClassName() + " with name=" + tableName + " validated";
                NucleusLogger.DATASTORE_SCHEMA.info((Object)msg2);
                DBCollection table = db.getCollection(tableName);
                ArrayList<DBObject> indices = new ArrayList<DBObject>(table.getIndexInfo());
                IndexMetaData[] idxmds = cmd.getIndexMetaData();
                if (idxmds != null && idxmds.length > 0) {
                    for (int i = 0; i < idxmds.length; ++i) {
                        String msg3;
                        DBObject idxObj = this.getDBObjectForIndex(cmd, idxmds[i]);
                        DBObject indexObj2 = this.getIndexObjectForIndex(indices, idxmds[i].getName(), idxObj, true);
                        if (indexObj2 != null) {
                            indices.remove(indexObj2);
                            msg3 = "Index for class=" + cmd.getFullClassName() + " with name=" + idxmds[i].getName() + " validated";
                            NucleusLogger.DATASTORE_SCHEMA.info((Object)msg3);
                            continue;
                        }
                        success = false;
                        msg3 = "Index missing for class=" + cmd.getFullClassName() + " name=" + idxmds[i].getName() + " key=" + idxObj;
                        System.out.println(msg3);
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)msg3);
                    }
                }
                if ((unimds = cmd.getUniqueMetaData()) != null && unimds.length > 0) {
                    for (int i = 0; i < unimds.length; ++i) {
                        DBObject uniObj = this.getDBObjectForUnique(cmd, unimds[i]);
                        indexObj = this.getIndexObjectForIndex(indices, unimds[i].getName(), uniObj, true);
                        if (indexObj != null) {
                            indices.remove(indexObj);
                            msg = "Unique index for class=" + cmd.getFullClassName() + " with name=" + unimds[i].getName() + " validated";
                            NucleusLogger.DATASTORE_SCHEMA.info((Object)msg);
                            continue;
                        }
                        success = false;
                        msg = "Unique index missing for class=" + cmd.getFullClassName() + " name=" + unimds[i].getName() + " key=" + uniObj;
                        System.out.println(msg);
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
                    }
                }
                if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    String msg4;
                    BasicDBObject query = new BasicDBObject();
                    int[] pkFieldNumbers = cmd.getPKMemberPositions();
                    for (int i = 0; i < pkFieldNumbers.length; ++i) {
                        AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
                        query.append(this.getNamingFactory().getColumnName(pkMmd, ColumnType.COLUMN), (Object)1);
                    }
                    String pkName = cmd.getPrimaryKeyMetaData() != null ? cmd.getPrimaryKeyMetaData().getName() : cmd.getName() + "_PK";
                    DBObject indexObj3 = this.getIndexObjectForIndex(indices, pkName, (DBObject)query, true);
                    if (indexObj3 != null) {
                        indices.remove(indexObj3);
                        msg4 = "Index for application-identity with name=" + pkName + " validated";
                        NucleusLogger.DATASTORE_SCHEMA.info((Object)msg4);
                    } else {
                        success = false;
                        msg4 = "Index missing for application id name=" + pkName + " key=" + query;
                        System.out.println(msg4);
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)msg4);
                    }
                } else if (cmd.getIdentityType() == IdentityType.DATASTORE && !this.isStrategyDatastoreAttributed(cmd, -1)) {
                    BasicDBObject query = new BasicDBObject();
                    query.append(this.getNamingFactory().getColumnName(cmd, ColumnType.DATASTOREID_COLUMN), (Object)1);
                    String pkName = cmd.getPrimaryKeyMetaData() != null ? cmd.getPrimaryKeyMetaData().getName() : cmd.getName() + "_PK";
                    indexObj = this.getIndexObjectForIndex(indices, pkName, (DBObject)query, true);
                    if (indexObj != null) {
                        indices.remove(indexObj);
                        msg = "Index for datastore-identity with name=" + pkName + " validated";
                        NucleusLogger.DATASTORE_SCHEMA.info((Object)msg);
                    } else {
                        success = false;
                        msg = "Index missing for datastore id name=" + pkName + " key=" + query;
                        System.out.println(msg);
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
                    }
                }
                if ((mmds = cmd.getManagedMembers()) == null || mmds.length <= 0) continue;
                for (int i = 0; i < mmds.length; ++i) {
                    String msg5;
                    UniqueMetaData unimd;
                    IndexMetaData idxmd = mmds[i].getIndexMetaData();
                    if (idxmd != null) {
                        String msg6;
                        BasicDBObject query = new BasicDBObject();
                        query.append(this.getNamingFactory().getColumnName(mmds[i], ColumnType.COLUMN), (Object)1);
                        DBObject indexObj4 = this.getIndexObjectForIndex(indices, idxmd.getName(), (DBObject)query, true);
                        if (indexObj4 != null) {
                            msg6 = "Index for field=" + mmds[i].getFullFieldName() + " with name=" + idxmd.getName() + " validated";
                            NucleusLogger.DATASTORE_SCHEMA.info((Object)msg6);
                            indices.remove(indexObj4);
                        } else {
                            success = false;
                            msg6 = "Index missing for field=" + mmds[i].getFullFieldName() + " name=" + idxmd.getName() + " key=" + query;
                            System.out.println(msg6);
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)msg6);
                        }
                    }
                    if ((unimd = mmds[i].getUniqueMetaData()) == null) continue;
                    BasicDBObject query = new BasicDBObject();
                    query.append(this.getNamingFactory().getColumnName(mmds[i], ColumnType.COLUMN), (Object)1);
                    DBObject indexObj5 = this.getIndexObjectForIndex(indices, unimd.getName(), (DBObject)query, true);
                    if (indexObj5 != null) {
                        msg5 = "Unique index for field=" + mmds[i].getFullFieldName() + " with name=" + unimd.getName() + " validated";
                        NucleusLogger.DATASTORE_SCHEMA.info((Object)msg5);
                        indices.remove(indexObj5);
                        continue;
                    }
                    success = false;
                    msg5 = "Unique index missing for field=" + mmds[i].getFullFieldName() + " name=" + unimd.getName() + " key=" + query;
                    System.out.println(msg5);
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)msg5);
                }
            }
        }
        finally {
            mconn.close();
        }
        if (!success) {
            throw new NucleusException("Errors were encountered during validation of MongoDB schema");
        }
    }

    private DBObject getIndexObjectForIndex(List<DBObject> indices, String idxName, DBObject idxObj, boolean unique) {
        if (indices == null || indices.isEmpty()) {
            return null;
        }
        for (DBObject index : indices) {
            boolean flag;
            DBObject obj = null;
            String name = (String)index.get("name");
            if (!name.equals(idxName)) continue;
            obj = index;
            if (unique && !(flag = ((Boolean)index.get("unique")).booleanValue())) continue;
            boolean equal = true;
            DBObject key = (DBObject)index.get("key");
            if (key.toMap().size() != idxObj.toMap().size()) {
                equal = false;
            } else {
                for (String fieldKey : key.keySet()) {
                    Object fieldValue = key.get(fieldKey);
                    if (!idxObj.containsField(fieldKey)) {
                        equal = false;
                        continue;
                    }
                    Object idxObjValue = idxObj.get(fieldKey);
                    if (idxObjValue.equals(fieldValue)) continue;
                    equal = false;
                }
            }
            if (!equal) continue;
            return obj;
        }
        return null;
    }
}

