/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.NucleusContext;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.Relation;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.fieldmanager.FetchFieldManager;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoDBUtils {
    public static String getDefaultValueForMember(AbstractMemberMetaData mmd) {
        ColumnMetaData[] colmds = mmd.getColumnMetaData();
        if (colmds == null || colmds.length < 1) {
            return null;
        }
        return colmds[0].getDefaultValue();
    }

    public static String getCollectionName(AbstractClassMetaData cmd) {
        if (cmd.getTable() != null) {
            return cmd.getTable();
        }
        return cmd.getName();
    }

    public static String getFieldName(AbstractMemberMetaData mmd) {
        ColumnMetaData[] colmds = mmd.getColumnMetaData();
        if (colmds != null && colmds.length > 1) {
            return colmds[0].getName();
        }
        return mmd.getName();
    }

    public static String getFieldName(IdentityMetaData idmd) {
        if (idmd.getValueStrategy() == IdentityStrategy.IDENTITY) {
            return "_id";
        }
        ColumnMetaData colmd = idmd.getColumnMetaData();
        if (colmd != null && colmd.getName() != null) {
            return colmd.getName();
        }
        return "IDENTITY";
    }

    public static String getFieldName(VersionMetaData vermd) {
        ColumnMetaData colmd = vermd.getColumnMetaData();
        if (colmd != null && colmd.getName() != null) {
            return colmd.getName();
        }
        return "VERSION";
    }

    public static String getFieldName(DiscriminatorMetaData discmd) {
        ColumnMetaData colmd = discmd.getColumnMetaData();
        if (colmd != null && colmd.getName() != null) {
            return colmd.getName();
        }
        return "DISCRIM";
    }

    public static String getFieldNameForMultitenancy(AbstractClassMetaData cmd) {
        if (cmd.hasExtension("multitenancy-column-name")) {
            return cmd.getValueForExtension("multitenancy-column-name");
        }
        return "TENANT_ID";
    }

    public static String getFieldName(AbstractMemberMetaData mmd, int fieldNumber) {
        ColumnMetaData[] colmds;
        String columnName = null;
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData embMmd = null;
        if (embmd != null) {
            AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
            embMmd = embmmds[fieldNumber];
        }
        if ((colmds = embMmd.getColumnMetaData()) != null && colmds.length > 0) {
            columnName = colmds[0].getName();
        }
        if (columnName == null) {
            columnName = embMmd.getName();
        }
        if (columnName == null) {
            columnName = embMmd.getName();
        }
        return columnName;
    }

    public static DBObject getObjectForObjectProvider(DBCollection dbCollection, ObjectProvider op, boolean checkVersion) {
        BasicDBObject query = new BasicDBObject();
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkPositions = cmd.getPKMemberPositions();
            for (int i = 0; i < pkPositions.length; ++i) {
                AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkPositions[i]);
                Object value = op.provideField(pkPositions[i]);
                if (value == null && pkMmd.getValueStrategy() == IdentityStrategy.IDENTITY) {
                    return null;
                }
                if (pkMmd.getValueStrategy() == IdentityStrategy.IDENTITY) {
                    query.put("_id", (Object)new ObjectId((String)value));
                    continue;
                }
                query.put(MongoDBUtils.getFieldName(pkMmd), value);
            }
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            OID oid = (OID)op.getObjectId();
            if (oid == null && cmd.getIdentityMetaData().getValueStrategy() == IdentityStrategy.IDENTITY) {
                return null;
            }
            Object value = oid.getKeyValue();
            if (cmd.getIdentityMetaData().getValueStrategy() == IdentityStrategy.IDENTITY) {
                query.put("_id", (Object)new ObjectId((String)value));
            } else {
                query.put(MongoDBUtils.getFieldName(cmd.getIdentityMetaData()), value);
            }
        }
        if (cmd.hasDiscriminatorStrategy()) {
            query.put(MongoDBUtils.getFieldName(cmd.getDiscriminatorMetaData()), cmd.getDiscriminatorValue());
        }
        if (checkVersion && cmd.isVersioned()) {
            Object currentVersion = op.getTransactionalVersion();
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                String fieldName = MongoDBUtils.getFieldName(verMmd);
                query.put(fieldName, currentVersion);
            } else {
                String fieldName = MongoDBUtils.getFieldName(vermd);
                query.put(fieldName, currentVersion);
            }
        }
        NucleusLogger.DATASTORE_RETRIEVE.debug((Object)("Retrieving object for " + query));
        return dbCollection.findOne((DBObject)query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getObjectsOfCandidateType(ExecutionContext ec, DB db, Class candidateClass, boolean subclasses, boolean ignoreCache, FetchPlan fp, BasicDBObject filterObject, Map<String, Object> options) {
        List cmds = MetaDataUtils.getMetaDataForCandidates((Class)candidateClass, (boolean)subclasses, (ExecutionContext)ec);
        Iterator cmdIter = cmds.iterator();
        ArrayList<Object> results = new ArrayList<Object>();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        while (cmdIter.hasNext()) {
            Boolean val;
            AbstractClassMetaData cmd = (AbstractClassMetaData)cmdIter.next();
            fp.manageFetchPlanForClass(cmd);
            int[] fpMembers = fp.getFetchPlanForClass(cmd).getMemberNumbers();
            BasicDBObject fieldsSelection = new BasicDBObject();
            if (fpMembers != null && fpMembers.length > 0) {
                fieldsSelection = new BasicDBObject();
                for (int i = 0; i < fpMembers.length; ++i) {
                    AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fpMembers[i]);
                    int relationType = mmd.getRelationType(clr);
                    if (mmd.isEmbedded() && Relation.isRelationSingleValued((int)relationType)) {
                        boolean nested = true;
                        String nestedStr = mmd.getValueForExtension("nested");
                        if (nestedStr != null && nestedStr.equalsIgnoreCase("false")) {
                            nested = false;
                        }
                        if (nested) {
                            String fieldName = MongoDBUtils.getFieldName(mmd);
                            fieldsSelection.append(fieldName, (Object)1);
                            continue;
                        }
                        MongoDBUtils.selectAllFieldsOfEmbeddedObject(mmd, fieldsSelection, ec, clr);
                        continue;
                    }
                    String fieldName = MongoDBUtils.getFieldName(mmd);
                    fieldsSelection.append(fieldName, (Object)1);
                }
            }
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                fieldsSelection.append(MongoDBUtils.getFieldName(cmd.getIdentityMetaData()), (Object)1);
            }
            if (cmd.isVersioned()) {
                fieldsSelection.append(MongoDBUtils.getFieldName(cmd.getVersionMetaDataForClass()), (Object)1);
            }
            BasicDBObject query = new BasicDBObject();
            if (filterObject != null) {
                for (Map.Entry entry : filterObject.entrySet()) {
                    query.put((String)entry.getKey(), entry.getValue());
                }
            }
            if (cmd.hasDiscriminatorStrategy()) {
                query.put(MongoDBUtils.getFieldName(cmd.getDiscriminatorMetaData()), cmd.getDiscriminatorValue());
            }
            if (ec.getStoreManager().getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
                String fieldName = MongoDBUtils.getFieldNameForMultitenancy(cmd);
                String value = ec.getStoreManager().getStringProperty("datanucleus.TenantID");
                query.put(fieldName, (Object)value);
            }
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)("Fetching instances of collection " + MongoDBUtils.getCollectionName(cmd) + " fields=" + fieldsSelection + " with filter=" + query));
            }
            DBCollection dbColl = db.getCollection(MongoDBUtils.getCollectionName(cmd));
            Boolean bl = val = options != null ? options.get("slave-ok") : Boolean.FALSE;
            if (val == Boolean.TRUE) {
                dbColl.slaveOk();
            }
            DBCursor curs = dbColl.find((DBObject)query, (DBObject)fieldsSelection);
            try {
                while (curs.hasNext()) {
                    DBObject dbObject = curs.next();
                    if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                        results.add(MongoDBUtils.getObjectUsingApplicationIdForDBObject(dbObject, cmd, ec, ignoreCache, fpMembers));
                        continue;
                    }
                    if (cmd.getIdentityType() != IdentityType.DATASTORE) continue;
                    results.add(MongoDBUtils.getObjectUsingDatastoreIdForDBObject(dbObject, cmd, ec, ignoreCache, fpMembers));
                }
            }
            finally {
                curs.close();
            }
        }
        return results;
    }

    protected static void selectAllFieldsOfEmbeddedObject(AbstractMemberMetaData mmd, BasicDBObject fieldsSelection, ExecutionContext ec, ClassLoaderResolver clr) {
        EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
        AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
        for (int i = 0; i < embmmds.length; ++i) {
            int relationType = embmmds[i].getRelationType(clr);
            if (embmmds[i].isEmbedded() && Relation.isRelationSingleValued((int)relationType)) {
                MongoDBUtils.selectAllFieldsOfEmbeddedObject(embmmds[i], fieldsSelection, ec, clr);
                continue;
            }
            String embFieldName = MongoDBUtils.getFieldName(mmd, i);
            fieldsSelection.append(embFieldName, (Object)1);
        }
    }

    public static Object getObjectUsingApplicationIdForDBObject(final DBObject dbObject, final AbstractClassMetaData cmd, final ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        Object id = IdentityUtils.getApplicationIdentityForResultSetRow((ExecutionContext)ec, (AbstractClassMetaData)cmd, null, (boolean)false, (FieldManager)new FetchFieldManager(ec, dbObject, cmd));
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject(id, new FieldValues(){

            public void fetchFields(ObjectProvider sm) {
                sm.replaceFields(fpMembers, (FieldManager)new FetchFieldManager(ec, dbObject, cmd));
            }

            public void fetchNonLoadedFields(ObjectProvider sm) {
                sm.replaceNonLoadedFields(fpMembers, (FieldManager)new FetchFieldManager(ec, dbObject, cmd));
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache);
        if (cmd.isVersioned()) {
            ObjectProvider sm = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = sm.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = dbObject.get(MongoDBUtils.getFieldName(vermd));
            }
            sm.setVersion(version);
        }
        return pc;
    }

    public static Object getObjectUsingDatastoreIdForDBObject(final DBObject dbObject, final AbstractClassMetaData cmd, final ExecutionContext ec, boolean ignoreCache, final int[] fpMembers) {
        Object idKey = null;
        if (cmd.getIdentityMetaData().getValueStrategy() == IdentityStrategy.IDENTITY) {
            idKey = dbObject.get("_id");
            if (idKey instanceof ObjectId) {
                idKey = ((ObjectId)idKey).toString();
            }
        } else {
            idKey = dbObject.get(MongoDBUtils.getFieldName(cmd.getIdentityMetaData()));
        }
        OID oid = OIDFactory.getInstance((NucleusContext)ec.getNucleusContext(), (String)cmd.getFullClassName(), (Object)idKey);
        Class type = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        Object pc = ec.findObject((Object)oid, new FieldValues(){

            public void fetchFields(ObjectProvider sm) {
                sm.replaceFields(fpMembers, (FieldManager)new FetchFieldManager(ec, dbObject, cmd));
            }

            public void fetchNonLoadedFields(ObjectProvider sm) {
                sm.replaceNonLoadedFields(fpMembers, (FieldManager)new FetchFieldManager(ec, dbObject, cmd));
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, type, ignoreCache);
        if (cmd.isVersioned()) {
            ObjectProvider sm = ec.findObjectProvider(pc);
            Object version = null;
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getFieldName() != null) {
                AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                version = sm.provideField(verMmd.getAbsoluteFieldNumber());
            } else {
                version = dbObject.get(MongoDBUtils.getFieldName(vermd));
            }
            sm.setVersion(version);
        }
        return pc;
    }
}

