/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.transaction.xa.XAResource;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.mongodb.MongoDBStoreManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.mongodb.Localisation", (ClassLoader)MongoDBStoreManager.class.getClassLoader());
    String dbName = "DataNucleus";
    Mongo mongo;

    public ConnectionFactoryImpl(StoreManager storeMgr, String resourceType) {
        super(storeMgr, resourceType);
        String url = storeMgr.getConnectionURL();
        if (url == null) {
            throw new NucleusException("You haven't specified persistence property 'datanucleus.ConnectionURL' (or alias)");
        }
        String remains = url.substring(7).trim();
        if (remains.indexOf(58) == 0) {
            remains = remains.substring(1);
        }
        try {
            ArrayList<ServerAddress> serverAddrs = new ArrayList<ServerAddress>();
            if (remains.length() == 0) {
                serverAddrs.add(new ServerAddress());
            } else {
                StringTokenizer tokeniser = new StringTokenizer(remains, ",");
                while (tokeniser.hasMoreTokens()) {
                    String token = tokeniser.nextToken();
                    String serverName = "localhost";
                    if (token.charAt(0) != '/') {
                        int serverEndPos = remains.indexOf(47);
                        if (serverEndPos > 0) {
                            serverName = token.substring(0, serverEndPos);
                            token = token.substring(serverEndPos);
                        } else {
                            serverName = token;
                            remains = "";
                        }
                    }
                    ServerAddress addr = null;
                    int portSeparatorPos = serverName.indexOf(58);
                    addr = portSeparatorPos > 0 ? new ServerAddress(serverName.substring(0, portSeparatorPos), Integer.valueOf(serverName.substring(portSeparatorPos + 1)).intValue()) : new ServerAddress(serverName);
                    serverAddrs.add(addr);
                    if (this.dbName != null || token.charAt(0) != '/' || token.length() <= 1) continue;
                    this.dbName = token.substring(1);
                }
            }
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                NucleusLogger.CONNECTION.debug((Object)LOCALISER.msg("MongoDB.ServerConnect", (Object)this.dbName, (Object)serverAddrs.size(), (Object)StringUtils.collectionToString(serverAddrs)));
            }
            this.mongo = serverAddrs.size() == 1 ? new Mongo((ServerAddress)serverAddrs.get(0)) : new Mongo(serverAddrs);
        }
        catch (UnknownHostException e) {
            throw new NucleusDataStoreException("Unable to connect to mongodb", (Throwable)e);
        }
        catch (MongoException me) {
            throw new NucleusDataStoreException("Unable to connect to mongodb", (Throwable)me);
        }
    }

    public void close() {
        this.mongo.close();
        super.close();
    }

    public ManagedConnection createManagedConnection(Object poolKey, Map transactionOptions) {
        return new ManagedConnectionImpl(transactionOptions);
    }

    public class ManagedConnectionImpl
    extends AbstractManagedConnection {
        Map options;

        public ManagedConnectionImpl(Map options) {
            this.options = options;
        }

        public Object getConnection() {
            if (this.conn == null) {
                boolean authenticated;
                this.conn = ConnectionFactoryImpl.this.mongo.getDB(ConnectionFactoryImpl.this.dbName);
                String userName = ConnectionFactoryImpl.this.storeMgr.getConnectionUserName();
                String password = ConnectionFactoryImpl.this.storeMgr.getConnectionPassword();
                if (!StringUtils.isWhitespace((String)userName) && !(authenticated = ((DB)this.conn).authenticate(userName, password.toCharArray()))) {
                    throw new NucleusDataStoreException("Authentication of the connection failed for datastore " + ConnectionFactoryImpl.this.dbName + " with user " + userName);
                }
                if (ConnectionFactoryImpl.this.storeMgr.getBooleanProperty("datanucleus.readOnlyDatastore", false)) {
                    ((DB)this.conn).setReadOnly(Boolean.TRUE);
                }
            }
            ((DB)this.conn).requestStart();
            return this.conn;
        }

        public void release() {
            ((DB)this.conn).requestDone();
            super.release();
        }

        public void close() {
            int i;
            if (this.conn == null) {
                return;
            }
            for (i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            for (i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
            }
        }

        public XAResource getXAResource() {
            return null;
        }
    }
}

