/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.query;

import com.mongodb.DB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.evaluator.JPQLEvaluator;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.NucleusLogger;

public class JPQLQuery
extends AbstractJPQLQuery {
    public JPQLQuery(ExecutionContext ec) {
        this(ec, (JPQLQuery)null);
    }

    public JPQLQuery(ExecutionContext ec, JPQLQuery q) {
        super(ec, (AbstractJPQLQuery)q);
    }

    public JPQLQuery(ExecutionContext ec, String query) {
        super(ec, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        ManagedConnection mconn = this.ec.getStoreManager().getConnection(this.ec);
        try {
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JPQL", (Object)this.getSingleStringQuery(), null));
            }
            List candidates = null;
            candidates = this.candidateCollection == null ? MongoDBUtils.getObjectsOfCandidateType(this.ec, db, this.candidateClass, this.subclasses, this.ignoreCache, this.getFetchPlan()) : new ArrayList(this.candidateCollection);
            JPQLEvaluator resultMapper = new JPQLEvaluator((Query)this, candidates, this.compilation, parameters, this.ec.getClassLoaderResolver());
            Collection results = resultMapper.execute(true, true, true, true, true);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)"JPQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            if (this.type == 2) {
                for (Object obj : results) {
                    this.ec.deleteObject(obj);
                }
                Long l = results.size();
                return l;
            }
            if (this.type == 1) {
                throw new NucleusException("Bulk Update is not yet supported");
            }
            Collection collection = results;
            return collection;
        }
        finally {
            mconn.release();
        }
    }
}

