/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.query;

import com.mongodb.DB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.query.evaluator.JDOQLEvaluator;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.NucleusLogger;

public class JDOQLQuery
extends AbstractJDOQLQuery {
    public JDOQLQuery(ExecutionContext ec) {
        this(ec, (JDOQLQuery)null);
    }

    public JDOQLQuery(ExecutionContext ec, JDOQLQuery q) {
        super(ec, (AbstractJDOQLQuery)q);
    }

    public JDOQLQuery(ExecutionContext ec, String query) {
        super(ec, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        ManagedConnection mconn = this.ec.getStoreManager().getConnection(this.ec);
        try {
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JDOQL", (Object)this.getSingleStringQuery(), null));
            }
            List candidates = null;
            if (this.candidateCollection != null) {
                candidates = new ArrayList(this.candidateCollection);
            } else if (this.candidateExtent != null) {
                candidates = new ArrayList();
                Iterator iter = this.candidateExtent.iterator();
                while (iter.hasNext()) {
                    candidates.add(iter.next());
                }
            } else {
                NucleusLogger.GENERAL.info((Object)">> JDOQL get candidates");
                candidates = MongoDBUtils.getObjectsOfCandidateType(this.ec, db, this.candidateClass, this.subclasses, this.ignoreCache, this.getFetchPlan());
                NucleusLogger.GENERAL.info((Object)(">> Number of candidates=" + candidates.size()));
            }
            JDOQLEvaluator resultMapper = new JDOQLEvaluator((Query)this, candidates, this.compilation, parameters, this.ec.getClassLoaderResolver());
            Collection results = resultMapper.execute(true, true, true, true, true);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)"JDOQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            Collection collection = results;
            return collection;
        }
        finally {
            mconn.release();
        }
    }
}

