/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.DBObject;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.types.ObjectStringConverter;
import org.datanucleus.store.types.sco.SCOUtils;

public class FetchFieldManager
extends AbstractFieldManager {
    private ExecutionContext ec;
    private DBObject dbObject;
    private AbstractClassMetaData acmd;

    public FetchFieldManager(ObjectProvider sm, DBObject dbObject, AbstractClassMetaData acmd) {
        this.ec = sm.getExecutionContext();
        this.dbObject = dbObject;
        this.acmd = acmd;
    }

    public FetchFieldManager(ExecutionContext ec, DBObject dbObject, AbstractClassMetaData acmd) {
        this.ec = ec;
        this.dbObject = dbObject;
        this.acmd = acmd;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        return (Boolean)this.dbObject.get(fieldName);
    }

    public char fetchCharField(int fieldNumber) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        return ((Character)this.dbObject.get(fieldName)).charValue();
    }

    public byte fetchByteField(int fieldNumber) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        return (Byte)this.dbObject.get(fieldName);
    }

    public short fetchShortField(int fieldNumber) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        return (Short)this.dbObject.get(fieldName);
    }

    public int fetchIntField(int fieldNumber) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        return (Integer)this.dbObject.get(fieldName);
    }

    public long fetchLongField(int fieldNumber) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        return (Long)this.dbObject.get(fieldName);
    }

    public float fetchFloatField(int fieldNumber) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        return ((Float)this.dbObject.get(fieldName)).floatValue();
    }

    public double fetchDoubleField(int fieldNumber) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        return (Double)this.dbObject.get(fieldName);
    }

    public String fetchStringField(int fieldNumber) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        if (this.dbObject.containsField(fieldName)) {
            return (String)this.dbObject.get(fieldName);
        }
        return null;
    }

    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData ammd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String fieldName = MongoDBUtils.getFieldName(ammd);
        if (!this.dbObject.containsField(fieldName)) {
            return null;
        }
        Object value = this.dbObject.get(fieldName);
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        int relationType = ammd.getRelationType(clr);
        if (relationType == 2 || relationType == 1 || relationType == 6 || relationType == 7) {
            return this.ec.findObject(value, true, true, null);
        }
        if (relationType == 3 || relationType == 4 || relationType == 5) {
            if (ammd.hasCollection()) {
                Collection coll;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)ammd.getType(), (Boolean)(ammd.getOrderMetaData() != null ? 1 : 0));
                    coll = (Collection)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                Collection collIds = (Collection)value;
                for (Object elementId : collIds) {
                    coll.add(this.ec.findObject(elementId, true, true, null));
                }
                return coll;
            }
            if (ammd.hasMap()) {
                throw new NucleusException("Dont currently support retrieval of map field values");
            }
            if (ammd.hasArray()) {
                Collection arrIds = (Collection)value;
                Object array = Array.newInstance(ammd.getType().getComponentType(), arrIds.size());
                Iterator idIter = arrIds.iterator();
                int i = 0;
                while (idIter.hasNext()) {
                    Object elementId = idIter.next();
                    Array.set(array, i, this.ec.findObject(elementId, true, true, null));
                }
                return array;
            }
            return value;
        }
        ObjectStringConverter strConv = this.ec.getNucleusContext().getTypeManager().getStringConverter(value.getClass());
        if (!ammd.isSerialized() && strConv != null) {
            String strValue = (String)value;
            return strConv.toObject(strValue);
        }
        return value;
    }
}

