/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mongodb.MongoDBPersistenceHandler;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.schema.SchemaAwareStoreManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoDBStoreManager
extends AbstractStoreManager
implements SchemaAwareStoreManager {
    public MongoDBStoreManager(ClassLoaderResolver clr, NucleusContext nucleusCtx, Map<String, Object> props) {
        super("mongodb", clr, nucleusCtx, props);
        this.persistenceHandler = new MongoDBPersistenceHandler((StoreManager)this);
        this.logConfiguration();
    }

    protected void registerConnectionMgr() {
        super.registerConnectionMgr();
        this.connectionMgr.disableConnectionPool();
    }

    public NucleusConnection getNucleusConnection(ObjectManager om) {
        throw new UnsupportedOperationException();
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationIdentity");
        set.add("DatastoreIdentity");
        set.add("ORM");
        set.add("TransactionIsolationLevel.read-committed");
        return set;
    }

    public void addClasses(String[] classNames, ClassLoaderResolver clr) {
        if (classNames == null) {
            return;
        }
        String[] filteredClassNames = this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        for (ClassMetaData cmd : this.getMetaDataManager().getReferencedClasses(filteredClassNames, clr)) {
            StoreData sd;
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || this.storeDataMgr.managesClass(cmd.getFullClassName()) || (sd = this.storeDataMgr.get(cmd.getFullClassName())) != null) continue;
            this.registerStoreData(this.newStoreData(cmd, clr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(Set<String> classNames, Properties props) {
        ManagedConnection mconn = this.getConnection(-1);
        try {
            DB db = (DB)mconn.getConnection();
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                String className = classIter.next();
                AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                db.getCollection(MongoDBUtils.getCollectionName(cmd));
            }
        }
        finally {
            mconn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchema(Set<String> classNames) {
        ManagedConnection mconn = this.getConnection(-1);
        try {
            DB db = (DB)mconn.getConnection();
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                String className = classIter.next();
                AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                DBCollection collection = db.getCollection(MongoDBUtils.getCollectionName(cmd));
                collection.drop();
            }
        }
        finally {
            mconn.close();
        }
    }

    public void validateSchema(Set<String> classNames) {
        Iterator<String> classIter = classNames.iterator();
        ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
        while (classIter.hasNext()) {
            String className = classIter.next();
            AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
            if (cmd == null) continue;
        }
    }
}

