/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.DB;
import com.mongodb.Mongo;
import java.net.UnknownHostException;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.util.NucleusLogger;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    String serverName = "localhost";
    String dbName = "DataNucleus";

    public ConnectionFactoryImpl(StoreManager storeMgr, String resourceType) {
        super(storeMgr, resourceType);
        String url = storeMgr.getConnectionURL();
        if (url == null) {
            throw new NucleusException("You haven't specified persistence property 'datanucleus.ConnectionURL' (or alias)");
        }
        String remains = url.substring(7).trim();
        if (remains == null || remains.length() == 0) {
            NucleusLogger.GENERAL.info((Object)">> MongoDB localhost DataNucleus");
            return;
        }
        if (remains.indexOf(58) != 0) {
            throw new NucleusException("Invalid URL " + url);
        }
        if ((remains = remains.substring(1)).charAt(0) != '/') {
            int serverEndPos = remains.indexOf(47);
            if (serverEndPos > 0) {
                this.serverName = remains.substring(0, serverEndPos);
                remains = remains.substring(serverEndPos);
            } else {
                this.serverName = remains;
                remains = "";
            }
        }
        if (remains.charAt(0) == '/' && remains.length() > 1) {
            this.dbName = remains.substring(1);
        }
    }

    public ManagedConnection createManagedConnection(Object poolKey, Map transactionOptions) {
        return new ManagedConnectionImpl(transactionOptions);
    }

    public class ManagedConnectionImpl
    extends AbstractManagedConnection {
        Map options;

        public ManagedConnectionImpl(Map options) {
            this.options = options;
        }

        public Object getConnection() {
            if (this.conn == null) {
                try {
                    Mongo mongo = new Mongo(ConnectionFactoryImpl.this.serverName);
                    this.conn = mongo.getDB(ConnectionFactoryImpl.this.dbName);
                }
                catch (UnknownHostException e) {
                    throw new NucleusDataStoreException("Unable to connect to mongodb", (Throwable)e);
                }
            }
            return this.conn;
        }

        public void close() {
            if (this.conn == null) {
                return;
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            DB db = (DB)this.conn;
            db.getMongo().close();
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
            }
        }

        public XAResource getXAResource() {
            return null;
        }
    }
}

