/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.CalendarToGeneralizedTimeStringConverter;
import org.datanucleus.store.ldap.fieldmanager.DateToGeneralizedTimeStringConverter;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.ArrayConversionHelper;

public class SimpleContainerHelper {
    public static Collection fetchCollection(AbstractMemberMetaData mmd, Attribute attr, TypeManager typeMgr, ClassLoaderResolver clr) {
        boolean singleAttribute = false;
        Class type = clr.classForName(mmd.getCollection().getElementType());
        Object[] values = null;
        if (attr == null) {
            values = new Object[]{};
        } else if (String.class.isAssignableFrom(type)) {
            values = SimpleContainerHelper.fetchStringArrayField(attr, singleAttribute, mmd);
        } else if (Boolean.class.isAssignableFrom(type)) {
            values = SimpleContainerHelper.fetchBooleanObjectArrayField(attr, singleAttribute, mmd);
        } else if (Byte.class.isAssignableFrom(type)) {
            values = SimpleContainerHelper.fetchByteObjectArrayField(attr, singleAttribute, mmd);
        } else if (Character.class.isAssignableFrom(type)) {
            values = SimpleContainerHelper.fetchCharacterObjectArrayField(attr, singleAttribute, mmd);
        } else if (Double.class.isAssignableFrom(type)) {
            values = SimpleContainerHelper.fetchDoubleObjectArrayField(attr, singleAttribute, mmd);
        } else if (Float.class.isAssignableFrom(type)) {
            values = SimpleContainerHelper.fetchFloatObjectArrayField(attr, singleAttribute, mmd);
        } else if (Integer.class.isAssignableFrom(type)) {
            values = SimpleContainerHelper.fetchIntegerObjectArrayField(attr, singleAttribute, mmd);
        } else if (Long.class.isAssignableFrom(type)) {
            values = SimpleContainerHelper.fetchLongObjectArrayField(attr, singleAttribute, mmd);
        } else if (Short.class.isAssignableFrom(type)) {
            values = SimpleContainerHelper.fetchShortObjectArrayField(attr, singleAttribute, mmd);
        } else {
            Object converter = null;
            converter = Date.class.isAssignableFrom(type) ? new DateToGeneralizedTimeStringConverter() : (Calendar.class.isAssignableFrom(type) ? new CalendarToGeneralizedTimeStringConverter() : typeMgr.getTypeConverterForType(type, String.class));
            if (converter != null) {
                String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, singleAttribute, mmd);
                values = (Object[])Array.newInstance(type, stringValues.length);
                for (int i = 0; i < stringValues.length; ++i) {
                    values[i] = converter.toMemberType(stringValues[i]);
                }
            } else if (type.isEnum()) {
                values = SimpleContainerHelper.fetchEnumArrayField(attr, singleAttribute, mmd, type);
            }
        }
        if (values != null) {
            Collection collection;
            Class instanceType = mmd.getType();
            instanceType = SCOUtils.getContainerInstanceType((Class)instanceType, (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
            try {
                collection = (Collection)instanceType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            collection.addAll(Arrays.asList(values));
            return collection;
        }
        throw new NucleusException("Cant obtain value for field " + mmd.getFullFieldName() + " since type=" + mmd.getTypeName() + " is not supported for this datastore");
    }

    public static Object fetchArray(AbstractMemberMetaData mmd, Attribute attr, TypeManager typeMgr) {
        boolean singleAttribute = mmd.getJoinMetaData() == null;
        Class<?> type = mmd.getType().getComponentType();
        if (attr == null) {
            return null;
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            return SimpleContainerHelper.fetchBooleanArrayField(attr, singleAttribute, mmd);
        }
        if (Byte.TYPE.isAssignableFrom(type)) {
            return SimpleContainerHelper.fetchByteArrayField(attr, singleAttribute, mmd);
        }
        if (Character.TYPE.isAssignableFrom(type)) {
            return SimpleContainerHelper.fetchCharArrayField(attr, singleAttribute, mmd);
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return SimpleContainerHelper.fetchDoubleArrayField(attr, singleAttribute, mmd);
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return SimpleContainerHelper.fetchFloatArrayField(attr, singleAttribute, mmd);
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return SimpleContainerHelper.fetchIntArrayField(attr, singleAttribute, mmd);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return SimpleContainerHelper.fetchLongArrayField(attr, singleAttribute, mmd);
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            return SimpleContainerHelper.fetchShortArrayField(attr, singleAttribute, mmd);
        }
        if (String.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.fetchStringArrayField(attr, singleAttribute, mmd);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.fetchBooleanObjectArrayField(attr, singleAttribute, mmd);
        }
        if (Byte.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.fetchByteObjectArrayField(attr, singleAttribute, mmd);
        }
        if (Character.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.fetchCharacterObjectArrayField(attr, singleAttribute, mmd);
        }
        if (Double.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.fetchDoubleObjectArrayField(attr, singleAttribute, mmd);
        }
        if (Float.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.fetchFloatObjectArrayField(attr, singleAttribute, mmd);
        }
        if (Integer.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.fetchIntegerObjectArrayField(attr, singleAttribute, mmd);
        }
        if (Long.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.fetchLongObjectArrayField(attr, singleAttribute, mmd);
        }
        if (Short.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.fetchShortObjectArrayField(attr, singleAttribute, mmd);
        }
        Object converter = null;
        converter = Date.class.isAssignableFrom(type) ? new DateToGeneralizedTimeStringConverter() : (Calendar.class.isAssignableFrom(type) ? new CalendarToGeneralizedTimeStringConverter() : typeMgr.getTypeConverterForType(type, String.class));
        if (converter != null) {
            String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, singleAttribute, mmd);
            Object[] values = (Object[])Array.newInstance(type, stringValues.length);
            for (int i = 0; i < stringValues.length; ++i) {
                values[i] = converter.toMemberType(stringValues[i]);
            }
            return values;
        }
        if (type.isEnum()) {
            return SimpleContainerHelper.fetchEnumArrayField(attr, singleAttribute, mmd, type);
        }
        throw new NucleusException("Cant obtain value for field " + mmd.getFullFieldName() + " since type=" + mmd.getTypeName() + " is not supported for this datastore");
    }

    protected static boolean[] fetchBooleanArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return ArrayConversionHelper.getBooleanArrayFromByteArray((byte[])SimpleContainerHelper.fetchByteArrayField(attr, true, mmd));
        }
        String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, false, mmd);
        boolean[] values = new boolean[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Boolean.valueOf(stringValues[i]);
        }
        return values;
    }

    protected static Boolean[] fetchBooleanObjectArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return ArrayConversionHelper.getBooleanObjectArrayFromByteArray((byte[])SimpleContainerHelper.fetchByteArrayField(attr, true, mmd));
        }
        String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, false, mmd);
        Boolean[] values = new Boolean[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Boolean.valueOf(stringValues[i]);
        }
        return values;
    }

    protected static Byte[] fetchByteObjectArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return ArrayConversionHelper.getByteObjectArrayFromByteArray((byte[])SimpleContainerHelper.fetchByteArrayField(attr, true, mmd));
        }
        String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, false, mmd);
        Byte[] values = new Byte[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Byte.valueOf(stringValues[i]);
        }
        return values;
    }

    protected static char[] fetchCharArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return ArrayConversionHelper.getCharArrayFromByteArray((byte[])SimpleContainerHelper.fetchByteArrayField(attr, true, mmd));
        }
        String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, false, mmd);
        char[] values = new char[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = stringValues[i].charAt(0);
        }
        return values;
    }

    protected static Character[] fetchCharacterObjectArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return ArrayConversionHelper.getCharObjectArrayFromByteArray((byte[])SimpleContainerHelper.fetchByteArrayField(attr, true, mmd));
        }
        String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, false, mmd);
        Character[] values = new Character[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Character.valueOf(stringValues[i].charAt(0));
        }
        return values;
    }

    protected static double[] fetchDoubleArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return ArrayConversionHelper.getDoubleArrayFromByteArray((byte[])SimpleContainerHelper.fetchByteArrayField(attr, true, mmd));
        }
        String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, false, mmd);
        double[] values = new double[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Double.valueOf(stringValues[i]);
        }
        return values;
    }

    protected static Double[] fetchDoubleObjectArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return ArrayConversionHelper.getDoubleObjectArrayFromByteArray((byte[])SimpleContainerHelper.fetchByteArrayField(attr, true, mmd));
        }
        String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, false, mmd);
        Double[] values = new Double[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Double.valueOf(stringValues[i]);
        }
        return values;
    }

    protected static float[] fetchFloatArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return ArrayConversionHelper.getFloatArrayFromByteArray((byte[])SimpleContainerHelper.fetchByteArrayField(attr, true, mmd));
        }
        String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, false, mmd);
        float[] values = new float[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Float.valueOf(stringValues[i]).floatValue();
        }
        return values;
    }

    protected static Float[] fetchFloatObjectArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return ArrayConversionHelper.getFloatObjectArrayFromByteArray((byte[])SimpleContainerHelper.fetchByteArrayField(attr, true, mmd));
        }
        String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, false, mmd);
        Float[] values = new Float[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Float.valueOf(stringValues[i]);
        }
        return values;
    }

    protected static int[] fetchIntArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return ArrayConversionHelper.getIntArrayFromByteArray((byte[])SimpleContainerHelper.fetchByteArrayField(attr, true, mmd));
        }
        String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, false, mmd);
        int[] values = new int[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Integer.valueOf(stringValues[i]);
        }
        return values;
    }

    protected static Integer[] fetchIntegerObjectArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return ArrayConversionHelper.getIntObjectArrayFromByteArray((byte[])SimpleContainerHelper.fetchByteArrayField(attr, true, mmd));
        }
        String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, false, mmd);
        Integer[] values = new Integer[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Integer.valueOf(stringValues[i]);
        }
        return values;
    }

    protected static long[] fetchLongArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return ArrayConversionHelper.getLongArrayFromByteArray((byte[])SimpleContainerHelper.fetchByteArrayField(attr, true, mmd));
        }
        String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, false, mmd);
        long[] values = new long[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Long.valueOf(stringValues[i]);
        }
        return values;
    }

    protected static Long[] fetchLongObjectArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return ArrayConversionHelper.getLongObjectArrayFromByteArray((byte[])SimpleContainerHelper.fetchByteArrayField(attr, true, mmd));
        }
        String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, false, mmd);
        Long[] values = new Long[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Long.valueOf(stringValues[i]);
        }
        return values;
    }

    protected static short[] fetchShortArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return ArrayConversionHelper.getShortArrayFromByteArray((byte[])SimpleContainerHelper.fetchByteArrayField(attr, true, mmd));
        }
        String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, false, mmd);
        short[] values = new short[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Short.valueOf(stringValues[i]);
        }
        return values;
    }

    protected static Short[] fetchShortObjectArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return ArrayConversionHelper.getShortObjectArrayFromByteArray((byte[])SimpleContainerHelper.fetchByteArrayField(attr, true, mmd));
        }
        String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, false, mmd);
        Short[] values = new Short[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Short.valueOf(stringValues[i]);
        }
        return values;
    }

    protected static Enum[] fetchEnumArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd, Class type) {
        String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, singleAttribute, mmd);
        Enum[] values = (Enum[])Array.newInstance(type, stringValues.length);
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Enum.valueOf(type, stringValues[i]);
        }
        return values;
    }

    protected static byte[] fetchByteArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            if (attr.size() == 0) {
                return null;
            }
            if (attr.size() == 1) {
                try {
                    Object object = attr.get();
                    if (object instanceof byte[]) {
                        return (byte[])object;
                    }
                    throw new NucleusException("Not a byte[]");
                }
                catch (NamingException e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
            }
            throw new NucleusException("Can't fetch embedded byte[] from multi-valued attribute.");
        }
        String[] stringValues = SimpleContainerHelper.fetchStringArrayField(attr, false, mmd);
        byte[] values = new byte[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Byte.valueOf(stringValues[i]);
        }
        return values;
    }

    protected static String[] fetchStringArrayField(Attribute attr, boolean singleAttribute, AbstractMemberMetaData mmd) {
        try {
            String[] values = new String[attr.size()];
            for (int i = 0; i < attr.size(); ++i) {
                values[i] = attr.get(i) instanceof byte[] ? new String((byte[])attr.get(i), "UTF-8") : (String)attr.get(i);
            }
            if (mmd.getOrderMetaData() != null) {
                TreeMap<Integer, String> orderingMap = new TreeMap<Integer, String>();
                for (String value : values) {
                    int left = value.indexOf(123);
                    int right = value.indexOf(125);
                    if (left == 0 && right > 0) {
                        try {
                            String number = value.substring(left + 1, right);
                            Integer integer = Integer.valueOf(number);
                            value = value.substring(right + 1);
                            if (orderingMap.containsKey(integer)) {
                                throw new NucleusDataStoreException("Ordering index must be unique: " + value);
                            }
                            orderingMap.put(integer, value);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new NucleusDataStoreException("Can't parse ordering index: " + value);
                        }
                    }
                    throw new NucleusDataStoreException("No ordering index at value: " + value);
                }
                values = orderingMap.values().toArray(new String[orderingMap.size()]);
            }
            return values;
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public static Attribute storeCollection(AbstractMemberMetaData mmd, Object value, TypeManager typeMgr, ClassLoaderResolver clr) {
        boolean singleAttribute = false;
        Class type = clr.classForName(mmd.getCollection().getElementType());
        Collection valueCollection = (Collection)value;
        Object[] values = valueCollection.toArray();
        if (String.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeObjectArrayField(values, singleAttribute, mmd);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeBooleanObjectArrayField(valueCollection.toArray(new Boolean[0]), singleAttribute, mmd);
        }
        if (Byte.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeByteObjectArrayField(valueCollection.toArray(new Byte[0]), singleAttribute, mmd);
        }
        if (Character.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeCharacterObjectArrayField(valueCollection.toArray(new Character[0]), singleAttribute, mmd);
        }
        if (Double.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeDoubleObjectArrayField(valueCollection.toArray(new Double[0]), singleAttribute, mmd);
        }
        if (Float.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeFloatObjectArrayField(valueCollection.toArray(new Float[0]), singleAttribute, mmd);
        }
        if (Integer.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeIntegerObjectArrayField(valueCollection.toArray(new Integer[0]), singleAttribute, mmd);
        }
        if (Long.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeLongObjectArrayField(valueCollection.toArray(new Long[0]), singleAttribute, mmd);
        }
        if (Short.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeShortObjectArrayField(valueCollection.toArray(new Short[0]), singleAttribute, mmd);
        }
        Object converter = null;
        converter = Date.class.isAssignableFrom(type) ? new DateToGeneralizedTimeStringConverter() : (Calendar.class.isAssignableFrom(type) ? new CalendarToGeneralizedTimeStringConverter() : typeMgr.getTypeConverterForType(type, String.class));
        if (converter != null) {
            Object[] stringValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                stringValues[i] = (String)converter.toDatastoreType(values[i]);
            }
            return SimpleContainerHelper.storeObjectArrayField(stringValues, singleAttribute, mmd);
        }
        if (type.isEnum()) {
            return SimpleContainerHelper.storeObjectArrayField(values, singleAttribute, mmd);
        }
        throw new NucleusException("Field " + mmd.getFullFieldName() + " cannot be persisted because type=" + mmd.getTypeName() + " is not supported for this datastore");
    }

    public static Attribute storeArray(AbstractMemberMetaData mmd, Object value, TypeManager typeMgr) {
        boolean singleAttribute = mmd.getJoinMetaData() == null;
        Class<?> type = mmd.getType().getComponentType();
        if (Boolean.TYPE.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeBooleanArrayField((boolean[])value, singleAttribute, mmd);
        }
        if (Byte.TYPE.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeByteArrayField((byte[])value, singleAttribute, mmd);
        }
        if (Character.TYPE.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeCharArrayField((char[])value, singleAttribute, mmd);
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeDoubleArrayField((double[])value, singleAttribute, mmd);
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeFloatArrayField((float[])value, singleAttribute, mmd);
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeIntArrayField((int[])value, singleAttribute, mmd);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeLongArrayField((long[])value, singleAttribute, mmd);
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeShortArrayField((short[])value, singleAttribute, mmd);
        }
        if (String.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeObjectArrayField((String[])value, singleAttribute, mmd);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeBooleanObjectArrayField((Boolean[])value, singleAttribute, mmd);
        }
        if (Byte.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeByteObjectArrayField((Byte[])value, singleAttribute, mmd);
        }
        if (Character.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeCharacterObjectArrayField((Character[])value, singleAttribute, mmd);
        }
        if (Double.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeDoubleObjectArrayField((Double[])value, singleAttribute, mmd);
        }
        if (Float.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeFloatObjectArrayField((Float[])value, singleAttribute, mmd);
        }
        if (Integer.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeIntegerObjectArrayField((Integer[])value, singleAttribute, mmd);
        }
        if (Long.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeLongObjectArrayField((Long[])value, singleAttribute, mmd);
        }
        if (Short.class.isAssignableFrom(type)) {
            return SimpleContainerHelper.storeShortObjectArrayField((Short[])value, singleAttribute, mmd);
        }
        Object converter = null;
        converter = Date.class.isAssignableFrom(type) ? new DateToGeneralizedTimeStringConverter() : (Calendar.class.isAssignableFrom(type) ? new CalendarToGeneralizedTimeStringConverter() : typeMgr.getTypeConverterForType(type, String.class));
        if (converter != null) {
            Object[] values = (Object[])value;
            Object[] stringValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                stringValues[i] = (String)converter.toDatastoreType(values[i]);
            }
            return SimpleContainerHelper.storeObjectArrayField(stringValues, singleAttribute, mmd);
        }
        if (type.isEnum()) {
            return SimpleContainerHelper.storeObjectArrayField((Enum[])value, singleAttribute, mmd);
        }
        throw new NucleusException("Field " + mmd.getFullFieldName() + " cannot be persisted because type=" + mmd.getTypeName() + " is not supported for this datastore");
    }

    protected static Attribute storeBooleanArrayField(boolean[] values, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return SimpleContainerHelper.storeByteArrayField(ArrayConversionHelper.getByteArrayFromBooleanArray((boolean[])values), true, mmd);
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (boolean v : values) {
            strings.add(("" + v).toUpperCase());
        }
        return SimpleContainerHelper.storeStringList(strings, mmd);
    }

    protected static Attribute storeBooleanObjectArrayField(Boolean[] values, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return SimpleContainerHelper.storeByteArrayField(ArrayConversionHelper.getByteArrayFromBooleanObjectArray((Boolean[])values), true, mmd);
        }
        ArrayList<String> strings = new ArrayList<String>();
        Boolean[] booleanArray = values;
        int n = booleanArray.length;
        for (int i = 0; i < n; ++i) {
            boolean v = booleanArray[i];
            strings.add(("" + v).toUpperCase());
        }
        return SimpleContainerHelper.storeStringList(strings, mmd);
    }

    protected static Attribute storeByteArrayField(byte[] values, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            String name = LDAPUtils.getAttributeNameForField(mmd);
            return new BasicAttribute(name, values);
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (byte v : values) {
            strings.add("" + v);
        }
        return SimpleContainerHelper.storeStringList(strings, mmd);
    }

    protected static Attribute storeByteObjectArrayField(Byte[] values, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return SimpleContainerHelper.storeByteArrayField(ArrayConversionHelper.getByteArrayFromByteObjectArray((Byte[])values), true, mmd);
        }
        return SimpleContainerHelper.storeObjectArrayField(values, false, mmd);
    }

    protected static Attribute storeCharArrayField(char[] values, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return SimpleContainerHelper.storeByteArrayField(ArrayConversionHelper.getByteArrayFromCharArray((char[])values), true, mmd);
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (char v : values) {
            strings.add("" + v);
        }
        return SimpleContainerHelper.storeStringList(strings, mmd);
    }

    protected static Attribute storeCharacterObjectArrayField(Character[] values, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return SimpleContainerHelper.storeByteArrayField(ArrayConversionHelper.getByteArrayFromCharObjectArray((Character[])values), true, mmd);
        }
        return SimpleContainerHelper.storeObjectArrayField(values, false, mmd);
    }

    protected static Attribute storeDoubleArrayField(double[] values, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return SimpleContainerHelper.storeByteArrayField(ArrayConversionHelper.getByteArrayFromDoubleArray((double[])values), true, mmd);
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (double v : values) {
            strings.add("" + v);
        }
        return SimpleContainerHelper.storeStringList(strings, mmd);
    }

    protected static Attribute storeDoubleObjectArrayField(Double[] values, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return SimpleContainerHelper.storeByteArrayField(ArrayConversionHelper.getByteArrayFromDoubleObjectArray((Double[])values), true, mmd);
        }
        return SimpleContainerHelper.storeObjectArrayField(values, false, mmd);
    }

    protected static Attribute storeFloatArrayField(float[] values, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return SimpleContainerHelper.storeByteArrayField(ArrayConversionHelper.getByteArrayFromFloatArray((float[])values), true, mmd);
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (float v : values) {
            strings.add("" + v);
        }
        return SimpleContainerHelper.storeStringList(strings, mmd);
    }

    protected static Attribute storeFloatObjectArrayField(Float[] values, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return SimpleContainerHelper.storeByteArrayField(ArrayConversionHelper.getByteArrayFromFloatObjectArray((Float[])values), true, mmd);
        }
        return SimpleContainerHelper.storeObjectArrayField(values, false, mmd);
    }

    protected static Attribute storeIntArrayField(int[] values, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return SimpleContainerHelper.storeByteArrayField(ArrayConversionHelper.getByteArrayFromIntArray((int[])values), true, mmd);
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (int v : values) {
            strings.add("" + v);
        }
        return SimpleContainerHelper.storeStringList(strings, mmd);
    }

    protected static Attribute storeIntegerObjectArrayField(Integer[] values, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return SimpleContainerHelper.storeByteArrayField(ArrayConversionHelper.getByteArrayFromIntObjectArray((Integer[])values), true, mmd);
        }
        return SimpleContainerHelper.storeObjectArrayField(values, false, mmd);
    }

    protected static Attribute storeLongArrayField(long[] values, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return SimpleContainerHelper.storeByteArrayField(ArrayConversionHelper.getByteArrayFromLongArray((long[])values), true, mmd);
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (long v : values) {
            strings.add("" + v);
        }
        return SimpleContainerHelper.storeStringList(strings, mmd);
    }

    protected static Attribute storeLongObjectArrayField(Long[] values, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return SimpleContainerHelper.storeByteArrayField(ArrayConversionHelper.getByteArrayFromLongObjectArray((Long[])values), true, mmd);
        }
        return SimpleContainerHelper.storeObjectArrayField(values, false, mmd);
    }

    protected static Attribute storeShortArrayField(short[] values, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return SimpleContainerHelper.storeByteArrayField(ArrayConversionHelper.getByteArrayFromShortArray((short[])values), true, mmd);
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (short v : values) {
            strings.add("" + v);
        }
        return SimpleContainerHelper.storeStringList(strings, mmd);
    }

    protected static Attribute storeShortObjectArrayField(Short[] values, boolean singleAttribute, AbstractMemberMetaData mmd) {
        if (singleAttribute) {
            return SimpleContainerHelper.storeByteArrayField(ArrayConversionHelper.getByteArrayFromShortObjectArray((Short[])values), true, mmd);
        }
        return SimpleContainerHelper.storeObjectArrayField(values, false, mmd);
    }

    protected static Attribute storeObjectArrayField(Object[] values, boolean singleAttribute, AbstractMemberMetaData mmd) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Object v : values) {
            strings.add("" + v);
        }
        return SimpleContainerHelper.storeStringList(strings, mmd);
    }

    protected static Attribute storeStringList(List<String> values, AbstractMemberMetaData mmd) {
        String name = LDAPUtils.getAttributeNameForField(mmd);
        BasicAttribute attribute = new BasicAttribute(name);
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            if (mmd.getOrderMetaData() != null) {
                value = "{" + i + "}" + (String)value;
            }
            attribute.add(value);
        }
        return attribute;
    }
}

