/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.util.Calendar;
import java.util.Date;
import javax.naming.directory.Attributes;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.EmbeddedMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.RelationByAttributeMetaData;
import org.datanucleus.store.ldap.fieldmanager.RelationByAttributeStrategy;
import org.datanucleus.store.ldap.fieldmanager.RelationByDnMetaData;
import org.datanucleus.store.ldap.fieldmanager.RelationByDnStrategy;
import org.datanucleus.store.ldap.fieldmanager.RelationByHierarchyStrategy;
import org.datanucleus.store.ldap.fieldmanager.SimpleArrayMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.SimpleCollectionMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.SimpleMappingStrategy;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.NucleusLogger;

public class MappingStrategyHelper {
    public static AbstractMappingStrategy findMappingStrategy(StoreManager storeMgr, DNStateManager sm, AbstractMemberMetaData mmd, Attributes attributes) {
        boolean isRelationByAttribute;
        String mappingStrategy;
        MetaDataManager mmgr = storeMgr.getMetaDataManager();
        ClassLoaderResolver clr = sm.getExecutionContext().getClassLoaderResolver();
        RelationType relType = mmd.getRelationType(clr);
        if (relType == RelationType.NONE) {
            Class type = mmd.getType();
            boolean isArray = type.isArray();
            boolean isCollection = mmd.hasCollection();
            if (isArray) {
                type = type.getComponentType();
            } else if (isCollection) {
                type = sm.getExecutionContext().getClassLoaderResolver().classForName(mmd.getCollection().getElementType());
            }
            if (MappingStrategyHelper.isBasicTypeSupported(type)) {
                if (isArray) {
                    NucleusLogger.GENERAL.info((Object)(">> getMappingStrategy ARRAY " + mmd.getFullFieldName()));
                    return new SimpleArrayMappingStrategy(sm, mmd, attributes);
                }
                if (isCollection) {
                    NucleusLogger.GENERAL.info((Object)(">> getMappingStrategy COLLECTION " + mmd.getFullFieldName()));
                    return new SimpleCollectionMappingStrategy(sm, mmd, attributes);
                }
                return new SimpleMappingStrategy(sm, mmd, attributes);
            }
            TypeConverter converter = storeMgr.getNucleusContext().getTypeManager().getTypeConverterForType(type, String.class);
            if (converter != null) {
                if (isArray) {
                    NucleusLogger.GENERAL.info((Object)(">> getMappingStrategy ARRAY " + mmd.getFullFieldName()));
                    return new SimpleArrayMappingStrategy(sm, mmd, attributes);
                }
                if (isCollection) {
                    NucleusLogger.GENERAL.info((Object)(">> getMappingStrategy COLLECTION " + mmd.getFullFieldName()));
                    return new SimpleCollectionMappingStrategy(sm, mmd, attributes);
                }
                return new SimpleMappingStrategy(sm, mmd, attributes);
            }
            return null;
        }
        if (LDAPUtils.isEmbeddedField(mmd)) {
            return new EmbeddedMappingStrategy(storeMgr, sm, mmd, attributes);
        }
        if (mmd.hasExtension("mapping-strategy") && (mappingStrategy = mmd.getValueForExtension("mapping-strategy")) != null) {
            if (mappingStrategy.equalsIgnoreCase("dn")) {
                return new RelationByDnStrategy(storeMgr, sm, mmd, attributes);
            }
            if (mappingStrategy.equalsIgnoreCase("attribute")) {
                return new RelationByAttributeStrategy(storeMgr, sm, mmd, attributes);
            }
        }
        if (isRelationByAttribute = RelationByAttributeMetaData.isRelationByAttribute(mmd, mmgr)) {
            return new RelationByAttributeStrategy(storeMgr, sm, mmd, attributes);
        }
        boolean isFieldHierarchicalMapped = RelationByHierarchyStrategy.isChildOfHierarchicalMapping(mmd, mmgr);
        boolean isFieldParentOfHierarchicalMapping = RelationByHierarchyStrategy.isParentOfHierarchicalMapping(mmd, mmgr);
        if (isFieldHierarchicalMapped || isFieldParentOfHierarchicalMapping) {
            return new RelationByHierarchyStrategy(storeMgr, sm, mmd, attributes);
        }
        boolean isRelationByDn = RelationByDnMetaData.isRelationByDn(mmd, mmgr);
        if (isRelationByDn) {
            return new RelationByDnStrategy(storeMgr, sm, mmd, attributes);
        }
        return null;
    }

    public static final boolean isBasicTypeSupported(Class type) {
        if (type == null) {
            return false;
        }
        return type.isPrimitive() || String.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || Calendar.class.isAssignableFrom(type) || type.isEnum();
    }
}

