/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.RelationByDnMetaData;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class RelationByDnStrategy
extends AbstractMappingStrategy {
    protected int fieldNumber;
    protected StoreManager storeMgr;
    protected ClassLoaderResolver clr;
    protected AbstractClassMetaData effectiveClassMetaData;
    protected RelationByDnMetaData mappingMetaData;

    protected RelationByDnStrategy(StoreManager storeMgr, ObjectProvider sm, AbstractMemberMetaData mmd, Attributes attributes) {
        super(sm, mmd, attributes);
        this.fieldNumber = mmd.getAbsoluteFieldNumber();
        this.storeMgr = storeMgr;
        this.clr = this.ec.getClassLoaderResolver();
        this.effectiveClassMetaData = LDAPUtils.getEffectiveClassMetaData(mmd, this.ec.getMetaDataManager());
        this.mappingMetaData = new RelationByDnMetaData(mmd, this.ec.getMetaDataManager());
        if (this.mappingMetaData.getOwnerAttributeName() == null) {
            throw new NucleusUserException("Member " + mmd.getFullFieldName() + " stores multiple values and has owner LDAP attribute as NULL. The metadata is incorrect and needs to set this.");
        }
    }

    @Override
    public Object fetch() {
        String ownerAttributeName = this.mappingMetaData.getOwnerAttributeName();
        String emptyValue = this.mappingMetaData.getEmptyValue();
        RelationType relationType = this.mmd.getRelationType(this.clr);
        if (this.mappingMetaData.getNonOwnerMMD() == this.mmd) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                return this.getDnMappedReference(this.effectiveClassMetaData, ownerAttributeName, this.op);
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType) && this.mmd.hasCollection()) {
                Collection<Object> coll = this.getDnMappedReferences(this.effectiveClassMetaData, this.mmd, ownerAttributeName, this.op);
                return this.op.wrapSCOField(this.fieldNumber, coll, false, false, true);
            }
            throw new NucleusException(Localiser.msg((String)"LDAP.Retrieve.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getRelationType(this.clr)}));
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            try {
                return this.attr != null ? LDAPUtils.getObjectByDN(this.storeMgr, this.ec, this.mmd.getType(), (String)this.attr.get(0)) : null;
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType) && this.mmd.hasCollection()) {
            Collection coll = null;
            Class instanceType = this.mmd.getType();
            instanceType = SCOUtils.getContainerInstanceType((Class)instanceType, (Boolean)(this.mmd.getOrderMetaData() != null ? 1 : 0));
            try {
                coll = (Collection)instanceType.newInstance();
                Class elementType = this.clr.classForName(this.mmd.getCollection().getElementType());
                RelationByDnStrategy.removeEmptyValue(emptyValue, this.attr);
                for (int i = 0; this.attr != null && i < this.attr.size(); ++i) {
                    coll.add(LDAPUtils.getObjectByDN(this.storeMgr, this.ec, elementType, (String)this.attr.get(i)));
                }
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw new NucleusException("Error in trying to create object of type " + instanceType.getName(), (Throwable)e);
            }
            return this.op.wrapSCOField(this.fieldNumber, (Object)coll, false, false, true);
        }
        throw new NucleusException(Localiser.msg((String)"LDAP.Retrieve.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getRelationType(this.clr)}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void insert(Object value) {
        if (value == null) return;
        String ownerAttributeName = this.mappingMetaData.getOwnerAttributeName();
        String emptyValue = this.mappingMetaData.getEmptyValue();
        RelationType relationType = this.mmd.getRelationType(this.clr);
        if (this.mappingMetaData.getNonOwnerMMD() == this.mmd) {
            LdapName myDN = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, this.op);
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                this.addDnReference(value, ownerAttributeName, myDN, emptyValue);
                return;
            } else {
                if (!RelationType.isRelationMultiValued((RelationType)relationType)) throw new NucleusException(Localiser.msg((String)"LDAP.Persist.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getTypeName(), this.mmd.getRelationType(this.clr)}));
                if (!this.mmd.hasCollection()) return;
                Collection c = (Collection)value;
                for (Object pc : c) {
                    LDAPUtils.unmarkForDeletion(pc, this.ec);
                    this.addDnReference(pc, ownerAttributeName, myDN, emptyValue);
                }
            }
            return;
        } else if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            ObjectProvider pcSM = this.ec.findObjectProvider(value, true);
            LdapName pcDN = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, pcSM);
            BasicAttribute attr = new BasicAttribute(ownerAttributeName, pcDN.toString());
            RelationByDnStrategy.addEmptyValue(emptyValue, attr);
            this.attributes.put(attr);
            return;
        } else {
            if (!RelationType.isRelationMultiValued((RelationType)relationType)) throw new NucleusException(Localiser.msg((String)"LDAP.Persist.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getTypeName(), this.mmd.getRelationType(this.clr)}));
            if (!this.mmd.hasCollection()) return;
            Collection c = (Collection)value;
            BasicAttribute attr = new BasicAttribute(this.name);
            for (Object pc : c) {
                ObjectProvider pcSM = this.ec.findObjectProvider(pc, true);
                attr.add(LDAPUtils.getDistinguishedNameForObject(this.storeMgr, pcSM).toString());
            }
            RelationByDnStrategy.addEmptyValue(emptyValue, attr);
            if (attr.size() <= 0) return;
            this.attributes.put(attr);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update(Object value) {
        if (value != null) {
            LDAPUtils.unmarkForDeletion(this.op.getObject(), this.ec);
        }
        String ownerAttributeName = this.mappingMetaData.getOwnerAttributeName();
        String emptyValue = this.mappingMetaData.getEmptyValue();
        RelationType relationType = this.mmd.getRelationType(this.clr);
        if (this.mappingMetaData.getNonOwnerMMD() == this.mmd) {
            LdapName myDN = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, this.op);
            if (value != null) {
                if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                    Object oldValue = this.getDnMappedReference(this.effectiveClassMetaData, ownerAttributeName, this.op);
                    if (value.equals(oldValue)) return;
                    LDAPUtils.markForPersisting(value, this.ec);
                    LDAPUtils.unmarkForDeletion(value, this.ec);
                    this.removeDnReference(oldValue, ownerAttributeName, myDN, emptyValue);
                    this.addDnReference(value, ownerAttributeName, myDN, emptyValue);
                    return;
                } else {
                    if (!RelationType.isRelationMultiValued((RelationType)relationType)) throw new NucleusException(Localiser.msg((String)"LDAP.Persist.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getTypeName(), this.mmd.getRelationType(this.clr)}));
                    if (!this.mmd.hasCollection()) return;
                    Collection coll = (Collection)value;
                    Collection<Object> oldColl = this.getDnMappedReferences(this.effectiveClassMetaData, this.mmd, ownerAttributeName, this.op);
                    if (oldColl == null) throw new NucleusDataStoreException("No old collection in SM " + this.op);
                    AbstractCollection toAdd = null;
                    AbstractCollection toRemove = null;
                    Class instanceType = this.mmd.getType();
                    if (List.class.isAssignableFrom(instanceType)) {
                        toAdd = new ArrayList(coll);
                        toRemove = new ArrayList<Object>(oldColl);
                    } else {
                        toAdd = new HashSet(coll);
                        toRemove = new HashSet<Object>(oldColl);
                    }
                    toAdd.removeAll(oldColl);
                    for (Object pc : toAdd) {
                        this.addDnReference(pc, ownerAttributeName, myDN, emptyValue);
                        LDAPUtils.unmarkForDeletion(pc, this.ec);
                    }
                    toRemove.removeAll(coll);
                    for (Object pc : toRemove) {
                        this.removeDnReference(pc, ownerAttributeName, myDN, emptyValue);
                        if (!this.mmd.getCollection().isDependentElement()) continue;
                        LDAPUtils.markForDeletion(pc, this.ec);
                    }
                }
                return;
            } else {
                this.removeDnReference(this.getDnMappedReference(this.effectiveClassMetaData, ownerAttributeName, this.op), ownerAttributeName, myDN, emptyValue);
            }
            return;
        }
        if (value != null) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                ObjectProvider smpc = this.ec.findObjectProvider(value, true);
                LDAPUtils.unmarkForDeletion(value, this.ec);
                this.attributes.put(new BasicAttribute(ownerAttributeName, LDAPUtils.getDistinguishedNameForObject(this.storeMgr, smpc).toString()));
                return;
            }
            if (!RelationType.isRelationMultiValued((RelationType)relationType)) throw new NucleusException(Localiser.msg((String)"LDAP.Persist.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getTypeName(), this.mmd.getRelationType(this.clr)}));
            if (!this.mmd.hasCollection()) return;
            Collection coll = (Collection)value;
            if (this.mmd.getCollection().isDependentElement()) {
                Collection oldColl = null;
                Class instanceType = this.mmd.getType();
                instanceType = SCOUtils.getContainerInstanceType((Class)instanceType, (Boolean)(this.mmd.getOrderMetaData() != null ? 1 : 0));
                Collection<Object> attributeValues = LDAPUtils.getAttributeValuesFromLDAP(this.storeMgr, this.op, ownerAttributeName);
                try {
                    oldColl = (Collection)instanceType.newInstance();
                    Class elementType = this.clr.classForName(this.mmd.getCollection().getElementType());
                    for (Object object : attributeValues) {
                        String oldDn = (String)object;
                        oldColl.add(LDAPUtils.getObjectByDN(this.storeMgr, this.ec, elementType, oldDn));
                    }
                }
                catch (Exception e) {
                    throw new NucleusException("Error in trying to create object of type " + instanceType.getName(), (Throwable)e);
                }
                if (oldColl != null) {
                    AbstractCollection toRemove = List.class.isAssignableFrom(instanceType) ? new ArrayList(oldColl) : new HashSet(oldColl);
                    toRemove.removeAll(coll);
                    for (Object pc : toRemove) {
                        LDAPUtils.markForDeletion(pc, this.ec);
                    }
                }
            }
            BasicAttribute attr = new BasicAttribute(ownerAttributeName);
            this.attributes.put(attr);
            for (Object pc : coll) {
                LDAPUtils.unmarkForDeletion(pc, this.ec);
                ObjectProvider smpc = this.ec.findObjectProvider(pc, true);
                attr.add(LDAPUtils.getDistinguishedNameForObject(this.storeMgr, smpc).toString());
            }
            RelationByDnStrategy.addEmptyValue(emptyValue, attr);
            return;
        }
        BasicAttribute attr = new BasicAttribute(ownerAttributeName);
        RelationByDnStrategy.addEmptyValue(emptyValue, attr);
        this.attributes.put(attr);
    }

    private Object getDnMappedReference(AbstractClassMetaData cmd, String pcAttributeName, ObjectProvider sm) {
        Collection<Object> coll = this.getDnMappedReferences(cmd, null, pcAttributeName, sm);
        if (coll.iterator().hasNext()) {
            Object value = coll.iterator().next();
            return value;
        }
        return null;
    }

    private Collection<Object> getDnMappedReferences(AbstractClassMetaData cmd, AbstractMemberMetaData mmd, String pcAttributeName, ObjectProvider sm) {
        Collection coll;
        Class collectionClass;
        if (mmd == null) {
            collectionClass = ArrayList.class;
        } else {
            collectionClass = mmd.getType();
            collectionClass = SCOUtils.getContainerInstanceType((Class)collectionClass, (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
        }
        try {
            coll = (Collection)collectionClass.newInstance();
            ExecutionContext om = sm.getExecutionContext();
            LdapName myDN = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, sm);
            String dnFilter = "(" + pcAttributeName + "=" + myDN.toString() + ")";
            LdapName base = LDAPUtils.getSearchBase(cmd, sm.getExecutionContext().getMetaDataManager());
            List<Object> objects = LDAPUtils.getObjectsOfCandidateType(this.storeMgr, om, cmd, base, dnFilter, true, false);
            coll.addAll(objects);
        }
        catch (InstantiationException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionClass.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionClass.getName(), (Throwable)e);
        }
        return coll;
    }

    private void removeDnReference(Object oldObject, String pcAttributeName, LdapName dn, String emptyValue) {
        if (oldObject != null) {
            ObjectProvider oldPcSM = this.ec.findObjectProvider(oldObject, true);
            LdapName oldPcDN = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, oldPcSM);
            ManagedConnection mconn = this.storeMgr.getConnection(this.ec);
            try {
                boolean removed;
                DirContext ctx = (DirContext)mconn.getConnection();
                Attributes pcAttributes = ctx.getAttributes(oldPcDN, new String[]{pcAttributeName});
                Attribute pcAttribute = pcAttributes.get(pcAttributeName);
                if (pcAttribute != null && (removed = pcAttribute.remove(dn.toString()))) {
                    RelationByDnStrategy.addEmptyValue(emptyValue, pcAttribute);
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.JNDI.DeleteDnReference", (Object[])new Object[]{oldPcDN, dn}));
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.JNDI.modifyAttributes", (Object[])new Object[]{oldPcDN, "REPLACE", pcAttributes}));
                    }
                    ctx.modifyAttributes(oldPcDN, 2, pcAttributes);
                }
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }

    private void addDnReference(Object newObject, String pcAttributeName, LdapName dn, String emptyValue) {
        if (newObject != null) {
            ObjectProvider newPcSM = this.ec.findObjectProvider(newObject, true);
            LdapName newPcDN = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, newPcSM);
            if (newPcSM.isInserting()) {
                return;
            }
            ManagedConnection mconn = this.storeMgr.getConnection(this.ec);
            try {
                DirContext ctx = (DirContext)mconn.getConnection();
                Attributes attributes = ctx.getAttributes(newPcDN, new String[]{pcAttributeName});
                Attribute attribute = attributes.get(pcAttributeName);
                if (attribute == null) {
                    attribute = new BasicAttribute(pcAttributeName);
                    attributes.put(attribute);
                }
                if (!attribute.contains(dn.toString())) {
                    attribute.add(dn.toString());
                    RelationByDnStrategy.removeEmptyValue(emptyValue, attribute);
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.JNDI.AddDnReference", (Object[])new Object[]{newPcDN, dn}));
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.JNDI.modifyAttributes", (Object[])new Object[]{newPcDN, "REPLACE", attributes}));
                    }
                    ctx.modifyAttributes(newPcDN, 2, attributes);
                }
            }
            catch (NamingException e) {
                NucleusLogger.DATASTORE_PERSIST.warn((Object)"Exception adding DN reference", (Throwable)e);
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }

    private static void addEmptyValue(String emptyValue, Attribute attr) {
        if (attr != null && attr.size() == 0 && emptyValue != null) {
            attr.add(emptyValue);
        }
    }

    private static void removeEmptyValue(String emptyValue, Attribute attr) {
        try {
            if (emptyValue != null && attr != null) {
                LdapName emptyDn = new LdapName(emptyValue);
                for (int i = 0; i < attr.size(); ++i) {
                    String value = (String)attr.get(i);
                    LdapName dn = new LdapName(value);
                    if (!emptyDn.equals(dn)) continue;
                    attr.remove(i);
                    --i;
                }
            }
        }
        catch (NamingException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<String> getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.mappingMetaData.getNonOwnerMMD() != this.mmd) {
            names.add(this.mappingMetaData.getOwnerAttributeName());
        }
        return names;
    }
}

