/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.RelationByAttributeMetaData;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class RelationByAttributeStrategy
extends AbstractMappingStrategy {
    protected int fieldNumber;
    protected StoreManager storeMgr;
    protected ClassLoaderResolver clr;
    protected AbstractClassMetaData effectiveClassMetaData;
    protected RelationByAttributeMetaData mappingMetaData;

    protected RelationByAttributeStrategy(StoreManager storeMgr, ObjectProvider sm, AbstractMemberMetaData mmd, Attributes attributes) {
        super(sm, mmd, attributes);
        this.fieldNumber = mmd.getAbsoluteFieldNumber();
        this.storeMgr = storeMgr;
        this.clr = this.ec.getClassLoaderResolver();
        this.effectiveClassMetaData = LDAPUtils.getEffectiveClassMetaData(mmd, this.ec.getMetaDataManager());
        this.mappingMetaData = new RelationByAttributeMetaData(mmd, this.ec.getMetaDataManager());
    }

    @Override
    public Object fetch() {
        String ownerAttributeName = this.mappingMetaData.getOwnerAttributeName();
        String joinAttributeName = this.mappingMetaData.getJoinAttributeName();
        String emptyValue = this.mappingMetaData.getEmptyValue();
        RelationType relationType = this.mmd.getRelationType(this.clr);
        if (this.mappingMetaData.getNonOwnerMMD() == this.mmd) {
            Object joinAttributeValue = null;
            try {
                joinAttributeValue = this.attributes.get(joinAttributeName).get();
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                return this.getAttributeMappedReference(this.effectiveClassMetaData, ownerAttributeName, joinAttributeValue);
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType) && this.mmd.hasCollection()) {
                Collection<Object> coll = this.getAttributeMappedReferences(this.effectiveClassMetaData, this.mmd, ownerAttributeName, joinAttributeValue);
                return this.op.wrapSCOField(this.fieldNumber, coll, false, false, true);
            }
            throw new NucleusException(Localiser.msg((String)"LDAP.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getRelationType(this.clr)}));
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            try {
                return this.attr != null ? LDAPUtils.getObjectByAttribute(this.storeMgr, this.ec, this.mmd.getType(), joinAttributeName, (String)this.attr.get(0), this.ec.getMetaDataManager()) : null;
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType) && this.mmd.hasCollection()) {
            Collection coll = null;
            Class instanceType = this.mmd.getType();
            instanceType = SCOUtils.getContainerInstanceType((Class)instanceType, (Boolean)(this.mmd.getOrderMetaData() != null ? 1 : 0));
            try {
                coll = (Collection)instanceType.newInstance();
                Class elementType = this.clr.classForName(this.mmd.getCollection().getElementType());
                RelationByAttributeStrategy.removeEmptyValue(emptyValue, this.attr);
                for (int i = 0; this.attr != null && i < this.attr.size(); ++i) {
                    Object o = LDAPUtils.getObjectByAttribute(this.storeMgr, this.ec, elementType, joinAttributeName, (String)this.attr.get(i), this.ec.getMetaDataManager());
                    coll.add(o);
                }
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw new NucleusException("Error in trying to create object of type " + instanceType.getName(), (Throwable)e);
            }
            return this.op.wrapSCOField(this.fieldNumber, (Object)coll, false, false, true);
        }
        throw new NucleusException(Localiser.msg((String)"LDAP.Retrieve.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getRelationType(this.clr)}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void insert(Object value) {
        if (value == null) return;
        String ownerAttributeName = this.mappingMetaData.getOwnerAttributeName();
        String joinAttributeName = this.mappingMetaData.getJoinAttributeName();
        String emptyValue = this.mappingMetaData.getEmptyValue();
        RelationType relationType = this.mmd.getRelationType(this.clr);
        if (this.mappingMetaData.getNonOwnerMMD() == this.mmd) {
            Object joinAttributeValue = LDAPUtils.getAttributeValue(this.storeMgr, this.op, joinAttributeName);
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                this.addAttributeReference(value, ownerAttributeName, joinAttributeValue, emptyValue);
                return;
            } else {
                if (!RelationType.isRelationMultiValued((RelationType)relationType)) throw new NucleusException(Localiser.msg((String)"LDAP.Persist.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getTypeName(), this.mmd.getRelationType(this.clr)}));
                if (!this.mmd.hasCollection()) return;
                Collection c = (Collection)value;
                for (Object pc : c) {
                    LDAPUtils.unmarkForDeletion(pc, this.ec);
                    this.addAttributeReference(pc, ownerAttributeName, joinAttributeValue, emptyValue);
                }
            }
            return;
        } else if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            ObjectProvider pcOP = this.ec.findObjectProvider(value, true);
            Object joinAttributeValue = LDAPUtils.getAttributeValue(this.storeMgr, pcOP, joinAttributeName);
            BasicAttribute attr = new BasicAttribute(ownerAttributeName, joinAttributeValue);
            RelationByAttributeStrategy.addEmptyValue(emptyValue, attr);
            this.attributes.put(attr);
            return;
        } else {
            if (!RelationType.isRelationMultiValued((RelationType)relationType)) throw new NucleusException(Localiser.msg((String)"LDAP.Persist.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getTypeName(), this.mmd.getRelationType(this.clr)}));
            if (!this.mmd.hasCollection()) return;
            Collection c = (Collection)value;
            BasicAttribute attr = new BasicAttribute(ownerAttributeName);
            for (Object pc : c) {
                ObjectProvider pcSM = this.ec.findObjectProvider(pc, true);
                Object joinAttributeValue = LDAPUtils.getAttributeValue(this.storeMgr, pcSM, joinAttributeName);
                attr.add(joinAttributeValue);
            }
            RelationByAttributeStrategy.addEmptyValue(emptyValue, attr);
            if (attr.size() <= 0) return;
            this.attributes.put(attr);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update(Object value) {
        if (value != null) {
            LDAPUtils.unmarkForDeletion(this.op.getObject(), this.ec);
        }
        String ownerAttributeName = this.mappingMetaData.getOwnerAttributeName();
        String joinAttributeName = this.mappingMetaData.getJoinAttributeName();
        String emptyValue = this.mappingMetaData.getEmptyValue();
        RelationType relationType = this.mmd.getRelationType(this.clr);
        if (this.mappingMetaData.getNonOwnerMMD() == this.mmd) {
            Object joinAttributeValue = LDAPUtils.getAttributeValue(this.storeMgr, this.op, joinAttributeName);
            if (value != null) {
                if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                    Object oldValue = this.getAttributeMappedReference(this.effectiveClassMetaData, ownerAttributeName, joinAttributeValue);
                    if (value.equals(oldValue)) return;
                    LDAPUtils.markForPersisting(value, this.ec);
                    LDAPUtils.unmarkForDeletion(value, this.ec);
                    this.removeAttributeReference(oldValue, ownerAttributeName, joinAttributeValue, emptyValue);
                    ObjectProvider valueOP = this.ec.findObjectProvider(value);
                    if (valueOP != null && valueOP.isWaitingToBeFlushedToDatastore()) {
                        valueOP.flush();
                    }
                    this.addAttributeReference(value, ownerAttributeName, joinAttributeValue, emptyValue);
                    return;
                } else {
                    if (!RelationType.isRelationMultiValued((RelationType)relationType)) throw new NucleusException(Localiser.msg((String)"LDAP.Persist.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getTypeName(), this.mmd.getRelationType(this.clr)}));
                    if (!this.mmd.hasCollection()) return;
                    Collection coll = (Collection)value;
                    Collection<Object> oldColl = this.getAttributeMappedReferences(this.effectiveClassMetaData, this.mmd, ownerAttributeName, joinAttributeValue);
                    if (oldColl == null) throw new NucleusDataStoreException("No old collection in ObjectProvider " + this.op);
                    AbstractCollection toAdd = null;
                    AbstractCollection toRemove = null;
                    Class instanceType = this.mmd.getType();
                    if (List.class.isAssignableFrom(instanceType)) {
                        toAdd = new ArrayList(coll);
                        toRemove = new ArrayList<Object>(oldColl);
                    } else {
                        toAdd = new HashSet(coll);
                        toRemove = new HashSet<Object>(oldColl);
                    }
                    toAdd.removeAll(oldColl);
                    for (Object pc : toAdd) {
                        this.addAttributeReference(pc, ownerAttributeName, joinAttributeValue, emptyValue);
                        LDAPUtils.unmarkForDeletion(pc, this.ec);
                    }
                    toRemove.removeAll(coll);
                    for (Object pc : toRemove) {
                        this.removeAttributeReference(pc, ownerAttributeName, joinAttributeValue, emptyValue);
                        if (!this.mmd.getCollection().isDependentElement()) continue;
                        LDAPUtils.markForDeletion(pc, this.ec);
                    }
                }
                return;
            } else {
                Object oldValue = this.getAttributeMappedReference(this.effectiveClassMetaData, ownerAttributeName, joinAttributeValue);
                this.removeAttributeReference(oldValue, ownerAttributeName, joinAttributeValue, emptyValue);
            }
            return;
        }
        if (value != null) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                ObjectProvider smpc = this.ec.findObjectProvider(value, true);
                LDAPUtils.unmarkForDeletion(value, this.ec);
                Object joinAttributeValue = LDAPUtils.getAttributeValue(this.storeMgr, smpc, joinAttributeName);
                this.attributes.put(new BasicAttribute(ownerAttributeName, joinAttributeValue));
                return;
            }
            if (!RelationType.isRelationMultiValued((RelationType)relationType)) throw new NucleusException(Localiser.msg((String)"LDAP.Persist.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getTypeName(), this.mmd.getRelationType(this.clr)}));
            if (!this.mmd.hasCollection()) return;
            Collection coll = (Collection)value;
            if (this.mmd.getCollection().isDependentElement()) {
                Collection<Object> attributeValues = LDAPUtils.getAttributeValuesFromLDAP(this.storeMgr, this.op, ownerAttributeName);
                Collection oldColl = null;
                Class instanceType = this.mmd.getType();
                instanceType = SCOUtils.getContainerInstanceType((Class)instanceType, (Boolean)(this.mmd.getOrderMetaData() != null ? 1 : 0));
                try {
                    oldColl = (Collection)instanceType.newInstance();
                    Class elementType = this.clr.classForName(this.mmd.getCollection().getElementType());
                    for (Object object : attributeValues) {
                        Object o = LDAPUtils.getObjectByAttribute(this.storeMgr, this.ec, elementType, joinAttributeName, (String)object, this.ec.getMetaDataManager());
                        oldColl.add(o);
                    }
                }
                catch (Exception e) {
                    throw new NucleusException("Error in trying to create object of type " + instanceType.getName(), (Throwable)e);
                }
                if (oldColl != null) {
                    AbstractCollection toRemove = null;
                    toRemove = List.class.isAssignableFrom(instanceType) ? new ArrayList(oldColl) : new HashSet(oldColl);
                    toRemove.removeAll(coll);
                    for (Object pc : toRemove) {
                        LDAPUtils.markForDeletion(pc, this.ec);
                    }
                }
            }
            BasicAttribute attr = new BasicAttribute(ownerAttributeName);
            this.attributes.put(attr);
            for (Object pc : coll) {
                LDAPUtils.unmarkForDeletion(pc, this.ec);
                ObjectProvider smpc = this.ec.findObjectProvider(pc, true);
                Object joinAttributeValue = LDAPUtils.getAttributeValue(this.storeMgr, smpc, joinAttributeName);
                attr.add(joinAttributeValue);
            }
            RelationByAttributeStrategy.addEmptyValue(emptyValue, attr);
            return;
        }
        BasicAttribute attr = new BasicAttribute(ownerAttributeName);
        RelationByAttributeStrategy.addEmptyValue(emptyValue, attr);
        this.attributes.put(attr);
    }

    private Object getAttributeMappedReference(AbstractClassMetaData cmd, String pcAttributeName, Object myAttributeValue) {
        Collection<Object> coll = this.getAttributeMappedReferences(cmd, null, pcAttributeName, myAttributeValue);
        if (coll.iterator().hasNext()) {
            return coll.iterator().next();
        }
        return null;
    }

    private Collection<Object> getAttributeMappedReferences(AbstractClassMetaData cmd, AbstractMemberMetaData mmd, String pcAttributeName, Object myAttributeValue) {
        Collection coll;
        Class collectionClass = mmd == null ? ArrayList.class : SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
        try {
            coll = (Collection)collectionClass.newInstance();
            String attributeFilter = "(" + pcAttributeName + "=" + myAttributeValue + ")";
            LdapName base = LDAPUtils.getSearchBase(cmd, this.ec.getMetaDataManager());
            List<Object> objects = LDAPUtils.getObjectsOfCandidateType(this.storeMgr, this.ec, cmd, base, attributeFilter, true, false);
            coll.addAll(objects);
        }
        catch (InstantiationException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionClass.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionClass.getName(), (Throwable)e);
        }
        return coll;
    }

    private void removeAttributeReference(Object fromObject, String attributeName, Object joinAttributeValue, String emptyValue) {
        if (fromObject != null) {
            ObjectProvider fromOP = this.ec.findObjectProvider(fromObject, true);
            LdapName fromDN = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, fromOP);
            if (fromOP.getExecutionContext().getApiAdapter().isDeleted(fromObject)) {
                return;
            }
            ManagedConnection mconn = this.storeMgr.getConnection(this.ec);
            try {
                boolean removed;
                DirContext ctx = (DirContext)mconn.getConnection();
                Attributes attributes = ctx.getAttributes(fromDN, new String[]{attributeName});
                Attribute attribute = attributes.get(attributeName);
                if (attribute != null && (removed = attribute.remove(joinAttributeValue))) {
                    RelationByAttributeStrategy.addEmptyValue(emptyValue, attribute);
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.JNDI.DeleteAttributeReference", (Object[])new Object[]{attributeName, joinAttributeValue, fromDN}));
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.JNDI.modifyAttributes", (Object[])new Object[]{fromDN, "REPLACE", attributes}));
                    }
                    ctx.modifyAttributes(fromDN, 2, attributes);
                }
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }

    private void addAttributeReference(Object toObject, String attributeName, Object joinAttributeValue, String emptyValue) {
        if (toObject != null) {
            ObjectProvider toOP = this.ec.findObjectProvider(toObject, true);
            LdapName toDN = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, toOP);
            if (toOP.isInserting()) {
                return;
            }
            ManagedConnection mconn = this.storeMgr.getConnection(this.ec);
            try {
                DirContext ctx = (DirContext)mconn.getConnection();
                Attributes attributes = ctx.getAttributes(toDN, new String[]{attributeName});
                Attribute attribute = attributes.get(attributeName);
                if (attribute == null) {
                    attribute = new BasicAttribute(attributeName);
                    attributes.put(attribute);
                }
                if (!attribute.contains(joinAttributeValue)) {
                    attribute.add(joinAttributeValue);
                    RelationByAttributeStrategy.removeEmptyValue(emptyValue, attribute);
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.JNDI.AddAttributeReference", (Object[])new Object[]{attributeName, joinAttributeValue, toDN}));
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.JNDI.modifyAttributes", (Object[])new Object[]{toDN, "REPLACE", attributes}));
                    }
                    ctx.modifyAttributes(toDN, 2, attributes);
                }
            }
            catch (NamingException e) {
                NucleusLogger.DATASTORE_PERSIST.warn((Object)"Exception thrown", (Throwable)e);
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }

    private static void addEmptyValue(String emptyValue, Attribute attr) {
        if (attr != null && attr.size() == 0 && emptyValue != null) {
            attr.add(emptyValue);
        }
    }

    private static void removeEmptyValue(String emptyValue, Attribute attr) {
        if (emptyValue != null && attr != null) {
            attr.remove(emptyValue);
        }
    }

    @Override
    public List<String> getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.mappingMetaData.getNonOwnerMMD() == this.mmd) {
            names.add(this.mappingMetaData.getJoinAttributeName());
        } else {
            names.add(this.mappingMetaData.getOwnerAttributeName());
        }
        return names;
    }
}

