/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.RelationByAttributeMetaData;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class RelationByAttributeStrategy
extends AbstractMappingStrategy {
    protected int fieldNumber;
    protected StoreManager storeMgr;
    protected ClassLoaderResolver clr;
    protected AbstractClassMetaData effectiveClassMetaData;
    protected RelationByAttributeMetaData mappingMetaData;

    protected RelationByAttributeStrategy(StoreManager storeMgr, ObjectProvider sm, AbstractMemberMetaData mmd, Attributes attributes) {
        super(sm, mmd, attributes);
        this.fieldNumber = mmd.getAbsoluteFieldNumber();
        this.storeMgr = storeMgr;
        this.clr = this.ec.getClassLoaderResolver();
        this.effectiveClassMetaData = LDAPUtils.getEffectiveClassMetaData(mmd, this.ec.getMetaDataManager());
        this.mappingMetaData = new RelationByAttributeMetaData(mmd, this.ec.getMetaDataManager());
    }

    @Override
    public Object fetch() {
        String ownerAttributeName = this.mappingMetaData.getOwnerAttributeName();
        String joinAttributeName = this.mappingMetaData.getJoinAttributeName();
        String emptyValue = this.mappingMetaData.getEmptyValue();
        RelationType relationType = this.mmd.getRelationType(this.clr);
        if (this.mappingMetaData.getNonOwnerMMD() == this.mmd) {
            Object joinAttributeValue = null;
            try {
                joinAttributeValue = this.attributes.get(joinAttributeName).get();
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                return this.getAttributeMappedReference(this.effectiveClassMetaData, ownerAttributeName, joinAttributeValue, this.ec);
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType) && this.mmd.hasCollection()) {
                Collection<Object> coll = this.getAttributeMappedReferences(this.effectiveClassMetaData, this.mmd, ownerAttributeName, joinAttributeValue, this.ec);
                return this.op.wrapSCOField(this.fieldNumber, coll, false, false, true);
            }
            throw new NucleusException(Localiser.msg((String)"LDAP.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getRelationType(this.clr)}));
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            try {
                Object value = this.attr != null ? LDAPUtils.getObjectByAttribute(this.storeMgr, this.ec, this.mmd.getType(), joinAttributeName, (String)this.attr.get(0), this.op.getExecutionContext().getMetaDataManager()) : null;
                return value;
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType) && this.mmd.hasCollection()) {
            Collection coll = null;
            Class instanceType = this.mmd.getType();
            instanceType = SCOUtils.getContainerInstanceType((Class)instanceType, (Boolean)(this.mmd.getOrderMetaData() != null ? 1 : 0));
            try {
                coll = (Collection)instanceType.newInstance();
                Class elementType = this.clr.classForName(this.mmd.getCollection().getElementType());
                RelationByAttributeStrategy.removeEmptyValue(emptyValue, this.attr);
                for (int i = 0; this.attr != null && i < this.attr.size(); ++i) {
                    String value = (String)this.attr.get(i);
                    Object o = LDAPUtils.getObjectByAttribute(this.storeMgr, this.ec, elementType, joinAttributeName, value, this.op.getExecutionContext().getMetaDataManager());
                    coll.add(o);
                }
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw new NucleusException("Error in trying to create object of type " + instanceType.getName(), (Throwable)e);
            }
            return this.op.wrapSCOField(this.fieldNumber, (Object)coll, false, false, true);
        }
        throw new NucleusException(Localiser.msg((String)"LDAP.Retrieve.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getRelationType(this.clr)}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void insert(Object value) {
        if (value == null) return;
        String ownerAttributeName = this.mappingMetaData.getOwnerAttributeName();
        String joinAttributeName = this.mappingMetaData.getJoinAttributeName();
        String emptyValue = this.mappingMetaData.getEmptyValue();
        RelationType relationType = this.mmd.getRelationType(this.clr);
        if (this.mappingMetaData.getNonOwnerMMD() == this.mmd) {
            Object joinAttributeValue = LDAPUtils.getAttributeValue(this.storeMgr, this.op, joinAttributeName);
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                this.addAttributeReference(value, ownerAttributeName, joinAttributeValue, emptyValue, this.ec);
                return;
            } else {
                if (!RelationType.isRelationMultiValued((RelationType)relationType)) throw new NucleusException(Localiser.msg((String)"LDAP.Persist.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getTypeName(), this.mmd.getRelationType(this.clr)}));
                if (!this.mmd.hasCollection()) return;
                Collection c = (Collection)value;
                for (Object pc : c) {
                    LDAPUtils.unmarkForDeletion(pc, this.ec);
                    this.addAttributeReference(pc, ownerAttributeName, joinAttributeValue, emptyValue, this.ec);
                }
            }
            return;
        } else if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            ObjectProvider pcSM = LDAPUtils.getObjectProviderForObject(value, this.ec, true);
            Object joinAttributeValue = LDAPUtils.getAttributeValue(this.storeMgr, pcSM, joinAttributeName);
            BasicAttribute attr = new BasicAttribute(ownerAttributeName, joinAttributeValue);
            RelationByAttributeStrategy.addEmptyValue(emptyValue, attr);
            this.attributes.put(attr);
            return;
        } else {
            if (!RelationType.isRelationMultiValued((RelationType)relationType)) throw new NucleusException(Localiser.msg((String)"LDAP.Persist.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getTypeName(), this.mmd.getRelationType(this.clr)}));
            if (!this.mmd.hasCollection()) return;
            Collection c = (Collection)value;
            BasicAttribute attr = new BasicAttribute(ownerAttributeName);
            for (Object pc : c) {
                ObjectProvider pcSM = LDAPUtils.getObjectProviderForObject(pc, this.ec, true);
                Object joinAttributeValue = LDAPUtils.getAttributeValue(this.storeMgr, pcSM, joinAttributeName);
                attr.add(joinAttributeValue);
            }
            RelationByAttributeStrategy.addEmptyValue(emptyValue, attr);
            if (attr.size() <= 0) return;
            this.attributes.put(attr);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update(Object value) {
        if (value != null) {
            LDAPUtils.unmarkForDeletion(this.op.getObject(), this.ec);
        }
        String ownerAttributeName = this.mappingMetaData.getOwnerAttributeName();
        String joinAttributeName = this.mappingMetaData.getJoinAttributeName();
        String emptyValue = this.mappingMetaData.getEmptyValue();
        RelationType relationType = this.mmd.getRelationType(this.clr);
        if (this.mappingMetaData.getNonOwnerMMD() == this.mmd) {
            Object joinAttributeValue = LDAPUtils.getAttributeValue(this.storeMgr, this.op, joinAttributeName);
            if (value != null) {
                if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                    Object oldValue = this.getAttributeMappedReference(this.effectiveClassMetaData, ownerAttributeName, joinAttributeValue, this.ec);
                    if (value.equals(oldValue)) return;
                    LDAPUtils.markForPersisting(value, this.ec);
                    LDAPUtils.unmarkForDeletion(value, this.ec);
                    this.removeAttributeReference(oldValue, ownerAttributeName, joinAttributeValue, emptyValue, this.ec);
                    this.addAttributeReference(value, ownerAttributeName, joinAttributeValue, emptyValue, this.ec);
                    return;
                } else {
                    if (!RelationType.isRelationMultiValued((RelationType)relationType)) throw new NucleusException(Localiser.msg((String)"LDAP.Persist.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getTypeName(), this.mmd.getRelationType(this.clr)}));
                    if (!this.mmd.hasCollection()) return;
                    Collection coll = (Collection)value;
                    Collection<Object> oldColl = this.getAttributeMappedReferences(this.effectiveClassMetaData, this.mmd, ownerAttributeName, joinAttributeValue, this.ec);
                    if (oldColl == null) throw new NucleusDataStoreException("No old collection in SM " + this.op);
                    AbstractCollection toAdd = null;
                    AbstractCollection toRemove = null;
                    Class instanceType = this.mmd.getType();
                    if (List.class.isAssignableFrom(instanceType)) {
                        toAdd = new ArrayList(coll);
                        toRemove = new ArrayList<Object>(oldColl);
                    } else {
                        toAdd = new HashSet(coll);
                        toRemove = new HashSet<Object>(oldColl);
                    }
                    toAdd.removeAll(oldColl);
                    for (Object pc : toAdd) {
                        this.addAttributeReference(pc, ownerAttributeName, joinAttributeValue, emptyValue, this.ec);
                        LDAPUtils.unmarkForDeletion(pc, this.ec);
                    }
                    toRemove.removeAll(coll);
                    for (Object pc : toRemove) {
                        this.removeAttributeReference(pc, ownerAttributeName, joinAttributeValue, emptyValue, this.ec);
                        if (!this.mmd.getCollection().isDependentElement()) continue;
                        LDAPUtils.markForDeletion(pc, this.ec);
                    }
                }
                return;
            } else {
                Object oldValue = this.getAttributeMappedReference(this.effectiveClassMetaData, ownerAttributeName, joinAttributeValue, this.ec);
                this.removeAttributeReference(oldValue, ownerAttributeName, joinAttributeValue, emptyValue, this.ec);
            }
            return;
        }
        if (value != null) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                ObjectProvider smpc = LDAPUtils.getObjectProviderForObject(value, this.ec, true);
                LDAPUtils.unmarkForDeletion(value, this.ec);
                Object joinAttributeValue = LDAPUtils.getAttributeValue(this.storeMgr, smpc, joinAttributeName);
                this.attributes.put(new BasicAttribute(ownerAttributeName, joinAttributeValue));
                return;
            }
            if (!RelationType.isRelationMultiValued((RelationType)relationType)) throw new NucleusException(Localiser.msg((String)"LDAP.Persist.RelationTypeNotSupported", (Object[])new Object[]{this.mmd.getFullFieldName(), this.mmd.getTypeName(), this.mmd.getRelationType(this.clr)}));
            if (!this.mmd.hasCollection()) return;
            Collection coll = (Collection)value;
            if (this.mmd.getCollection().isDependentElement()) {
                Collection<Object> attributeValues = LDAPUtils.getAttributeValuesFromLDAP(this.storeMgr, this.op, ownerAttributeName);
                Collection oldColl = null;
                Class instanceType = this.mmd.getType();
                instanceType = SCOUtils.getContainerInstanceType((Class)instanceType, (Boolean)(this.mmd.getOrderMetaData() != null ? 1 : 0));
                try {
                    oldColl = (Collection)instanceType.newInstance();
                    Class elementType = this.clr.classForName(this.mmd.getCollection().getElementType());
                    for (Object object : attributeValues) {
                        String oldValue = (String)object;
                        Object o = LDAPUtils.getObjectByAttribute(this.storeMgr, this.ec, elementType, joinAttributeName, oldValue, this.op.getExecutionContext().getMetaDataManager());
                        oldColl.add(o);
                    }
                }
                catch (Exception e) {
                    throw new NucleusException("Error in trying to create object of type " + instanceType.getName(), (Throwable)e);
                }
                if (oldColl != null) {
                    AbstractCollection toRemove = null;
                    toRemove = List.class.isAssignableFrom(instanceType) ? new ArrayList(oldColl) : new HashSet(oldColl);
                    toRemove.removeAll(coll);
                    for (Object pc : toRemove) {
                        LDAPUtils.markForDeletion(pc, this.ec);
                    }
                }
            }
            BasicAttribute attr = new BasicAttribute(ownerAttributeName);
            this.attributes.put(attr);
            for (Object pc : coll) {
                LDAPUtils.unmarkForDeletion(pc, this.ec);
                ObjectProvider smpc = LDAPUtils.getObjectProviderForObject(pc, this.ec, true);
                Object joinAttributeValue = LDAPUtils.getAttributeValue(this.storeMgr, smpc, joinAttributeName);
                attr.add(joinAttributeValue);
            }
            RelationByAttributeStrategy.addEmptyValue(emptyValue, attr);
            return;
        }
        BasicAttribute attr = new BasicAttribute(ownerAttributeName);
        RelationByAttributeStrategy.addEmptyValue(emptyValue, attr);
        this.attributes.put(attr);
    }

    private Object getAttributeMappedReference(AbstractClassMetaData cmd, String pcAttributeName, Object myAttributeValue, ExecutionContext om) {
        Collection<Object> coll = this.getAttributeMappedReferences(cmd, null, pcAttributeName, myAttributeValue, om);
        if (coll.iterator().hasNext()) {
            Object value = coll.iterator().next();
            return value;
        }
        return null;
    }

    private Collection<Object> getAttributeMappedReferences(AbstractClassMetaData cmd, AbstractMemberMetaData mmd, String pcAttributeName, Object myAttributeValue, ExecutionContext om) {
        Collection coll;
        Class collectionClass;
        if (mmd == null) {
            collectionClass = ArrayList.class;
        } else {
            collectionClass = mmd.getType();
            collectionClass = SCOUtils.getContainerInstanceType((Class)collectionClass, (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
        }
        try {
            coll = (Collection)collectionClass.newInstance();
            String attributeFilter = "(" + pcAttributeName + "=" + myAttributeValue + ")";
            LdapName base = LDAPUtils.getSearchBase(cmd, om.getMetaDataManager());
            List<Object> objects = LDAPUtils.getObjectsOfCandidateType(this.storeMgr, om, cmd, base, attributeFilter, true, false);
            coll.addAll(objects);
        }
        catch (InstantiationException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionClass.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionClass.getName(), (Throwable)e);
        }
        return coll;
    }

    private void removeAttributeReference(Object fromObject, String attributeName, Object joinAttributeValue, String emptyValue, ExecutionContext om) {
        if (fromObject != null) {
            ObjectProvider fromSM = LDAPUtils.getObjectProviderForObject(fromObject, om, true);
            LdapName fromDN = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, fromSM);
            if (fromSM.getExecutionContext().getApiAdapter().isDeleted(fromObject)) {
                return;
            }
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            try {
                boolean removed;
                DirContext ctx = (DirContext)mconn.getConnection();
                Attributes attributes = ctx.getAttributes(fromDN, new String[]{attributeName});
                Attribute attribute = attributes.get(attributeName);
                if (attribute != null && (removed = attribute.remove(joinAttributeValue))) {
                    RelationByAttributeStrategy.addEmptyValue(emptyValue, attribute);
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.JNDI.DeleteAttributeReference", (Object[])new Object[]{attributeName, joinAttributeValue, fromDN}));
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.JNDI.modifyAttributes", (Object[])new Object[]{fromDN, "REPLACE", attributes}));
                    }
                    ctx.modifyAttributes(fromDN, 2, attributes);
                }
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }

    private void addAttributeReference(Object toObject, String attributeName, Object joinAttributeValue, String emptyValue, ExecutionContext om) {
        if (toObject != null) {
            ObjectProvider toSM = LDAPUtils.getObjectProviderForObject(toObject, om, true);
            LdapName toDN = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, toSM);
            if (toSM.isInserting()) {
                return;
            }
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            try {
                DirContext ctx = (DirContext)mconn.getConnection();
                Attributes attributes = ctx.getAttributes(toDN, new String[]{attributeName});
                Attribute attribute = attributes.get(attributeName);
                if (attribute == null) {
                    attribute = new BasicAttribute(attributeName);
                    attributes.put(attribute);
                }
                if (!attribute.contains(joinAttributeValue)) {
                    attribute.add(joinAttributeValue);
                    RelationByAttributeStrategy.removeEmptyValue(emptyValue, attribute);
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.JNDI.AddAttributeReference", (Object[])new Object[]{attributeName, joinAttributeValue, toDN}));
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"LDAP.JNDI.modifyAttributes", (Object[])new Object[]{toDN, "REPLACE", attributes}));
                    }
                    ctx.modifyAttributes(toDN, 2, attributes);
                }
            }
            catch (NamingException e) {
                System.out.println(toSM);
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }

    private static void addEmptyValue(String emptyValue, Attribute attr) {
        if (attr != null && attr.size() == 0 && emptyValue != null) {
            attr.add(emptyValue);
        }
    }

    private static void removeEmptyValue(String emptyValue, Attribute attr) {
        if (emptyValue != null && attr != null) {
            attr.remove(emptyValue);
        }
    }

    @Override
    public List<String> getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.mappingMetaData.getNonOwnerMMD() == this.mmd) {
            names.add(this.mappingMetaData.getJoinAttributeName());
        } else {
            names.add(this.mappingMetaData.getOwnerAttributeName());
        }
        return names;
    }
}

