/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.types.SCOUtils;

public class EmbeddedMappingStrategy
extends AbstractMappingStrategy {
    protected AbstractClassMetaData effectiveClassMetaData;
    protected int fieldNumber;
    protected StoreManager storeMgr;
    protected ClassLoaderResolver clr;

    protected EmbeddedMappingStrategy(StoreManager storeMgr, ObjectProvider sm, AbstractMemberMetaData mmd, Attributes attributes) {
        super(sm, mmd, attributes);
        this.fieldNumber = mmd.getAbsoluteFieldNumber();
        this.storeMgr = storeMgr;
        this.clr = this.ec.getClassLoaderResolver();
        this.effectiveClassMetaData = LDAPUtils.getEffectiveClassMetaData(mmd, this.ec.getMetaDataManager());
    }

    @Override
    public Object fetch() {
        RelationType relType = this.mmd.getRelationType(this.clr);
        if (relType == RelationType.ONE_TO_ONE_UNI || relType == RelationType.ONE_TO_ONE_BI) {
            Object value = null;
            Set<String> objectClasses = LDAPUtils.getObjectClassesForClass(this.effectiveClassMetaData);
            value = objectClasses.isEmpty() ? this.fetchEmbedded() : this.fetchFromChild();
            return value;
        }
        if ((relType == RelationType.ONE_TO_MANY_UNI || relType == RelationType.ONE_TO_MANY_BI) && this.mmd.hasCollection()) {
            Class instanceType = this.mmd.getType();
            instanceType = SCOUtils.getContainerInstanceType((Class)instanceType, (Boolean)(this.mmd.getOrderMetaData() != null ? 1 : 0));
            Collection<Object> coll = this.fetchFromChildren(instanceType);
            return this.op.wrapSCOField(this.fieldNumber, coll, false, false, true);
        }
        throw new NucleusException("Cant obtain value for field " + this.mmd.getFullFieldName() + " since type=" + this.mmd.getTypeName() + " is not supported for this datastore");
    }

    private Object fetchEmbedded() {
        EmbeddedMetaData embeddedMetaData = this.mmd.getEmbeddedMetaData();
        ArrayList<AbstractMemberMetaData> embeddedMmds = new ArrayList<AbstractMemberMetaData>(Arrays.asList(embeddedMetaData.getMemberMetaData()));
        ObjectProvider embeddedSM = this.ec.newObjectProviderForEmbedded(this.effectiveClassMetaData, null, -1);
        embeddedSM = this.getEmbeddedObjectProvider(embeddedSM.getObject());
        Object value = this.fetchMerge(embeddedSM, this.attributes, embeddedMmds, embeddedMetaData);
        return value;
    }

    private Object fetchFromChild() {
        EmbeddedMetaData embeddedMetaData = this.mmd.getEmbeddedMetaData();
        Collection<Object> children = this.fetchFromChildren(ArrayList.class, this.mmd, embeddedMetaData);
        if (children.size() == 0) {
            return null;
        }
        if (children.size() == 1) {
            return children.iterator().next();
        }
        throw new NucleusDataStoreException("Must be unique!");
    }

    private Collection<Object> fetchFromChildren(Class collectionType) {
        EmbeddedMetaData embeddedMetaData = this.mmd.getElementMetaData().getEmbeddedMetaData();
        return this.fetchFromChildren(collectionType, this.mmd, embeddedMetaData);
    }

    private Collection<Object> fetchFromChildren(Class collectionType, AbstractMemberMetaData mmd, EmbeddedMetaData embeddedMetaData) {
        List<AbstractMemberMetaData> embeddedMmds = LDAPUtils.getAllMemberMetaData(this.effectiveClassMetaData);
        Collection<Object> coll = this.getCollectionInstance(collectionType);
        LdapName baseDn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, this.op);
        Map<LdapName, Attributes> entries = LDAPUtils.getEntries(this.storeMgr, this.ec, this.effectiveClassMetaData, baseDn, null, false, false);
        for (Attributes embeddedAttrs : entries.values()) {
            ObjectProvider embeddedSM = this.ec.newObjectProviderForEmbedded(this.effectiveClassMetaData, null, -1);
            Object value = this.fetchMerge(embeddedSM = this.getEmbeddedObjectProvider(embeddedSM.getObject()), embeddedAttrs, embeddedMmds, embeddedMetaData);
            if (value == null) continue;
            coll.add(value);
        }
        String[] subclassNames = this.ec.getMetaDataManager().getSubclassesForClass(this.effectiveClassMetaData.getFullClassName(), true);
        if (subclassNames != null) {
            for (String subclassName : subclassNames) {
                AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(subclassName, this.clr);
                entries = LDAPUtils.getEntries(this.storeMgr, this.ec, cmd, baseDn, null, false, false);
                embeddedMmds = LDAPUtils.getAllMemberMetaData(cmd);
                for (Attributes embeddedAttrs : entries.values()) {
                    ObjectProvider embeddedSM = this.ec.newObjectProviderForEmbedded(cmd, null, -1);
                    Object value = this.fetchMerge(embeddedSM = this.getEmbeddedObjectProvider(embeddedSM.getObject()), embeddedAttrs, embeddedMmds, embeddedMetaData);
                    if (value == null) continue;
                    coll.add(value);
                }
            }
        }
        return coll;
    }

    private Object fetchMerge(ObjectProvider embeddedSM, Attributes embeddedAttrs, List<AbstractMemberMetaData> embeddedMmds, EmbeddedMetaData embeddedMetaData) {
        if (embeddedAttrs != null && embeddedMmds != null) {
            String fieldName;
            AbstractClassMetaData embeddedCmd = embeddedSM.getClassMetaData();
            String nullIndicatorColumn = embeddedMetaData.getNullIndicatorColumn();
            String nullIndicatorValue = embeddedMetaData.getNullIndicatorValue();
            for (AbstractMemberMetaData embeddedMmd : embeddedMmds) {
                fieldName = embeddedMmd.getName();
                int i = embeddedCmd.getAbsolutePositionOfMember(fieldName);
                if (fieldName.equals(embeddedMetaData.getOwnerMember())) {
                    Object embeddedValue = this.op.getObject();
                    embeddedSM.replaceField(i, embeddedValue);
                    continue;
                }
                if (!embeddedMmd.isPrimaryKey()) continue;
                AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(this.storeMgr, embeddedSM, embeddedMmd, embeddedAttrs);
                Object embeddedValue = ms.fetch();
                embeddedSM.replaceField(i, embeddedValue);
            }
            for (AbstractMemberMetaData embeddedMmd : embeddedMmds) {
                fieldName = embeddedMmd.getName();
                String attributeName = LDAPUtils.getAttributeNameForField(embeddedMmd);
                int i = embeddedCmd.getAbsolutePositionOfMember(fieldName);
                if (fieldName.equals(embeddedMetaData.getOwnerMember()) || embeddedMmd.isPrimaryKey()) continue;
                AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(this.storeMgr, embeddedSM, embeddedMmd, embeddedAttrs);
                Object embeddedValue = ms.fetch();
                if (nullIndicatorColumn != null && attributeName.equals(nullIndicatorColumn)) {
                    if (embeddedValue == null) {
                        return null;
                    }
                    if (nullIndicatorValue != null && embeddedValue.equals(nullIndicatorValue)) {
                        return null;
                    }
                }
                embeddedSM.replaceField(i, embeddedValue);
            }
            return embeddedSM.getObject();
        }
        return null;
    }

    private Collection<Object> getCollectionInstance(Class<?> collectionType) {
        Collection coll;
        try {
            coll = (Collection)collectionType.newInstance();
        }
        catch (InstantiationException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionType.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionType.getName(), (Throwable)e);
        }
        return coll;
    }

    private ObjectProvider getEmbeddedObjectProvider(Object value) {
        return this.ec.findObjectProviderForEmbedded(value, this.op, this.mmd);
    }

    @Override
    public void insert(Object value) {
        if (value == null) {
            return;
        }
        RelationType relationType = this.mmd.getRelationType(this.clr);
        if (relationType == RelationType.ONE_TO_ONE_UNI || relationType == RelationType.ONE_TO_ONE_BI) {
            Set<String> objectClasses = LDAPUtils.getObjectClassesForClass(this.effectiveClassMetaData);
            if (objectClasses.isEmpty()) {
                this.insertEmbedded(value);
            } else {
                EmbeddedMetaData embeddedMetaData = this.mmd.getEmbeddedMetaData();
                this.insertAsChild(value, embeddedMetaData);
            }
        } else if (relationType == RelationType.ONE_TO_MANY_UNI || relationType == RelationType.ONE_TO_MANY_BI) {
            if (this.mmd.hasCollection()) {
                EmbeddedMetaData embeddedMetaData = this.mmd.getElementMetaData().getEmbeddedMetaData();
                Collection c = (Collection)value;
                for (Object pc : c) {
                    this.insertAsChild(pc, embeddedMetaData);
                }
            }
        } else {
            throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " with relation type " + this.mmd.getRelationType(this.clr) + " is not supported for this datastore");
        }
    }

    private void insertEmbedded(Object value) {
        ObjectProvider embeddedSM = this.getEmbeddedObjectProvider(value);
        EmbeddedMetaData embeddedMetaData = this.mmd.getEmbeddedMetaData();
        ArrayList<AbstractMemberMetaData> embeddedMmds = new ArrayList<AbstractMemberMetaData>(Arrays.asList(embeddedMetaData.getMemberMetaData()));
        this.insertMerge(embeddedSM, this.attributes, embeddedMmds, embeddedMetaData);
    }

    private void insertAsChild(Object value, EmbeddedMetaData embeddedMetaData) {
        ObjectProvider embeddedSM = this.getEmbeddedObjectProvider(value);
        this.effectiveClassMetaData = embeddedSM.getClassMetaData();
        List<AbstractMemberMetaData> embeddedMmds = LDAPUtils.getAllMemberMetaData(this.effectiveClassMetaData);
        BasicAttributes embeddedAttributes = new BasicAttributes();
        ArrayList<AbstractMemberMetaData> nonEmbeddedMmds = new ArrayList<AbstractMemberMetaData>();
        Iterator<AbstractMemberMetaData> it = embeddedMmds.iterator();
        while (it.hasNext()) {
            AbstractMemberMetaData mmd = it.next();
            if (LDAPUtils.isEmbeddedField(mmd)) continue;
            nonEmbeddedMmds.add(mmd);
            it.remove();
        }
        this.insertMerge(embeddedSM, embeddedAttributes, nonEmbeddedMmds, embeddedMetaData);
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        Set<String> embeddedObjectClasses = LDAPUtils.getObjectClassesForClass(this.effectiveClassMetaData);
        for (String oc : embeddedObjectClasses) {
            objectClass.add(oc);
        }
        embeddedAttributes.put(objectClass);
        LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, embeddedSM);
        LDAPUtils.insert(this.storeMgr, dn, embeddedAttributes, this.ec);
        this.insertMerge(embeddedSM, embeddedAttributes, embeddedMmds, embeddedMetaData);
    }

    private void insertMerge(ObjectProvider embeddedSM, Attributes embeddedAttributes, List<AbstractMemberMetaData> embeddedMmds, EmbeddedMetaData embeddedMetaData) {
        Object embeddedValue;
        AbstractMappingStrategy ms;
        int i;
        String fieldName;
        AbstractClassMetaData embeddedCmd = embeddedSM.getClassMetaData();
        for (AbstractMemberMetaData embeddedMmd : embeddedMmds) {
            fieldName = embeddedMmd.getName();
            i = embeddedCmd.getAbsolutePositionOfMember(fieldName);
            if (fieldName.equals(embeddedMetaData.getOwnerMember())) {
                Object embeddedValue2 = this.op.getObject();
                embeddedSM.replaceField(i, embeddedValue2);
                continue;
            }
            if (!embeddedMmd.isPrimaryKey()) continue;
            ms = AbstractMappingStrategy.findMappingStrategy(this.storeMgr, embeddedSM, embeddedMmd, embeddedAttributes);
            embeddedValue = embeddedSM.provideField(i);
            ms.insert(embeddedValue);
        }
        for (AbstractMemberMetaData embeddedMmd : embeddedMmds) {
            fieldName = embeddedMmd.getName();
            i = embeddedCmd.getAbsolutePositionOfMember(fieldName);
            if (fieldName.equals(embeddedMetaData.getOwnerMember()) || embeddedMmd.isPrimaryKey()) continue;
            ms = AbstractMappingStrategy.findMappingStrategy(this.storeMgr, embeddedSM, embeddedMmd, embeddedAttributes);
            embeddedValue = embeddedSM.provideField(i);
            ms.insert(embeddedValue);
        }
    }

    @Override
    public void update(Object value) {
        RelationType relType = this.mmd.getRelationType(this.clr);
        if (relType == RelationType.ONE_TO_ONE_UNI || relType == RelationType.ONE_TO_ONE_BI) {
            Set<String> objectClasses = LDAPUtils.getObjectClassesForClass(this.effectiveClassMetaData);
            if (objectClasses.isEmpty()) {
                this.updateEmbedded(value);
            } else {
                Object oldValue = this.fetchFromChild();
                this.op.replaceField(this.fieldNumber, value);
                EmbeddedMetaData embeddedMetaData = this.mmd.getEmbeddedMetaData();
                if (value == null) {
                    if (oldValue != null) {
                        this.deleteAsChild(oldValue, embeddedMetaData);
                    }
                } else if (oldValue == null) {
                    this.insertAsChild(value, embeddedMetaData);
                } else {
                    LdapName oldValueDn;
                    ObjectProvider valueSM = this.getEmbeddedObjectProvider(value);
                    ObjectProvider oldValueSM = this.getEmbeddedObjectProvider(oldValue);
                    LdapName valueDn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, valueSM);
                    if (!valueDn.equals(oldValueDn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, oldValueSM))) {
                        this.deleteAsChild(oldValue, embeddedMetaData);
                        this.insertAsChild(value, embeddedMetaData);
                    } else {
                        this.updateAsChild(value, embeddedMetaData);
                    }
                }
            }
        } else if (relType == RelationType.ONE_TO_MANY_UNI || relType == RelationType.ONE_TO_MANY_BI) {
            if (this.mmd.hasCollection()) {
                Collection coll = (Collection)value;
                LinkedHashMap newMap = new LinkedHashMap();
                for (Object newObject : coll) {
                    ObjectProvider newObjectSM = this.getEmbeddedObjectProvider(newObject);
                    LdapName newObjectDn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, newObjectSM);
                    newMap.put(newObjectDn, newObject);
                }
                EmbeddedMetaData embeddedMetaData = this.mmd.getElementMetaData().getEmbeddedMetaData();
                Class oldCollInstanceType = SCOUtils.getContainerInstanceType((Class)this.mmd.getType(), (Boolean)(this.mmd.getOrderMetaData() != null ? 1 : 0));
                Collection<Object> oldColl = this.fetchFromChildren(oldCollInstanceType, this.mmd, embeddedMetaData);
                LinkedHashMap<LdapName, Object> oldMap = new LinkedHashMap<LdapName, Object>();
                for (Object oldObject : oldColl) {
                    ObjectProvider oldObjectSM = this.getEmbeddedObjectProvider(oldObject);
                    LdapName oldObjectDn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, oldObjectSM);
                    oldMap.put(oldObjectDn, oldObject);
                }
                AbstractCollection toInsert = null;
                AbstractCollection toUpdate = null;
                AbstractCollection toDelete = null;
                Class instanceType = this.mmd.getType();
                if (List.class.isAssignableFrom(instanceType)) {
                    toInsert = new ArrayList();
                    toUpdate = new ArrayList();
                    toDelete = new ArrayList();
                } else {
                    toInsert = new HashSet();
                    toUpdate = new HashSet();
                    toDelete = new HashSet();
                }
                Iterator it = oldMap.keySet().iterator();
                while (it.hasNext()) {
                    LdapName dn = (LdapName)it.next();
                    if (!newMap.containsKey(dn)) continue;
                    toUpdate.add(newMap.get(dn));
                    newMap.remove(dn);
                    it.remove();
                }
                toInsert.addAll(newMap.values());
                toDelete.addAll(oldMap.values());
                for (Object pc : toInsert) {
                    this.insertAsChild(pc, embeddedMetaData);
                }
                for (Object pc : toUpdate) {
                    this.updateAsChild(pc, embeddedMetaData);
                }
                for (Object pc : toDelete) {
                    this.deleteAsChild(pc, embeddedMetaData);
                }
            }
        } else {
            throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " with relation type " + this.mmd.getRelationType(this.clr) + " is not supported for this datastore");
        }
    }

    private void updateAsChild(Object value, EmbeddedMetaData embeddedMetaData) {
        ObjectProvider embeddedSM = this.ec.findObjectProvider(value);
        boolean insert = false;
        if (embeddedSM == null) {
            embeddedSM = this.getEmbeddedObjectProvider(value);
            insert = true;
        }
        this.effectiveClassMetaData = embeddedSM.getClassMetaData();
        int[] dirtyFieldNumbers = embeddedSM.getDirtyFieldNumbers();
        List<AbstractMemberMetaData> dirtyAndEmbeddedMmds = LDAPUtils.getMemberMetaData(dirtyFieldNumbers, this.effectiveClassMetaData);
        List<AbstractMemberMetaData> allMmds = LDAPUtils.getAllMemberMetaData(this.effectiveClassMetaData);
        for (AbstractMemberMetaData mmd : allMmds) {
            if (!LDAPUtils.isEmbeddedField(mmd) || dirtyAndEmbeddedMmds.contains(mmd)) continue;
            dirtyAndEmbeddedMmds.add(mmd);
        }
        if (dirtyAndEmbeddedMmds.isEmpty()) {
            return;
        }
        BasicAttributes embeddedAttributes = new BasicAttributes();
        this.updateMerge(embeddedSM, embeddedAttributes, dirtyAndEmbeddedMmds, embeddedMetaData, insert);
        if (embeddedAttributes.size() > 0) {
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, embeddedSM);
            LDAPUtils.update(this.storeMgr, dn, embeddedAttributes, this.ec);
        }
    }

    private void deleteAsChild(Object oldValue, EmbeddedMetaData embeddedMetaData) {
        ObjectProvider embeddedSM = this.getEmbeddedObjectProvider(oldValue);
        LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, embeddedSM);
        LDAPUtils.deleteRecursive(this.storeMgr, dn, this.ec);
    }

    private void updateEmbedded(Object value) {
        ObjectProvider embeddedSM;
        if (value == null) {
            int[] allMemberPositions;
            embeddedSM = this.ec.newObjectProviderForEmbedded(this.effectiveClassMetaData, null, -1);
            for (int i : allMemberPositions = embeddedSM.getClassMetaData().getAllMemberPositions()) {
                embeddedSM.makeDirty(i);
            }
            value = embeddedSM.getObject();
        }
        embeddedSM = this.ec.findObjectProvider(value);
        boolean insert = false;
        if (embeddedSM == null) {
            embeddedSM = this.getEmbeddedObjectProvider(value);
            insert = true;
        }
        EmbeddedMetaData embeddedMetaData = this.mmd.getEmbeddedMetaData();
        ArrayList<AbstractMemberMetaData> embeddedMmds = new ArrayList<AbstractMemberMetaData>(Arrays.asList(embeddedMetaData.getMemberMetaData()));
        this.updateMerge(embeddedSM, this.attributes, embeddedMmds, embeddedMetaData, insert);
    }

    private void updateMerge(ObjectProvider embeddedSM, Attributes embeddedAttributes, List<AbstractMemberMetaData> embeddedMmds, EmbeddedMetaData embeddedMetaData, boolean insert) {
        AbstractClassMetaData embeddedCmd = embeddedSM.getClassMetaData();
        for (AbstractMemberMetaData embeddedMmd : embeddedMmds) {
            String fieldName = embeddedMmd.getName();
            int i = embeddedCmd.getAbsolutePositionOfMember(fieldName);
            if (fieldName.equals(embeddedMetaData.getOwnerMember())) {
                Object embeddedValue = this.op.getObject();
                embeddedSM.replaceField(i, embeddedValue);
                continue;
            }
            if (!embeddedMmd.isPrimaryKey()) continue;
            AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(this.storeMgr, embeddedSM, embeddedMmd, embeddedAttributes);
            Object embeddedValue = embeddedSM.provideField(i);
            ms.update(embeddedValue);
        }
        String[] dirtyFieldNames = embeddedSM.getDirtyFieldNames();
        ArrayList dirtyFieldNameList = dirtyFieldNames != null ? Arrays.asList(dirtyFieldNames) : new ArrayList();
        for (AbstractMemberMetaData embeddedMmd : embeddedMmds) {
            String fieldName = embeddedMmd.getName();
            if (fieldName.equals(embeddedMetaData.getOwnerMember()) || embeddedMmd.isPrimaryKey()) continue;
            int i = embeddedCmd.getAbsolutePositionOfMember(fieldName);
            AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(this.storeMgr, embeddedSM, embeddedMmd, embeddedAttributes);
            Object embeddedValue = embeddedSM.provideField(i);
            if (!insert && !LDAPUtils.isEmbeddedField(embeddedMmd) && !dirtyFieldNameList.contains(fieldName)) continue;
            ms.update(embeddedValue);
        }
    }

    @Override
    public List<String> getAttributeNames() {
        Class c = this.ec.getClassLoaderResolver().classForName(this.effectiveClassMetaData.getFullClassName());
        if (c.isInterface() || Modifier.isAbstract(c.getModifiers())) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> names = new ArrayList<String>();
        EmbeddedMetaData embeddedMetaData = null;
        RelationType relType = this.mmd.getRelationType(this.clr);
        if (relType == RelationType.ONE_TO_ONE_UNI || relType == RelationType.ONE_TO_ONE_BI) {
            embeddedMetaData = this.mmd.getEmbeddedMetaData();
        } else if (relType == RelationType.ONE_TO_MANY_UNI || relType == RelationType.ONE_TO_MANY_BI) {
            embeddedMetaData = this.mmd.getElementMetaData().getEmbeddedMetaData();
        }
        if (embeddedMetaData != null) {
            ArrayList<AbstractMemberMetaData> embeddedMmds = new ArrayList<AbstractMemberMetaData>(Arrays.asList(embeddedMetaData.getMemberMetaData()));
            ObjectProvider embeddedSM = this.ec.newObjectProviderForEmbedded(this.effectiveClassMetaData, null, -1);
            for (AbstractMemberMetaData embeddedMmd : embeddedMmds) {
                AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(this.storeMgr, embeddedSM, embeddedMmd, new BasicAttributes());
                if (ms == null) continue;
                List<String> embeddedAttributeNames = ms.getAttributeNames();
                names.addAll(embeddedAttributeNames);
            }
        }
        return names;
    }
}

