/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.Transaction;
import org.datanucleus.TransactionEventListener;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.ldap.LDAPStoreManager;
import org.datanucleus.store.ldap.LDAPTransactionEventListener;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.FetchFieldManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class LDAPUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.ldap.Localisation", (ClassLoader)LDAPStoreManager.class.getClassLoader());
    public static final String[] NO_ATTRIBUTES = new String[0];

    public static ObjectProvider getObjectProviderForObject(Object object, ExecutionContext ec, boolean persist) {
        ObjectProvider smpc = ec.findObjectProvider(object, persist);
        return smpc;
    }

    public static AbstractClassMetaData getEffectiveClassMetaData(AbstractMemberMetaData mmd, MetaDataManager mmgr) {
        AbstractClassMetaData collectionFieldTypeCmd;
        AbstractClassMetaData fieldTypeCmd;
        ClassLoaderResolver clr = mmgr.getNucleusContext().getClassLoaderResolver(null);
        String[] fieldTypes = mmd.getFieldTypes();
        if (fieldTypes != null && fieldTypes.length > 0 && (fieldTypeCmd = mmgr.getMetaDataForClass(fieldTypes[0], clr)) != null) {
            return fieldTypeCmd;
        }
        fieldTypeCmd = mmgr.getMetaDataForClass(mmd.getType(), clr);
        if (fieldTypeCmd != null) {
            return fieldTypeCmd;
        }
        AbstractClassMetaData abstractClassMetaData = collectionFieldTypeCmd = mmd.getCollection() != null ? mmd.getCollection().getElementClassMetaData(clr, mmgr) : null;
        if (collectionFieldTypeCmd != null) {
            return collectionFieldTypeCmd;
        }
        return null;
    }

    public static AbstractMemberMetaData getMemberMetadataForAttributeName(AbstractClassMetaData cmd, String attributeName) {
        if (cmd != null && attributeName != null) {
            List<AbstractMemberMetaData> allMemberMetaData = LDAPUtils.getAllMemberMetaData(cmd);
            for (AbstractMemberMetaData mmd : allMemberMetaData) {
                String attributeNameForField = LDAPUtils.getAttributeNameForField(mmd);
                if (!attributeName.equals(attributeNameForField)) continue;
                return mmd;
            }
        }
        return null;
    }

    public static List<AbstractMemberMetaData> getAllMemberMetaData(AbstractClassMetaData cmd) {
        int[] fieldNumbers = cmd.getAllMemberPositions();
        return LDAPUtils.getMemberMetaData(fieldNumbers, cmd);
    }

    public static List<AbstractMemberMetaData> getMemberMetaData(int[] fieldNumbers, AbstractClassMetaData cmd) {
        ArrayList<AbstractMemberMetaData> mmds = new ArrayList<AbstractMemberMetaData>();
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            for (int fieldNumber : fieldNumbers) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                mmds.add(mmd);
            }
        }
        return mmds;
    }

    public static boolean isEmbeddedField(AbstractMemberMetaData mmd) {
        return mmd.getEmbeddedMetaData() != null || mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null;
    }

    public static boolean isHierarchicalMappedAtChild(ObjectProvider sm) {
        LocationInfo locationInfo = LDAPUtils.getLocationInfo(sm.getClassMetaData());
        return locationInfo.parentFieldName != null;
    }

    public static LdapName getParentDistingueshedName(LdapName dn, LdapName suffix) {
        LdapName parent = (LdapName)dn.getPrefix(dn.size() - suffix.size() - 1);
        return parent;
    }

    private static Rdn getRdnForObject(StoreManager storeMgr, ObjectProvider op) throws InvalidNameException {
        AbstractClassMetaData cmd = op.getClassMetaData();
        int fieldNumber = cmd.getPKMemberPositions()[0];
        Object value = op.provideField(fieldNumber);
        AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        BasicAttributes rdnAttributes = new BasicAttributes();
        AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(storeMgr, op, mmd, rdnAttributes);
        ms.insert(value);
        Rdn rdn = new Rdn(rdnAttributes);
        return rdn;
    }

    public static LdapName getDistinguishedNameForObject(StoreManager storeMgr, ObjectProvider op) {
        return LDAPUtils.getDistinguishedNameForObject(storeMgr, op, false);
    }

    public static LdapName getDistinguishedNameForObject(StoreManager storeMgr, ObjectProvider op, boolean forceFetchHierarchicalMappedDn) {
        return LDAPUtils.getDistinguishedNameForObject(storeMgr, op, null, forceFetchHierarchicalMappedDn);
    }

    private static LdapName getDistinguishedNameForObject(StoreManager storeMgr, ObjectProvider op, Set<ObjectProvider> handledOPs, boolean forceFetchHierarchicalMappedDn) {
        LdapName dn;
        if (handledOPs == null) {
            handledOPs = new HashSet<ObjectProvider>();
        }
        if (handledOPs.contains(op)) {
            throw new NucleusDataStoreException("Recursive loop detected while creating distinguished name for " + op);
        }
        handledOPs.add(op);
        AbstractClassMetaData cmd = op.getClassMetaData();
        LocationInfo locationInfo = LDAPUtils.getLocationInfo(cmd);
        ExecutionContext ec = op.getExecutionContext();
        try {
            SearchControls searchControls = LDAPUtils.getSearchControls(cmd);
            if (op.getEmbeddedOwners() != null && op.getEmbeddedOwners().length > 0) {
                ObjectProvider owner = op.getEmbeddedOwners()[0];
                dn = LDAPUtils.getDistinguishedNameForObject(storeMgr, owner, handledOPs, forceFetchHierarchicalMappedDn);
                dn.add(LDAPUtils.getRdnForObject(storeMgr, op));
            } else if (searchControls.getSearchScope() == 0) {
                dn = locationInfo.dn;
            } else if (LDAPUtils.isHierarchicalMappedAtChild(op)) {
                LdapName parentDn;
                Rdn rdn = LDAPUtils.getRdnForObject(storeMgr, op);
                AbstractMemberMetaData parentFieldMmd = cmd.getMetaDataForMember(locationInfo.parentFieldName);
                if (forceFetchHierarchicalMappedDn) {
                    AbstractClassMetaData parentFieldTypeCmd = ec.getMetaDataManager().getMetaDataForClass(parentFieldMmd.getType(), ec.getClassLoaderResolver());
                    LdapName base = LDAPUtils.getSearchBase(parentFieldTypeCmd, ec.getMetaDataManager());
                    String ocFilter = LDAPUtils.getSearchFilter(cmd);
                    String rdnFilter = "(" + rdn.getType() + "=" + rdn.getValue() + ")";
                    String filter = ocFilter != null ? "(&" + ocFilter + rdnFilter + ")" : rdnFilter;
                    ManagedConnection mconn = storeMgr.getConnection(ec);
                    try {
                        NamingEnumeration<SearchResult> enumeration;
                        DirContext ctx = (DirContext)mconn.getConnection();
                        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("LDAP.JNDI.search", (Object)base, (Object)filter, (Object)searchControls.getSearchScope()));
                        }
                        if ((enumeration = ctx.search((Name)base, filter, searchControls)).hasMoreElements()) {
                            SearchResult sr = (SearchResult)enumeration.nextElement();
                            String srName = sr.getNameInNamespace();
                            LdapName srDn = new LdapName(srName);
                            parentDn = LDAPUtils.getParentDistingueshedName(srDn, locationInfo.suffix);
                            enumeration.close();
                        }
                        if (locationInfo.dn != null) {
                            parentDn = locationInfo.dn;
                        }
                        throw new NucleusObjectNotFoundException("No distinguished name found for object " + op.toString());
                    }
                    catch (NamingException e) {
                        throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        mconn.release();
                    }
                } else {
                    Object parentFieldValue = op.provideField(parentFieldMmd.getAbsoluteFieldNumber());
                    if (parentFieldValue != null) {
                        boolean detached = ec.getApiAdapter().isDetached(parentFieldValue);
                        ObjectProvider parentSm = LDAPUtils.getObjectProviderForObject(parentFieldValue, ec, detached);
                        if (parentSm == null) {
                            throw new NucleusObjectNotFoundException("No state manager found for object " + parentFieldValue);
                        }
                        parentDn = LDAPUtils.getDistinguishedNameForObject(storeMgr, parentSm, handledOPs, forceFetchHierarchicalMappedDn);
                    } else if (locationInfo.dn != null) {
                        parentDn = locationInfo.dn;
                    } else {
                        handledOPs.remove(op);
                        LdapName smDn = LDAPUtils.getDistinguishedNameForObject(storeMgr, op, handledOPs, true);
                        parentDn = LDAPUtils.getParentDistingueshedName(smDn, locationInfo.suffix);
                    }
                }
                dn = LDAPUtils.composeDistinguishedName(parentDn, rdn, locationInfo.suffix);
            } else {
                dn = new LdapName(locationInfo.dn.toString());
                dn.add(LDAPUtils.getRdnForObject(storeMgr, op));
            }
        }
        catch (InvalidNameException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        return dn;
    }

    public static LdapName getSearchBase(AbstractClassMetaData cmd, MetaDataManager mmgr) {
        LdapName dn;
        try {
            LocationInfo locationInfo = LDAPUtils.getLocationInfo(cmd);
            if (locationInfo.parentFieldName != null && locationInfo.dn == null) {
                AbstractMemberMetaData parentMmd = cmd.getMetaDataForMember(locationInfo.parentFieldName);
                ClassLoaderResolver clr = mmgr.getNucleusContext().getClassLoaderResolver(null);
                AbstractClassMetaData parentFieldCmd = mmgr.getMetaDataForClass(parentMmd.getType(), clr);
                LdapName parentDn = LDAPUtils.getSearchBase(parentFieldCmd, mmgr);
                dn = LDAPUtils.composeDistinguishedName(parentDn, null, locationInfo.suffix);
            } else {
                dn = locationInfo.dn;
            }
        }
        catch (InvalidNameException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        return dn;
    }

    public static SearchControls getSearchControls(AbstractClassMetaData cmd) {
        SearchControls searchControls = new SearchControls();
        LocationInfo locationInfo = LDAPUtils.getLocationInfo(cmd);
        if (locationInfo.parentFieldName != null) {
            searchControls.setSearchScope(2);
        }
        if (locationInfo.scope != -1) {
            searchControls.setSearchScope(locationInfo.scope);
        }
        return searchControls;
    }

    public static String getSearchFilter(AbstractClassMetaData cmd) {
        LocationInfo locationInfo = LDAPUtils.getLocationInfo(cmd);
        String urlFilter = locationInfo.filter;
        Set<String> objectClasses = LDAPUtils.getObjectClassesForClass(cmd);
        if (objectClasses.isEmpty()) {
            return null;
        }
        StringBuffer filter = new StringBuffer();
        if (objectClasses.size() > 1 || urlFilter != null) {
            filter.append("(&");
            for (String oc : objectClasses) {
                filter.append("(objectClass=");
                filter.append(oc);
                filter.append(")");
            }
            if (urlFilter != null) {
                filter.append(urlFilter);
            }
            filter.append(")");
        } else {
            filter.append("(objectClass=");
            filter.append(objectClasses.iterator().next());
            filter.append(")");
        }
        return filter.toString();
    }

    public static LocationInfo getLocationInfo(AbstractClassMetaData cmd) {
        String raw = null;
        if (cmd != null && cmd.hasExtension("dn")) {
            raw = cmd.getValueForExtension("dn");
        } else if (cmd != null && cmd.getTable() != null) {
            raw = cmd.getTable();
        }
        LocationInfo li = new LocationInfo();
        if (raw != null) {
            String dnOrParentField = null;
            if (raw.startsWith("ldap:///")) {
                String filter;
                String scope;
                String[] split = (raw = raw.substring("ldap:///".length())).split("\\?", 5);
                if (split.length > 0) {
                    dnOrParentField = split[0];
                }
                if (split.length > 1) {
                    // empty if block
                }
                if (split.length > 2 && (scope = split[2]).length() > 0) {
                    if ("base".equals(scope)) {
                        li.scope = 0;
                    } else if ("one".equals(scope)) {
                        li.scope = 1;
                    } else if ("sub".equals(scope)) {
                        li.scope = 2;
                    } else {
                        throw new NucleusDataStoreException("Invalid scope in LDAP URL: " + scope);
                    }
                }
                if (split.length > 3 && (filter = split[3]).length() > 0) {
                    li.filter = filter;
                }
            } else {
                dnOrParentField = raw;
            }
            if (dnOrParentField != null) {
                int left = dnOrParentField.indexOf(123);
                int right = dnOrParentField.indexOf(125);
                if (left > -1 && right > left) {
                    li.parentFieldName = dnOrParentField.substring(left + 1, right);
                    try {
                        String suffix = dnOrParentField.substring(0, left);
                        LdapName suffixDn = new LdapName(suffix);
                        if (suffixDn.size() > 0 && suffixDn.getRdn(0).size() == 0) {
                            suffixDn.remove(0);
                        }
                        li.suffix = suffixDn;
                    }
                    catch (InvalidNameException e) {
                        throw new NucleusDataStoreException("Invalid LDAP DN: " + dnOrParentField);
                    }
                    if (dnOrParentField.length() > right + 2 && dnOrParentField.charAt(right + 1) == '|') {
                        try {
                            li.dn = new LdapName(dnOrParentField.substring(right + 2, dnOrParentField.length()));
                        }
                        catch (InvalidNameException e) {
                            throw new NucleusDataStoreException("Invalid LDAP DN: " + dnOrParentField);
                        }
                    }
                } else {
                    try {
                        li.dn = new LdapName(dnOrParentField);
                    }
                    catch (InvalidNameException e) {
                        throw new NucleusDataStoreException("Invalid LDAP DN: " + dnOrParentField);
                    }
                }
            }
        }
        return li;
    }

    public static String getEmptyValue(AbstractMemberMetaData mmd) {
        return mmd.getValueForExtension("empty-value");
    }

    public static Object getAttributeValue(StoreManager storeMgr, ObjectProvider op, String attributeName) {
        try {
            AbstractMemberMetaData pcMmd = LDAPUtils.getMemberMetadataForAttributeName(op.getClassMetaData(), attributeName);
            Object pcFieldValue = op.provideField(pcMmd.getAbsoluteFieldNumber());
            BasicAttributes pcAttributes = new BasicAttributes();
            AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(storeMgr, op, pcMmd, pcAttributes);
            ms.insert(pcFieldValue);
            Attribute pcAttribute = pcAttributes.get(attributeName);
            Object pcAttributeValue = pcAttribute.get();
            return pcAttributeValue;
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public static Collection<Object> getAttributeValuesFromLDAP(StoreManager storeMgr, ObjectProvider op, String attributeName) {
        ManagedConnection mconn = storeMgr.getConnection(op.getExecutionContext());
        try {
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(storeMgr, op, true);
            DirContext ctx = (DirContext)mconn.getConnection();
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)LOCALISER.msg("LDAP.JNDI.getAttributes", (Object)dn, (Object)attributeName, (Object)""));
            }
            Attributes attributes = ctx.getAttributes(dn, new String[]{attributeName});
            Attribute attribute = attributes.get(attributeName);
            ArrayList<Object> pcAttributeValues = new ArrayList<Object>();
            if (attribute != null) {
                NamingEnumeration<?> all = attribute.getAll();
                while (all.hasMoreElements()) {
                    pcAttributeValues.add(all.nextElement());
                }
            }
            ArrayList<Object> arrayList = pcAttributeValues;
            return arrayList;
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public static String getAttributeNameForField(AbstractMemberMetaData mmd) {
        String name = mmd.getName();
        if (mmd.hasExtension("dn")) {
            name = mmd.getValueForExtension("dn");
        } else if (mmd.hasExtension("attribute")) {
            name = mmd.getValueForExtension("attribute");
        } else if (mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
            name = mmd.getColumnMetaData()[0].getName();
        }
        return name;
    }

    public static Set<String> getObjectClassesForClass(AbstractClassMetaData cmd) {
        LinkedHashSet<String> ocs = new LinkedHashSet<String>();
        if (cmd.hasExtension("objectClass")) {
            ocs.addAll(Arrays.asList(cmd.getValuesForExtension("objectClass")));
        } else if (cmd.getSchema() != null) {
            ocs.addAll(Arrays.asList(MetaDataUtils.getInstance().getValuesForCommaSeparatedAttribute(cmd.getSchema())));
        }
        return ocs;
    }

    public static LdapName composeDistinguishedName(LdapName parentDn, Rdn rdn, LdapName suffix) throws InvalidNameException {
        LdapName dn = new LdapName(parentDn.getRdns());
        dn.addAll(suffix.getRdns());
        if (rdn != null) {
            dn.add(rdn);
        }
        return dn;
    }

    public static Object getObjectByDN(StoreManager storeMgr, ExecutionContext om, Class type, String dnAsString) {
        AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(type, om.getClassLoaderResolver());
        LdapName base = LDAPUtils.getSearchBase(cmd, om.getMetaDataManager());
        try {
            LdapName dn = new LdapName(dnAsString);
            Rdn rdn = dn.getRdn(dn.size() - 1);
            String filter = "(" + rdn.getType() + "=" + rdn.getValue() + ")";
            List<Object> objects = LDAPUtils.getObjectsOfCandidateType(storeMgr, om, cmd, base, filter, true, false);
            if (objects.size() == 1) {
                return objects.get(0);
            }
            if (objects.size() == 0) {
                throw new NucleusObjectNotFoundException("No object found with type " + type + " and filter " + filter);
            }
            throw new NucleusDataStoreException("Unambiguous match with type " + type + " and filter " + filter);
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public static Object getObjectByAttribute(StoreManager storeMgr, ExecutionContext ec, Class type, String attributeName, String attributeValue, MetaDataManager mmgr) {
        LdapName base;
        String attributeFilter = "(" + attributeName + "=" + attributeValue + ")";
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(type, ec.getClassLoaderResolver());
        List<Object> objects = LDAPUtils.getObjectsOfCandidateType(storeMgr, ec, cmd, base = LDAPUtils.getSearchBase(cmd, mmgr), attributeFilter, true, false);
        if (objects.size() == 1) {
            return objects.get(0);
        }
        if (objects.size() == 0) {
            throw new NucleusObjectNotFoundException("No object found with type " + type + " and filter " + attributeFilter);
        }
        throw new NucleusDataStoreException("Unambiguous match with type " + type + " and filter " + attributeFilter);
    }

    public static void markForPersisting(Object pc, ExecutionContext ec) {
        LDAPTransactionEventListener listener = LDAPUtils.getTransactionEventListener(ec);
        listener.addObjectToPersist(pc);
    }

    public static void markForRename(StoreManager storeMgr, Object pc, ExecutionContext ec, LdapName oldDn, LdapName newDn) {
        ManagedConnection mconn = storeMgr.getConnection(ec);
        try {
            DirContext ctx = (DirContext)mconn.getConnection();
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)LOCALISER.msg("LDAP.JNDI.rename", (Object)oldDn, (Object)newDn));
            }
            ctx.rename(oldDn, newDn);
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public static void markForDeletion(Object pc, ExecutionContext ec) {
        LDAPTransactionEventListener listener = LDAPUtils.getTransactionEventListener(ec);
        listener.addObjectToDelete(pc);
    }

    public static void unmarkForDeletion(Object pc, ExecutionContext ec) {
        LDAPTransactionEventListener listener = LDAPUtils.getTransactionEventListener(ec);
        listener.removeObjectToDelete(pc);
    }

    private static LDAPTransactionEventListener getTransactionEventListener(ExecutionContext ec) {
        LDAPTransactionEventListener listener;
        Transaction transaction = ec.getTransaction();
        Map txOptions = transaction.getOptions();
        LDAPTransactionEventListener lDAPTransactionEventListener = listener = txOptions != null ? (LDAPTransactionEventListener)txOptions.get("LDAPTransactionEventListener") : null;
        if (listener == null) {
            listener = new LDAPTransactionEventListener(ec);
            transaction.setOption("LDAPTransactionEventListener", (Object)listener);
            transaction.addTransactionEventListener((TransactionEventListener)listener);
        }
        return listener;
    }

    public static List<Object> getObjectsOfCandidateType(StoreManager storeMgr, ExecutionContext ec, QueryCompilation compilation, Map parameters, Class candidateClass, boolean subclasses, boolean ignoreCache, boolean inMemory) {
        String[] subclassNames;
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(candidateClass, clr);
        List<Object> results = LDAPUtils.getObjectsOfCandidateType(storeMgr, ec, compilation, parameters, cmd, ignoreCache, inMemory);
        if (subclasses && (subclassNames = ec.getMetaDataManager().getSubclassesForClass(candidateClass.getName(), true)) != null) {
            for (String subclassName : subclassNames) {
                AbstractClassMetaData subCmd = ec.getMetaDataManager().getMetaDataForClass(subclassName, clr);
                results.addAll(LDAPUtils.getObjectsOfCandidateType(storeMgr, ec, compilation, parameters, subCmd, ignoreCache, inMemory));
            }
        }
        return results;
    }

    private static List<Object> getObjectsOfCandidateType(StoreManager storeMgr, ExecutionContext ec, QueryCompilation compilation, Map parameters, AbstractClassMetaData acmd, boolean ignoreCache, boolean inMemory) {
        List<Object> results = new ArrayList<Object>();
        String classFilter = LDAPUtils.getSearchFilter(acmd);
        if (classFilter != null) {
            if (!inMemory) {
                try {
                    String className = "org.datanucleus.store.ldap.query.QueryToLDAPFilterMapper";
                    Class cls = ec.getClassLoaderResolver().classForName(className);
                    Method method = ClassUtils.getMethodForClass((Class)cls, (String)"compile", null);
                    Constructor constr = ClassUtils.getConstructorWithArguments((Class)cls, (Class[])new Class[]{QueryCompilation.class, Map.class, AbstractClassMetaData.class});
                    String filter = (String)method.invoke(constr.newInstance(compilation, parameters, acmd), (Object[])null);
                    results = LDAPUtils.getObjectsOfCandidateType(storeMgr, ec, acmd, null, filter, ignoreCache);
                }
                catch (Throwable e) {
                    NucleusLogger.QUERY.warn((Object)LOCALISER.msg("LDAP.Query.NativeQueryFailed"));
                    inMemory = true;
                }
            }
            if (inMemory) {
                results = LDAPUtils.getObjectsOfCandidateType(storeMgr, ec, acmd, null, classFilter, ignoreCache);
            }
        }
        return results;
    }

    public static List<Object> getObjectsOfCandidateType(StoreManager storeMgr, ExecutionContext ec, AbstractClassMetaData candidateCmd, LdapName base, String additionalFilter, boolean subclasses, boolean ignoreCache) {
        String[] subclassNames;
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        List<Object> results = LDAPUtils.getObjectsOfCandidateType(storeMgr, ec, candidateCmd, base, additionalFilter, ignoreCache);
        if (subclasses && (subclassNames = ec.getMetaDataManager().getSubclassesForClass(candidateCmd.getFullClassName(), true)) != null) {
            for (String subclassName : subclassNames) {
                AbstractClassMetaData subCmd = ec.getMetaDataManager().getMetaDataForClass(subclassName, clr);
                results.addAll(LDAPUtils.getObjectsOfCandidateType(storeMgr, ec, subCmd, base, additionalFilter, ignoreCache));
            }
        }
        return results;
    }

    private static List<Object> getObjectsOfCandidateType(final StoreManager storeMgr, final ExecutionContext ec, final AbstractClassMetaData cmd, LdapName base, String additionalFilter, boolean ignoreCache) {
        ArrayList<Object> results = new ArrayList<Object>();
        final ClassLoaderResolver clr = ec.getClassLoaderResolver();
        Map<LdapName, Attributes> entries = LDAPUtils.getEntries(storeMgr, ec, cmd, base, additionalFilter, false, ignoreCache);
        for (final Attributes attrs : entries.values()) {
            Object pc = LDAPUtils.findObjectUsingAID(ec, clr.classForName(cmd.getFullClassName()), new FieldValues(){

                public void fetchFields(ObjectProvider op) {
                    op.replaceFields(cmd.getPKMemberPositions(), (FieldManager)new FetchFieldManager(storeMgr, op, attrs));
                    List<AbstractMemberMetaData> allMemberMetaData = LDAPUtils.getAllMemberMetaData(cmd);
                    ArrayList<AbstractMemberMetaData> basicMemberMetaData = new ArrayList<AbstractMemberMetaData>();
                    for (AbstractMemberMetaData mmd : allMemberMetaData) {
                        mmd.getAbsoluteFieldNumber();
                        if (mmd.getRelationType(clr) != RelationType.NONE || mmd.isPersistentInterface(clr, ec.getMetaDataManager()) || Collection.class.isAssignableFrom(mmd.getType()) || Map.class.isAssignableFrom(mmd.getType()) || mmd.getType().isArray()) continue;
                        basicMemberMetaData.add(mmd);
                    }
                    int[] basicMemberPosition = new int[basicMemberMetaData.size()];
                    for (int i = 0; i < basicMemberMetaData.size(); ++i) {
                        basicMemberPosition[i] = ((AbstractMemberMetaData)basicMemberMetaData.get(i)).getAbsoluteFieldNumber();
                    }
                    op.replaceFields(basicMemberPosition, (FieldManager)new FetchFieldManager(storeMgr, op, attrs));
                }

                public void fetchNonLoadedFields(ObjectProvider op) {
                    op.replaceNonLoadedFields(cmd.getAllMemberPositions(), (FieldManager)new FetchFieldManager(storeMgr, op, attrs));
                }

                public FetchPlan getFetchPlanForLoading() {
                    return null;
                }
            }, ignoreCache, true);
            results.add(pc);
        }
        return results;
    }

    protected static Object findObjectUsingAID(ExecutionContext ec, Class pcCls, FieldValues fv, boolean ignoreCache, boolean checkInheritance) {
        Object pc;
        Object oid;
        ObjectProvider op = ec.getNucleusContext().getObjectProviderFactory().newForHollowPopulatedAppId(ec, pcCls, fv);
        if (!ignoreCache) {
            oid = op.getInternalObjectId();
            pc = ec.getObjectFromCache(oid);
            if (pc != null) {
                op = ec.findObjectProvider(pc);
                op.loadFieldValues(fv);
                return pc;
            }
            if (checkInheritance) {
                String[] subclasses;
                ApiAdapter api = ec.getApiAdapter();
                if ((oid instanceof OID || api.isSingleFieldIdentity(oid)) && (subclasses = ec.getMetaDataManager().getSubclassesForClass(pcCls.getName(), true)) != null) {
                    for (int i = 0; i < subclasses.length; ++i) {
                        if (api.isDatastoreIdentity(oid)) {
                            oid = OIDFactory.getInstance((PersistenceNucleusContext)ec.getNucleusContext(), (String)subclasses[i], (Object)((OID)oid).getKeyValue());
                        } else if (api.isSingleFieldIdentity(oid)) {
                            oid = api.getNewSingleFieldIdentity(oid.getClass(), ec.getClassLoaderResolver().classForName(subclasses[i]), api.getTargetKeyForSingleFieldIdentity(oid));
                        }
                        pc = ec.getObjectFromCache(oid);
                        if (pc == null) continue;
                        op = ec.findObjectProvider(pc);
                        op.loadFieldValues(fv);
                        return pc;
                    }
                }
            }
        }
        if (checkInheritance) {
            op.checkInheritance(fv);
            if (!ignoreCache && (pc = ec.getObjectFromCache(oid = op.getInternalObjectId())) != null) {
                op = ec.findObjectProvider(pc);
                op.loadFieldValues(fv);
                return pc;
            }
        }
        ec.putObjectIntoLevel1Cache(op);
        return op.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<LdapName, Attributes> getEntries(StoreManager storeMgr, ExecutionContext ec, AbstractClassMetaData candidateCmd, LdapName base, String additionalFilter, boolean subclasses, boolean ignoreCache) {
        ManagedConnection mconn = storeMgr.getConnection(ec);
        try {
            String[] subclassNames;
            DirContext ctx = (DirContext)mconn.getConnection();
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            Map<LdapName, Attributes> results = LDAPUtils.getEntries(ec, candidateCmd, ctx, base, additionalFilter, ignoreCache);
            if (subclasses && (subclassNames = ec.getMetaDataManager().getSubclassesForClass(candidateCmd.getFullClassName(), true)) != null) {
                for (String subclassName : subclassNames) {
                    AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(subclassName, clr);
                    results.putAll(LDAPUtils.getEntries(ec, cmd, ctx, base, additionalFilter, ignoreCache));
                }
            }
            Map<LdapName, Attributes> map = results;
            return map;
        }
        finally {
            mconn.release();
        }
    }

    private static Map<LdapName, Attributes> getEntries(ExecutionContext ec, AbstractClassMetaData acmd, DirContext ctx, LdapName base, String additionalFilter, boolean ignoreCache) {
        LinkedHashMap<LdapName, Attributes> results = new LinkedHashMap<LdapName, Attributes>();
        Class c = ec.getClassLoaderResolver().classForName(acmd.getFullClassName());
        if (c.isInterface() || Modifier.isAbstract(c.getModifiers())) {
            return results;
        }
        try {
            if (base == null) {
                base = LDAPUtils.getSearchBase(acmd, ec.getMetaDataManager());
            }
            String filter = LDAPUtils.getSearchFilter(acmd);
            if (additionalFilter != null) {
                filter = "(&" + filter + additionalFilter + ")";
            }
            SearchControls searchControls = LDAPUtils.getSearchControls(acmd);
            if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)LOCALISER.msg("LDAP.JNDI.search", (Object)base, (Object)filter, (Object)searchControls.getSearchScope()));
            }
            NamingEnumeration<SearchResult> enumeration = ctx.search(base.toString(), filter, searchControls);
            while (enumeration.hasMoreElements()) {
                SearchResult sr = (SearchResult)enumeration.nextElement();
                Attributes attrs = sr.getAttributes();
                String name = sr.getNameInNamespace();
                LdapName dn = new LdapName(name);
                if (searchControls.getSearchScope() == 2 && dn.equals(base)) continue;
                results.put(dn, attrs);
            }
        }
        catch (NameNotFoundException nnfe) {
        }
        catch (NamingException ne) {
            throw new NucleusDataStoreException(ne.getMessage(), (Throwable)ne);
        }
        return results;
    }

    public static void insert(StoreManager storeMgr, LdapName dn, Attributes attributes, ExecutionContext ec) {
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)LOCALISER.msg("LDAP.JNDI.createSubcontext", (Object)dn, (Object)attributes));
        }
        ManagedConnection mconn = storeMgr.getConnection(ec);
        try {
            DirContext ctx = (DirContext)mconn.getConnection();
            ctx.bind(dn, null, attributes);
        }
        catch (NamingException ne) {
            throw new NucleusDataStoreException(ne.getMessage(), (Throwable)ne);
        }
        finally {
            mconn.release();
        }
    }

    public static void update(StoreManager storeMgr, LdapName dn, Attributes attributes, ExecutionContext ec) {
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)LOCALISER.msg("LDAP.JNDI.modifyAttributes", (Object)dn, (Object)"REPLACE", (Object)attributes));
        }
        ManagedConnection mconn = storeMgr.getConnection(ec);
        try {
            DirContext ctx = (DirContext)mconn.getConnection();
            ctx.modifyAttributes(dn, 2, attributes);
        }
        catch (NamingException ne) {
            throw new NucleusDataStoreException(ne.getMessage(), (Throwable)ne);
        }
        finally {
            mconn.release();
        }
    }

    public static void deleteRecursive(StoreManager storeMgr, LdapName dn, ExecutionContext ec) {
        ManagedConnection mconn = storeMgr.getConnection(ec);
        try {
            DirContext ctx = (DirContext)mconn.getConnection();
            LDAPUtils.deleteRecursive(dn, ctx);
        }
        catch (NamingException ne) {
            throw new NucleusDataStoreException(ne.getMessage(), (Throwable)ne);
        }
        finally {
            mconn.release();
        }
    }

    public static void deleteRecursive(LdapName dn, DirContext ctx) throws NamingException {
        NamingEnumeration<SearchResult> enumeration = ctx.search((Name)dn, "(objectClass=*)", new SearchControls());
        while (enumeration.hasMoreElements()) {
            SearchResult result = (SearchResult)enumeration.nextElement();
            String resultName = result.getNameInNamespace();
            LdapName resultDn = new LdapName(resultName);
            try {
                if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)LOCALISER.msg("LDAP.JNDI.destroySubcontext", (Object)resultDn));
                }
                ctx.unbind(resultDn);
            }
            catch (ContextNotEmptyException cnee) {
                LDAPUtils.deleteRecursive(resultDn, ctx);
            }
        }
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_NATIVE.debug((Object)LOCALISER.msg("LDAP.JNDI.destroySubcontext", (Object)dn));
        }
        ctx.unbind(dn);
    }

    public static class LocationInfo {
        public LdapName dn = null;
        public String parentFieldName = null;
        public LdapName suffix = null;
        public String filter = null;
        public int scope = -1;
    }
}

