/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.ldap.fieldmanager.GeneralizedTime;
import org.datanucleus.store.types.converters.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateToGeneralizedTimeStringConverter
implements TypeConverter<Date, String> {
    public Date toMemberType(String str) {
        if (str == null) {
            return null;
        }
        Calendar cal = null;
        try {
            GeneralizedTime gt = new GeneralizedTime(str);
            cal = gt.getCalendar();
            cal.set(14, 0);
        }
        catch (ParseException e) {
            throw new NucleusException("Error parsing string to calendar.", (Throwable)e);
        }
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date date = cal.getTime();
        return date;
    }

    public String toDatastoreType(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.setTime(date);
        calendar.set(14, 0);
        GeneralizedTime gt = new GeneralizedTime(calendar);
        return gt.toGeneralizedTime();
    }
}

