/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.CalendarToGeneralizedTimeStringConverter;
import org.datanucleus.store.ldap.fieldmanager.DateToGeneralizedTimeStringConverter;
import org.datanucleus.util.TypeConversionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleArrayMappingStrategy
extends AbstractMappingStrategy {
    public SimpleArrayMappingStrategy(ObjectProvider sm, AbstractMemberMetaData mmd, Attributes attributes) {
        super(sm, mmd, attributes);
        this.type = this.type.getComponentType();
    }

    @Override
    public Object fetch() {
        if (this.attr == null) {
            return null;
        }
        if (Boolean.TYPE.isAssignableFrom(this.type)) {
            return this.fetchBooleanArrayField();
        }
        if (Byte.TYPE.isAssignableFrom(this.type)) {
            return this.fetchByteArrayField();
        }
        if (Character.TYPE.isAssignableFrom(this.type)) {
            return this.fetchCharArrayField();
        }
        if (Double.TYPE.isAssignableFrom(this.type)) {
            return this.fetchDoubleArrayField();
        }
        if (Float.TYPE.isAssignableFrom(this.type)) {
            return this.fetchFloatArrayField();
        }
        if (Integer.TYPE.isAssignableFrom(this.type)) {
            return this.fetchIntArrayField();
        }
        if (Long.TYPE.isAssignableFrom(this.type)) {
            return this.fetchLongArrayField();
        }
        if (Short.TYPE.isAssignableFrom(this.type)) {
            return this.fetchShortArrayField();
        }
        if (String.class.isAssignableFrom(this.type)) {
            return this.fetchStringArrayField();
        }
        if (Boolean.class.isAssignableFrom(this.type)) {
            return this.fetchBooleanObjectArrayField();
        }
        if (Byte.class.isAssignableFrom(this.type)) {
            return this.fetchByteObjectArrayField();
        }
        if (Character.class.isAssignableFrom(this.type)) {
            return this.fetchCharacterObjectArrayField();
        }
        if (Double.class.isAssignableFrom(this.type)) {
            return this.fetchDoubleObjectArrayField();
        }
        if (Float.class.isAssignableFrom(this.type)) {
            return this.fetchFloatObjectArrayField();
        }
        if (Integer.class.isAssignableFrom(this.type)) {
            return this.fetchIntegerObjectArrayField();
        }
        if (Long.class.isAssignableFrom(this.type)) {
            return this.fetchLongObjectArrayField();
        }
        if (Short.class.isAssignableFrom(this.type)) {
            return this.fetchShortObjectArrayField();
        }
        Object converter = null;
        converter = Date.class.isAssignableFrom(this.type) ? new DateToGeneralizedTimeStringConverter() : (Calendar.class.isAssignableFrom(this.type) ? new CalendarToGeneralizedTimeStringConverter() : this.op.getExecutionContext().getTypeManager().getTypeConverterForType(this.type, String.class));
        if (converter != null) {
            String[] stringValues = this.fetchStringArrayField();
            Object[] values = (Object[])Array.newInstance(this.type, stringValues.length);
            for (int i = 0; i < stringValues.length; ++i) {
                values[i] = converter.toMemberType(stringValues[i]);
            }
            return values;
        }
        if (this.type.isEnum()) {
            return this.fetchEnumArrayField(this.type);
        }
        throw new NucleusException("Cant obtain value for field " + this.mmd.getFullFieldName() + " since type=" + this.mmd.getTypeName() + " is not supported for this datastore");
    }

    protected boolean[] fetchBooleanArrayField() {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = this.fetchByteArrayField();
            return (boolean[])TypeConversionHelper.getBooleanArrayFromByteArray((byte[])bytes);
        }
        String[] stringValues = this.fetchStringArrayField();
        boolean[] values = new boolean[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Boolean(stringValues[i]);
        }
        return values;
    }

    protected Boolean[] fetchBooleanObjectArrayField() {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = this.fetchByteArrayField();
            return (Boolean[])TypeConversionHelper.getBooleanObjectArrayFromByteArray((byte[])bytes);
        }
        String[] stringValues = this.fetchStringArrayField();
        Boolean[] values = new Boolean[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Boolean(stringValues[i]);
        }
        return values;
    }

    protected byte[] fetchByteArrayField() {
        if (this.mmd.getJoinMetaData() == null) {
            if (this.attr.size() == 0) {
                return null;
            }
            if (this.attr.size() == 1) {
                try {
                    Object object = this.attr.get();
                    if (object instanceof byte[]) {
                        return (byte[])object;
                    }
                    throw new NucleusException("Not a byte[]");
                }
                catch (NamingException e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
            }
            throw new NucleusException("Can't fetch embedded byte[] from multi-valued attribute.");
        }
        String[] stringValues = this.fetchStringArrayField();
        byte[] values = new byte[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Byte(stringValues[i]);
        }
        return values;
    }

    protected Byte[] fetchByteObjectArrayField() {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = this.fetchByteArrayField();
            return (Byte[])TypeConversionHelper.getByteObjectArrayFromByteArray((byte[])bytes);
        }
        String[] stringValues = this.fetchStringArrayField();
        Byte[] values = new Byte[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Byte(stringValues[i]);
        }
        return values;
    }

    protected char[] fetchCharArrayField() {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = this.fetchByteArrayField();
            return (char[])TypeConversionHelper.getCharArrayFromByteArray((byte[])bytes);
        }
        String[] stringValues = this.fetchStringArrayField();
        char[] values = new char[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = stringValues[i].charAt(0);
        }
        return values;
    }

    protected Character[] fetchCharacterObjectArrayField() {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = this.fetchByteArrayField();
            return (Character[])TypeConversionHelper.getCharObjectArrayFromByteArray((byte[])bytes);
        }
        String[] stringValues = this.fetchStringArrayField();
        Character[] values = new Character[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Character(stringValues[i].charAt(0));
        }
        return values;
    }

    protected double[] fetchDoubleArrayField() {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = this.fetchByteArrayField();
            return (double[])TypeConversionHelper.getDoubleArrayFromByteArray((byte[])bytes);
        }
        String[] stringValues = this.fetchStringArrayField();
        double[] values = new double[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Double(stringValues[i]);
        }
        return values;
    }

    protected Double[] fetchDoubleObjectArrayField() {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = this.fetchByteArrayField();
            return (Double[])TypeConversionHelper.getDoubleObjectArrayFromByteArray((byte[])bytes);
        }
        String[] stringValues = this.fetchStringArrayField();
        Double[] values = new Double[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Double(stringValues[i]);
        }
        return values;
    }

    protected float[] fetchFloatArrayField() {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = this.fetchByteArrayField();
            return (float[])TypeConversionHelper.getFloatArrayFromByteArray((byte[])bytes);
        }
        String[] stringValues = this.fetchStringArrayField();
        float[] values = new float[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Float(stringValues[i]).floatValue();
        }
        return values;
    }

    protected Float[] fetchFloatObjectArrayField() {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = this.fetchByteArrayField();
            return (Float[])TypeConversionHelper.getFloatObjectArrayFromByteArray((byte[])bytes);
        }
        String[] stringValues = this.fetchStringArrayField();
        Float[] values = new Float[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Float(stringValues[i]);
        }
        return values;
    }

    protected int[] fetchIntArrayField() {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = this.fetchByteArrayField();
            return (int[])TypeConversionHelper.getIntArrayFromByteArray((byte[])bytes);
        }
        String[] stringValues = this.fetchStringArrayField();
        int[] values = new int[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Integer(stringValues[i]);
        }
        return values;
    }

    protected Integer[] fetchIntegerObjectArrayField() {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = this.fetchByteArrayField();
            return (Integer[])TypeConversionHelper.getIntObjectArrayFromByteArray((byte[])bytes);
        }
        String[] stringValues = this.fetchStringArrayField();
        Integer[] values = new Integer[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = new Integer(stringValues[i]);
        }
        return values;
    }

    protected long[] fetchLongArrayField() {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = this.fetchByteArrayField();
            return (long[])TypeConversionHelper.getLongArrayFromByteArray((byte[])bytes);
        }
        String[] stringValues = this.fetchStringArrayField();
        long[] values = new long[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Long.valueOf(stringValues[i]);
        }
        return values;
    }

    protected Long[] fetchLongObjectArrayField() {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = this.fetchByteArrayField();
            return (Long[])TypeConversionHelper.getLongObjectArrayFromByteArray((byte[])bytes);
        }
        String[] stringValues = this.fetchStringArrayField();
        Long[] values = new Long[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Long.valueOf(stringValues[i]);
        }
        return values;
    }

    protected short[] fetchShortArrayField() {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = this.fetchByteArrayField();
            return (short[])TypeConversionHelper.getShortArrayFromByteArray((byte[])bytes);
        }
        String[] stringValues = this.fetchStringArrayField();
        short[] values = new short[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Short.valueOf(stringValues[i]);
        }
        return values;
    }

    protected Short[] fetchShortObjectArrayField() {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = this.fetchByteArrayField();
            return (Short[])TypeConversionHelper.getShortObjectArrayFromByteArray((byte[])bytes);
        }
        String[] stringValues = this.fetchStringArrayField();
        Short[] values = new Short[stringValues.length];
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Short.valueOf(stringValues[i]);
        }
        return values;
    }

    protected Enum[] fetchEnumArrayField(Class type) {
        String[] stringValues = this.fetchStringArrayField();
        Enum[] values = (Enum[])Array.newInstance(type, stringValues.length);
        for (int i = 0; i < stringValues.length; ++i) {
            values[i] = Enum.valueOf(type, stringValues[i]);
        }
        return values;
    }

    protected String[] fetchStringArrayField() {
        try {
            String[] values = new String[this.attr.size()];
            for (int i = 0; i < this.attr.size(); ++i) {
                values[i] = this.attr.get(i) instanceof byte[] ? new String((byte[])this.attr.get(i), "UTF-8") : (String)this.attr.get(i);
            }
            if (this.mmd.getOrderMetaData() != null) {
                TreeMap<Integer, String> orderingMap = new TreeMap<Integer, String>();
                for (String value : values) {
                    int left = value.indexOf(123);
                    int right = value.indexOf(125);
                    if (left == 0 && right > 0) {
                        try {
                            String number = value.substring(left + 1, right);
                            Integer integer = new Integer(number);
                            value = value.substring(right + 1);
                            if (orderingMap.containsKey(integer)) {
                                throw new NucleusDataStoreException("Ordering index must be unique: " + value);
                            }
                            orderingMap.put(integer, value);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new NucleusDataStoreException("Can't parse ordering index: " + value);
                        }
                    }
                    throw new NucleusDataStoreException("No ordering index at value: " + value);
                }
                values = orderingMap.values().toArray(new String[orderingMap.size()]);
            }
            return values;
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void insert(Object value) {
        if (value == null) {
            return;
        }
        this.store(value);
    }

    @Override
    public void update(Object value) {
        if (value == null) {
            this.attributes.put(new BasicAttribute(this.name));
            return;
        }
        this.store(value);
    }

    protected void store(Object value) {
        if (Boolean.TYPE.isAssignableFrom(this.type)) {
            this.storeBooleanArrayField((boolean[])value);
        } else if (Byte.TYPE.isAssignableFrom(this.type)) {
            this.storeByteArrayField((byte[])value);
        } else if (Character.TYPE.isAssignableFrom(this.type)) {
            this.storeCharArrayField((char[])value);
        } else if (Double.TYPE.isAssignableFrom(this.type)) {
            this.storeDoubleArrayField((double[])value);
        } else if (Float.TYPE.isAssignableFrom(this.type)) {
            this.storeFloatArrayField((float[])value);
        } else if (Integer.TYPE.isAssignableFrom(this.type)) {
            this.storeIntArrayField((int[])value);
        } else if (Long.TYPE.isAssignableFrom(this.type)) {
            this.storeLongArrayField((long[])value);
        } else if (Short.TYPE.isAssignableFrom(this.type)) {
            this.storeShortArrayField((short[])value);
        } else if (String.class.isAssignableFrom(this.type)) {
            this.storeObjectArrayField((String[])value);
        } else if (Boolean.class.isAssignableFrom(this.type)) {
            this.storeBooleanObjectArrayField((Boolean[])value);
        } else if (Byte.class.isAssignableFrom(this.type)) {
            this.storeByteObjectArrayField((Byte[])value);
        } else if (Character.class.isAssignableFrom(this.type)) {
            this.storeCharacterObjectArrayField((Character[])value);
        } else if (Double.class.isAssignableFrom(this.type)) {
            this.storeDoubleObjectArrayField((Double[])value);
        } else if (Float.class.isAssignableFrom(this.type)) {
            this.storeFloatObjectArrayField((Float[])value);
        } else if (Integer.class.isAssignableFrom(this.type)) {
            this.storeIntegerObjectArrayField((Integer[])value);
        } else if (Long.class.isAssignableFrom(this.type)) {
            this.storeLongObjectArrayField((Long[])value);
        } else if (Short.class.isAssignableFrom(this.type)) {
            this.storeShortObjectArrayField((Short[])value);
        } else {
            Object converter = null;
            converter = Date.class.isAssignableFrom(this.type) ? new DateToGeneralizedTimeStringConverter() : (Calendar.class.isAssignableFrom(this.type) ? new CalendarToGeneralizedTimeStringConverter() : this.op.getExecutionContext().getTypeManager().getTypeConverterForType(this.type, String.class));
            if (converter != null) {
                Object[] values = (Object[])value;
                Object[] stringValues = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    stringValues[i] = (String)converter.toDatastoreType(values[i]);
                }
                this.storeObjectArrayField(stringValues);
            } else if (this.type.isEnum()) {
                this.storeObjectArrayField((Enum[])value);
            } else {
                throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " is not supported for this datastore");
            }
        }
    }

    protected void storeBooleanArrayField(boolean[] values) {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = TypeConversionHelper.getByteArrayFromBooleanArray((Object)values);
            this.storeByteArrayField(bytes);
        } else {
            ArrayList<String> strings = new ArrayList<String>();
            for (boolean v : values) {
                strings.add(("" + v).toUpperCase());
            }
            this.storeStringList(strings);
        }
    }

    protected void storeBooleanObjectArrayField(Boolean[] values) {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = TypeConversionHelper.getByteArrayFromBooleanObjectArray((Object)values);
            this.storeByteArrayField(bytes);
        } else {
            ArrayList<String> strings = new ArrayList<String>();
            Boolean[] arr$ = values;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                boolean v = arr$[i$];
                strings.add(("" + v).toUpperCase());
            }
            this.storeStringList(strings);
        }
    }

    protected void storeByteArrayField(byte[] values) {
        if (this.mmd.getJoinMetaData() == null) {
            BasicAttribute attribute = new BasicAttribute(this.name, values);
            this.attributes.put(attribute);
        } else {
            ArrayList<String> strings = new ArrayList<String>();
            for (byte v : values) {
                strings.add("" + v);
            }
            this.storeStringList(strings);
        }
    }

    protected void storeByteObjectArrayField(Byte[] values) {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = TypeConversionHelper.getByteArrayFromByteObjectArray((Object)values);
            this.storeByteArrayField(bytes);
        } else {
            this.storeObjectArrayField(values);
        }
    }

    protected void storeCharArrayField(char[] values) {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = TypeConversionHelper.getByteArrayFromCharArray((Object)values);
            this.storeByteArrayField(bytes);
        } else {
            ArrayList<String> strings = new ArrayList<String>();
            for (char v : values) {
                strings.add("" + v);
            }
            this.storeStringList(strings);
        }
    }

    protected void storeCharacterObjectArrayField(Character[] values) {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = TypeConversionHelper.getByteArrayFromCharObjectArray((Object)values);
            this.storeByteArrayField(bytes);
        } else {
            this.storeObjectArrayField(values);
        }
    }

    protected void storeDoubleArrayField(double[] values) {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = TypeConversionHelper.getByteArrayFromDoubleArray((Object)values);
            this.storeByteArrayField(bytes);
        } else {
            ArrayList<String> strings = new ArrayList<String>();
            for (double v : values) {
                strings.add("" + v);
            }
            this.storeStringList(strings);
        }
    }

    protected void storeDoubleObjectArrayField(Double[] values) {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = TypeConversionHelper.getByteArrayFromDoubleObjectArray((Object)values);
            this.storeByteArrayField(bytes);
        } else {
            this.storeObjectArrayField(values);
        }
    }

    protected void storeFloatArrayField(float[] values) {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = TypeConversionHelper.getByteArrayFromFloatArray((Object)values);
            this.storeByteArrayField(bytes);
        } else {
            ArrayList<String> strings = new ArrayList<String>();
            for (float v : values) {
                strings.add("" + v);
            }
            this.storeStringList(strings);
        }
    }

    protected void storeFloatObjectArrayField(Float[] values) {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = TypeConversionHelper.getByteArrayFromFloatObjectArray((Object)values);
            this.storeByteArrayField(bytes);
        } else {
            this.storeObjectArrayField(values);
        }
    }

    protected void storeIntArrayField(int[] values) {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = TypeConversionHelper.getByteArrayFromIntArray((Object)values);
            this.storeByteArrayField(bytes);
        } else {
            ArrayList<String> strings = new ArrayList<String>();
            for (int v : values) {
                strings.add("" + v);
            }
            this.storeStringList(strings);
        }
    }

    protected void storeIntegerObjectArrayField(Integer[] values) {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = TypeConversionHelper.getByteArrayFromIntObjectArray((Object)values);
            this.storeByteArrayField(bytes);
        } else {
            this.storeObjectArrayField(values);
        }
    }

    protected void storeLongArrayField(long[] values) {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = TypeConversionHelper.getByteArrayFromLongArray((Object)values);
            this.storeByteArrayField(bytes);
        } else {
            ArrayList<String> strings = new ArrayList<String>();
            for (long v : values) {
                strings.add("" + v);
            }
            this.storeStringList(strings);
        }
    }

    protected void storeLongObjectArrayField(Long[] values) {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = TypeConversionHelper.getByteArrayFromLongObjectArray((Object)values);
            this.storeByteArrayField(bytes);
        } else {
            this.storeObjectArrayField(values);
        }
    }

    protected void storeShortArrayField(short[] values) {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = TypeConversionHelper.getByteArrayFromShortArray((Object)values);
            this.storeByteArrayField(bytes);
        } else {
            ArrayList<String> strings = new ArrayList<String>();
            for (short v : values) {
                strings.add("" + v);
            }
            this.storeStringList(strings);
        }
    }

    protected void storeShortObjectArrayField(Short[] values) {
        if (this.mmd.getJoinMetaData() == null) {
            byte[] bytes = TypeConversionHelper.getByteArrayFromShortObjectArray((Object)values);
            this.storeByteArrayField(bytes);
        } else {
            this.storeObjectArrayField(values);
        }
    }

    protected void storeObjectArrayField(Object[] values) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Object v : values) {
            strings.add("" + v);
        }
        this.storeStringList(strings);
    }

    protected void storeStringList(List<String> values) {
        BasicAttribute attribute = new BasicAttribute(this.name);
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i);
            if (this.mmd.getOrderMetaData() != null) {
                value = "{" + i + "}" + value;
            }
            attribute.add(value);
        }
        this.attributes.put(attribute);
    }

    @Override
    public List<String> getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.name);
        return names;
    }
}

