/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import javax.naming.directory.Attributes;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;

public class StoreFieldManager
extends AbstractFieldManager {
    ObjectProvider sm;
    StoreManager storeMgr;
    Attributes attributes;
    boolean insert;

    public StoreFieldManager(StoreManager storeMgr, ObjectProvider sm, Attributes attrs, boolean insert) {
        this.sm = sm;
        this.storeMgr = storeMgr;
        this.attributes = attrs;
        this.insert = insert;
    }

    public void storeStringField(int fieldNumber, String value) {
        this.storeObjectField(fieldNumber, value);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(this.storeMgr, this.sm, mmd, this.attributes);
        if (ms != null) {
            if (this.insert) {
                ms.insert(value);
            } else {
                ms.update(value);
            }
            return;
        }
        throw new NucleusException("Field " + mmd.getFullFieldName() + " cannot be persisted because type=" + mmd.getTypeName() + " is not supported for this datastore");
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        this.storeObjectField(fieldNumber, value);
    }

    public void storeByteField(int fieldNumber, byte value) {
        this.storeObjectField(fieldNumber, value);
    }

    public void storeCharField(int fieldNumber, char value) {
        this.storeObjectField(fieldNumber, Character.valueOf(value));
    }

    public void storeDoubleField(int fieldNumber, double value) {
        this.storeObjectField(fieldNumber, value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        this.storeObjectField(fieldNumber, Float.valueOf(value));
    }

    public void storeIntField(int fieldNumber, int value) {
        this.storeObjectField(fieldNumber, value);
    }

    public void storeLongField(int fieldNumber, long value) {
        this.storeObjectField(fieldNumber, value);
    }

    public void storeShortField(int fieldNumber, short value) {
        this.storeObjectField(fieldNumber, value);
    }
}

