/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.ldap.LDAPManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.RelationByAttributeMetaData;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationByAttributeStrategy
extends AbstractMappingStrategy {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.ldap.Localisation", (ClassLoader)LDAPManager.class.getClassLoader());
    protected int fieldNumber;
    protected ObjectManager om;
    protected ClassLoaderResolver clr;
    protected AbstractClassMetaData effectiveClassMetaData;
    protected RelationByAttributeMetaData mappingMetaData;

    protected RelationByAttributeStrategy(StateManager sm, AbstractMemberMetaData mmd, Attributes attributes) {
        super(sm, mmd, attributes);
        this.fieldNumber = mmd.getAbsoluteFieldNumber();
        this.om = sm.getObjectManager();
        this.clr = this.om.getClassLoaderResolver();
        this.effectiveClassMetaData = LDAPUtils.getEffectiveClassMetaData(mmd, sm.getMetaDataManager());
        this.mappingMetaData = new RelationByAttributeMetaData(mmd, sm.getMetaDataManager());
    }

    @Override
    public Object fetch() {
        String ownerAttributeName = this.mappingMetaData.getOwnerAttributeName();
        String joinAttributeName = this.mappingMetaData.getJoinAttributeName();
        String emptyValue = this.mappingMetaData.getEmptyValue();
        if (this.mappingMetaData.getNonOwnerMMD() == this.mmd) {
            Object joinAttributeValue = null;
            try {
                joinAttributeValue = this.attributes.get(joinAttributeName).get();
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            switch (this.mmd.getRelationType(this.clr)) {
                case 1: 
                case 2: 
                case 6: {
                    Collection<Object> coll = RelationByAttributeStrategy.getAttributeMappedReferences(this.effectiveClassMetaData, ownerAttributeName, joinAttributeValue, ArrayList.class, this.om);
                    if (coll.iterator().hasNext()) {
                        Object value = coll.iterator().next();
                        this.sm.setAssociatedValue((Object)("OBJ" + this.fieldNumber), value);
                        return value;
                    }
                    this.sm.setAssociatedValue((Object)("OBJ" + this.fieldNumber), null);
                    return null;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (!this.mmd.hasCollection()) break;
                    Class instanceType = this.mmd.getType();
                    instanceType = SCOUtils.getContainerInstanceType((Class)instanceType, (Boolean)(this.mmd.getOrderMetaData() != null ? 1 : 0));
                    Collection<Object> coll = RelationByAttributeStrategy.getAttributeMappedReferences(this.effectiveClassMetaData, ownerAttributeName, joinAttributeValue, instanceType, this.om);
                    this.sm.setAssociatedValue((Object)("COLL" + this.fieldNumber), coll);
                    return this.sm.wrapSCOField(this.fieldNumber, coll, false, false, true);
                }
            }
            throw new NucleusException(LOCALISER.msg("LDAP.RelationTypeNotSupported", (Object)this.mmd.getFullFieldName(), (Object)this.mmd.getRelationType(this.clr)));
        }
        switch (this.mmd.getRelationType(this.clr)) {
            case 1: 
            case 2: 
            case 6: {
                try {
                    Object value = this.attr != null ? LDAPUtils.getObjectByAttribute(this.om, this.mmd.getType(), joinAttributeName, (String)this.attr.get(0), this.sm.getMetaDataManager()) : null;
                    this.sm.setAssociatedValue((Object)("OBJ" + this.fieldNumber), value);
                    return value;
                }
                catch (NamingException e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
            }
            case 3: 
            case 4: 
            case 5: {
                if (!this.mmd.hasCollection()) break;
                Collection coll = null;
                Class instanceType = this.mmd.getType();
                instanceType = SCOUtils.getContainerInstanceType((Class)instanceType, (Boolean)(this.mmd.getOrderMetaData() != null ? 1 : 0));
                try {
                    coll = (Collection)instanceType.newInstance();
                    Class elementType = this.clr.classForName(this.mmd.getCollection().getElementType());
                    RelationByAttributeStrategy.removeEmptyValue(emptyValue, this.attr);
                    for (int i = 0; this.attr != null && i < this.attr.size(); ++i) {
                        String value = (String)this.attr.get(i);
                        Object o = LDAPUtils.getObjectByAttribute(this.om, elementType, joinAttributeName, value, this.sm.getMetaDataManager());
                        coll.add(o);
                    }
                }
                catch (NamingException e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    throw new NucleusException("Error in trying to create object of type " + instanceType.getName(), (Throwable)e);
                }
                this.sm.setAssociatedValue((Object)("COLL" + this.fieldNumber), (Object)coll);
                return this.sm.wrapSCOField(this.fieldNumber, (Object)coll, false, false, true);
            }
        }
        throw new NucleusException(LOCALISER.msg("LDAP.Retrieve.RelationTypeNotSupported", (Object)this.mmd.getFullFieldName(), (Object)this.mmd.getRelationType(this.clr)));
    }

    @Override
    public void insert(Object value) {
        block11: {
            String emptyValue;
            String joinAttributeName;
            String ownerAttributeName;
            block12: {
                if (value == null) break block11;
                ownerAttributeName = this.mappingMetaData.getOwnerAttributeName();
                joinAttributeName = this.mappingMetaData.getJoinAttributeName();
                emptyValue = this.mappingMetaData.getEmptyValue();
                if (this.mappingMetaData.getNonOwnerMMD() != this.mmd) break block12;
                Object joinAttributeValue = LDAPUtils.getAttributeValue(this.sm, joinAttributeName);
                switch (this.mmd.getRelationType(this.clr)) {
                    case 1: 
                    case 2: 
                    case 6: {
                        RelationByAttributeStrategy.addAttributeReference(value, ownerAttributeName, joinAttributeValue, emptyValue, this.om);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        if (this.mmd.hasCollection()) {
                            Collection c = (Collection)value;
                            for (Object pc : c) {
                                LDAPUtils.unmarkForDeletion(pc, this.om);
                                RelationByAttributeStrategy.addAttributeReference(pc, ownerAttributeName, joinAttributeValue, emptyValue, this.om);
                            }
                        }
                        break block11;
                    }
                    default: {
                        throw new NucleusException(LOCALISER.msg("LDAP.Persist.RelationTypeNotSupported", (Object)this.mmd.getFullFieldName(), (Object)this.mmd.getTypeName(), (Object)this.mmd.getRelationType(this.clr)));
                    }
                }
                break block11;
            }
            switch (this.mmd.getRelationType(this.clr)) {
                case 1: 
                case 2: 
                case 6: {
                    StateManager pcSM = LDAPUtils.getStateManagerForObject(value, this.om, true);
                    Object joinAttributeValue = LDAPUtils.getAttributeValue(pcSM, joinAttributeName);
                    BasicAttribute attr = new BasicAttribute(ownerAttributeName, joinAttributeValue);
                    RelationByAttributeStrategy.addEmptyValue(emptyValue, attr);
                    this.attributes.put(attr);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (!this.mmd.hasCollection()) break;
                    Collection c = (Collection)value;
                    BasicAttribute attr = new BasicAttribute(ownerAttributeName);
                    for (Object pc : c) {
                        StateManager pcSM = LDAPUtils.getStateManagerForObject(pc, this.om, true);
                        Object joinAttributeValue = LDAPUtils.getAttributeValue(pcSM, joinAttributeName);
                        attr.add(joinAttributeValue);
                    }
                    RelationByAttributeStrategy.addEmptyValue(emptyValue, attr);
                    if (attr.size() <= 0) break;
                    this.attributes.put(attr);
                    break;
                }
                default: {
                    throw new NucleusException(LOCALISER.msg("LDAP.Persist.RelationTypeNotSupported", (Object)this.mmd.getFullFieldName(), (Object)this.mmd.getTypeName(), (Object)this.mmd.getRelationType(this.clr)));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update(Object value) {
        if (value != null) {
            LDAPUtils.unmarkForDeletion(this.sm.getObject(), this.om);
        }
        String ownerAttributeName = this.mappingMetaData.getOwnerAttributeName();
        String joinAttributeName = this.mappingMetaData.getJoinAttributeName();
        String emptyValue = this.mappingMetaData.getEmptyValue();
        if (this.mappingMetaData.getNonOwnerMMD() == this.mmd) {
            Object joinAttributeValue = LDAPUtils.getAttributeValue(this.sm, joinAttributeName);
            if (value != null) {
                switch (this.mmd.getRelationType(this.clr)) {
                    case 1: 
                    case 2: 
                    case 6: {
                        Object oldValue = this.sm.getAssociatedValue((Object)("OBJ" + this.fieldNumber));
                        if (value.equals(oldValue)) return;
                        LDAPUtils.markForPersisting(value, this.om);
                        LDAPUtils.unmarkForDeletion(value, this.om);
                        RelationByAttributeStrategy.removeAttributeReference(oldValue, ownerAttributeName, joinAttributeValue, emptyValue, this.om);
                        RelationByAttributeStrategy.addAttributeReference(value, ownerAttributeName, joinAttributeValue, emptyValue, this.om);
                        return;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        if (!this.mmd.hasCollection()) return;
                        Collection coll = (Collection)value;
                        Collection oldColl = (Collection)this.sm.getAssociatedValue((Object)("COLL" + this.fieldNumber));
                        if (oldColl == null) throw new NucleusDataStoreException("No old collection in SM " + this.sm);
                        AbstractCollection toAdd = null;
                        AbstractCollection toRemove = null;
                        Class instanceType = this.mmd.getType();
                        if (List.class.isAssignableFrom(instanceType)) {
                            toAdd = new ArrayList(coll);
                            toRemove = new ArrayList(oldColl);
                        } else {
                            toAdd = new HashSet(coll);
                            toRemove = new HashSet(oldColl);
                        }
                        toAdd.removeAll(oldColl);
                        for (Object pc : toAdd) {
                            RelationByAttributeStrategy.addAttributeReference(pc, ownerAttributeName, joinAttributeValue, emptyValue, this.om);
                            LDAPUtils.unmarkForDeletion(pc, this.om);
                        }
                        toRemove.removeAll(coll);
                        for (Object pc : toRemove) {
                            RelationByAttributeStrategy.removeAttributeReference(pc, ownerAttributeName, joinAttributeValue, emptyValue, this.om);
                            if (!this.mmd.getCollection().isDependentElement()) continue;
                            LDAPUtils.markForDeletion(pc, this.om);
                        }
                        return;
                    }
                    default: {
                        throw new NucleusException(LOCALISER.msg("LDAP.Persist.RelationTypeNotSupported", (Object)this.mmd.getFullFieldName(), (Object)this.mmd.getTypeName(), (Object)this.mmd.getRelationType(this.clr)));
                    }
                }
            }
            Object oldValue = this.sm.getAssociatedValue((Object)("OBJ" + this.fieldNumber));
            RelationByAttributeStrategy.removeAttributeReference(oldValue, ownerAttributeName, joinAttributeValue, emptyValue, this.om);
            return;
        }
        if (value != null) {
            switch (this.mmd.getRelationType(this.clr)) {
                case 1: 
                case 2: 
                case 6: {
                    StateManager smpc = LDAPUtils.getStateManagerForObject(value, this.om, true);
                    LDAPUtils.unmarkForDeletion(value, this.om);
                    Object joinAttributeValue = LDAPUtils.getAttributeValue(smpc, joinAttributeName);
                    this.attributes.put(new BasicAttribute(ownerAttributeName, joinAttributeValue));
                    return;
                }
                case 3: 
                case 4: 
                case 5: {
                    Collection oldColl;
                    if (!this.mmd.hasCollection()) return;
                    Collection coll = (Collection)value;
                    if (this.mmd.getCollection().isDependentElement() && (oldColl = (Collection)this.sm.getAssociatedValue((Object)("COLL" + this.fieldNumber))) != null) {
                        AbstractCollection toRemove = null;
                        Class instanceType = this.mmd.getType();
                        toRemove = List.class.isAssignableFrom(instanceType) ? new ArrayList(oldColl) : new HashSet(oldColl);
                        toRemove.removeAll(coll);
                        for (Object pc : toRemove) {
                            LDAPUtils.markForDeletion(pc, this.om);
                        }
                    }
                    BasicAttribute attr = new BasicAttribute(ownerAttributeName);
                    this.attributes.put(attr);
                    for (Object pc : coll) {
                        LDAPUtils.unmarkForDeletion(pc, this.om);
                        StateManager smpc = LDAPUtils.getStateManagerForObject(pc, this.om, true);
                        Object joinAttributeValue = LDAPUtils.getAttributeValue(smpc, joinAttributeName);
                        attr.add(joinAttributeValue);
                    }
                    RelationByAttributeStrategy.addEmptyValue(emptyValue, attr);
                    return;
                }
                default: {
                    throw new NucleusException(LOCALISER.msg("LDAP.Persist.RelationTypeNotSupported", (Object)this.mmd.getFullFieldName(), (Object)this.mmd.getTypeName(), (Object)this.mmd.getRelationType(this.clr)));
                }
            }
        }
        BasicAttribute attr = new BasicAttribute(ownerAttributeName);
        RelationByAttributeStrategy.addEmptyValue(emptyValue, attr);
        this.attributes.put(attr);
    }

    private static Collection<Object> getAttributeMappedReferences(AbstractClassMetaData cmd, String pcAttributeName, Object myAttributeValue, Class collectionClass, ObjectManager om) {
        Collection coll;
        try {
            coll = (Collection)collectionClass.newInstance();
            String attributeFilter = "(" + pcAttributeName + "=" + myAttributeValue + ")";
            LdapName base = LDAPUtils.getSearchBase(cmd, om.getMetaDataManager());
            List<Object> objects = LDAPUtils.getObjectsOfCandidateType(om, cmd, base, attributeFilter, true, false);
            coll.addAll(objects);
        }
        catch (InstantiationException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionClass.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionClass.getName(), (Throwable)e);
        }
        return coll;
    }

    private static void removeAttributeReference(Object fromObject, String attributeName, Object joinAttributeValue, String emptyValue, ObjectManager om) {
        if (fromObject != null) {
            StateManager fromSM = LDAPUtils.getStateManagerForObject(fromObject, om, true);
            LdapName fromDN = LDAPUtils.getDistinguishedNameForObject(fromSM);
            if (fromSM.getObjectManager().getApiAdapter().isDeleted(fromObject)) {
                return;
            }
            ManagedConnection mconn = om.getStoreManager().getConnection(om);
            try {
                boolean removed;
                DirContext ctx = (DirContext)mconn.getConnection();
                Attributes attributes = ctx.getAttributes(fromDN, new String[]{attributeName});
                Attribute attribute = attributes.get(attributeName);
                if (attribute != null && (removed = attribute.remove(joinAttributeValue))) {
                    RelationByAttributeStrategy.addEmptyValue(emptyValue, attribute);
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.JNDI.DeleteAttributeReference", (Object)attributeName, joinAttributeValue, (Object)fromDN));
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.JNDI.modifyAttributes", (Object)fromDN, (Object)"REPLACE", (Object)attributes));
                    }
                    ctx.modifyAttributes(fromDN, 2, attributes);
                }
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }

    private static void addAttributeReference(Object toObject, String attributeName, Object joinAttributeValue, String emptyValue, ObjectManager om) {
        if (toObject != null) {
            StateManager toSM = LDAPUtils.getStateManagerForObject(toObject, om, true);
            LdapName toDN = LDAPUtils.getDistinguishedNameForObject(toSM);
            if (toSM.isInserting()) {
                return;
            }
            ManagedConnection mconn = om.getStoreManager().getConnection(om);
            try {
                boolean added;
                DirContext ctx = (DirContext)mconn.getConnection();
                Attributes attributes = ctx.getAttributes(toDN, new String[]{attributeName});
                Attribute attribute = attributes.get(attributeName);
                if (attribute == null) {
                    attribute = new BasicAttribute(attributeName);
                    attributes.put(attribute);
                }
                if (added = attribute.add(joinAttributeValue)) {
                    RelationByAttributeStrategy.removeEmptyValue(emptyValue, attribute);
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.JNDI.AddAttributeReference", (Object)attributeName, joinAttributeValue, (Object)toDN));
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.JNDI.modifyAttributes", (Object)toDN, (Object)"REPLACE", (Object)attributes));
                    }
                    ctx.modifyAttributes(toDN, 2, attributes);
                }
            }
            catch (NamingException e) {
                System.out.println(toSM);
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }

    private static void addEmptyValue(String emptyValue, Attribute attr) {
        if (attr != null && attr.size() == 0 && emptyValue != null) {
            attr.add(emptyValue);
        }
    }

    private static void removeEmptyValue(String emptyValue, Attribute attr) {
        if (emptyValue != null && attr != null) {
            attr.remove(emptyValue);
        }
    }
}

