/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedMappingStrategy
extends AbstractMappingStrategy {
    protected AbstractClassMetaData effectiveClassMetaData;
    protected int fieldNumber;
    protected ObjectManager om;
    protected ClassLoaderResolver clr;
    protected StateManager effectiveStateManager;

    protected EmbeddedMappingStrategy(StateManager sm, AbstractMemberMetaData mmd, Attributes attributes) {
        super(sm, mmd, attributes);
        this.fieldNumber = mmd.getAbsoluteFieldNumber();
        this.om = sm.getObjectManager();
        this.clr = this.om.getClassLoaderResolver();
        this.effectiveClassMetaData = LDAPUtils.getEffectiveClassMetaData(mmd, sm.getMetaDataManager());
        this.effectiveStateManager = sm;
        while (this.effectiveStateManager.getEmbeddedOwners() != null && this.effectiveStateManager.getEmbeddedOwners().length > 0) {
            this.effectiveStateManager = sm.getEmbeddedOwners()[0];
        }
    }

    @Override
    public Object fetch() {
        switch (this.mmd.getRelationType(this.clr)) {
            case 1: 
            case 2: {
                Object value = null;
                Set<String> objectClasses = LDAPUtils.getObjectClassesForClass(this.effectiveClassMetaData);
                value = objectClasses.isEmpty() ? this.fetchEmbedded() : this.fetchFromChild();
                return value;
            }
            case 3: 
            case 4: {
                if (!this.mmd.hasCollection()) break;
                Class instanceType = this.mmd.getType();
                instanceType = SCOUtils.getContainerInstanceType((Class)instanceType, (Boolean)(this.mmd.getOrderMetaData() != null ? 1 : 0));
                Collection<Object> coll = this.fetchFromChildren(instanceType);
                return this.sm.wrapSCOField(this.fieldNumber, coll, false, false, true);
            }
        }
        throw new NucleusException("Cant obtain value for field " + this.mmd.getFullFieldName() + " since type=" + this.mmd.getTypeName() + " is not supported for this datastore");
    }

    private Object fetchEmbedded() {
        EmbeddedMetaData embeddedMetaData = this.mmd.getEmbeddedMetaData();
        ArrayList<AbstractMemberMetaData> embeddedMmds = new ArrayList<AbstractMemberMetaData>(Arrays.asList(embeddedMetaData.getMemberMetaData()));
        Object value = this.getObjectInstance(this.effectiveClassMetaData.getFullClassName());
        value = this.fetchMerge(value, this.attributes, embeddedMmds, embeddedMetaData);
        return value;
    }

    private Object fetchFromChild() {
        EmbeddedMetaData embeddedMetaData = this.mmd.getEmbeddedMetaData();
        Collection<Object> children = this.fetchFromChildren(ArrayList.class, embeddedMetaData);
        if (children.size() == 0) {
            return null;
        }
        if (children.size() == 1) {
            return children.iterator().next();
        }
        throw new NucleusDataStoreException("Must be unique!");
    }

    private Collection<Object> fetchFromChildren(Class collectionType) {
        EmbeddedMetaData embeddedMetaData = this.mmd.getElementMetaData().getEmbeddedMetaData();
        return this.fetchFromChildren(collectionType, embeddedMetaData);
    }

    private Collection<Object> fetchFromChildren(Class collectionType, EmbeddedMetaData embeddedMetaData) {
        List<AbstractMemberMetaData> embeddedMmds = LDAPUtils.getAllMemberMetaData(this.effectiveClassMetaData);
        Collection<Object> coll = this.getCollectionInstance(collectionType);
        LdapName baseDn = LDAPUtils.getDistinguishedNameForObject(this.sm);
        Map<LdapName, Attributes> entries = LDAPUtils.getEntries(this.sm.getObjectManager(), this.effectiveClassMetaData, baseDn, null, false, false);
        for (Attributes embeddedAttrs : entries.values()) {
            Object value = this.getObjectInstance(this.effectiveClassMetaData.getFullClassName());
            if ((value = this.fetchMerge(value, embeddedAttrs, embeddedMmds, embeddedMetaData)) == null) continue;
            coll.add(value);
        }
        String[] subclassNames = this.om.getMetaDataManager().getSubclassesForClass(this.effectiveClassMetaData.getFullClassName(), true);
        if (subclassNames != null) {
            for (String subclassName : subclassNames) {
                AbstractClassMetaData cmd = this.om.getMetaDataManager().getMetaDataForClass(subclassName, this.clr);
                entries = LDAPUtils.getEntries(this.sm.getObjectManager(), cmd, baseDn, null, false, false);
                for (Attributes embeddedAttrs : entries.values()) {
                    Object value = this.getObjectInstance(cmd.getFullClassName());
                    if ((value = this.fetchMerge(value, embeddedAttrs, embeddedMmds, embeddedMetaData)) == null) continue;
                    coll.add(value);
                }
            }
        }
        return coll;
    }

    private Object fetchMerge(Object value, Attributes embeddedAttrs, List<AbstractMemberMetaData> embeddedMmds, EmbeddedMetaData embeddedMetaData) {
        if (embeddedAttrs != null && embeddedMmds != null) {
            String fieldName;
            StateManager embeddedSM = this.getEmbeddedStateManager(value);
            AbstractClassMetaData embeddedCmd = embeddedSM.getClassMetaData();
            String nullIndicatorColumn = embeddedMetaData.getNullIndicatorColumn();
            String nullIndicatorValue = embeddedMetaData.getNullIndicatorValue();
            for (AbstractMemberMetaData embeddedMmd : embeddedMmds) {
                fieldName = embeddedMmd.getName();
                int i = embeddedCmd.getAbsolutePositionOfMember(fieldName);
                if (fieldName.equals(embeddedMetaData.getOwnerMember())) {
                    Object embeddedValue = this.sm.getObject();
                    embeddedSM.replaceField(i, embeddedValue, true);
                    continue;
                }
                if (!embeddedMmd.isPrimaryKey()) continue;
                AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(embeddedSM, embeddedMmd, embeddedAttrs);
                Object embeddedValue = ms.fetch();
                embeddedSM.replaceField(i, embeddedValue, true);
            }
            for (AbstractMemberMetaData embeddedMmd : embeddedMmds) {
                fieldName = embeddedMmd.getName();
                String attributeName = LDAPUtils.getAttributeNameForField(embeddedMmd);
                int i = embeddedCmd.getAbsolutePositionOfMember(fieldName);
                if (fieldName.equals(embeddedMetaData.getOwnerMember()) || embeddedMmd.isPrimaryKey()) continue;
                AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(embeddedSM, embeddedMmd, embeddedAttrs);
                Object embeddedValue = ms.fetch();
                if (nullIndicatorColumn != null && attributeName.equals(nullIndicatorColumn)) {
                    if (embeddedValue == null) {
                        return null;
                    }
                    if (nullIndicatorValue != null && embeddedValue.equals(nullIndicatorValue)) {
                        return null;
                    }
                }
                embeddedSM.replaceField(i, embeddedValue, true);
            }
            return embeddedSM.getObject();
        }
        return null;
    }

    private Object getObjectInstance(String fullClassName) {
        Object value;
        try {
            value = this.clr.classForName(fullClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    private Collection<Object> getCollectionInstance(Class<?> collectionType) {
        Collection coll;
        try {
            coll = (Collection)collectionType.newInstance();
        }
        catch (InstantiationException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionType.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionType.getName(), (Throwable)e);
        }
        return coll;
    }

    private StateManager getEmbeddedStateManager(Object value) {
        StateManager embeddedSM = this.sm.getObjectManager().findStateManager(value);
        if (embeddedSM == null) {
            embeddedSM = StateManagerFactory.newStateManagerForEmbedded((ObjectManager)this.sm.getObjectManager(), (Object)value, (boolean)false);
        }
        if (embeddedSM.getEmbeddedOwners() == null || embeddedSM.getEmbeddedOwners().length == 0) {
            int absoluteFieldNumber = this.sm.getClassMetaData().getMetaDataForMember(this.mmd.getName()).getAbsoluteFieldNumber();
            embeddedSM.addEmbeddedOwner(this.sm, absoluteFieldNumber);
            embeddedSM.setPcObjectType(1);
        }
        return embeddedSM;
    }

    @Override
    public void insert(Object value) {
        if (value == null) {
            return;
        }
        switch (this.mmd.getRelationType(this.clr)) {
            case 1: 
            case 2: {
                Set<String> objectClasses = LDAPUtils.getObjectClassesForClass(this.effectiveClassMetaData);
                if (objectClasses.isEmpty()) {
                    this.insertEmbedded(value);
                    break;
                }
                EmbeddedMetaData embeddedMetaData = this.mmd.getEmbeddedMetaData();
                this.insertAsChild(value, embeddedMetaData);
                break;
            }
            case 3: 
            case 4: {
                if (!this.mmd.hasCollection()) break;
                EmbeddedMetaData embeddedMetaData = this.mmd.getElementMetaData().getEmbeddedMetaData();
                Collection c = (Collection)value;
                for (Object pc : c) {
                    this.insertAsChild(pc, embeddedMetaData);
                }
                break;
            }
            default: {
                throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " with relation type " + this.mmd.getRelationType(this.clr) + " is not supported for this datastore");
            }
        }
    }

    private void insertEmbedded(Object value) {
        StateManager embeddedSM = this.getEmbeddedStateManager(value);
        EmbeddedMetaData embeddedMetaData = this.mmd.getEmbeddedMetaData();
        ArrayList<AbstractMemberMetaData> embeddedMmds = new ArrayList<AbstractMemberMetaData>(Arrays.asList(embeddedMetaData.getMemberMetaData()));
        this.insertMerge(embeddedSM, this.attributes, embeddedMmds, embeddedMetaData);
    }

    private void insertAsChild(Object value, EmbeddedMetaData embeddedMetaData) {
        StateManager embeddedSM = this.getEmbeddedStateManager(value);
        List<AbstractMemberMetaData> embeddedMmds = LDAPUtils.getAllMemberMetaData(this.effectiveClassMetaData);
        BasicAttributes embeddedAttributes = new BasicAttributes();
        this.insertMerge(embeddedSM, embeddedAttributes, embeddedMmds, embeddedMetaData);
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        Set<String> embeddedObjectClasses = LDAPUtils.getObjectClassesForClass(this.effectiveClassMetaData);
        for (String oc : embeddedObjectClasses) {
            objectClass.add(oc);
        }
        embeddedAttributes.put(objectClass);
        LdapName dn = LDAPUtils.getDistinguishedNameForObject(embeddedSM);
        if (this.effectiveStateManager.getAssociatedValue((Object)"insert-embedded") == null) {
            this.effectiveStateManager.setAssociatedValue((Object)"insert-embedded", new LinkedHashMap());
        }
        Map map = (Map)this.effectiveStateManager.getAssociatedValue((Object)"insert-embedded");
        map.put(dn, embeddedAttributes);
    }

    private void insertMerge(StateManager embeddedSM, Attributes embeddedAttributes, List<AbstractMemberMetaData> embeddedMmds, EmbeddedMetaData embeddedMetaData) {
        Object embeddedValue;
        AbstractMappingStrategy ms;
        int i;
        String fieldName;
        AbstractClassMetaData embeddedCmd = embeddedSM.getClassMetaData();
        for (AbstractMemberMetaData embeddedMmd : embeddedMmds) {
            fieldName = embeddedMmd.getName();
            i = embeddedCmd.getAbsolutePositionOfMember(fieldName);
            if (fieldName.equals(embeddedMetaData.getOwnerMember())) {
                Object embeddedValue2 = this.sm.getObject();
                embeddedSM.replaceField(i, embeddedValue2, true);
                continue;
            }
            if (!embeddedMmd.isPrimaryKey()) continue;
            ms = AbstractMappingStrategy.findMappingStrategy(embeddedSM, embeddedMmd, embeddedAttributes);
            embeddedValue = embeddedSM.provideField(i);
            ms.insert(embeddedValue);
        }
        for (AbstractMemberMetaData embeddedMmd : embeddedMmds) {
            fieldName = embeddedMmd.getName();
            i = embeddedCmd.getAbsolutePositionOfMember(fieldName);
            if (fieldName.equals(embeddedMetaData.getOwnerMember()) || embeddedMmd.isPrimaryKey()) continue;
            ms = AbstractMappingStrategy.findMappingStrategy(embeddedSM, embeddedMmd, embeddedAttributes);
            embeddedValue = embeddedSM.provideField(i);
            ms.insert(embeddedValue);
        }
    }

    @Override
    public void update(Object value) {
        switch (this.mmd.getRelationType(this.clr)) {
            case 1: 
            case 2: {
                LdapName oldValueDn;
                Set<String> objectClasses = LDAPUtils.getObjectClassesForClass(this.effectiveClassMetaData);
                if (objectClasses.isEmpty()) {
                    this.updateEmbedded(value);
                    break;
                }
                EmbeddedMetaData embeddedMetaData = this.mmd.getEmbeddedMetaData();
                Object oldValue = this.fetchFromChild();
                if (value == null) {
                    if (oldValue == null) break;
                    this.deleteAsChild(oldValue, embeddedMetaData);
                    break;
                }
                if (oldValue == null) {
                    this.insertAsChild(value, embeddedMetaData);
                    break;
                }
                StateManager valueSM = this.getEmbeddedStateManager(value);
                StateManager oldValueSM = this.getEmbeddedStateManager(oldValue);
                LdapName valueDn = LDAPUtils.getDistinguishedNameForObject(valueSM);
                if (!valueDn.equals(oldValueDn = LDAPUtils.getDistinguishedNameForObject(oldValueSM))) {
                    this.deleteAsChild(oldValue, embeddedMetaData);
                    this.insertAsChild(value, embeddedMetaData);
                    break;
                }
                this.updateAsChild(value, embeddedMetaData);
                break;
            }
            case 3: 
            case 4: {
                if (!this.mmd.hasCollection()) break;
                Collection coll = (Collection)value;
                LinkedHashMap newMap = new LinkedHashMap();
                for (Object newObject : coll) {
                    StateManager newObjectSM = this.getEmbeddedStateManager(newObject);
                    LdapName newObjectDn = LDAPUtils.getDistinguishedNameForObject(newObjectSM);
                    newMap.put(newObjectDn, newObject);
                }
                EmbeddedMetaData embeddedMetaData = this.mmd.getElementMetaData().getEmbeddedMetaData();
                Class oldCollInstanceType = SCOUtils.getContainerInstanceType((Class)this.mmd.getType(), (Boolean)(this.mmd.getOrderMetaData() != null ? 1 : 0));
                Collection<Object> oldColl = this.fetchFromChildren(oldCollInstanceType, embeddedMetaData);
                LinkedHashMap<LdapName, Object> oldMap = new LinkedHashMap<LdapName, Object>();
                for (Object oldObject : oldColl) {
                    StateManager oldObjectSM = this.getEmbeddedStateManager(oldObject);
                    LdapName oldObjectDn = LDAPUtils.getDistinguishedNameForObject(oldObjectSM);
                    oldMap.put(oldObjectDn, oldObject);
                }
                AbstractCollection toInsert = null;
                AbstractCollection toUpdate = null;
                AbstractCollection toDelete = null;
                Class instanceType = this.mmd.getType();
                if (List.class.isAssignableFrom(instanceType)) {
                    toInsert = new ArrayList();
                    toUpdate = new ArrayList();
                    toDelete = new ArrayList();
                } else {
                    toInsert = new HashSet();
                    toUpdate = new HashSet();
                    toDelete = new HashSet();
                }
                Iterator it = oldMap.keySet().iterator();
                while (it.hasNext()) {
                    LdapName dn = (LdapName)it.next();
                    if (!newMap.containsKey(dn)) continue;
                    toUpdate.add(newMap.get(dn));
                    newMap.remove(dn);
                    it.remove();
                }
                toInsert.addAll(newMap.values());
                toDelete.addAll(oldMap.values());
                for (Object pc : toInsert) {
                    this.insertAsChild(pc, embeddedMetaData);
                }
                for (Object pc : toUpdate) {
                    this.updateAsChild(pc, embeddedMetaData);
                }
                for (Object pc : toDelete) {
                    this.deleteAsChild(pc, embeddedMetaData);
                }
                break;
            }
            default: {
                throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " with relation type " + this.mmd.getRelationType(this.clr) + " is not supported for this datastore");
            }
        }
    }

    private void updateAsChild(Object value, EmbeddedMetaData embeddedMetaData) {
        StateManager embeddedSM = this.getEmbeddedStateManager(value);
        int[] dirtyFieldNumbers = embeddedSM.getDirtyFieldNumbers();
        List<AbstractMemberMetaData> dirtyAndEmbeddedMmds = LDAPUtils.getMemberMetaData(dirtyFieldNumbers, this.effectiveClassMetaData);
        List<AbstractMemberMetaData> allMmds = LDAPUtils.getAllMemberMetaData(this.effectiveClassMetaData);
        for (AbstractMemberMetaData mmd : allMmds) {
            if (!LDAPUtils.isEmbeddedField(mmd)) continue;
            dirtyAndEmbeddedMmds.add(mmd);
        }
        if (dirtyAndEmbeddedMmds.isEmpty()) {
            return;
        }
        BasicAttributes embeddedAttributes = new BasicAttributes();
        this.updateMerge(embeddedSM, embeddedAttributes, dirtyAndEmbeddedMmds, embeddedMetaData);
        if (embeddedAttributes.size() > 0) {
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(embeddedSM);
            if (this.effectiveStateManager.getAssociatedValue((Object)"update-embedded") == null) {
                this.effectiveStateManager.setAssociatedValue((Object)"update-embedded", new LinkedHashMap());
            }
            Map map = (Map)this.effectiveStateManager.getAssociatedValue((Object)"update-embedded");
            map.put(dn, embeddedAttributes);
        }
    }

    private void deleteAsChild(Object oldValue, EmbeddedMetaData embeddedMetaData) {
        StateManager embeddedSM = this.getEmbeddedStateManager(oldValue);
        LdapName dn = LDAPUtils.getDistinguishedNameForObject(embeddedSM);
        if (this.effectiveStateManager.getAssociatedValue((Object)"delete-embedded") == null) {
            this.effectiveStateManager.setAssociatedValue((Object)"delete-embedded", new LinkedHashMap());
        }
        Map map = (Map)this.effectiveStateManager.getAssociatedValue((Object)"delete-embedded");
        map.put(dn, null);
    }

    private void updateEmbedded(Object value) {
        if (value == null) {
            value = this.getObjectInstance(this.effectiveClassMetaData.getFullClassName());
        }
        StateManager embeddedSM = this.getEmbeddedStateManager(value);
        EmbeddedMetaData embeddedMetaData = this.mmd.getEmbeddedMetaData();
        ArrayList<AbstractMemberMetaData> embeddedMmds = new ArrayList<AbstractMemberMetaData>(Arrays.asList(embeddedMetaData.getMemberMetaData()));
        this.updateMerge(embeddedSM, this.attributes, embeddedMmds, embeddedMetaData);
    }

    private void updateMerge(StateManager embeddedSM, Attributes embeddedAttributes, List<AbstractMemberMetaData> embeddedMmds, EmbeddedMetaData embeddedMetaData) {
        AbstractClassMetaData embeddedCmd = embeddedSM.getClassMetaData();
        for (AbstractMemberMetaData embeddedMmd : embeddedMmds) {
            String fieldName = embeddedMmd.getName();
            int i = embeddedCmd.getAbsolutePositionOfMember(fieldName);
            if (fieldName.equals(embeddedMetaData.getOwnerMember())) {
                Object embeddedValue = this.sm.getObject();
                embeddedSM.replaceField(i, embeddedValue, true);
                continue;
            }
            if (!embeddedMmd.isPrimaryKey()) continue;
            AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(embeddedSM, embeddedMmd, embeddedAttributes);
            Object embeddedValue = embeddedSM.provideField(i);
            ms.update(embeddedValue);
        }
        int[] dirtyFieldNumbers = embeddedSM.getDirtyFieldNumbers();
        if (dirtyFieldNumbers != null) {
            Arrays.sort(dirtyFieldNumbers);
        }
        for (AbstractMemberMetaData embeddedMmd : embeddedMmds) {
            String fieldName = embeddedMmd.getName();
            int i = embeddedCmd.getAbsolutePositionOfMember(fieldName);
            if (fieldName.equals(embeddedMetaData.getOwnerMember()) || embeddedMmd.isPrimaryKey()) continue;
            AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(embeddedSM, embeddedMmd, embeddedAttributes);
            Object embeddedValue = embeddedSM.provideField(i);
            ms.update(embeddedValue);
        }
    }
}

