/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.CalendarToGeneralizedTimeStringConverter;
import org.datanucleus.store.ldap.fieldmanager.DateToGeneralizedTimeStringConverter;

public class SimpleMappingStrategy
extends AbstractMappingStrategy {
    public SimpleMappingStrategy(StateManager sm, AbstractMemberMetaData mmd, Attributes attributes) {
        super(sm, mmd, attributes);
    }

    public Object fetch() {
        if (Boolean.TYPE.isAssignableFrom(this.type)) {
            return this.fetchBooleanField();
        }
        if (Byte.TYPE.isAssignableFrom(this.type)) {
            return this.fetchByteField();
        }
        if (Character.TYPE.isAssignableFrom(this.type)) {
            return Character.valueOf(this.fetchCharField());
        }
        if (Double.TYPE.isAssignableFrom(this.type)) {
            return this.fetchDoubleField();
        }
        if (Float.TYPE.isAssignableFrom(this.type)) {
            return Float.valueOf(this.fetchFloatField());
        }
        if (Integer.TYPE.isAssignableFrom(this.type)) {
            return this.fetchIntField();
        }
        if (Long.TYPE.isAssignableFrom(this.type)) {
            return this.fetchLongField();
        }
        if (Short.TYPE.isAssignableFrom(this.type)) {
            return this.fetchShortField();
        }
        if (this.attr == null) {
            return null;
        }
        if (String.class.isAssignableFrom(this.type)) {
            return this.fetchStringField();
        }
        if (String.class.isAssignableFrom(this.type)) {
            return this.fetchStringField();
        }
        if (Boolean.class.isAssignableFrom(this.type)) {
            return this.fetchBooleanField();
        }
        if (Byte.class.isAssignableFrom(this.type)) {
            return this.fetchByteField();
        }
        if (Character.class.isAssignableFrom(this.type)) {
            return Character.valueOf(this.fetchCharField());
        }
        if (Float.class.isAssignableFrom(this.type)) {
            return Float.valueOf(this.fetchFloatField());
        }
        if (Double.class.isAssignableFrom(this.type)) {
            return this.fetchDoubleField();
        }
        if (Short.class.isAssignableFrom(this.type)) {
            return this.fetchShortField();
        }
        if (Integer.class.isAssignableFrom(this.type)) {
            return this.fetchIntField();
        }
        if (Long.class.isAssignableFrom(this.type)) {
            return this.fetchLongField();
        }
        CalendarToGeneralizedTimeStringConverter converter = null;
        converter = Date.class.isAssignableFrom(this.type) ? new DateToGeneralizedTimeStringConverter() : (Calendar.class.isAssignableFrom(this.type) ? new CalendarToGeneralizedTimeStringConverter() : this.sm.getObjectManager().getOMFContext().getTypeManager().getStringConverter(this.type));
        if (converter != null) {
            return converter.toObject(this.fetchStringField());
        }
        throw new NucleusException("Cant obtain value for field " + this.mmd.getFullFieldName() + " since type=" + this.mmd.getTypeName() + " is not supported for this datastore");
    }

    private String fetchStringField() {
        try {
            if (this.attr.get(0) instanceof byte[]) {
                return new String((byte[])this.attr.get(0), "UTF-8");
            }
            return (String)this.attr.get(0);
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean fetchBooleanField() {
        if (this.attr == null) {
            return false;
        }
        try {
            return new Boolean(this.attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    private byte fetchByteField() {
        if (this.attr == null) {
            return 0;
        }
        try {
            return new Byte(this.attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    private char fetchCharField() {
        if (this.attr == null) {
            return ' ';
        }
        try {
            return this.attr.get(0).toString().charAt(0);
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    private double fetchDoubleField() {
        if (this.attr == null) {
            return 0.0;
        }
        try {
            return new Double(this.attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    private float fetchFloatField() {
        if (this.attr == null) {
            return 0.0f;
        }
        try {
            return new Float(this.attr.get(0).toString()).floatValue();
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    private int fetchIntField() {
        if (this.attr == null) {
            return 0;
        }
        try {
            return new Integer(this.attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    private long fetchLongField() {
        if (this.attr == null) {
            return 0L;
        }
        try {
            return new Long(this.attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    private short fetchShortField() {
        if (this.attr == null) {
            return 0;
        }
        try {
            return new Short(this.attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public void insert(Object value) {
        this.store(value);
    }

    public void update(Object value) {
        if (value == null) {
            this.attributes.put(new BasicAttribute(this.name));
            return;
        }
        this.store(value);
    }

    private void store(Object value) {
        if (Boolean.TYPE.isAssignableFrom(this.type)) {
            this.storeBooleanField((Boolean)value);
        } else if (Byte.TYPE.isAssignableFrom(this.type)) {
            this.storeField(value);
        } else if (Character.TYPE.isAssignableFrom(this.type)) {
            this.storeField(value);
        } else if (Double.TYPE.isAssignableFrom(this.type)) {
            this.storeField(value);
        } else if (Float.TYPE.isAssignableFrom(this.type)) {
            this.storeField(value);
        } else if (Integer.TYPE.isAssignableFrom(this.type)) {
            this.storeField(value);
        } else if (Long.TYPE.isAssignableFrom(this.type)) {
            this.storeField(value);
        } else if (Short.TYPE.isAssignableFrom(this.type)) {
            this.storeField(value);
        } else {
            if (value == null) {
                return;
            }
            if (String.class.isAssignableFrom(this.type)) {
                this.storeField(value);
            } else if (Boolean.class.isAssignableFrom(this.type)) {
                this.storeBooleanField((Boolean)value);
            } else if (Byte.class.isAssignableFrom(this.type)) {
                this.storeField(value);
            } else if (Character.class.isAssignableFrom(this.type)) {
                this.storeField(value);
            } else if (Float.class.isAssignableFrom(this.type)) {
                this.storeField(value);
            } else if (Double.class.isAssignableFrom(this.type)) {
                this.storeField(value);
            } else if (Short.class.isAssignableFrom(this.type)) {
                this.storeField(value);
            } else if (Integer.class.isAssignableFrom(this.type)) {
                this.storeField(value);
            } else if (Long.class.isAssignableFrom(this.type)) {
                this.storeField(value);
            } else {
                CalendarToGeneralizedTimeStringConverter converter = null;
                converter = Date.class.isAssignableFrom(this.type) ? new DateToGeneralizedTimeStringConverter() : (Calendar.class.isAssignableFrom(this.type) ? new CalendarToGeneralizedTimeStringConverter() : this.sm.getObjectManager().getOMFContext().getTypeManager().getStringConverter(this.type));
                if (converter != null) {
                    this.attributes.put(new BasicAttribute(this.name, converter.toString(value)));
                } else {
                    throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " is not supported for this datastore");
                }
            }
        }
    }

    private void storeBooleanField(boolean value) {
        this.attributes.put(new BasicAttribute(this.name, ("" + value).toUpperCase()));
    }

    private void storeField(Object value) {
        this.attributes.put(new BasicAttribute(this.name, "" + value));
    }
}

