/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierachicalMappingStrategy
extends AbstractMappingStrategy {
    protected ObjectManager om;
    protected ClassLoaderResolver clr;
    protected AbstractClassMetaData effectiveClassMetaData;
    protected boolean isFieldHierarchicalMapped;
    protected boolean isFieldParentOfHierarchicalMapping;

    protected HierachicalMappingStrategy(StateManager sm, int fieldNumber, Attributes attributes) {
        super(sm, fieldNumber, attributes);
        this.om = sm.getObjectManager();
        this.clr = this.om.getClassLoaderResolver();
        this.effectiveClassMetaData = LDAPUtils.getEffectiveClassMetaData(this.mmd);
        this.isFieldHierarchicalMapped = LDAPUtils.isHierarchicalMapped(this.effectiveClassMetaData, sm.getClassMetaData());
        this.isFieldParentOfHierarchicalMapping = LDAPUtils.isParentOfHierarchicalMapping(this.effectiveClassMetaData, sm.getClassMetaData());
    }

    @Override
    public Object fetch() {
        if (this.isFieldHierarchicalMapped) {
            String mappedBy = this.mmd.getMappedBy();
            switch (this.mmd.getRelationType(this.clr)) {
                case 1: 
                case 2: {
                    this.mmd.setDependent(true);
                    Collection<Object> coll = this.getHierarchicalMappedChildren(this.mmd.getTypeName(), mappedBy, ArrayList.class);
                    if (coll.iterator().hasNext()) {
                        Object value = coll.iterator().next();
                        this.sm.setAssociatedValue((Object)("OBJ" + this.fieldNumber), value);
                        return value;
                    }
                    this.sm.setAssociatedValue((Object)("OBJ" + this.fieldNumber), null);
                    return null;
                }
                case 3: 
                case 4: {
                    if (!this.mmd.hasCollection()) break;
                    Class instanceType = this.mmd.getType();
                    instanceType = LDAPUtils.getConcreteCollectionType(instanceType);
                    Collection<Object> coll = this.getHierarchicalMappedChildren(this.mmd.getCollection().getElementType(), mappedBy, instanceType);
                    this.sm.setAssociatedValue((Object)("COLL" + this.fieldNumber), coll);
                    return this.sm.wrapSCOField(this.fieldNumber, coll, false, false, true);
                }
            }
        }
        if (this.isFieldParentOfHierarchicalMapping) {
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.sm);
            String pattern = LDAPUtils.getDistinguishedNamePattern(this.sm.getClassMetaData());
            LdapName parentDn = LDAPUtils.getParentDistingueshedName(dn, pattern);
            Object value = LDAPUtils.getObjectByAttributes(this.om, this.type, parentDn.toString());
            this.sm.setAssociatedValue((Object)("OBJ" + this.fieldNumber), value);
            return value;
        }
        throw new NucleusException("Cant obtain value for field " + this.mmd.getFullFieldName() + " since type=" + this.mmd.getTypeName() + " is not supported for this datastore");
    }

    private Collection<Object> getHierarchicalMappedChildren(String type, String mappedBy, Class collectionClass) {
        Collection coll;
        block10: {
            try {
                coll = (Collection)collectionClass.newInstance();
                ObjectManager om = this.sm.getObjectManager();
                ClassLoaderResolver clr = om.getClassLoaderResolver();
                MetaDataManager metaDataMgr = this.sm.getMetaDataManager();
                AbstractClassMetaData childCmd = metaDataMgr.getMetaDataForClass(type, clr);
                String pattern = LDAPUtils.getDistinguishedNamePattern(childCmd);
                String parentFieldName = LDAPUtils.getParentFieldName(pattern);
                if (parentFieldName == null || !mappedBy.equals(parentFieldName)) break block10;
                LdapName base = LDAPUtils.getDistinguishedNameForObject(this.sm);
                SearchControls searchControls = LDAPUtils.getSearchControls(childCmd);
                String filter = LDAPUtils.getObjectClassesFilterForObject(childCmd);
                ManagedConnection mconn = om.getStoreManager().getConnection(om);
                try {
                    DirContext ctx = (DirContext)mconn.getConnection();
                    NamingEnumeration<SearchResult> enumeration = ctx.search((Name)base, filter, searchControls);
                    Class<?> c = Class.forName(childCmd.getFullClassName());
                    while (enumeration.hasMoreElements()) {
                        SearchResult sr = (SearchResult)enumeration.nextElement();
                        String srName = sr.getNameInNamespace();
                        coll.add(LDAPUtils.getObjectByAttributes(om, c, srName));
                    }
                }
                catch (NamingException e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                finally {
                    mconn.release();
                }
            }
            catch (InstantiationException e) {
                throw new NucleusException("Error in trying to create object of type " + collectionClass.getName(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new NucleusException("Error in trying to create object of type " + collectionClass.getName(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new NucleusException("Error in trying to call Class.forName()", (Throwable)e);
            }
        }
        return coll;
    }

    @Override
    public void insert(Object value) {
        block6: {
            block7: {
                if (value == null || this.isFieldParentOfHierarchicalMapping) break block6;
                if (!this.isFieldHierarchicalMapped) break block7;
                switch (this.mmd.getRelationType(this.clr)) {
                    case 1: 
                    case 2: {
                        LDAPUtils.markForPersisting(value, this.om);
                        break block6;
                    }
                    case 3: 
                    case 4: {
                        if (this.mmd.hasCollection()) {
                            Collection c = (Collection)value;
                            for (Object pc : c) {
                                LDAPUtils.markForPersisting(pc, this.om);
                            }
                        }
                        break block6;
                    }
                    default: {
                        throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " with relation type " + this.mmd.getRelationType(this.clr) + " is not supported for this datastore");
                    }
                }
            }
            throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " is not supported for this datastore");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update(Object value) {
        if (this.isFieldParentOfHierarchicalMapping) {
            if (value != null) return;
            LDAPUtils.markForDeletion(this.sm.getObject(), this.om);
            return;
        }
        if (!this.isFieldHierarchicalMapped) throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " is not supported for this datastore");
        if (value == null) return;
        String mappedBy = this.mmd.getMappedBy();
        switch (this.mmd.getRelationType(this.clr)) {
            case 1: {
                StateManager valueSM;
                StateManager oldValueSM;
                Object oldValue = this.sm.getAssociatedValue((Object)("OBJ" + this.fieldNumber));
                if (oldValue != null && this.mustDelete(oldValueSM = LDAPUtils.getStateManagerForObject(oldValue, this.om, false))) {
                    LDAPUtils.markForDeletion(oldValue, this.om);
                }
                if ((valueSM = LDAPUtils.getStateManagerForObject(value, this.om, false)) != null) {
                    LdapName oldDn = LDAPUtils.getDistinguishedNameForObject(valueSM);
                    valueSM.setAssociatedValue((Object)"dn", null);
                    LdapName newDn = LDAPUtils.getDistinguishedNameForObject(valueSM);
                    LDAPUtils.markForRename(value, this.om, oldDn, newDn);
                    LDAPUtils.unmarkForDeletion(value, this.om);
                }
            }
            case 2: {
                LDAPUtils.markForPersisting(value, this.om);
                LDAPUtils.unmarkForDeletion(value, this.om);
                return;
            }
            case 3: 
            case 4: {
                if (!this.mmd.hasCollection()) return;
                Collection coll = (Collection)value;
                Collection oldColl = (Collection)this.sm.getAssociatedValue((Object)("COLL" + this.fieldNumber));
                if (oldColl == null) throw new NucleusDataStoreException("No old collection in SM " + this.sm);
                AbstractCollection toAdd = null;
                AbstractCollection toRemove = null;
                Class instanceType = this.mmd.getType();
                if (List.class.isAssignableFrom(instanceType)) {
                    toAdd = new ArrayList(coll);
                    toRemove = new ArrayList(oldColl);
                } else {
                    toAdd = new HashSet(coll);
                    toRemove = new HashSet(oldColl);
                }
                toAdd.removeAll(oldColl);
                for (Object pc : toAdd) {
                    LDAPUtils.markForPersisting(pc, this.om);
                    LDAPUtils.unmarkForDeletion(pc, this.om);
                }
                if (this.mmd.getRelationType(this.clr) == 3) {
                    toRemove.removeAll(coll);
                    for (Object pc : toRemove) {
                        StateManager pcSM = LDAPUtils.getStateManagerForObject(pc, this.om, false);
                        if (!this.mustDelete(pcSM)) continue;
                        LDAPUtils.markForDeletion(pc, this.om);
                    }
                    return;
                } else {
                    if (mappedBy == null) return;
                    toRemove.removeAll(coll);
                    for (Object pc : toRemove) {
                        StateManager pcSM = LDAPUtils.getStateManagerForObject(pc, this.om, false);
                        if (!this.mustDelete(pcSM, mappedBy)) continue;
                        LDAPUtils.markForDeletion(pc, this.om);
                    }
                }
                return;
            }
            default: {
                throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " with relation type " + this.mmd.getRelationType(this.clr) + " is not supported for this datastore");
            }
        }
    }

    private boolean mustDelete(StateManager pcSM) {
        LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.sm);
        LdapName pcDn = LDAPUtils.getDistinguishedNameForObject(pcSM);
        boolean b = pcDn.startsWith(dn);
        return b;
    }

    private boolean mustDelete(StateManager pcSM, String mappedBy) {
        try {
            Object pc = pcSM.getObject();
            Class<?> clazz = pc.getClass();
            String methodName = ClassUtils.getJavaBeanGetterName((String)mappedBy, (boolean)false);
            Method method = ClassUtils.getMethodForClass(clazz, (String)methodName, null);
            Object fieldPC = method.invoke(pc, new Object[0]);
            Object myPC = this.sm.getObject();
            if (fieldPC == null || fieldPC == myPC) {
                return true;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }
}

