/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import javax.naming.directory.Attributes;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;

public class FetchFieldManager
extends AbstractFieldManager {
    StateManager sm;
    Attributes result;

    public FetchFieldManager(StateManager sm, Attributes result) {
        this.sm = sm;
        this.result = result;
    }

    public String fetchStringField(int fieldNumber) {
        return (String)this.fetchObjectField(fieldNumber);
    }

    public Object fetchObjectField(int fieldNumber) {
        AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(this.sm, fieldNumber, this.result);
        if (ms != null) {
            return ms.fetch();
        }
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        throw new NucleusException("Cant obtain value for field " + mmd.getFullFieldName() + " since type=" + mmd.getTypeName() + " is not supported for this datastore");
    }

    public boolean fetchBooleanField(int fieldNumber) {
        return (Boolean)this.fetchObjectField(fieldNumber);
    }

    public byte fetchByteField(int fieldNumber) {
        return (Byte)this.fetchObjectField(fieldNumber);
    }

    public char fetchCharField(int fieldNumber) {
        return ((Character)this.fetchObjectField(fieldNumber)).charValue();
    }

    public double fetchDoubleField(int fieldNumber) {
        return (Double)this.fetchObjectField(fieldNumber);
    }

    public float fetchFloatField(int fieldNumber) {
        return ((Float)this.fetchObjectField(fieldNumber)).floatValue();
    }

    public int fetchIntField(int fieldNumber) {
        return (Integer)this.fetchObjectField(fieldNumber);
    }

    public long fetchLongField(int fieldNumber) {
        return (Long)this.fetchObjectField(fieldNumber);
    }

    public short fetchShortField(int fieldNumber) {
        return (Short)this.fetchObjectField(fieldNumber);
    }
}

