/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnMappingStrategy
extends AbstractMappingStrategy {
    protected ObjectManager om;
    protected ClassLoaderResolver clr;
    protected AbstractClassMetaData effectiveClassMetaData;

    protected DnMappingStrategy(StateManager sm, int fieldNumber, Attributes attributes) {
        super(sm, fieldNumber, attributes);
        this.om = sm.getObjectManager();
        this.clr = this.om.getClassLoaderResolver();
        this.effectiveClassMetaData = LDAPUtils.getEffectiveClassMetaData(this.mmd);
    }

    @Override
    public Object fetch() {
        ElementMetaData elementMetaData = this.mmd.getElementMetaData();
        if (elementMetaData != null) {
            String pcAttributeName = elementMetaData.getColumnName();
            switch (this.mmd.getRelationType(this.clr)) {
                case 1: 
                case 2: {
                    Collection<Object> coll = this.getDnMappedReferences(this.effectiveClassMetaData, pcAttributeName, ArrayList.class);
                    if (coll.iterator().hasNext()) {
                        Object value = coll.iterator().next();
                        this.sm.setAssociatedValue((Object)("OBJ" + this.fieldNumber), value);
                        return value;
                    }
                    this.sm.setAssociatedValue((Object)("OBJ" + this.fieldNumber), null);
                    return null;
                }
                case 3: 
                case 4: {
                    if (!this.mmd.hasCollection()) break;
                    Class instanceType = this.mmd.getType();
                    instanceType = LDAPUtils.getConcreteCollectionType(instanceType);
                    Collection<Object> coll = this.getDnMappedReferences(this.effectiveClassMetaData, pcAttributeName, instanceType);
                    this.sm.setAssociatedValue((Object)("COLL" + this.fieldNumber), coll);
                    return this.sm.wrapSCOField(this.fieldNumber, coll, false, false, true);
                }
            }
        } else {
            switch (this.mmd.getRelationType(this.clr)) {
                case 1: 
                case 2: {
                    try {
                        Object value = this.attr != null ? LDAPUtils.getObjectByAttributes(this.om, this.mmd.getType(), (String)this.attr.get(0)) : null;
                        this.sm.setAssociatedValue((Object)("OBJ" + this.fieldNumber), value);
                        return value;
                    }
                    catch (NamingException e) {
                        throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                    }
                }
                case 3: 
                case 4: {
                    if (this.attr == null) {
                        return null;
                    }
                    if (!this.mmd.hasCollection()) break;
                    Collection coll = null;
                    Class instanceType = this.mmd.getType();
                    instanceType = LDAPUtils.getConcreteCollectionType(instanceType);
                    try {
                        coll = (Collection)instanceType.newInstance();
                        Class elementType = this.clr.classForName(this.mmd.getCollection().getElementType());
                        String emptyValue = LDAPUtils.getEmptyValue(this.mmd);
                        LdapName emptyDn = emptyValue != null ? new LdapName(emptyValue) : null;
                        for (int i = 0; i < this.attr.size(); ++i) {
                            String value = (String)this.attr.get(i);
                            LdapName dn = new LdapName(value);
                            if (emptyDn != null && emptyDn.equals(dn)) continue;
                            coll.add(LDAPUtils.getObjectByAttributes(this.om, elementType, value));
                        }
                    }
                    catch (NamingException e) {
                        throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                    }
                    catch (Exception e) {
                        throw new NucleusException("Error in trying to create object of type " + instanceType.getName(), (Throwable)e);
                    }
                    return this.sm.wrapSCOField(this.fieldNumber, (Object)coll, false, false, true);
                }
            }
        }
        throw new NucleusException("Cant obtain value for field " + this.mmd.getFullFieldName() + " since type=" + this.mmd.getTypeName() + " is not supported for this datastore");
    }

    private Collection<Object> getDnMappedReferences(AbstractClassMetaData cmd, String pcAttributeName, Class collectionClass) {
        Collection coll;
        try {
            coll = (Collection)collectionClass.newInstance();
            ObjectManager om = this.sm.getObjectManager();
            ManagedConnection mconn = om.getStoreManager().getConnection(om);
            try {
                LdapName myDN = LDAPUtils.getDistinguishedNameForObject(this.sm);
                LdapName base = LDAPUtils.getDistinguishedNameForClass(cmd);
                String ocFilter = LDAPUtils.getObjectClassesFilterForObject(cmd);
                String dnFilter = "(" + pcAttributeName + "=" + myDN.toString() + ")";
                String filter = ocFilter != null ? "(&" + ocFilter + dnFilter + ")" : dnFilter;
                SearchControls searchControls = LDAPUtils.getSearchControls(cmd);
                DirContext ctx = (DirContext)mconn.getConnection();
                NamingEnumeration<SearchResult> enumeration = ctx.search((Name)base, filter, searchControls);
                Class<?> c = Class.forName(cmd.getFullClassName());
                while (enumeration.hasMoreElements()) {
                    SearchResult sr = (SearchResult)enumeration.nextElement();
                    String srName = sr.getNameInNamespace();
                    coll.add(LDAPUtils.getObjectByAttributes(om, c, srName));
                }
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
        catch (InstantiationException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionClass.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionClass.getName(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new NucleusException("Error in trying to call Class.forName() of type" + cmd.getFullClassName(), (Throwable)e);
        }
        return coll;
    }

    @Override
    public void insert(Object value) {
        block23: {
            block24: {
                if (value == null) break block23;
                ElementMetaData elementMetaData = this.mmd.getElementMetaData();
                if (elementMetaData == null) break block24;
                switch (this.mmd.getRelationType(this.clr)) {
                    case 1: 
                    case 2: {
                        StateManager pcSM = LDAPUtils.getStateManagerForObject(value, this.om, true);
                        LdapName pcDN = LDAPUtils.getDistinguishedNameForObject(pcSM);
                        String pcAttributeName = elementMetaData.getColumnName();
                        LdapName myDN = LDAPUtils.getDistinguishedNameForObject(this.sm);
                        ManagedConnection mconn = this.om.getStoreManager().getConnection(this.om);
                        try {
                            DirContext ctx = (DirContext)mconn.getConnection();
                            Attributes pcAttributes = ctx.getAttributes(pcDN, new String[]{pcAttributeName});
                            Attribute pcAttribute = pcAttributes.get(pcAttributeName);
                            if (pcAttribute == null) {
                                pcAttribute = new BasicAttribute(pcAttributeName);
                                pcAttributes.put(pcAttribute);
                            }
                            pcAttribute.add(myDN.toString());
                            ctx.modifyAttributes(pcDN, 2, pcAttributes);
                            break block23;
                        }
                        catch (NamingException e) {
                            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                        }
                        finally {
                            mconn.release();
                        }
                    }
                    case 3: 
                    case 4: {
                        if (this.mmd.hasCollection()) {
                            Collection c = (Collection)value;
                            for (Object pc : c) {
                                LDAPUtils.unmarkForDeletion(pc, this.om);
                                StateManager pcSM = LDAPUtils.getStateManagerForObject(pc, this.om, true);
                                LdapName pcDN = LDAPUtils.getDistinguishedNameForObject(pcSM);
                                String pcAttributeName = elementMetaData.getColumnName();
                                LdapName myDN = LDAPUtils.getDistinguishedNameForObject(this.sm);
                                ManagedConnection mconn = this.om.getStoreManager().getConnection(this.om);
                                try {
                                    DirContext ctx = (DirContext)mconn.getConnection();
                                    Attributes pcAttributes = ctx.getAttributes(pcDN, new String[]{pcAttributeName});
                                    Attribute pcAttribute = pcAttributes.get(pcAttributeName);
                                    if (pcAttribute == null) {
                                        pcAttribute = new BasicAttribute(pcAttributeName);
                                        pcAttributes.put(pcAttribute);
                                    }
                                    pcAttribute.add(myDN.toString());
                                    ctx.modifyAttributes(pcDN, 2, pcAttributes);
                                }
                                catch (NamingException e) {
                                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                                }
                                finally {
                                    mconn.release();
                                }
                            }
                        }
                        break block23;
                    }
                    default: {
                        throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " with relation type " + this.mmd.getRelationType(this.clr) + " is not supported for this datastore");
                    }
                }
            }
            switch (this.mmd.getRelationType(this.clr)) {
                case 1: 
                case 2: {
                    StateManager pcSM = LDAPUtils.getStateManagerForObject(value, this.om, true);
                    LdapName pcDN = LDAPUtils.getDistinguishedNameForObject(pcSM);
                    this.attributes.put(new BasicAttribute(this.name, pcDN.toString()));
                    break;
                }
                case 3: 
                case 4: {
                    if (!this.mmd.hasCollection()) break;
                    Collection c = (Collection)value;
                    BasicAttribute attr = new BasicAttribute(this.name);
                    this.attributes.put(attr);
                    for (Object pc : c) {
                        StateManager pcSM = LDAPUtils.getStateManagerForObject(pc, this.om, true);
                        LdapName pcDN = LDAPUtils.getDistinguishedNameForObject(pcSM);
                        attr.add(pcDN.toString());
                    }
                    String emptyValue = LDAPUtils.getEmptyValue(this.mmd);
                    if (attr.size() != 0 || emptyValue == null) break;
                    attr.add(emptyValue);
                    break;
                }
                default: {
                    throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " with relation type " + this.mmd.getRelationType(this.clr) + " is not supported for this datastore");
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update(Object value) {
        LdapName myDN = LDAPUtils.getDistinguishedNameForObject(this.sm);
        ElementMetaData elementMetaData = this.mmd.getElementMetaData();
        if (elementMetaData != null) {
            String pcAttributeName = elementMetaData.getColumnName();
            Object oldValue = this.sm.getAssociatedValue((Object)("OBJ" + this.fieldNumber));
            if (value != null) {
                switch (this.mmd.getRelationType(this.clr)) {
                    case 1: 
                    case 2: {
                        this.removeDnReference(oldValue, pcAttributeName, myDN, this.om);
                        this.addDnReference(value, pcAttributeName, myDN, this.om);
                        return;
                    }
                    case 3: 
                    case 4: {
                        if (!this.mmd.hasCollection()) return;
                        Collection coll = (Collection)value;
                        Collection oldColl = (Collection)this.sm.getAssociatedValue((Object)("COLL" + this.fieldNumber));
                        if (oldColl == null) throw new NucleusDataStoreException("No old collection in SM " + this.sm);
                        AbstractCollection toAdd = null;
                        AbstractCollection toRemove = null;
                        Class instanceType = this.mmd.getType();
                        if (List.class.isAssignableFrom(instanceType)) {
                            toAdd = new ArrayList(coll);
                            toRemove = new ArrayList(oldColl);
                        } else {
                            toAdd = new HashSet(coll);
                            toRemove = new HashSet(oldColl);
                        }
                        toAdd.removeAll(oldColl);
                        for (Object pc : toAdd) {
                            this.addDnReference(pc, pcAttributeName, myDN, this.om);
                            LDAPUtils.unmarkForDeletion(pc, this.om);
                        }
                        toRemove.removeAll(coll);
                        for (Object pc : toRemove) {
                            this.removeDnReference(pc, pcAttributeName, myDN, this.om);
                            if (!this.mmd.getCollection().isDependentElement()) continue;
                            LDAPUtils.markForDeletion(pc, this.om);
                        }
                        return;
                    }
                    default: {
                        throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " with relation type " + this.mmd.getRelationType(this.clr) + " is not supported for this datastore");
                    }
                }
            }
            this.removeDnReference(oldValue, pcAttributeName, myDN, this.om);
            return;
        }
        if (value != null) {
            switch (this.mmd.getRelationType(this.clr)) {
                case 1: 
                case 2: {
                    StateManager smpc = LDAPUtils.getStateManagerForObject(value, this.om, true);
                    this.attributes.put(new BasicAttribute(this.name, LDAPUtils.getDistinguishedNameForObject(smpc).toString()));
                    return;
                }
                case 3: 
                case 4: {
                    if (!this.mmd.hasCollection()) return;
                    Collection c = (Collection)value;
                    BasicAttribute attr = new BasicAttribute(this.name);
                    this.attributes.put(attr);
                    for (Object pc : c) {
                        StateManager smpc = LDAPUtils.getStateManagerForObject(pc, this.om, true);
                        attr.add(LDAPUtils.getDistinguishedNameForObject(smpc).toString());
                    }
                    String emptyValue = LDAPUtils.getEmptyValue(this.mmd);
                    if (attr.size() != 0 || emptyValue == null) return;
                    attr.add(emptyValue);
                    return;
                }
                default: {
                    throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " with relation type " + this.mmd.getRelationType(this.clr) + " is not supported for this datastore");
                }
            }
        }
        this.attributes.put(new BasicAttribute(this.name));
    }

    private void removeDnReference(Object oldObject, String pcAttributeName, LdapName dn, ObjectManager om) {
        if (oldObject != null) {
            StateManager oldPcSM = LDAPUtils.getStateManagerForObject(oldObject, om, true);
            LdapName oldPcDN = LDAPUtils.getDistinguishedNameForObject(oldPcSM);
            ManagedConnection mconn = om.getStoreManager().getConnection(om);
            try {
                boolean removed;
                DirContext ctx = (DirContext)mconn.getConnection();
                Attributes pcAttributes = ctx.getAttributes(oldPcDN, new String[]{pcAttributeName});
                Attribute pcAttribute = pcAttributes.get(pcAttributeName);
                if (pcAttribute != null && (removed = pcAttribute.remove(dn.toString()))) {
                    ctx.modifyAttributes(oldPcDN, 2, pcAttributes);
                }
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }

    private void addDnReference(Object newObject, String pcAttributeName, LdapName dn, ObjectManager om) {
        if (newObject != null) {
            StateManager newPcSM = LDAPUtils.getStateManagerForObject(newObject, om, true);
            LdapName newPcDN = LDAPUtils.getDistinguishedNameForObject(newPcSM);
            ManagedConnection mconn = om.getStoreManager().getConnection(om);
            try {
                boolean added;
                DirContext ctx = (DirContext)mconn.getConnection();
                Attributes pcAttributes = ctx.getAttributes(newPcDN, new String[]{pcAttributeName});
                Attribute pcAttribute = pcAttributes.get(pcAttributeName);
                if (pcAttribute == null) {
                    pcAttribute = new BasicAttribute(pcAttributeName);
                    pcAttributes.put(pcAttribute);
                }
                if (added = pcAttribute.add(dn.toString())) {
                    ctx.modifyAttributes(newPcDN, 2, pcAttributes);
                }
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
    }
}

