/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.util.Calendar;
import java.util.Date;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.DnMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.HierachicalMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.SimpleArrayMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.SimpleCollectionMapingStrategy;
import org.datanucleus.store.ldap.fieldmanager.SimpleMappingStrategy;
import org.datanucleus.store.types.ObjectStringConverter;

public abstract class AbstractMappingStrategy {
    protected int fieldNumber;
    protected StateManager sm;
    protected Attributes attributes;
    protected Attribute attr;
    protected AbstractMemberMetaData mmd;
    protected Class type;
    protected String name;

    protected AbstractMappingStrategy(StateManager sm, int fieldNumber, Attributes attributes) {
        this.sm = sm;
        this.fieldNumber = fieldNumber;
        this.attributes = attributes;
        this.mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        this.type = this.mmd.getType();
        this.name = LDAPUtils.getAttributeNameForField(this.mmd);
        this.attr = attributes.get(this.name);
    }

    public abstract void insert(Object var1);

    public abstract void update(Object var1);

    public abstract Object fetch();

    public static AbstractMappingStrategy findMappingStrategy(StateManager sm, int fieldNumber, Attributes attributes) {
        boolean isFieldDnMapped;
        AbstractMemberMetaData mmd = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        AbstractClassMetaData effectiveClassMetaData = LDAPUtils.getEffectiveClassMetaData(mmd);
        if (effectiveClassMetaData == null) {
            Class type = mmd.getType();
            boolean isArray = type.isArray();
            boolean isCollection = mmd.hasCollection();
            if (isArray) {
                type = type.getComponentType();
            } else if (isCollection) {
                type = sm.getObjectManager().getClassLoaderResolver().classForName(mmd.getCollection().getElementType());
            }
            if (type.isPrimitive() || String.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || Calendar.class.isAssignableFrom(type)) {
                if (isArray) {
                    return new SimpleArrayMappingStrategy(sm, fieldNumber, attributes);
                }
                if (isCollection) {
                    return new SimpleCollectionMapingStrategy(sm, fieldNumber, attributes);
                }
                return new SimpleMappingStrategy(sm, fieldNumber, attributes);
            }
            ObjectStringConverter converter = sm.getObjectManager().getOMFContext().getTypeManager().getStringConverter(type);
            if (converter != null) {
                if (isArray) {
                    return new SimpleArrayMappingStrategy(sm, fieldNumber, attributes);
                }
                if (isCollection) {
                    return new SimpleCollectionMapingStrategy(sm, fieldNumber, attributes);
                }
                return new SimpleMappingStrategy(sm, fieldNumber, attributes);
            }
            return null;
        }
        boolean isFieldHierarchicalMapped = LDAPUtils.isHierarchicalMapped(effectiveClassMetaData, sm.getClassMetaData());
        boolean isFieldParentOfHierarchicalMapping = LDAPUtils.isParentOfHierarchicalMapping(effectiveClassMetaData, sm.getClassMetaData());
        boolean bl = isFieldDnMapped = !isFieldHierarchicalMapped && !isFieldParentOfHierarchicalMapping;
        if (isFieldHierarchicalMapped || isFieldParentOfHierarchicalMapping) {
            return new HierachicalMappingStrategy(sm, fieldNumber, attributes);
        }
        if (isFieldDnMapped) {
            return new DnMappingStrategy(sm, fieldNumber, attributes);
        }
        return null;
    }
}

